package com.bcxin.saas.domains.readers;

import com.bcxin.saas.core.components.CacheProvider;
import com.bcxin.saas.domains.dtos.DomainRelationDTO;
import com.bcxin.saas.domains.entities.DomainRelationEntity;
import com.bcxin.saas.domains.repositories.DomainRelationRepository;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DomainRelationDbReaderImpl implements DomainRelationDbReader {
    private final DomainRelationRepository domainRelationRepository;
    private final CacheProvider cacheProvider;

    public DomainRelationDbReaderImpl(DomainRelationRepository domainRelationRepository, CacheProvider cacheProvider) {
        this.domainRelationRepository = domainRelationRepository;
        this.cacheProvider = cacheProvider;
    }

    @Override
    public DomainRelationDTO getWithFromCache(String domainId) {
        DomainRelationDTO dto = cacheProvider.<DomainRelationDTO>getData(String.format("CACHE_DomainRelationDTO_%s", domainId), () -> {
            Collection<DomainRelationEntity> domainRelationEntities = this.domainRelationRepository.getByDomainId(domainId);
            if (domainRelationEntities == null || domainRelationEntities.isEmpty()) {
                return null;
            }

            List<String> childDomainIds = domainRelationEntities.stream().map(ii -> ii.getChildDomainId())
                    .collect(Collectors.toList());

            return DomainRelationDTO.create(domainId, childDomainIds);
        });

        return dto;
    }

    @Override
    public boolean isSuperDomain(String domainId) {
        DomainRelationDTO dto = getWithFromCache(domainId);
        if (dto == null) {
            return false;
        }

        return dto.getIsSuperDomain();
    }
}
