package com.bcxin.saas.domains.dtos;

import lombok.Data;

import java.util.Collections;
import java.util.List;

@Data
public class PageResultDto {
    private int pageCount;
    private int linesPerPage;
    private int rowCount;
    private int pageNum;
    private List datas;

    public PageResultDto(
            int linesPerPage,
            int rowCount,
            int pageNum,
            List datas){
        this.linesPerPage = linesPerPage;
        this.rowCount = rowCount;
        this.pageNum = pageNum;
        this.pageCount = (datas.size()+linesPerPage-1)/linesPerPage;


        int fromIndex = (pageNum - 1) * linesPerPage;
        if (fromIndex >= datas.size()) {
            this.datas = Collections.emptyList();
        }else {
            int toIndex = pageNum * linesPerPage;
            if (toIndex >= datas.size()) {
                toIndex = datas.size();
            }
            this.datas = datas.subList(fromIndex, toIndex);
        }

    }

    public static PageResultDto create(PageSearchDto searchDto, List datas){
        return new PageResultDto(
                searchDto.getPageSize(),
                datas.size(),
                searchDto.getPageNum(),
                datas);

    }
}
