package cn.myapps.listener;

import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.api.ApiConfig;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.view.Column;
import cn.myapps.components.RingBufferProducer;
import cn.myapps.components.events.DistributeDesignCacheObject;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.events.FsDesignTimeComponentChangedEvent;
import cn.myapps.designtime.requests.RefreshDesignRequest;
import com.bcxin.saas.core.components.JsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@Component
public class FsDesignTimeComponentChangedEventListener implements ApplicationListener<FsDesignTimeComponentChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(FsDesignTimeComponentChangedEvent.class);
    private final DiscoveryClient discoveryClient;
    private final JsonProvider jsonProvider;

    private final RingBufferProducer ringBufferProducer;

    public FsDesignTimeComponentChangedEventListener(DiscoveryClient discoveryClient, JsonProvider jsonProvider,
                                                     RingBufferProducer ringBufferProducer) {
        this.discoveryClient = discoveryClient;
        this.jsonProvider = jsonProvider;
        this.ringBufferProducer = ringBufferProducer;
    }

    @Override
    public void onApplicationEvent(FsDesignTimeComponentChangedEvent event) {
        logger.error("即将更新如下信息={}到runtime", event);
        String appId = event.getDesignObject().getApplicationid();
        Collection<String> parentIds = new ArrayList<>();
        if (event.getDesignObject() instanceof Application) {
            appId = event.getDesignObject().getId();
        }

        /**
         * 系统根据上级存储缓存信息, 因此,需要进行清除
         */
        parentIds.add(event.getDesignObject().getParentId());
        /*
        if (event.getDesignObject() instanceof Column ||
                event.getDesignObject() instanceof Activity ||
                event.getDesignObject() instanceof ApiConfig) {
            parentIds.add(event.getDesignObject().getParentId());
        }
         */

        Collection<RefreshDesignRequest.ComponentDataItemRequest> itemRequests =
                event.getAll().stream()
                        .map(ii ->
                                RefreshDesignRequest.ComponentDataItemRequest.create(RefreshDesignRequest.ActionType.Changed, ii.getId()))
                        .collect(Collectors.toList());

        RefreshDesignRequest rq = RefreshDesignRequest.create(
                parentIds,
                itemRequests);
        DesignTimeSerializableCache.doRefreshWrapperObject(appId, rq);

        DistributeDesignCacheObject data = DistributeDesignCacheObject.create(appId,rq);
        this.ringBufferProducer.publish(data);
    }
}
