package cn.myapps.designtime.overview;

import cn.myapps.common.ModelSuffix;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import com.lowagie.text.Cell;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;

import java.awt.*;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Mobile菜单的pdf表格生成
 *
 * 2.6版本新增的类
 *
 * @author keezzm
 *
 */
public class MobileMenuOverview implements IOverview {

    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2);
        table.setSpacing(0);
        table.setBorderWidth(1);
        table.setWidth(100);

        if (!StringUtil.isBlank(applicationId)) {
            BaseFont bfChinese = BaseFont.createFont("STSongStd-Light",
                    "UniGB-UCS2-H", false);
            Font fontChinese = new Font(bfChinese, 10, Font.NORMAL, Color.BLACK);
            Cell mc = new Cell();
            mc.setBackgroundColor(Color.gray);
            mc.addElement(new Paragraph("mobile菜单：", fontChinese));
            table.addCell(mc);

            ResourceDesignTimeService rp = DesignTimeServiceManager.resourceDesignTimeService();
            Collection<ResourceVO> rs = rp.doSimpleQuery(new ParamsTable(),
                    applicationId, ModelSuffix.MOBILE_MENU_PATH_SUFFIX, ModelSuffix.MOBILE_MENU_FILE_SUFFIX);
            if (rs != null) {
                mc = new Cell();
                Table rTable = new Table(5);
                rTable.setWidth(96);
                rTable.setPadding(0);
                rTable.setSpacing(0);
                rTable.setBorderWidth(0);

                // 表头
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement(new Paragraph("名称", fontChinese));
                rTable.addCell(cell);

                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement(new Paragraph("序列号", fontChinese));
                rTable.addCell(cell);

                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement(new Paragraph("上级", fontChinese));
                rTable.addCell(cell);

                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement(new Paragraph("资源描述", fontChinese));
                rTable.addCell(cell);

                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement(new Paragraph("链接类型", fontChinese));
                rTable.addCell(cell);

//                cell = new Cell();
//                cell.setBackgroundColor(Color.gray);
//                cell.addElement(new Paragraph("打开方式", fontChinese));
//                rTable.addCell(cell);

                Iterator<ResourceVO> it = rs.iterator();
                while (it.hasNext()) {
                    ResourceVO resource = it.next();
                    if (resource != null) {
                        // 名称
                        cell = new Cell();
                        String rName = resource.getName();
                        if (!StringUtil.isBlank(rName)) {
                            cell.addElement(new Paragraph(rName, fontChinese));
                        }
                        rTable.addCell(cell);
                        // 序列号
                        cell = new Cell();
                        String orderno = String.valueOf(resource.getOrderno());
                        if (!StringUtil.isBlank(orderno)) {
                            cell
                                    .addElement(new Paragraph(orderno,
                                            fontChinese));
                        }
                        rTable.addCell(cell);
                        // 上级
                        ResourceVO superior = rp.findById(resource.getSuperior());
                        cell = new Cell();
                        if (superior != null) {
                            String sName = superior.getName();
                            if (!StringUtil.isBlank(sName)) {
                                cell.addElement(new Paragraph(sName,
                                        fontChinese));
                            }
                        }
                        rTable.addCell(cell);
                        // 类型
//						String[] types = resource.getType().split(",");
//						cell = new Cell();
//						for(String type:types){
//							if ("00".equals(type)) {
//								cell.addElement(new Paragraph("菜单", fontChinese));
//							} else if ("01".equals(type)) {
//								cell.addElement(new Paragraph("页面", fontChinese));
//							} else if ("100".equals(type)) {
//								cell.addElement(new Paragraph("手机菜单", fontChinese));
//							}
//						}
//						rTable.addCell(cell);
                        //资源描述
                        cell = new Cell();
                        String description = resource.getDescription();
                        cell.addElement(new Paragraph(description, fontChinese));
                        rTable.addCell(cell);
                        // 链接类型
                        cell = new Cell();
                        String linkType = resource.getLinkType();
                        Map<String, String> map = new HashMap<String, String>();
                        map.put("00", "表单");
                        map.put("01", "视图");
                        map.put("02", "报表");
                        map.put("03", "Excel导入");
                        // map.put("04", "");
                        map.put("05", "自定义内部链接");
                        map.put("06", "自定义外部链接");
                        map.put("07", "脚本链接");
                        map.put("08", "邮件链接");
                        map.put("09", "自定义报表");
                        map.put("10", "论坛链接");
                        if (!StringUtil.isBlank(linkType)) {
                            cell.addElement(new Paragraph(
                                    map.get(linkType), fontChinese));
                        }
                        rTable.addCell(cell);
                        // 打开方式
//                        String opentarget = resource.getOpentarget();
//                        cell = new Cell();
//                        map = new HashMap<String, String>();
//                        map.put("detail", "工作区域打开");
//                        map.put("target", "新窗口打开");
//                        if (StringUtil.isBlank(opentarget)) {
//                            opentarget = "detail";
//                        }
//                        cell.addElement(new Paragraph(map.get(opentarget),
//                                fontChinese));
//                        rTable.addCell(cell);
                        // 查询参数
                        String queryString = resource.getQueryString();
                        if (!StringUtil.isBlank(queryString)) {
                            cell = new Cell();
                            cell.setColspan(5);
                            cell.addElement(new Paragraph("参数：\n"
                                    + queryString, fontChinese));
                            rTable.addCell(cell);
                        }
                    }
                }
                mc.addElement(rTable);
                table.addCell(mc);
            }
        }
        return table;
    }

}
