package cn.myapps.conf;

import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Slf4j
@Deprecated
/**
 * 将跟Runtime一样,使用redis来实现该功能
 * @Component
 * @Primary
 */
public class NoopDistributedCacheProviderImpl implements DistributedCacheProvider {
    private static final Map<String, Object> _localMap = new ConcurrentHashMap<>();

    @Override
    public <T> T get(String key) {
        return (T)_localMap.get(key);
    }

    @Override
    public <T> T get(String key, Supplier<T> callback, long expires) {
        if (callback == null) {
            throw new SaasBadException("无效回调函数");
        }

        return callback.get();
    }

    @Override
    public <T> void put(String key, T data) {
        if (!StringUtils.hasLength(key)) {
            return;
        }

        if (data == null) {
            _localMap.remove(key);
        }

        _localMap.put(key, data);
    }

    @Override
    public void clear(String prefix) {
        Collection<String> matchedKeys =
                _localMap.keySet().stream().filter(ii -> ii.startsWith(prefix))
                        .collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(matchedKeys)) {
            matchedKeys.forEach(ky -> {
                _localMap.remove(ky);
            });
        }
    }

    @Override
    public void remove(String key) {
        _localMap.remove(key);
    }

    @Override
    public Collection<String> keys(String prefix) {
        return _localMap.keySet();
    }

    @Override
    public void remove(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }

        keys.forEach(ky -> {
            _localMap.remove(ky);
        });
    }

    @Override
    public <T> void batchPut(Map<String, T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }

        data.keySet().forEach(ky -> {
            put(ky,data.get(ky));
        });
    }

    @Override
    public boolean executeByLock(String key, Runnable runnable) {
        return true;
    }

    @Override
    public boolean lock(String key, int expiredInSeconds) {
        return true;
    }

    @Override
    public void release(String key) {
    }


    @Override
    public <T> void put(String key, T data, long expires) {
        put(key, data);
    }

    @Override
    public <T> void putForSet(String key, Collection<T> data) {
        _localMap.put(key, data);
    }

    @Override
    public <T> void putForSetWithExpired(String key, Collection<T> data, long expires) {
        putForSet(key, data);
    }

    @Override
    public <T> void addToSet(String key, T data) {
        Set<T> t = (Set<T>) _localMap.get(key);
        if (t == null) {
            t = new HashSet<>();
        }
        t.add(data);

        _localMap.put(key, t);
    }

    @Override
    public long getSetSize(String key) {
        Set t = (Set) _localMap.get(key);
        if (t == null) {
            return 0;
        }

        return t.size();
    }

    @Override
    public <T> Collection<T> getRandomFromSet(String key, int count) {
        throw new SaasNoSupportException();
    }

    @Override
    public <T> Collection<T> getFromSet(String key) {
        return (Collection<T>) get(key);
    }

    @Override
    public <T> void removeFromSet(String key, T data) {
        Set<T> t = (Set<T>) _localMap.get(key);
        if (t == null) {
            t = new HashSet<>();
        }
        t.remove(data);

        _localMap.put(key, t);
    }
}
