package cn.myapps.conf;

import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.web.commons.components.RedisDistributedCacheProviderImpl;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import cn.myapps.base.web.interceptor.ActionInterceptor;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.designtime.common.filter.MultiLanguageFilter;
import cn.myapps.designtime.common.filter.TimeOutFilter;
import cn.myapps.designtime.upload.servlet.UploadServlet;
import cn.myapps.listener.ApplicationContextEventListener;
import cn.myapps.util.CheckCodeServlet;
import net.fckeditor.connector.ConnectorServlet;

@Configuration
//@EnableWebMvc
//@ComponentScan(basePackages = "cn.myapps.**.controller,cn.myapps.support.**.action,cn.myapps.support.**.controller,cn.myapps.designtime.**.action,cn.myapps.authtime.**.action,cn.myapps.runtime.**.action,com.teemlink.attendance.**.controller,com.teemlink.email.**.action,com.teemlink.message.**.controller,com.teemlink.pm.**.controller,com.teemlink.qm.**.controller", includeFilters = @Filter(classes = EnableWebMvc.class))
public class MyappsMvcConfig extends WebMvcConfigurerAdapter {


	@Override
	public void addViewControllers(ViewControllerRegistry registry) {
		registry.addViewController("/").setViewName("forward:/admin");
		registry.setOrder(Ordered.HIGHEST_PRECEDENCE);
		super.addViewControllers(registry);
	}

	@Bean
	public CommonsMultipartResolver multipartResolver() {
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
		multipartResolver.setMaxUploadSize(-1);// 不限制上传文件大小
		return multipartResolver;
	}

	//spring 容器启动监听器
	@Bean
	public ApplicationContextEventListener applicationStartListener() {
		return new ApplicationContextEventListener();
	}

	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		registry.addResourceHandler("/**").addResourceLocations("classpath:/static/").addResourceLocations("/");
		String uploadsFolderPath = PropertyUtil.getPath() + "/uploads/";
		registry.addResourceHandler("/uploads/**").addResourceLocations("file:" + uploadsFolderPath);
		super.addResourceHandlers(registry);
	}

	@Autowired
	public SpringApplicationContextUtil utils;

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		super.addInterceptors(registry);


		registry.addInterceptor(new ActionInterceptor()).addPathPatterns("/**/*.action")
				.excludePathPatterns("/static/**");
	}

	@Bean
	public FilterRegistrationBean filterRegistrationBean2() {
		FilterRegistrationBean bean = new FilterRegistrationBean();
		bean.setFilter(new MultiLanguageFilter());
		bean.addUrlPatterns("/dwr/*", "/api/designtime/applications/*", "/api/designtime/login");
//		bean.setOrder(7);
		return bean;
	}

	@Bean
	public FilterRegistrationBean filterRegistrationBean3() {
		FilterRegistrationBean bean = new FilterRegistrationBean();
		bean.setFilter(new TimeOutFilter());
		bean.addUrlPatterns("/*");
//		bean.setOrder(7);
		return bean;
	}

	@Bean // checkCodeServlet 验证码
	public ServletRegistrationBean getCheckCodeServletRegistrationBean() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new CheckCodeServlet());
		bean.addUrlMappings("/api/checkCodeImg"); // 访问路径值
		return bean;
	}

	@Bean // UploadServlet 后台视图类图片上传
	public ServletRegistrationBean getServletRegistrationBean() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new UploadServlet());
		bean.addUrlMappings("/api/UploadServlet"); // 访问路径值
		return bean;
	}

	@Bean // ConnectorServlet FCK编辑器
	public ServletRegistrationBean getConnectorServletRegistrationBean() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new ConnectorServlet());
		bean.addUrlMappings("/formHtml/webeditor/editor/filemanager/connectors/*"); // 访问路径值
		return bean;
	}

	/*
	@Bean
	public RedissonClient redissonClient(RedisProperties redisProperties) {
		Config config = new Config();
		SingleServerConfig singleServerConfig = config.useSingleServer();

		//可以redisss://用来启动SSL
		singleServerConfig.setAddress(String.format("redis://%s:%s", redisProperties.getHost(), redisProperties.getPort()));
		singleServerConfig.setPassword(redisProperties.getPassword());
		singleServerConfig.setConnectionPoolSize(10000);
		singleServerConfig.setPingConnectionInterval(10000);

		RedissonClient redissonClient = Redisson.create(config);

		return redissonClient;
	}


		@Bean
	public DistributedCacheProvider distributedCacheProvider(RedisTemplate redisTemplate, RedissonClient redissonClient) {
		//return new RedisDistributedCacheProviderImpl(redisTemplate, redissonClient);

		return new NoopDistributedCacheProviderImpl();
	}
	 */

	@Bean
	public DistributedCacheProvider distributedCacheProvider() {
		return new NoopDistributedCacheProviderImpl();
	}
}
