package cn.myapps.conf;

import com.bcxin.saas.core.InjectResolver;
import com.bcxin.saas.core.InjectResolverFactory;
import com.bcxin.spring.adpater.config.InjectFactory;
import feign.RequestInterceptor;
import feign.RequestTemplate;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
@Component
public class FeignConfig implements RequestInterceptor, ApplicationContextAware {

    public static String ADMIN_TOKEN;
    public static String ACCESS_TOKEN;
    public static String DESIGNER_TOKEN;

    @Override
    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        //添加token
        requestTemplate.header("Cookie","adminToken="+ADMIN_TOKEN+"; designerToken="+DESIGNER_TOKEN+"");
        requestTemplate.header("feignApi", "true");
    }

    @Override
    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        InjectFactory.setApplicationContext(appContext);

        InjectResolverFactory.setInjectResolver(new InjectResolver() {
            @Override
            public <T> T resolve(Class<T> tClass) {
                return appContext.getBean(tClass);
            }

            @Override
            public <T> T resolve(String beanName) {
                return (T) appContext.getBean(beanName);
            }
        });
    }
}