package cn.myapps.designtime.wizard.service;

import cn.myapps.authtime.common.service.AuthTimeService;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.model.ValueObject;

/**
 * WizardProcess class.
 * 
 * @author zhuxuehong ,Sam
 * @since JDK1.4
 */
public interface WizardProcess extends AuthTimeService<WizardVO> {

	/**
	 * 当确认时，程序创建所有的表单，视图，菜单，流程
	 * 
	 * @param vo
	 *            向导VO
	 * @param user
	 *            当前在线用户
	 * @param applicationid
	 *            当前应用ID
	 * @param contextBasePath
	 *            当前应用的相对路径
	 * @throws Exception
	 */
	public abstract void confirm(ValueObject vo, IUser user, String applicationid, String contextBasePath)
			throws Exception;
}
