package cn.myapps.designtime.report.feignservice;

import cn.myapps.common.model.report.QueryColumnInfo;
import cn.myapps.conf.FeignConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 远程调用runtime服务的接口
 */
@FeignClient(value = "obpm-runtime", path="${myapps.feign-path}", configuration = FeignConfig.class)
public interface RuntimeFeignService {

    /**
     * 获取域列表
     */
    @PostMapping(value = "/api/authtime/domains")
    String getDomainList(@RequestBody String content);

    /**
     * 报表预览
     *
     * @param id
     * @param content
     * @param docid
     * @return
     */
    @PostMapping(value = "/api/runtime/report/showjrxml/{id}")
    String showJrxmlReport(@PathVariable(value = "id") String id, @RequestBody String content, @RequestParam(value = "docid") String docid);

    /**
     * 获取自定义数据源报表的列
     *
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/api/runtime/report/getCustomColumnsInfos")
    List<QueryColumnInfo> getCustomColumnsInfos(@RequestBody String scriptString, @RequestParam(value = "applicationId") String applicationId);
}
