package cn.myapps.designtime.overview;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;

import com.lowagie.text.Cell;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.role.service.RoleDesignTimeService;

/**
 * 角色的pdf表格生成
 * 
 * 2.6版本新增的类
 * 
 * @author keezzm
 * 
 */
public class RoleOverview implements IOverview {

	public Table buildOverview(String applicationId) throws Exception {
		Table table = new Table(1);
		table.setPadding(2);
		table.setSpacing(0);
		table.setBorderWidth(1);
		table.setWidth(100);

		if (!StringUtil.isBlank(applicationId)) {
			BaseFont bfChinese = BaseFont.createFont("STSongStd-Light",
					"UniGB-UCS2-H", false);
			Font fontChinese = new Font(bfChinese, 10, Font.NORMAL, Color.BLACK);
			Cell rc = new Cell();
			rc.setBackgroundColor(Color.gray);
			rc.addElement(new Paragraph("角色：", fontChinese));
			table.addCell(rc);

			RoleDesignTimeService roleService = AuthTimeServiceManager.roleRuntimeService();
			Collection<Role> rs = roleService.getRolesByApplication(applicationId);
			if (rs != null) {
				rc = new Cell();
				Table rTable = new Table(1);
				rTable.setWidth(96);
				rTable.setPadding(0);
				rTable.setSpacing(0);
				rTable.setBorderWidth(0);

				Iterator<Role> it_role = rs.iterator();
				while (it_role.hasNext()) {
					Role role = it_role.next();
					if (role != null) {
						// 名称
						String rName = role.getName();
						Cell cell = new Cell();
						cell.addElement(new Paragraph("名称："
								+ (rName != null ? rName : ""), fontChinese));
						//designer不连接数据源，因此查询用户失效
						//rTable.addCell(cell);
						/*// 角色用户
						cell.addElement(new Paragraph("包含的用户：\n", fontChinese));
						Table uTable = new Table(4);
						uTable.setWidth(100);
						uTable.setPadding(0);
						uTable.setSpacing(0);
						uTable.setBorderWidth(1);

						// 表头
						Cell uc = new Cell();
						uc.setBackgroundColor(Color.gray);
						uc.addElement(new Paragraph("用户名", fontChinese));
						uTable.addCell(uc);

						uc = new Cell();
						uc.setBackgroundColor(Color.gray);
						uc.addElement(new Paragraph("账号", fontChinese));
						uTable.addCell(uc);

						uc = new Cell();
						uc.setBackgroundColor(Color.gray);
						uc.addElement(new Paragraph("电子邮箱", fontChinese));
						uTable.addCell(uc);

						uc = new Cell();
						uc.setBackgroundColor(Color.gray);
						uc.addElement(new Paragraph("手机", fontChinese));
						uTable.addCell(uc);

		                UserProcess userProcess = new UserProcessBean();
		                Collection<UserVO> users = userProcess.queryByRole(role.getId());

//						Collection<UserVO> users = role.getUsers();
						if (users != null) {
							Iterator<UserVO> it_user = users.iterator();
							while (it_user.hasNext()) {
								UserVO user = it_user.next();
								if (user != null) {
									uc = new Cell();
									// 用户名
									String username = user.getName();
									uc = new Cell();
									uc.addElement(new Paragraph(
											username != null ? username : "",
											fontChinese));
									uTable.addCell(uc);

									// 账号
									String loginno = user.getLoginno();
									uc = new Cell();
									uc.addElement(new Paragraph(
											loginno != null ? loginno : "",
											fontChinese));
									uTable.addCell(uc);

									// 电子邮箱
									String email = user.getEmail();
									uc = new Cell();
									uc.addElement(new Paragraph(
											email != null ? email : "",
											fontChinese));
									uTable.addCell(uc);

									// 手机
									String telephone = user.getTelephone();
									uc = new Cell();
									uc.addElement(new Paragraph(
											telephone != null ? telephone : "",
											fontChinese));
									uTable.addCell(uc);
								}
							}
						}
						cell.addElement(uTable);*/
						rTable.addCell(cell);
					}
				}
				rc.addElement(rTable);
				table.addCell(rc);
			}
		}
		return table;
	}

}
