package cn.myapps.designtime.compile.controller;

import javax.xml.parsers.ParserConfigurationException;

import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.xml.sax.SAXException;

import cn.myapps.common.Environment;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.helper.service.HelpHelper;
import cn.myapps.runtime.macro.runner.CompileHelper;
import cn.myapps.util.http.CookieUtil;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

/**
 * 脚本编辑器模块
 */
@Component
@RequestMapping(value = "/api/designtime")
@Scope("prototype")
public class CompileController extends AbstractDesignTimeController {

    /**
     * 脚本预编译
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/applications/iscript/compile")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "脚本预编译", notes = "脚本预编译")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "脚本内容", required = true, paramType = "body", dataType = "string")
    })
    public Resource compile(@RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject(content);
            String iscriptString = (String) json.get("iscriptString");
            String result = CompileHelper.compile(iscriptString,request);
            return success("ok", result);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 脚本帮助接口
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/applications/iscript/getIscriptHelp")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "脚本帮助接口", notes = "脚本帮助接口")
    public Resource getIscriptHelp(String staticPath) throws Exception {
        String iscriptHtml = "";
        HelpHelper hhelper = new HelpHelper();
        Environment.getInstance().setContextPath(request.getContextPath());
        String language = CookieUtil.getMultiLanguage(request);
        try {
            iscriptHtml = hhelper.getIscriptHelp(language,staticPath);
            return success("ok", iscriptHtml);
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        } catch (SAXException e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }

    }

}
