package cn.myapps.designtime.common.controller;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Restful 接口返回的校验错误信息对象
 * 
 * @author spy
 *
 */
@ApiModel
public class ErrorMessage {

	@ApiModelProperty(name = "errcode",value = "错误代码")
	private int errcode;

	@ApiModelProperty(name = "field",value = "错误字段")
	private String field;

	@ApiModelProperty(name = "errmsg",value = "错误信息")
	private String errmsg;

	public ErrorMessage() {
		super();
	}

	public String getField() {
		return field;
	}

	public void setField(String field) {
		this.field = field;
	}

	public ErrorMessage(int errcode, String field, String errmsg) {
		super();
		this.errcode = errcode;
		this.field = field;
		this.errmsg = errmsg;
	}

	public String getErrmsg() {
		return errmsg;
	}

	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}

	public int getErrcode() {
		return errcode;
	}

	public void setErrcode(int errcode) {
		this.errcode = errcode;
	}
}
