package cn.myapps.conf;

import cn.myapps.common.DataSourceFactory;
import cn.myapps.common.util.DbUtil;
import cn.myapps.components.MessageProvider;
import cn.myapps.components.SettingProvider;
import cn.myapps.components.requests.CreateMessageRequest;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

import javax.sql.DataSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by arnold.zhu on 6/13/2017.
 */
@ConditionalOnProperty("${spring.datasource}")
@Configuration
public class DataSourceConfig implements TransactionManagementConfigurer {

    @Value("${spring.datasource.url}")
    private String dbUrl;

    @Value("${spring.datasource.username}")
    private String username;

    @Value("${spring.datasource.password}")
    private String password;

    @Value("${spring.datasource.driver-class-name}")
    private String driverClassName;

    @Value("${spring.datasource.validationQuery}")
    private String validationQuery;

    @Bean
    public DataSource druidDataSource() {
        DataSource ds = null;

        Map<String, String> properties = new HashMap<String, String>();
        properties.put("driverClassName", driverClassName);
        properties.put("url", dbUrl);
        properties.put("username", username);
        properties.put("password", password);
        validationQuery = DbUtil.getValidationQuery(driverClassName);
        properties.put("validationQuery", validationQuery);
        try {
            ds = DataSourceFactory.create(properties);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }


    @Bean
    public JdbcTemplate jdbcTemplate(DataSource kmDataSource) {
        return new JdbcTemplate(kmDataSource);

    }

    @Override
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(druidDataSource());
    }


    @Bean
    public MessageProvider messageProvider() {
        return new MessageProvider() {
            @Override
            public void dispatch(String senderId, MessageType messageType, String title, String content, ReceiverType receiverType, String receiver, String businessNumber, String uniqueId) {

            }

            @Override
            public void dispatch(CreateMessageRequest request) {

            }

            @Override
            public void dispatch(Collection<CreateMessageRequest> requests) {

            }
        };
    }

    @Bean
    public SettingProvider settingProvider() {
        return new SettingProvider() {
            @Override
            public String getSettingWithCache(String category, String key, int seconds) {
                return null;
            }

            @Override
            public String getSetting(String category, String key) {
                return null;
            }
        };
    }
}