# @turf/nearest-point

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## nearestPoint

Takes a reference [point][1] and a FeatureCollection of Features
with Point geometries and returns the
point from the FeatureCollection closest to the reference. This calculation
is geodesic.

**Parameters**

-   `targetPoint` **[Coord][2]** the reference point
-   `points` **[FeatureCollection][3]&lt;[Point][4]>** against input point set

**Examples**

```javascript
var targetPoint = turf.point([28.965797, 41.010086], {"marker-color": "#0F0"});
var points = turf.featureCollection([
    turf.point([28.973865, 41.011122]),
    turf.point([28.948459, 41.024204]),
    turf.point([28.938674, 41.013324])
]);

var nearest = turf.nearestPoint(targetPoint, points);

//addToMap
var addToMap = [targetPoint, points, nearest];
nearest.properties['marker-color'] = '#F00';
```

Returns **[Feature][5]&lt;[Point][4]>** the closest point in the set to the reference point

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[3]: https://tools.ietf.org/html/rfc7946#section-3.3

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/nearest-point
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
