(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["home"],{

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/AMap/infowindow/index.vue?vue&type=script&lang=js":
/*!*****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/AMap/infowindow/index.vue?vue&type=script&lang=js ***!
  \*****************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__);


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "AInfoWindow",
  inject: ["map"],
  props: {
    // see complete options documentation https://lbs.amap.com/api/javascript-api-v2/documentation#infowindow
    infoWindowOptions: {
      type: Object
    },
    className: {
      type: [String, Array]
    },
    mapType: {
      type: String,
      default: "tianditu"
    }
  },
  data() {
    return {
      infoWindow: null
    };
  },
  watch: {
    infoWindowOptions: {
      handler(value) {
        if (value && this.mapType !== 'tianditu') {
          const {
            position,
            offset
          } = value;
          if (position) {
            if (this.infoWindow) {
              this.infoWindow.setOffset(offset);
              this.infoWindow.open(this.map.map, position);
            } else {
              this.init();
              this.infoWindow.open(this.map.map, position);
            }
          } else {
            this.infoWindow.close();
          }
        }
      },
      deep: true,
      immediate: false
    }
  },
  methods: {
    init() {
      this.infoWindow = new this.map.AMap.InfoWindow({
        content: this.$refs.windowInfo,
        ...this.infoWindowOptions
      });
      this.infoWindow.on("open", () => {
        this.$emit("open");
      });
      this.infoWindow.on("close", () => {
        this.$emit("close");
      });
      // 鼠标移入弹框移除地图滚轮监听，避免两者滚轮事件冲突；移除弹框后恢复。
      this.infoWindow.on("mouseover", () => {
        this.map.map.setStatus({
          scrollWheel: false
        });
      });
      this.infoWindow.on("mouseout", () => {
        this.map.map.setStatus({
          scrollWheel: true
        });
      });
      this.infoWindow.on("click", () => {
        this.$emit("click");
      });
      // console.log(this.infoWindow);
    }
  },
  mounted() {
    if (this.mapType !== 'tianditu') {
      this.init();
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/AMap/map/index.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/AMap/map/index.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.find.js */ "./node_modules/core-js/modules/es.iterator.find.js");
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _api_tenant_user_controller__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/api/tenant-user-controller */ "./src/api/tenant-user-controller.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! nanoid */ "./node_modules/nanoid/index.browser.js");
/* harmony import */ var _amap_amap_jsapi_loader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @amap/amap-jsapi-loader */ "./node_modules/@amap/amap-jsapi-loader/dist/index.js");
/* harmony import */ var _amap_amap_jsapi_loader__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_amap_amap_jsapi_loader__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/utils */ "./src/utils/index.js");
/* harmony import */ var _api_amap__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/api/amap */ "./src/api/amap.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _views_dispatch_components_lnglatMap_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/views/dispatch/components/lnglatMap.js */ "./src/views/dispatch/components/lnglatMap.js");
/* harmony import */ var gcoord__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! gcoord */ "./node_modules/gcoord/dist/gcoord.esm-bundler.js");













/* harmony default export */ __webpack_exports__["default"] = ({
  name: "AMap",
  provide() {
    return {
      map: this
    };
  },
  props: {
    // map container element id
    mapType: {
      type: String,
      default: ""
    },
    id: {
      type: String,
      default: `map-${Object(nanoid__WEBPACK_IMPORTED_MODULE_6__["nanoid"])()}`
    },
    // map container width
    width: {
      type: [String, Number],
      default: "100%"
    },
    // map container height
    height: {
      type: [String, Number],
      default: "100%"
    },
    // see complete options documentation https://lbs.amap.com/api/javascript-api-v2/guide/abc/load
    loadOptions: {
      type: Object
    },
    // see complete options documentation https://lbs.amap.com/api/javascript-api-v2/documentation#map
    mapOptions: {
      type: Object
    },
    // collection for markers. one marker options complete documentation https://lbs.amap.com/api/javascript-api-v2/documentation#marker
    markers: {
      type: Array,
      default() {
        return [];
      }
    },
    cluster: Object,
    // {dataOptions[],MarkerClusterOptions{}}
    // see complete options documentation https://lbs.amap.com/api/javascript-api-v2/documentation#overlaygroup
    overlayGroupOptions: {
      type: Object
    },
    layers: {
      type: Array,
      default() {
        return [];
      }
    },
    // see all plugin https://lbs.amap.com/api/javascript-api-v2/guide/abc/plugins-list
    plugin: {
      type: Array
    },
    moveStartIndex: {
      type: Number,
      default: 0
    },
    moveAlong: {
      // https://developer.amap.com/api/jsapi-v2/documentation#markermovealong -- opts
      type: Object,
      default() {
        return {};
      }
    },
    moveMarker: {
      // https://lbs.amap.com/api/javascript-api-v2/documentation#marker
      type: Object,
      default() {
        return {};
      }
    },
    speedRatio: {
      type: Number,
      default: 1
    },
    toolbar: {
      type: Object,
      default() {
        return {
          position: {
            bottom: "120px",
            left: "40px"
          },
          offset: [0, 0]
        };
      }
    },
    scale: {
      type: Object
    },
    controlBar: {
      type: Object,
      default() {
        return {
          position: {
            bottom: "20px",
            left: "10px"
          },
          offset: [0, 0]
        };
      }
    }
  },
  data() {
    return {
      AMap: null,
      map: null,
      city: "",
      overlayGroup: null,
      infoWindow: null,
      layersList: {},
      plugins: {
        CitySearch: null,
        MouseTool: null,
        PlaceSearch: null
      },
      drawPolygonEdit: null,
      polygonEditor: null,
      drawCircleEdit: null,
      circleEditor: null,
      rectangleEditor: null,
      rectangle: null,
      railCircle: null,
      moveAnimationMarker: null,
      movePath: [],
      currentIndex: 0,
      roadPolyline: null,
      trackMarker: null,
      timer: null,
      drawType: "",
      trafficLayer: null,
      trafficLayerVisible: false,
      currentLocation: null,
      clusterTarget: null,
      polyEditor: null
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_5__["mapState"])({
      placeKeywords: state => state.placeKeywords,
      appLoadingMask: state => state.appLoadingMask
    }),
    mapStyle() {
      return {
        width: typeof this.width === "string" ? this.width : this.width.toString() + "px",
        height: typeof this.height === "string" ? this.height : this.height.toString() + "px"
      };
    }
  },
  watch: {
    markers: {
      handler() {
        if (this.mapType === 'tianditu') {
          if (this.markers && this.markers.length > 0) {
            this.markers.map(data => {
              const {
                extData
              } = data;
              const lnglat = {
                lng: extData === null || extData === void 0 ? void 0 : extData.longitude,
                lat: extData === null || extData === void 0 ? void 0 : extData.latitude
              };
              const marker = new T.Marker(lnglat, {
                icon: this.getMapIcon(data.icon || extData.icon)
              });
              this.map.addOverLay(marker);
              this.$emit("setWinInfo", marker, data);
              if (data.panTo) {
                const _this = this;
                setTimeout(function () {
                  _this.map.panTo(new T.LngLat(extData === null || extData === void 0 ? void 0 : extData.longitude, extData === null || extData === void 0 ? void 0 : extData.latitude));
                }, 500);
              }
            });
          }
        } else {
          // this.map.clearMap();
          if (this.clusterTarget) this.map.remove(this.clusterTarget);
          if (this.overlayGroup) {
            this.overlayGroup.clearOverlays();
          }
          if (this.markers && this.markers.length > 0) {
            const markers = this.markers.map(marker => {
              return new this.AMap.Marker({
                ...marker,
                icon: this.setIcon(marker.icon)
              });
            });
            // 创建覆盖物群组，传入覆盖物组成的数组
            this.overlayGroup = new this.AMap.OverlayGroup(markers);

            // 对此覆盖物群组设置同一属性
            if (this.overlayGroupOptions) this.overlayGroup.setOptions(this.overlayGroupOptions);

            // this.overlayGroup.on("click", this.overlayGroupClickHandler);

            // 统一添加到地图实例上
            this.map.add(this.overlayGroup);
            this.overlayGroup.on("click", this.overlayGroupClickHandler);
            // this.infoWindow = new AMap.InfoWindow({
            //   ...this.infoWindowOptions,
            //   content: this.$refs.windowInfo,
            // });
          }
        }
      },
      deep: true,
      immediate: false
    },
    "cluster.dataOptions": {
      handler(value = []) {
        console.log("cluster.dataOptions", this.clusterTarget);
        console.log("cluster.dataOptions", value);
        if (this.clusterTarget) {
          this.clusterTarget.setMap(null);
          this.map.plugin(["AMap.MarkerCluster"], () => {
            this.clusterTarget = new this.AMap.MarkerCluster(this.map, value, this.cluster.MarkerClusterOptions);
            this.clusterTarget.on("click", data => this.$emit("clickCluster", data, this.map));
          });
        } else {
          this.map.plugin(["AMap.MarkerCluster"], () => {
            this.clusterTarget = new this.AMap.MarkerCluster(this.map, value, this.cluster.MarkerClusterOptions);
            this.clusterTarget.on("click", data => this.$emit("clickCluster", data, this.map));
          });
        }
      },
      deep: true,
      immediate: false
    },
    layers: {
      handler(value) {
        if (value && value.length > 0) {
          if (this.mapType === "tianditu") {
            if (value !== null && value !== void 0 && value.find(e => e.type === "default")) {
              this.map.setMapType(window.TMAP_NORMAL_MAP);
            } else {
              this.map.setMapType(window.TMAP_SATELLITE_MAP);
            }
          } else {
            this.map.getLayers().forEach(layer => {
              this.map.removeLayer(layer);
            });
            this.map.setLayers(this.setLayers(this.AMap));
          }
        }
      },
      deep: true,
      immediate: false
    },
    placeKeywords(value) {
      this.placeSearch(value);
    }
  },
  methods: {
    getLayers() {
      return this.layersList;
    },
    setLayers(AMap) {
      this.layersList = {};
      if (this.layers.length > 0) {
        this.layers.forEach(layer => {
          switch (layer.type) {
            case "Satellite":
              this.layersList["Satellite"] = new AMap.TileLayer.Satellite(layer === null || layer === void 0 ? void 0 : layer.opts);
              break;
            case "RoadNet":
              this.layersList["RoadNet"] = new AMap.TileLayer.RoadNet(layer === null || layer === void 0 ? void 0 : layer.opts);
              break;
            default:
              this.layersList["default"] = new AMap.TileLayer(layer === null || layer === void 0 ? void 0 : layer.opts);
              break;
          }
        });
        console.log(this.layersList);
        return lodash__WEBPACK_IMPORTED_MODULE_10___default.a.values(this.layersList);
      } else {
        this.layersList["default"] = new AMap.TileLayer();
        return [new AMap.TileLayer()];
      }
    },
    initTiandiMap(lng, lat) {
      // this.map = new T.Map(this.id);
      const imageURL = "http://t0.tianditu.gov.cn/img_w/wmts?" + "SERVICE=WMTS&REQUEST=GetTile&VERSION=1.0.0&LAYER=img&STYLE=default&TILEMATRIXSET=w&FORMAT=tiles" + "&TILEMATRIX={z}&TILEROW={y}&TILECOL={x}&tk=18111c7ecf3f616faf921e930914e879";
      //创建自定义图层对象
      const lay = new T.TileLayer(imageURL, {
        minZoom: 1,
        maxZoom: 18
      });
      const config = {
        layers: [lay]
      };
      //初始化地图对象
      this.map = new T.Map(this.id, config);
      if (lng && lat) {
        this.map.centerAndZoom(new T.LngLat(lng, lat), 13);
      } else {
        this.map.centerAndZoom(new T.LngLat(118.084283, 24.482525), 13);
      }
      //   const _this = this;
      //   const lo = new T.Geolocation();
      //   console.log('H5定位开始');
      //   const fn = function (e) {
      //     console.log('H5定位：e: ', e, this.getStatus());
      //     //当前为移动端时
      //     if (this.getStatus() == 0) {
      //       _this.map.centerAndZoom(e.lnglat, 13);
      //     }
      //     //当前为PC端时
      //     if (this.getStatus() == 1) {
      //       _this.map.centerAndZoom(e.lnglat, e.level);
      //     }
      //     if (this.getStatus() == 2) {
      //       _this.map.centerAndZoom(e.lnglat, 13);
      //     }
      //   };
      //   lo.getCurrentPosition(fn);
      this.$emit("emitMap", this.map, {});
      this.map.addEventListener("click", this.clickHandler);
      if (this.markers && this.markers.length > 0) {
        this.markers.map(data => {
          const coordinates = data.lonlat.split(",");
          const lnglat = {
            lng: coordinates[0],
            lat: coordinates[1]
          };
          const marker = new T.Marker(lnglat, {
            icon: this.getMapIcon(data.icon)
          });
          this.map.addOverLay(marker);
        });
      }
    },
    // 获取天地图marker图标
    getMapIcon(url) {
      const icon = new T.Icon({
        iconUrl: url,
        iconSize: new T.Point(32, 42),
        // 图标可视区域的大小
        iconAnchor: new T.Point(30, 30) // 图标的定位锚点
      });
      return icon;
    },
    async initMap() {
      if (this.mapType === 'tianditu') {
        Object(_api_tenant_user_controller__WEBPACK_IMPORTED_MODULE_4__["getCurrentUser"])().then(res => {
          this.initTiandiMap(res.orgLongitude, res.orgLatitude);
        }).catch(() => {
          this.initTiandiMap();
        });
      } else {
        const {
          mapConfig
        } = await Object(_utils__WEBPACK_IMPORTED_MODULE_8__["getConfig"])();
        const {
          load,
          map
        } = mapConfig;
        const loadOptions = {
          ...this.loadOptions,
          ...load
        };
        console.log(loadOptions);
        // load AMap api
        _amap_amap_jsapi_loader__WEBPACK_IMPORTED_MODULE_7___default.a.load(loadOptions).then(AMap => {
          this.AMap = AMap;
          // generate map object

          this.map = new AMap.Map(this.id, {
            ...this.mapOptions,
            ...map,
            layers: this.setLayers(AMap)
          });
          // 楼块图层
          const buildingLayer = new this.AMap.Buildings({
            zooms: [1, 20]
          });
          this.map.addLayer(buildingLayer);
          this.$emit("emitMap", this.map, AMap);
          // bind events
          this.map.on("click", this.clickHandler);

          // set overlayGroup
          if (this.markers && this.markers.length > 0) {
            const markers = this.markers.map(marker => {
              return new AMap.Marker({
                ...marker,
                icon: this.setIcon(marker.icon)
              });
            });
            // 创建覆盖物群组，传入覆盖物组成的数组
            this.overlayGroup = new AMap.OverlayGroup(markers);

            // 对此覆盖物群组设置同一属性
            if (this.overlayGroupOptions) this.overlayGroup.setOptions(this.overlayGroupOptions);
            this.overlayGroup.on("click", this.overlayGroupClickHandler);

            // 统一添加到地图实例上
            this.map.add(this.overlayGroup);
          }
          // 根据IP获取当前城市
          AMap.plugin("AMap.CitySearch", () => {
            console.log("AMap.CitySearch  成功调用插件", this.AMap);
            this.plugins.CitySearch = new AMap.CitySearch();
            this.AMap.Event.addListener(this.plugins.CitySearch, "complete", CitySearchResult => {
              console.log("AMap.CitySearch complete", CitySearchResult);
            }); //返回定位信息
            this.AMap.Event.addListener(this.plugins.CitySearch, "error", error => {
              console.log("AMap.CitySearch error", error);
            }); //返回定位出错信息
            console.log("AMap.CitySearch 成功生成CitySearch插件", this.plugins.CitySearch);
            this.plugins.CitySearch.getLocalCity((status, result) => {
              console.log("获取 CitySearch.getLocalCity 返回值", status, result);
              if (status === "complete" && result.info === "OK") {
                // 查询成功，result即为当前所在城市信息
                const {
                  city
                } = result;
                this.city = city;
              }
            });
          });

          // set plugins
          if (this.plugin && this.plugin.length > 0) {
            this.map.plugin(this.plugin, () => {
              this.plugin.forEach(plugin => {
                console.log("set plugins", plugin);
                this.setPlugin(plugin);
              });
            });
          }

          // if(process.env.VUE_APP_ENV === "development") {
          this.map.on("complete", () => {
            this.$emit("complete");
          });
          // }else {
          // AMap.plugin("AMap.Geolocation", () => {
          //   const geolocation = new AMap.Geolocation({
          //     enableHighAccuracy: true, //是否使用高精度定位，默认:true
          //     timeout: 30000, //超过10秒后停止定位，默认：5s
          //     showButton: false,
          //     zoomToAccuracy: false, //定位成功后是否自动调整地图视野到定位点
          //   });
          //   this.map.addControl(geolocation);
          //   geolocation.getCurrentPosition((status, result) => {
          //     console.log("on get current position complete", result, this.map);
          //     if (status === "complete") {
          //       this.currentLocation = result;
          //       this.$emit("complete");
          //     } else {
          //       // onError(result)
          //       this.$message.error("获取浏览器定位失败");
          //     }
          //   });
          // });
          // }

          this.setControl();
          this.trafficLayer = new this.AMap.TileLayer.Traffic({
            zIndex: 10,
            // zooms: [7, 22],
            visible: this.trafficLayerVisible
          });
          this.trafficLayer.setMap(this.map);
        }).catch(e => {
          console.log(e);
        });
      }
    },
    setControl() {
      if (this.scale) {
        this.map.plugin(["AMap.Scale"], () => {
          const control = new this.AMap.Scale(this.scale);
          this.map.addControl(control);
        });
      }
      if (this.controlBar) {
        this.map.plugin(["AMap.ControlBar"], () => {
          const control = new this.AMap.ControlBar(this.controlBar);
          this.map.addControl(control);
        });
      }
      if (this.toolbar) {
        this.map.plugin(["AMap.ToolBar"], () => {
          const control = new this.AMap.ToolBar(this.toolbar);
          this.map.addControl(control);
        });
      }
    },
    setIcon(icon) {
      if (!icon || typeof icon === "string") {
        return icon;
      } else {
        return new this.AMap.Icon(icon);
      }
    },
    /**
     * @注册插件 https://lbs.amap.com/api/javascript-api-v2/guide/abc/plugins
     * @param {String} plugin
     */
    setPlugin(plugin) {
      const pluginName = plugin.split(".")[1];
      switch (plugin) {
        case "AMap.MouseTool":
          // https://developer.amap.com/api/jsapi-v2/documentation#mousetool
          this.plugins[pluginName] = new this.AMap[pluginName](this.map);
          this.plugins[pluginName].on("draw", event => {
            // event.obj 为绘制出来的覆盖物对象
            // console.log(event)
            const params = {
              drawType: this.drawType,
              ...event
            };
            this.$emit("draw", params);
          });
          break;
        case "AMap.PlaceSearch":
          // https://developer.amap.com/api/jsapi-v2/documentation#mousetool
          console.log(this.city);
          this.plugins[pluginName] = new this.AMap[pluginName]({
            city: this.city,
            extensions: "all"
          });
          break;
      }
      console.log(this.plugins);
    },
    /**
     * @ 地图点击事件 https://developer.amap.com/api/jsapi-v2/documentation#mapeventclick
     * @param {*} e https://developer.amap.com/api/jsapi-v2/documentation#mapsevent
     */
    clickHandler(e) {
      this.$emit("clickMap", e);
    },
    /**
     * @要素集合图层点击事件
     * @param {*} e https://developer.amap.com/api/jsapi-v2/documentation#mapsevent
     */
    overlayGroupClickHandler(e) {
      this.$emit("clickMarker", e);
    },
    // 划自由线
    polyline(type) {
      if (this.plugin && this.plugin.length > 0 && this.plugin.includes("AMap.MouseTool")) {
        switch (type) {
          case "polyline":
            {
              this.drawType = type;
              this.plugins.MouseTool.polyline({
                strokeColor: "#28F",
                //线颜色
                strokeWeight: 4 //线宽
              });
              break;
            }
        }
      } else {
        this.$message.error("未注册MouseTool");
      }
    },
    // 厦马路线
    xmPolyline() {
      if (this.mapType === "tianditu") {
        const path = _views_dispatch_components_lnglatMap_js__WEBPACK_IMPORTED_MODULE_11__["default"].map(e => {
          const result = gcoord__WEBPACK_IMPORTED_MODULE_12__["default"].transform([e.lng, e.lat],
          // 经纬度坐标
          gcoord__WEBPACK_IMPORTED_MODULE_12__["default"].GCJ02,
          // 当前坐标系
          gcoord__WEBPACK_IMPORTED_MODULE_12__["default"].WGS84 // 目标坐标系
          );
          return new T.LngLat(result[0], result[1]);
        });
        //创建线对象
        const line = new T.Polyline(path);
        //向地图上添加线
        this.map.addOverLay(line);
        this.setText(path);
        this.$emit("setShowRouteDetail", {
          polylineObj: line
        });
        const _this = this;
        setTimeout(function () {
          _this.map.panTo(new T.LngLat(Number(118.084283), Number(24.482525)));
        }, 500);
      } else {
        const path = _views_dispatch_components_lnglatMap_js__WEBPACK_IMPORTED_MODULE_11__["default"].map(e => [e.lng, e.lat]);
        const polyline = new this.AMap.Polyline({
          path: path,
          strokeColor: "#28F",
          strokeWeight: 4,
          cursor: "pointer" //指定鼠标悬停时的鼠标样式。
        });
        this.map.add([polyline]);
        this.map.setFitView();
        this.setText(path);
        this.$emit("setShowRouteDetail", {
          polylineObj: polyline
        });
      }
    },
    // 添加文字点标识
    setText(path) {
      if (this.mapType === "tianditu") {
        path.map((item, index) => {
          const latlng = new T.LngLat(item.lng, item.lat);
          const label = new T.Label({
            text: `${index}`,
            position: latlng,
            offset: new T.Point(-9, 0)
          });
          //创建地图文本对象
          this.map.addOverLay(label);
        });
      } else {
        path.map((item, index) => {
          const text = new this.AMap.Text({
            text: !index ? "0" : index,
            //标记显示的文本内容
            anchor: "center",
            //设置文本标记锚点位置
            // draggable: true, //是否可拖拽
            cursor: "pointer",
            //指定鼠标悬停时的鼠标样式。
            // angle: 10, //点标记的旋转角度
            style: {
              //设置文本样式，Object 同 css 样式表
              "border-radius": "30px",
              "background-color": "white",
              width: "30px",
              height: "30px",
              display: "flex",
              "align-items": "center",
              "justify-content": "center",
              "border-width": 0,
              "font-size": "16px",
              color: "blue"
            },
            position: item //点标记在地图上显示的位置
          });
          text.setMap(this.map);
        });
      }
    },
    // 地图上查看
    addPolyline(data) {
      console.log("🚀 ~ addPolyline ~ data:", data);
      if (this.mapType === "tianditu") {
        const {
          roadmap
        } = data;
        // const path = roadmap.path.map(e => { return {lng: e[0], lat: e[1]}})
        //创建线对象
        const line = new T.Polyline(roadmap.path);
        //向地图上添加线
        line.setWeight(roadmap.strokeWeight || "#28F");
        line.setColor(roadmap.color || 4);
        this.map.addOverLay(line);
        this.$emit("storagePolyine", line);
        this.setText(roadmap.path);
        this.polylineData = data;
        const _this = this;
        line.on("click", function (e) {
          e.target.enableEdit();
          _this.$emit("setShowRouteDetail", {
            ...data,
            polylineObj: e.target
          });
        });
      } else {
        const {
          roadmap
        } = data;
        const polyline = new this.AMap.Polyline({
          path: roadmap.path,
          strokeColor: roadmap.color || "#28F",
          strokeWeight: roadmap.strokeWeight || 4,
          cursor: "pointer" //指定鼠标悬停时的鼠标样式。
        });
        this.map.add([polyline]);
        this.map.setFitView();
        this.$emit("storagePolyine", polyline);
        this.setText(roadmap.path);
        this.polylineData = data;
        const _this = this;
        polyline.on("click", function (e) {
          console.log("🚀 ~ polyline ~ click:--edit", e);
          _this.map.plugin(["AMap.PolylineEditor"], () => {
            _this.polyEditor = new _this.AMap.PolylineEditor(_this.map, polyline);
            _this.polyEditor.setTarget(polyline);
            _this.polyEditor.open();
            _this.$emit("setShowRouteDetail", {
              ...data,
              polylineObj: polyline
            });
          });
        });
      }
    },
    // 路线编辑
    setPolyEditor(polyline) {
      const _this = this;
      polyline.on("click", function (e) {
        _this.polyEditor.setTarget(e.target);
        _this.polyEditor.open();
        _this.$emit("setShowRouteDetail", {
          ..._this.polylineData,
          polylineObj: polyline
        });
      });
      this.map.plugin(["AMap.PolylineEditor"], () => {
        this.polyEditor = new this.AMap.PolylineEditor(this.map, polyline);
        this.polyEditor.setTarget(polyline);
        this.polyEditor.open();
      });
    },
    // 线路保存后关闭编辑器
    setPolyEditorClose(data) {
      if (this.mapType === "tianditu") {
        this.polyEditor && this.polyEditor.disableEdit();
        if (data) {
          const {
            roadmap,
            polylineObj
          } = data;
          polylineObj && polylineObj.disableEdit();
          this.map.addOverLay(polylineObj);
          this.polylineData = data;
          polylineObj.setWeight(roadmap.strokeWeight);
          polylineObj.setColor(roadmap.color);
        }
      } else {
        this.polyEditor && this.polyEditor.close();
        this.plugins.MouseTool.close(true);
        if (data) {
          const {
            roadmap,
            polylineObj
          } = data;
          this.map.add([polylineObj]);
          this.map.setFitView();
          this.polylineData = data;
          polylineObj.setOptions({
            strokeWeight: roadmap.strokeWeight,
            strokeColor: roadmap.color
          });
        }
      }
    },
    //工具栏选择图形
    circle(type) {
      // 先判断组件是否注册
      if (this.plugin && this.plugin.length > 0 && this.plugin.includes("AMap.MouseTool")) {
        switch (type) {
          case "circle":
            {
              this.drawType = type;
              this.plugins.MouseTool.circle();
              break;
            }
        }
      } else {
        this.$message.error("未注册MouseTool");
      }
    },
    //工具栏选择图形
    square(type) {
      // 先判断组件是否注册
      if (this.plugin && this.plugin.length > 0 && this.plugin.includes("AMap.MouseTool")) {
        switch (type) {
          case "square":
            {
              this.drawType = type;
              this.plugins.MouseTool.rectangle();
              break;
            }
        }
      } else {
        this.$message.error("未注册MouseTool");
      }
    },
    //工具栏选择图形
    polygon(type) {
      // 先判断组件是否注册
      if (this.plugin && this.plugin.length > 0 && this.plugin.includes("AMap.MouseTool")) {
        switch (type) {
          case "polygon":
            {
              this.drawType = type;
              this.plugins.MouseTool.polygon();
              break;
            }
        }
      } else {
        this.$message.error("未注册MouseTool");
      }
    },
    /**
     * @测量
     * @param {String} type
     */
    measure(type) {
      // 先判断组件是否注册
      if (this.plugin && this.plugin.length > 0 && this.plugin.includes("AMap.MouseTool")) {
        switch (type) {
          case "rule":
            {
              this.plugins.MouseTool.rule();
              break;
            }
          case "measureArea":
            {
              this.plugins.MouseTool.measureArea();
              break;
            }
        }
      } else {
        this.$message.error("未注册MouseTool");
      }
    },
    /**
     * @清除测量
     */
    clearMeasure() {
      // 先判断组件是否注册
      if (this.plugin && this.plugin.length > 0 && this.plugin.includes("AMap.MouseTool")) {
        this.drawType = "";
        this.plugins.MouseTool.close(true); //关闭，并清除覆盖物
      } else {
        this.$message.error("未注册MouseTool");
      }
    },
    setCenter(center, immediately, duration) {
      this.map.setCenter(center, immediately, duration);
    },
    setZoomAndCenter(zoom, center, immediately, duration) {
      this.map.setZoomAndCenter(zoom, center, immediately, duration);
    },
    setZoom(zoom) {
      this.map.setZoom(zoom);
    },
    getFitZoomAndCenterByOverlays(overlays, avoid, maxZoom) {
      return this.map.getFitZoomAndCenterByOverlays(overlays, avoid, maxZoom);
    },
    getAllOverlays(type) {
      return this.map.getAllOverlays(type);
    },
    getOverlays() {
      return this.overlayGroup.getOverlays();
    },
    placeSearch(keywords) {
      Object(_api_amap__WEBPACK_IMPORTED_MODULE_9__["place"])({
        keywords: keywords,
        offset: 10,
        city: this.city
      }).then(res => {
        let list = [];
        const {
          status,
          data
        } = res;
        if (status === 200) {
          console.log("poidata", data);
          list = data.tips;
        }
        this.$emit("placeSearch", list);
        this.$store.commit("SET_POI_LIST", list);
      }).catch(err => {
        console.log(err);
      });

      // console.log(keywords);
      // this.plugins.PlaceSearch.search(keywords, (status, result) => {
      //   console.log(result);
      //   let list = [];
      //   // 查询成功时，result即对应匹配的POI信息
      //   if (status === "complete" && result.info === "OK") {
      //     // 查询成功，result即为当前所在城市信息
      //     const { poiList } = result;
      //     list = poiList.pois;
      //   }
      //   this.$emit("placeSearch", list);
      //   this.$store.commit("SET_POI_LIST", list);
      // });
    },
    setPolygonEditor(path, autoPan = true) {
      let that = this;
      if (!path || path.length <= 0) return false;
      return new Promise(resolve => {
        that.drawPolygonEdit = new this.AMap.Polygon({
          path,
          strokeColor: "#E6A23C",
          strokeWeight: 6,
          strokeOpacity: 1,
          fillOpacity: 0.2,
          fillColor: "#E6A23C",
          zIndex: 50,
          bubble: true
        });
        this.map.add([that.drawPolygonEdit]);
        if (autoPan) this.map.setFitView([that.drawPolygonEdit]);
        this.map.plugin(["AMap.PolyEditor"], () => {
          this.polygonEditor = new this.AMap.PolyEditor(this.map, that.drawPolygonEdit);
          this.polygonEditor.on("move", event => {
            // log.info('触发事件：move')
            this.$emit("polygonEditorChange", event);
          });
          this.polygonEditor.on("adjust", event => {
            // log.info('触发事件：adjust')
            this.$emit("polygonEditorChange", event);
          });
          resolve({
            figure: that.drawPolygonEdit,
            editor: that.polygonEditor
          });
        });
        // resolve(this.drawPolygonEdit);
        // this.polygonEditor = new this.AMap.PolyEditor(this.map, polygon);
      });

      // this.polyEditor.open();
      // return this.polyEditor
    },
    getPolygonEditor() {
      var _this$polygonEditor;
      return (_this$polygonEditor = this.polygonEditor) === null || _this$polygonEditor === void 0 ? void 0 : _this$polygonEditor.getTarget();
    },
    openPolygonEditor() {
      if (this.polygonEditor) this.polygonEditor.open();
    },
    closePolygonEditor() {
      if (this.polygonEditor) this.polygonEditor.close();
    },
    async setCircleEditor({
      center,
      radius
    }, autoPan = true) {
      let that = this;
      return new Promise(resolve => {
        that.drawCircleEdit = new this.AMap.Circle({
          center,
          radius,
          //半径
          borderWeight: 3,
          strokeColor: "#E6A23C",
          // strokeOpacity: 1,
          strokeWeight: 6,
          strokeOpacity: 1,
          fillOpacity: 0.2,
          //strokeStyle: 'dashed',
          //strokeDasharray: [10, 10],
          // 线样式还支持 'dashed'
          fillColor: "#E6A23C",
          zIndex: 50
        });
        this.map.add(that.drawCircleEdit);
        // 缩放地图到合适的视野级别
        if (autoPan) this.map.setFitView([that.drawCircleEdit]);
        this.map.plugin(["AMap.CircleEditor"], () => {
          // 实例化多边形编辑器，传入地图实例和要进行编辑的多边形实例
          this.circleEditor = new this.AMap.CircleEditor(this.map, that.drawCircleEdit);
          this.circleEditor.on("move", event => {
            // log.info('触发事件：move')
            this.$emit("circleEditorChange", event);
          });
          this.circleEditor.on("adjust", event => {
            // log.info('触发事件：adjust')
            this.$emit("circleEditorChange", event);
          });
          console.log("resolve之前", that.circleEditor);
          resolve({
            figure: that.drawCircleEdit,
            editor: that.circleEditor
          });
        });
      });
    },
    getCircleEditor() {
      var _this$circleEditor;
      return (_this$circleEditor = this.circleEditor) === null || _this$circleEditor === void 0 ? void 0 : _this$circleEditor.getTarget();
    },
    openCircleEditor() {
      if (this.circleEditor) this.circleEditor.open();
    },
    closeCircleEditor() {
      if (this.circleEditor) this.circleEditor.close();
    },
    setRectangleEditor({
      northEast,
      southWest
    }, autoPan = true) {
      let that = this;
      let northEastTrans = new this.AMap.LngLat(northEast[0], northEast[1]);
      let southWestTrans = new this.AMap.LngLat(southWest[0], southWest[1]);
      let bounds = new this.AMap.Bounds(southWestTrans, northEastTrans);
      return new Promise(resolve => {
        that.rectangle = new this.AMap.Rectangle({
          bounds: bounds,
          //半径
          borderWeight: 3,
          strokeColor: "#E6A23C",
          // strokeOpacity: 1,
          strokeWeight: 6,
          strokeOpacity: 1,
          fillOpacity: 0.2,
          //strokeStyle: 'dashed',
          //strokeDasharray: [10, 10],
          // 线样式还支持 'dashed'
          fillColor: "#E6A23C",
          zIndex: 50
        });
        this.map.add(that.rectangle);
        // 缩放地图到合适的视野级别
        if (autoPan) this.map.setFitView([that.rectangle]);
        this.map.plugin(["AMap.RectangleEditor"], () => {
          // 实例化多边形编辑器，传入地图实例和要进行编辑的多边形实例
          this.rectangleEditor = new this.AMap.RectangleEditor(this.map, that.rectangle);
          this.rectangleEditor.on("move", event => {
            // log.info('触发事件：move')
            this.$emit("rectangleEditorChange", event);
          });
          this.rectangleEditor.on("adjust", event => {
            // log.info('触发事件：adjust')
            this.$emit("rectangleEditorChange", event);
          });
          console.log("resolve之前", that.rectangleEditor);
          resolve({
            figure: that.rectangle,
            editor: that.rectangleEditor
          });
        });
        // resolve(that.rectangle);
      });
    },
    getRectangleEditor() {
      var _this$rectangleEditor;
      return (_this$rectangleEditor = this.rectangleEditor) === null || _this$rectangleEditor === void 0 ? void 0 : _this$rectangleEditor.getTarget();
    },
    openRectangleEditor() {},
    closeRectangleEditor() {
      if (this.rectangleEditor) this.rectangleEditor.close();
    },
    //周边调度画圈
    drawCircle(center, radius) {
      if (this.mapType === "tianditu") {
        if (this.railCircle) {
          let newMarker = this.map.getOverlays(); // 获取到了地图上的所有点
          for (let i = 0; i < newMarker.length; i++) {
            if (newMarker[i].id === "cusCircle") {
              this.map.removeOverLay(newMarker[i]);
            }
          }
        }
        this.railCircle = new T.Circle(new T.LngLat(center[0], center[1]), radius, {
          color: "0E70FF",
          weight: 5,
          opacity: 1,
          fillColor: "#0E70FF",
          fillOpacity: 0.5,
          lineStyle: "dashed"
        });
        this.railCircle.id = "cusCircle";
        //向地图上添加圆
        this.map.addOverLay(this.railCircle);
      } else {
        if (this.railCircle) {
          this.map.remove(this.railCircle);
        }
        this.railCircle = new this.AMap.Circle({
          center,
          radius,
          //半径
          borderWeight: 3,
          strokeColor: "#0E70FF",
          // strokeOpacity: 1,
          strokeWeight: 3,
          strokeOpacity: 1,
          fillOpacity: 0.2,
          strokeStyle: "dashed",
          strokeDasharray: [10, 10],
          // 线样式还支持 'dashed'
          fillColor: "#0E70FF"
          // zIndex: 50,
        });

        //圆形 Circle 对象添加到 Map
        this.railCircle.setMap(this.map);
        this.setZoom(14);
      }
    },
    setMoveAnimation(movePath) {
      if (this.mapType === 'tianditu') {
        let newMarker = this.map.getOverlays(); // 获取到了地图上的所有点
        for (let i = 0; i < newMarker.length; i++) {
          const {
            options
          } = newMarker[i];
          if (options.icon) {
            const {
              iconUrl
            } = options.icon.options;
            if (!iconUrl.includes('在岗_保安员')) {
              this.map.removeOverLay(newMarker[i]);
            }
          }
        }
        if (this.trajectoryLine) this.map.removeOverLay(this.trajectoryLine);
        this.movePath = movePath;
        const lineArr = movePath.map(x => {
          return new T.LngLat(x.position[0], x.position[1]);
        });
        this.trajectoryLine = new T.Polyline(lineArr);
        //向地图上添加线
        // line.setWeight("#28F")
        // line.setColor(6);
        this.map.addOverLay(this.trajectoryLine);
        // const lnglat = {
        //   lng: movePath[this.moveStartIndex].position[0],
        //   lat: movePath[this.moveStartIndex].position[1],
        // }
        // const marker = new T.Marker(lnglat, { icon: this.getMapIcon(require("@/assets/images/map/icons/红点轨迹.png")) });
        // this.map.addOverLay(marker);
      } else {
        // this.map.clearMap();
        this.currentIndex = 0;
        if (this.timer) clearTimeout(this.timer);
        if (this.roadPolyline) {
          this.map.remove(this.roadPolyline);
        }
        if (this.moveAnimationMarker) {
          this.map.remove(this.moveAnimationMarker);
        }
        this.movePath = movePath;
        console.log(this.movePath);
        const lineArr = this.movePath.map(x => {
          return x.position;
        });
        console.log(lineArr);
        this.trackMarker = {
          map: this.map,
          position: lineArr[this.moveStartIndex],
          anchor: "bottom-center",
          icon: __webpack_require__(/*! @/assets/images/map/icons/红点轨迹.png */ "./src/assets/images/map/icons/红点轨迹.png")
          // ...this.moveMarker,
          // ...{
          //   icon: this.setIcon(this.moveMarker.icon),
          // }
        };
        this.AMap.plugin("AMap.MoveAnimation", () => {
          this.moveAnimationMarker = new this.AMap.Marker(this.trackMarker);
          console.log(" this.moveAnimationMarker", this.moveAnimationMarker);
          this.roadPolyline = new this.AMap.Polyline({
            // map: this.map,
            path: lineArr,
            showDir: true,
            strokeColor: "#28F",
            //线颜色
            // strokeOpacity: 1,     //线透明度
            strokeWeight: 6 //线宽
            // strokeStyle: "solid"  //线样式
          });
          this.roadPolyline.setMap(this.map);

          // const passedPolyline = new this.AMap.Polyline({
          //   map: this.map,
          //   strokeColor: "#AF5", //线颜色
          //   strokeWeight: 6, //线宽
          // });
          this.moveAnimationMarker.on("moving", e => {
            console.log("this.moveAnimationMarker.on", e);
            // this.currentIndex = e.index;
            // passedPolyline.setPath(e.passedPath);
            // this.$emit("move", e);
            this.$emit("move", {
              index: this.currentIndex
            });
            // this.map.setCenter(e.target.getPosition(),true)
          });
          // this.moveAnimationMarker.on("moveend", (e) => {
          //   console.log(e);
          //   //this.currentIndex = e.index;
          //   this.$emit("moveend", {index: this.currentIndex});
          //   // this.map.setCenter(e.target.getPosition(),true)
          // });
          this.map.setFitView();
          // this.moveAnimationMarker.moveAlong(this.movePath, {
          //   autoRotation: true,
          //   // ...this.moveAlong
          // });
        });
      }
    },
    moveStart(speedRatio) {
      if (this.mapType === 'tianditu') {
        var _this$movePath$, _this$movePath$2;
        const duration = 10000 / speedRatio;
        console.log("🚀 ~ moveStart ~ duration:", duration);
        let newMarker = this.map.getOverlays(); // 获取到了地图上的所有点
        for (let i = 0; i < newMarker.length; i++) {
          const {
            options
          } = newMarker[i];
          if (options.icon) {
            const {
              iconUrl
            } = options.icon.options;
            if (!iconUrl.includes('在岗_保安员')) {
              this.map.removeOverLay(newMarker[i]);
            }
          }
        }
        let currentIndex = 0;
        const lnglat = {
          lng: (_this$movePath$ = this.movePath[0]) === null || _this$movePath$ === void 0 ? void 0 : _this$movePath$.position[0],
          lat: (_this$movePath$2 = this.movePath[0]) === null || _this$movePath$2 === void 0 ? void 0 : _this$movePath$2.position[1]
        };
        let marker = new T.Marker(lnglat, {
          icon: this.getMapIcon(__webpack_require__(/*! @/assets/images/map/icons/红点轨迹.png */ "./src/assets/images/map/icons/红点轨迹.png"))
        });
        this.map.addOverLay(marker);
        if (this.timer) clearInterval(this.timer);
        this.timer = setInterval(() => {
          if (currentIndex >= this.movePath.length) {
            clearInterval(this.timer);
            return;
          }
          const point = this.movePath[currentIndex];
          marker.setLngLat(new T.LngLat(point.position[0], point.position[1]));
          currentIndex++;
        }, duration);
      } else {
        const duration = 10000 / this.speedRatio;
        const movePath = this.movePath.map(x => {
          return {
            ...x,
            duration: x.duration / Number(this.speedRatio)
          };
        });
        this.moveAnimationMarker.moveTo(movePath[this.currentIndex].position, {
          duration: 500,
          // delay: 500,
          autoRotation: false
        });
        if (this.timer) clearTimeout(this.timer);
        this.timer = setTimeout(() => {
          if (this.currentIndex > movePath.length - 1) {
            clearTimeout(this.timer);
          } else {
            this.currentIndex++;
            this.moveStart();
          }
        }, duration);
        // movePath.forEach(item=>{
        //   this.moveAnimationMarker.moveTo(item.position,{
        //     duration: 500,
        //     // autoRotation: true,
        //     ...this.moveAlong
        //   })
        // })
        // this.moveAnimationMarker.moveAlong(movePath, this.moveAlong);
      }
    },
    pauseMove() {
      // this.moveAnimationMarker.pauseMove();
      if (this.timer) clearInterval(this.timer);
      if (this.timer) clearTimeout(this.timer);
    },
    resumeMove() {
      // this.moveAnimationMarker.resumeMove();
      this.moveStart();
    },
    stopMove() {
      // this.moveAnimationMarker.stopMove();
      this.currentIndex = 0;
      if (this.timer) clearInterval(this.timer);
      if (this.timer) clearTimeout(this.timer);
    },
    backStep() {
      if (this.currentIndex <= 0) return false;
      this.currentIndex--;
      // const position = this.movePath[this.currentIndex]?.position;
      if (this.timer) clearInterval(this.timer);
      clearTimeout(this.timer);
      this.moveStart();
    },
    nextStep() {
      if (this.currentIndex >= this.movePath.length) return false;
      if (this.timer) clearInterval(this.timer);
      clearTimeout(this.timer);
      this.currentIndex++;
      this.moveStart();
    },
    toggleTraffic() {
      this.trafficLayerVisible = !this.trafficLayerVisible;
      if (this.trafficLayerVisible) {
        this.trafficLayer.show();
      } else {
        this.trafficLayer.hide();
      }
    },
    locationInContain(lng, lat) {
      const myLngLat = this.currentLocation.position; // 浏览器定位
      const circle = new this.AMap.Circle({
        center: new this.AMap.LngLat(lng, lat),
        // 圆心位置--企业经纬度
        radius: 500 // 圆半径，单位:米
      });
      if (circle.contains(myLngLat)) {
        this.appLoadingMask.close();
      } else {
        this.$message.error("您已超出调度范围，请在设定位置500米范围内进行调度");
      }
    },
    // 画圆工具
    openCircleTool(active) {
      // this.map.clearOverLays();
      this.tdToolTemp && this.tdToolTemp.clear();
      const handler = new T.CircleTool(this.map, {
        follow: true
      });
      this.tdToolTemp = handler;
      if (active) {
        handler.open();
        handler.addEventListener("drawend", event => {
          this.$emit("draw", event);
        });
      } else {
        handler.close();
      }
    },
    // 画矩形工具
    openRectangleTool(active) {
      // this.map.clearOverLays();
      this.tdToolTemp && this.tdToolTemp.clear();
      const handler = new T.RectangleTool(this.map, {
        follow: true
      });
      this.tdToolTemp = handler;
      if (active) {
        handler.open();
        handler.addEventListener("draw", event => {
          this.$emit("draw", event);
        });
      } else {
        handler.close();
      }
    },
    // 多边形工具
    openPolygonTool(active) {
      // this.map.clearOverLays();
      this.tdToolTemp && this.tdToolTemp.clear();
      const handler = new T.PolygonTool(this.map);
      this.tdToolTemp = handler;
      if (active) {
        handler.open();
        handler.addEventListener("draw", event => {
          this.$emit("draw", event);
        });
      } else {
        handler.close();
      }
    },
    // 测距工具
    openPolylineTool(active) {
      const config = {
        showLabel: true
      };
      //创建标注工具对象
      const lineTool = new T.PolylineTool(this.map, config);
      if (active) {
        lineTool.open();
      } else {
        lineTool.close();
      }
    }
  },
  mounted() {
    //init map after DOM rendered
    this.initMap();
  },
  destroyed() {
    var _this$map;
    (_this$map = this.map) === null || _this$map === void 0 || _this$map.destroy();
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/imageCropper/index.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/imageCropper/index.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.url-search-params.delete.js */ "./node_modules/core-js/modules/web.url-search-params.delete.js");
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.url-search-params.has.js */ "./node_modules/core-js/modules/web.url-search-params.has.js");
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.url-search-params.size.js */ "./node_modules/core-js/modules/web.url-search-params.size.js");
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var vue_cropper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-cropper */ "./node_modules/vue-cropper/dist/index.js");
/* harmony import */ var vue_cropper__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(vue_cropper__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/utils */ "./src/utils/index.js");





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "imageCropper",
  components: {
    VueCropper: vue_cropper__WEBPACK_IMPORTED_MODULE_3__["VueCropper"]
  },
  props: {
    open: {
      type: Boolean,
      default: false
    },
    // 是否固定截图框大小
    fixedBox: {
      type: Boolean,
      default: false
    },
    // 是否默认生成截图框
    autoCrop: {
      type: Boolean,
      default: true
    },
    // 默认生成截图框宽度
    autoCropWidth: {
      type: Number,
      default: 200
    },
    // 默认生成截图框高度
    autoCropHeight: {
      type: Number,
      default: 200
    },
    img: {
      type: String
    },
    showPreview: Boolean
  },
  data() {
    return {
      openDialog: this.open,
      previews: {},
      // 裁剪组件的基础配置option
      options: {
        img: ""
      },
      currentIndex: 0
    };
  },
  watch: {
    open(val) {
      this.openDialog = val;
    }
  },
  methods: {
    closeDialog() {
      // this.openDialog = false;
      this.$emit("update:open", false);
    },
    // 上传预处理
    changeUpload(file) {
      if (file.raw.type.indexOf("image/") < 0) {
        this.$message({
          message: "文件格式错误，请上传图片类型,如：JPG，PNG后缀的文件。",
          type: "warning"
        });
      } else {
        const reader = new FileReader();
        reader.readAsDataURL(file.raw);
        reader.onload = () => {
          this.options.img = reader.result;
        };
      }
    },
    //下载图片
    downImg() {
      let aLink = document.createElement("a");
      aLink.download = Object(_utils__WEBPACK_IMPORTED_MODULE_4__["parseTime"])(new Date(), "{y}{m}{d}{h}{i}{s}") + Math.floor(Math.random() * 99999);
      this.$refs.cropper.getCropBlob(data => {
        aLink.href = window.URL.createObjectURL(data);
        aLink.click();
      });
    },
    // 生成截图数据
    getCropData() {
      this.$refs.cropper.getCropBlob(data => {
        this.$emit("onCropped", data);
      });
    },
    // 实时预览
    realTime() {
      // console.log(data)
      // this.previews = data;
      if (this.showPreview) {
        this.$refs.cropper.getCropBlob(res => {
          // do something
          // console.log(res)
          // this.previews.url  = window.URL.createObjectURL(res);
          // console.log(this.previews)
          this.$refs.img.setAttribute("src", window.URL.createObjectURL(res));
        });
      }
    },
    // 向左旋转
    rotateLeft() {
      this.$refs.cropper.rotateLeft();
    },
    // 向右旋转
    rotateRight() {
      this.$refs.cropper.rotateRight();
    },
    // 图片缩放
    changeScale(num) {
      num = num || 1;
      this.$refs.cropper.changeScale(num);
    },
    setIndex(index) {
      console.log(index);
      this.currentIndex = index;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/mapSearch/index.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/mapSearch/index.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.find.js */ "./node_modules/core-js/modules/es.iterator.find.js");
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var address__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! address */ "./node_modules/address/lib/address.js");
/* harmony import */ var address__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(address__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _riophae_vue_treeselect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @riophae/vue-treeselect */ "./node_modules/@riophae/vue-treeselect/dist/vue-treeselect.cjs.js");
/* harmony import */ var _riophae_vue_treeselect__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_riophae_vue_treeselect__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _riophae_vue_treeselect_dist_vue_treeselect_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @riophae/vue-treeselect/dist/vue-treeselect.css */ "./node_modules/@riophae/vue-treeselect/dist/vue-treeselect.css");
/* harmony import */ var _riophae_vue_treeselect_dist_vue_treeselect_css__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_riophae_vue_treeselect_dist_vue_treeselect_css__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _api_amap__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/api/amap */ "./src/api/amap.js");
/* harmony import */ var _api_security_station_controller__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/api/security-station-controller */ "./src/api/security-station-controller.js");
/* harmony import */ var _api_employee_controller__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/api/employee-controller */ "./src/api/employee-controller.js");
/* harmony import */ var _api_company_controller__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/api/company-controller */ "./src/api/company-controller.js");
/* harmony import */ var _api_device_controller__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/api/device-controller */ "./src/api/device-controller.js");
/* harmony import */ var _api_resource_controller__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/api/resource-controller */ "./src/api/resource-controller.js");
/* harmony import */ var _api_departs_controller__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/api/departs-controller */ "./src/api/departs-controller.js");
/* harmony import */ var _api_projects_controller__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/api/projects-controller */ "./src/api/projects-controller.js");
/* harmony import */ var _api_police_incident_controller__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/api/police-incident-controller */ "./src/api/police-incident-controller.js");
/* harmony import */ var _api_tenant_user_controller__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/api/tenant-user-controller */ "./src/api/tenant-user-controller.js");
/* harmony import */ var _api_common__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/api/common */ "./src/api/common.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _components_StationTypesForm_index_vue__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @/components/StationTypesForm/index.vue */ "./src/components/StationTypesForm/index.vue");
/* harmony import */ var _api_exam_site_room_controller__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @/api/exam-site-room-controller */ "./src/api/exam-site-room-controller.js");






















/* harmony default export */ __webpack_exports__["default"] = ({
  name: "mapSearch",
  props: {
    sysUserInfo: {
      type: Object,
      required: true
    },
    // sysUserInfo.role[ Urban 市局：SubUrb 分局：Company 企业 PoliceStation：基层派出所]
    type: {
      type: [String, Number],
      default() {
        return 1;
      }
    },
    showResourceLayers: Boolean,
    showIncidents: {
      type: Boolean,
      default: false
    },
    mapType: {
      type: String,
      default: ""
    }
  },
  components: {
    treeSelect: (_riophae_vue_treeselect__WEBPACK_IMPORTED_MODULE_6___default()),
    stationTypesForm: _components_StationTypesForm_index_vue__WEBPACK_IMPORTED_MODULE_20__["default"]
  },
  data() {
    return {
      actEmployeeTypes: [],
      actAllEmployeeTypes: [],
      orgInstitutional: "",
      checkAll: false,
      checkedActEmployeeTypes: [],
      isIndeterminate: false,
      platform: localStorage.getItem("platform") || "1",
      deskTypes: localStorage.getItem("platform") === "2" ? ["Proprietor"] : localStorage.getItem("platform") === "3" ? ["TemporarySecurity"] : ["Normal"],
      deskTypesParam: ["TemporarySecurity"],
      //默认临保调度参数
      checkAllPro: false,
      isCompany: false,
      isSecurity: false,
      //当前用户角色是否为治安市局/分局
      isPoliceStation: false,
      //当前用户角色是否为派出所
      companyTypes: [],
      proprietorTypes: [],
      proprietorTypesCode: [],
      departs: [],
      normalizer(node) {
        if (node.children && !node.children.length) {
          delete node.children;
        }
        return {
          id: node.code,
          label: node.name,
          children: node.children,
          // isDisabled: !node.selectable,
          isDisabled: false
        };
      },
      normalizer1(node) {
        if (node.children && !node.children.length) {
          delete node.children;
        }
        return {
          id: node.code,
          label: node.name,
          children: node.children
        };
      },
      normalizer2(node) {
        // if (node.children && !node.children.length) {
        //   delete node.children;
        // }
        return {
          id: node.id,
          label: node.name + "(" + node.statusLabel + ")"
          // children: node.children,
        };
      },
      projects: [],
      formDevice: {
        depart: null,
        superviseDepartIds: []
      },
      formCompany: {
        institutional: [],
        depart: null,
        superviseDepartIds: []
      },
      resTypeListShow: false,
      activeTypeIndex: 0,
      resTypeList: [{
        name: "保安员",
        value: 1,
        roles: ["Urban", "SubUrb", "Company"],
        platform: ["1"],
        placeholder: "请输入保安员证件号或姓名"
      }, {
        name: "保安员",
        value: 1,
        roles: ["Company"],
        platform: ["2"],
        placeholder: "请输入保安员证件号或姓名"
      }, {
        name: "人员",
        value: 1,
        roles: ["PoliceStation", "PopulationPoliceStation", "PopulationUrban", "PopulationSubUrb", "Proprietor"],
        platform: ["1"],
        placeholder: "请输入人员证件号或姓名"
      }, {
        name: "人员",
        value: 1,
        roles: ["Urban", "SubUrb", "PoliceStation", "PopulationPoliceStation", "PopulationUrban", "PopulationSubUrb", "Proprietor"],
        platform: ["2"],
        placeholder: "请输入人员证件号或姓名"
      }, {
        name: "临保员",
        value: 1,
        roles: ["*"],
        platform: ["3"],
        placeholder: "请输入临保员证件号或姓名"
      }, {
        name: "驻勤点",
        value: 2,
        roles: ["Urban", "SubUrb", "Company"],
        platform: ["1"],
        placeholder: "请输入驻勤点名称"
      }, {
        name: "驻勤点",
        value: 2,
        roles: ["PoliceStation", "PopulationPoliceStation", "Proprietor"],
        platform: ["2"],
        placeholder: "请输入驻勤点名称"
      }, {
        name: "执勤点",
        value: 2,
        roles: ["PoliceStation", "PopulationPoliceStation", "PopulationUrban", "PopulationSubUrb", "Proprietor"],
        platform: ["1"],
        placeholder: "请输入执勤点名称"
      }, {
        name: "岗点",
        value: 2,
        roles: ["*"],
        platform: ["3"],
        placeholder: "请输入岗点名称"
      }, {
        name: "内保单位",
        value: 3,
        roles: ["Urban", "SubUrb", "PoliceStation", "PopulationPoliceStation", "PopulationUrban", "PopulationSubUrb", "Proprietor"],
        platform: ["2"],
        placeholder: "请输入内保单位名称"
      }, {
        name: "搜考场",
        value: 7,
        roles: ["*"],
        platform: ["1"],
        placeholder: "请输入名称"
      }, {
        name: "搜地点",
        value: 4,
        roles: ["*"],
        platform: ["*"],
        placeholder: "请输入地点名称"
      }, {
        name: "智能设备",
        value: 5,
        roles: ["*"],
        platform: ["*"],
        // disabled: true,
        placeholder: "请输入智能设备名称"
      }],
      keywords: "",
      empoloyeesResultShow: false,
      stationsResultShow: false,
      devicesResultShow: false,
      proprietorResultShow: false,
      examResultShow: false,
      resResultShow: false,
      resResult: [],
      policeIncidents: {},
      stationTypesShow: false,
      policeIncidentsShow: false,
      stationType: null,
      stationTypes: [],
      levelCounts: [],
      levelCountTabList: [{
        label: "特别重大",
        number: "0",
        name: "greatsCount",
        level: "Greats",
        bgColor: "#A80000"
      }, {
        label: "重大",
        number: "0",
        name: "greatCount",
        level: "Great",
        bgColor: "#F48200"
      }, {
        label: "较大",
        number: "0",
        name: "moreCount",
        level: "More",
        bgColor: "#F7BE00"
      }, {
        label: "一般",
        number: "0",
        name: "comonCount",
        level: "Comon",
        bgColor: "#00B40C"
      }],
      employees: [],
      levelIndex: undefined,
      //警情上报选中
      isDetail: false,
      //是否详情
      isFromWarn: false,
      //true 来自报警消息立即处理 false 本地报警消息查看
      currentLevel: "Greats",
      policeIncidentsData: {},
      //警情上报详情
      isPoliceContact: true,
      piCurrentPage: 1,
      //当前页
      piTotal: 0,
      //分页总条数
      piPageSize: 3,
      //分页默认3条
      isPhone: false,
      isSuperVision: false,
      //是否监管账户 是 ture 否：false
      stationCount: 0,
      deviceCount: 0,
      employeeCount: 0,
      companyCount: 0,
      stationLoading: false,
      deviceLoading: false,
      proprietorLoading: false,
      examLoading: false,
      employeeLoading: false,
      stationPageIndex: 1,
      proprietorPageIndex: 1,
      examPageIndex: 1,
      employeePageIndex: 1,
      devicePageIndex: 1,
      pageSize: 10,
      noMore: false,
      formEmployee: {
        followed: 1,
        type: null,
        depart: null,
        project: null,
        projectIds: [],
        superviseDepartIds: []
      },
      employeeTypes: [{
        code: null,
        name: "全部",
        roles: ["PoliceStation", "PopulationPoliceStation", "Proprietor", "Urban", "SubUrb"],
        platform: ["1", "2", "3"]
      }, {
        code: ["Security"],
        name: "保安员",
        roles: ["PoliceStation", "PopulationPoliceStation", "Proprietor"],
        platform: ["1", "2"]
      }, {
        code: ["TemporarySecurity"],
        name: "临保员",
        roles: ["PoliceStation", "PopulationPoliceStation", "Urban", "SubUrb"],
        platform: ["3"]
      }, {
        code: ["Population"],
        name: "全部社会力量",
        roles: ["PoliceStation", "PopulationPoliceStation"],
        platform: ["1"]
      }, {
        code: ["Population", "Security"],
        name: "兼职社会力量(部分保安员)",
        roles: ["PoliceStation", "PopulationPoliceStation"],
        platform: ["1"]
      }, {
        code: ["ProfessionalPopulation"],
        name: "全职社会力量",
        roles: ["PoliceStation", "PopulationPoliceStation"],
        platform: ["1"]
      }, {
        code: ["Proprietor"],
        name: "甲方管理员",
        roles: ["PoliceStation", "PopulationPoliceStation", "Proprietor"],
        platform: ["2"]
      }, {
        code: [""],
        name: "智能设备持有人",
        roles: ["PoliceStation", "Urban", "SubUrb", "PopulationPoliceStation", "Proprietor"],
        platform: ["1", "2", "3"],
        disabled: true
      }],
      formStation: {
        type: null,
        stationTypes: [],
        depart: null,
        project: null,
        projectIds: [],
        superviseDepartIds: []
      },
      formStationTypes: [{
        code: null,
        name: "全部",
        roles: ["PoliceStation", "PopulationPoliceStation", "Proprietor"]
      }, {
        code: "Security",
        name: "驻勤点",
        roles: ["PoliceStation", "PopulationPoliceStation", "Proprietor"]
      }, {
        code: "Population",
        name: "社区警务",
        roles: ["PoliceStation", "PopulationPoliceStation", "Proprietor"]
      }]
    };
  },
  computed: {
    loading() {
      return this.stationLoading || this.examLoading || this.employeeLoading || this.proprietorLoading || this.deviceLoading;
    },
    // ...mapState({ poiList: (state) => state.poiList || [] }),
    resTypeRoleList() {
      const platform = localStorage.getItem("platform") || "1";
      return this.resTypeList.filter(type => {
        if (type.roles.includes("*") && type.platform.includes("*")) {
          return type;
        } else {
          // return type.roles.includes(this.sysUserInfo.role) || type.platform.includes(platform);
          if (type.roles.includes(this.sysUserInfo.role)) {
            return type.platform.includes(platform) || type.platform.includes("*");
          }
          if (type.platform.includes(platform)) {
            return type.roles.includes(this.sysUserInfo.role) || type.roles.includes("*");
          }
        }
      });
    },
    stationRolesTypes() {
      return this.formStationTypes.filter(type => type.roles.includes(this.sysUserInfo.role)); // 通过用户角色过滤可选的类型
    },
    employeeRolesTypes() {
      const platform = localStorage.getItem("platform") || "1";
      return this.employeeTypes.filter(type => type.roles.includes(this.sysUserInfo.role) && type.platform.includes(platform)); // 通过用户角色过滤可选的类型
    },
    typeName() {
      return this.resTypeRoleList[this.activeTypeIndex].name;
    },
    placeholder() {
      return this.resTypeRoleList[this.activeTypeIndex].placeholder;
    },
    activeTab() {
      return function ({
        bgColor,
        level
      }) {
        return {
          color: "#fff",
          background: bgColor,
          borderColor: this.currentLevel === level ? "#0e71ff" : "grey",
          opacity: this.currentLevel === level ? 1 : 0.4
        };
      };
    },
    disabled() {
      return this.stationLoading || this.noMore;
    },
    totalNumCount() {
      return this.resResult.length;
    },
    signInCount() {
      return this.resResult.filter(({
        dutyStatus
      }) => dutyStatus === "SignIn").length;
    },
    signOffCount() {
      return this.resResult.filter(({
        dutyStatus
      }) => dutyStatus === "SignOut").length;
    },
    deviceOnlineCount() {
      return this.resResult.filter(({
        status
      }) => status === "Online").length;
    },
    deviceOfflineCount() {
      return this.resResult.filter(({
        status
      }) => status === "Offline").length;
    },
    noActivation() {
      return this.resResult.filter(({
        dutyStatus
      }) => dutyStatus === "None").length;
    },
    populationCount() {
      return this.resResult.filter(({
        rts
      }) => !rts.includes("Security")).length;
    },
    proprietorCount() {
      return this.resResult.filter(({
        rts
      }) => rts.includes("Proprietor")).length;
    },
    securityCount() {
      return this.resResult.filter(({
        rts
      }) => rts.includes("Security")).length;
    },
    noLonLatCount() {
      return this.resResult.filter(({
        longitude,
        latitude
      }) => {
        return !longitude || !latitude;
      }).length;
    },
    personRoleValid() {
      return !["Company", "Urban", "SubUrb", "PopulationSubUrb", "PopulationUrban"].includes(this.sysUserInfo.role);
    },
    companyRoleValid() {
      return !["Company", "Urban", "SubUrb", "PopulationSubUrb", "PopulationUrban", "Proprietor"].includes(this.sysUserInfo.role);
    }
  },
  methods: {
    handleCheckAllChangeAct(val) {
      this.checkedActEmployeeTypes = val ? this.actEmployeeTypes.map(el => el.code) : [];
      this.isIndeterminate = false;
    },
    handleCheckedCitiesChangeAct(value) {
      let checkedCount = value.length;
      this.checkAll = checkedCount === this.actEmployeeTypes.length;
      this.isIndeterminate = checkedCount > 0 && checkedCount < this.actEmployeeTypes.length;
    },
    handleCheckChange(val) {
      this.formStation.stationTypes = val;
    },
    handleCheckAllChangePro(val) {
      this.formCompany.institutional = val ? this.proprietorTypes.map(x => x.code) : [];
      this.isIndeterminatePro = false;
    },
    handleCheckedCitiesChangePro(value) {
      let checkedCount = value.length;
      this.checkAllPro = checkedCount === this.proprietorTypes.length;
      this.isIndeterminatePro = checkedCount > 0 && checkedCount < this.proprietorTypes.length;
    },
    onSelectCompanyDeparts(node) {
      var _node$children;
      if ((node === null || node === void 0 || (_node$children = node.children) === null || _node$children === void 0 ? void 0 : _node$children.length) > 0) {
        const getTail = item => item.children && item.children.length > 0 ? item.children.map(m => getTail(m)) : [item];
        const result = lodash__WEBPACK_IMPORTED_MODULE_19___default.a.flattenDeep(node.children.map(m => [m, ...getTail(m)]));
        console.log("mapSearch log result", result);
        this.formCompany.superviseDepartIds = [node.code, ...result.map(x => x.code)];
      } else {
        this.formCompany.superviseDepartIds = [node.code];
      }
    },
    onSelectEmployeeDeparts(node) {
      var _node$children2;
      if ((node === null || node === void 0 || (_node$children2 = node.children) === null || _node$children2 === void 0 ? void 0 : _node$children2.length) > 0) {
        const getTail = item => item.children && item.children.length > 0 ? item.children.map(m => getTail(m)) : [item];
        const result = lodash__WEBPACK_IMPORTED_MODULE_19___default.a.flattenDeep(node.children.map(m => getTail(m)));
        console.log(" log result", result);
        this.formEmployee.superviseDepartIds = [node.code, ...result.map(x => x.code)];
      } else {
        this.formEmployee.superviseDepartIds = [node.code];
      }
    },
    onSelectEmployeeProjects(node) {
      var _node$children3;
      if ((node === null || node === void 0 || (_node$children3 = node.children) === null || _node$children3 === void 0 ? void 0 : _node$children3.length) > 0) {
        const getTail = item => item.children && item.children.length > 0 ? item.children.map(m => getTail(m)) : [item];
        const result = lodash__WEBPACK_IMPORTED_MODULE_19___default.a.flattenDeep(node.children.map(m => [m, ...getTail(m)]));
        console.log(" log result", result);
        this.formEmployee.projectIds = [node.code, ...result.map(x => x.code)];
      } else {
        this.formEmployee.projectIds = [node.code];
      }
    },
    onSelectStationDeparts(node) {
      var _node$children4;
      if ((node === null || node === void 0 || (_node$children4 = node.children) === null || _node$children4 === void 0 ? void 0 : _node$children4.length) > 0) {
        const getTail = item => item.children && item.children.length > 0 ? item.children.map(m => getTail(m)) : [item];
        const result = lodash__WEBPACK_IMPORTED_MODULE_19___default.a.flattenDeep(node.children.map(m => [m, ...getTail(m)]));
        console.log(" log result", result);
        this.formStation.superviseDepartIds = [node.code, ...result.map(x => x.code)];
      } else {
        this.formStation.superviseDepartIds = [node.code];
      }
    },
    onSelectStationProjects(node) {
      var _node$children5;
      if ((node === null || node === void 0 || (_node$children5 = node.children) === null || _node$children5 === void 0 ? void 0 : _node$children5.length) > 0) {
        const getTail = item => item.children && item.children.length > 0 ? item.children.map(m => getTail(m)) : [item];
        const result = lodash__WEBPACK_IMPORTED_MODULE_19___default.a.flattenDeep(node.children.map(m => [m, ...getTail(m)]));
        console.log(" log result", result);
        this.formStation.projectIds = [node.code, ...result.map(x => x.code)];
      } else {
        this.formStation.projectIds = [node.code];
      }
    },
    onSelectDeviceDeparts(node) {
      var _node$children6;
      if ((node === null || node === void 0 || (_node$children6 = node.children) === null || _node$children6 === void 0 ? void 0 : _node$children6.length) > 0) {
        const getTail = item => item.children && item.children.length > 0 ? item.children.map(m => getTail(m)) : [item];
        const result = lodash__WEBPACK_IMPORTED_MODULE_19___default.a.flattenDeep(node.children.map(m => [m, ...getTail(m)]));
        console.log(" log result", result);
        this.formDevice.superviseDepartIds = [node.code, ...result.map(x => x.code)];
      } else {
        this.formDevice.superviseDepartIds = [node.code];
      }
    },
    parseStringToStar(str) {
      if (str) {
        return str.length > 2 ? str.substr(0, 2) + new Array(str.length - 2).join("*") + str.substr(-2) : str;
      } else {
        return "";
      }
    },
    railCk() {
      this.$emit("clickRail", this.policeIncidentsData);
    },
    async init() {
      this.stationTypes = await Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_9__["getAllStationTypes"])({
        deskTypes: []
      }); //获取驻勤点信息
      console.log("stationTypes", this.stationTypes);
      if (this.sysUserInfo.role !== "Company") {
        var _this$employeeRolesTy, _this$stationRolesTyp;
        this.formEmployee.type = (_this$employeeRolesTy = this.employeeRolesTypes[0]) === null || _this$employeeRolesTy === void 0 ? void 0 : _this$employeeRolesTy.code;
        this.formStation.type = (_this$stationRolesTyp = this.stationRolesTypes[0]) === null || _this$stationRolesTyp === void 0 ? void 0 : _this$stationRolesTyp.code;
      }
      const userInfo = localStorage.getItem("userInfo");
      let userInfoJson;
      if (userInfo) {
        userInfoJson = JSON.parse(userInfo);
        this.orgInstitutional = userInfoJson.orgInstitutional;
      } else {
        Object(_api_tenant_user_controller__WEBPACK_IMPORTED_MODULE_17__["getCurrentUser"])().then(async response => {
          this.orgInstitutional = response.orgInstitutional;
          userInfoJson = JSON.stringify(response);
        });
      }
      if (userInfoJson) {
        const {
          superviseDesk,
          role,
          organizationId
        } = userInfoJson;
        this.isSuperVision = superviseDesk; //判断身份 ture:监管账户；false:企业账户
        //判断是否是企业或内保单位
        if (role === "Company" || role === "Proprietor") {
          this.isCompany = true;
        }
        if (this.platform !== "3") {
          this.deskTypesParam = this.isCompany ? ["Normal", "Proprietor"] : this.deskTypes;
        }
        this.isSecurity = role === "Urban" || role === "SubUrb";
        this.isPoliceStation = role === "PopulationPoliceStation" || role === "PoliceStation";
        // this.resTypeList.filter((resType) => resType.value === 5)[0].disabled = ![
        //   "TLK_DMT1", //测试环境使用
        //   "TLK_DMT347", //测试环境使用
        //   "__yUx7oCr0CPEjfFd0T1K",
        //   "__Ovmh5cBQhH9e6IJtWlz",
        //   "O7f4fVUf",
        // ].includes(organizationId); //如果当前组织则显示智能设备
        // this.resTypeList.filter((resType) => resType.value === 7)[0].disabled = ![
        //   "TLK_DMT1", //测试环境使用
        //   "TLK_DMT347", //测试环境使用
        //   "__l4j8hCF7xNmFSRfeQb0",
        //   "7JXUKfBb",
        //   "O7f4fVUf",
        //   "09T9dNBG",
        //   "VxPArVQC",
        //   "__iZjB3As6MOfttXkZTXo",
        // ].includes(organizationId); //如果当前组织则显示考场
      }
      this.companyTypes = await Object(_api_resource_controller__WEBPACK_IMPORTED_MODULE_13__["getOrganizationType"])(); // 获取企业类型 {code,name}
      this.proprietorTypes = this.companyTypes.filter(item => item.category === "Proprietor");
      this.proprietorTypesCode = this.proprietorTypes.map(item => {
        return item.code;
      });
      this.departs = await Object(_api_departs_controller__WEBPACK_IMPORTED_MODULE_14__["getDeparts"])({
        deskTypes: this.deskTypes
      }); // 获取辖区树
      this.projects = await Object(_api_projects_controller__WEBPACK_IMPORTED_MODULE_15__["getProjects"])({
        pageIndex: 1,
        pageSize: 10000,
        forExport: true,
        keyword: null,
        superviseDepartIds: []
      });
    },
    //显示搜索类型信息
    showResTypeList() {
      this.resResultShow = false;
      this.stationTypesShow = false; //隐藏资源图层
      this.policeIncidentsShow = false; //隐藏警情上报
      this.empoloyeesResultShow = false; //隐藏保安员列表
      this.stationsResultShow = false; //隐藏驻勤点列表
      this.devicesResultShow = false; //隐藏设备列表
      this.proprietorResultShow = false; //隐藏内保单位列表
      this.examResultShow = false; //隐藏考场列表
      this.resTypeListShow = !this.resTypeListShow; //搜索类型
    },
    setType(type, index) {
      this.checkedActEmployeeTypes = [];
      this.isIndeterminate = false;
      this.checkAll = false;
      this.activeTypeIndex = index;
      console.log(type);
      if (type === 1) {
        this.actEmployeeTypes = this.actAllEmployeeTypes.filter(el => !el.onlyForStation);
      } else if (type === 2) {
        this.actEmployeeTypes = this.actAllEmployeeTypes;
      }
      this.$emit("update:type", type);
      // this.resTypeListShow = false;
      // 类型切换后置空搜索内容
      this.keywords = "";
      this.resResult = [];
      this.stationPageIndex = 1;
      this.employeePageIndex = 1;
      this.devicePageIndex = 1;
      this.proprietorPageIndex = 1;
      // 清空图标
      this.$emit("clearMap");
      this.$emit("addPolylineEntity", true);
    },
    async search() {
      if (this.loading) return false;
      this.resResult = [];
      this.employeePageIndex = 1;
      this.devicePageIndex = 1;
      this.stationPageIndex = 1;
      this.proprietorPageIndex = 1;
      const roles1 = ["Urban", "SubUrb", "PopulationUrban", "PopulationSubUrb", "Company"];
      if (this.type === 1 && this.platform !== "3") {
        if (roles1.includes(this.sysUserInfo.role)) {
          if (!this.keywords.trim()) {
            this.$message.info("请输入搜索条件");
            return false;
          }
        }
      }
      if (this.type === 2 && this.platform !== "3") {
        if (roles1.includes(this.sysUserInfo.role)) {
          if (!this.keywords.trim()) {
            this.$message.info("请输入搜索条件");
            return false;
          }
        }
      }
      if (this.type === 4 || this.type === 7) {
        if (!this.keywords.trim()) {
          this.$message.info("请输入搜索条件");
          return false;
        }
        // this.resResultShow = !!this.keywords;
        // this.$store.commit("SET_PLACE_KEYWORDS", this.keywords);
      }
      this.noMore = false;
      this.resTypeListShow = false;
      this.resResultShow = false;
      this.stationTypesShow = false; //隐藏资源图层
      this.policeIncidentsShow = false; //隐藏警情上报
      this.$emit("hideAllLayers");
      // 清空图标
      this.$emit("clearMap");
      console.log("type", this.type);
      if (this.type === 1) {
        //查询人员
        await this.searchEmployees();
      } else if (this.type === 2) {
        // 查询执勤点
        await this.searchStations();
      } else if (this.type === 3) {
        //查询内保单位
        await this.searchProprietors();
      } else if (this.type === 4) {
        // 查询地点
        await this.getPlace();
      } else if (this.type === 5) {
        // 搜智能设备
        await this.searchDevices();
      } else if (this.type === 7) {
        // 搜考场
        await this.getExam();
      }
      this.$emit("addPolylineEntity");
    },
    setKeywords() {
      this.employeePageIndex = 1;
      this.devicePageIndex = 1;
      this.stationPageIndex = 1;
      this.proprietorPageIndex = 1;
    },
    onClearSearch() {
      this.empoloyeesResultShow = false;
      this.stationsResultShow = false;
      this.devicesResultShow = false;
      this.proprietorResultShow = false;
      this.examResultShow = false; //隐藏考场列表
      this.resTypeListShow = false;
      this.resResultShow = false;
      this.$emit("search", {
        type: this.type,
        data: []
      });
    },
    //显示驻勤点类型
    async showStationTypes() {
      this.stationTypesShow = !this.stationTypesShow;
      this.resResultShow = false; //搜索地址表
      this.resTypeListShow = false;
      this.policeIncidentsShow = false; //隐藏警情上报
      this.empoloyeesResultShow = false; //隐藏保安员列表
      this.stationsResultShow = false; //隐藏驻勤点列表
      this.devicesResultShow = false; //隐藏设备列表
      this.proprietorResultShow = false; //隐藏内保单位列表
      this.examResultShow = false; //隐藏考场列表
      // 类型切换后置空搜索内容
      this.keywords = "";
      this.$emit("clearMap");
      this.$emit("hideAllLayers");
    },
    //根据驻勤点类型查询驻勤点
    async getStationsByType(stationType) {
      Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_9__["getStations"])({
        keyword: "",
        searchModel: "StationType",
        deskTypes: this.isCompany ? ["Normal", "Proprietor"] : this.deskTypes,
        pageIndex: 1,
        pageSize: 100,
        stationTypes: [stationType + ""]
      }).then(res => {
        this.$emit("getStationsByType", [...res].map(x => {
          x.type = "station";
          return x;
        }));
      }).catch(err => {
        console.log(err);
      });
    },
    /**
     * @隐藏所有搜索结果列表框
     */
    hideAllList() {
      this.resResultShow = false;
      this.resTypeListShow = false;
      this.stationTypesShow = false; //隐藏资源图层
      this.empoloyeesResultShow = false; //隐藏保安员列表
      this.stationsResultShow = false; //隐藏驻勤点列表
      this.devicesResultShow = false; //隐藏设备列表
      this.proprietorResultShow = false; //隐藏内保单位列表
      this.examResultShow = false; //隐藏考场列表
      this.policeIncidentsShow = false; //隐藏警情上报列表
    },
    //显示警情上报
    async showPoliceIncidents(alwaysShow) {
      if (!alwaysShow) {
        this.currentLevel = "Greats";
        this.policeIncidentsShow = !this.policeIncidentsShow;
      }
      // 类型切换后置空搜索内容
      this.keywords = "";
      this.$emit("clearMap");
      this.resResultShow = false;
      this.resTypeListShow = false;
      this.stationTypesShow = false; //隐藏资源图层
      this.empoloyeesResultShow = false; //隐藏保安员列表
      this.stationsResultShow = false; //隐藏驻勤点列表
      this.devicesResultShow = false; //隐藏设备列表
      this.proprietorResultShow = false; //隐藏内保单位列表
      this.examResultShow = false; //隐藏考场列表
      this.levelCounts = await Object(_api_police_incident_controller__WEBPACK_IMPORTED_MODULE_16__["getLevelCount"])(); //获取警情上报等级数量
      console.log("levelCounts", this.levelCounts);
      // this.levelCountTabList.forEach((item) => {
      //   item.number = this.levelCounts[item.name];
      // });
      for (let key in this.levelCounts) {
        const data = this.levelCountTabList.find(x => x.name === key);
        if (data) data.number = this.levelCounts[key];
      }
      await this.getPoliceIncidentsByLevel(
      // this.levelCountTabList[0].level,
      this.currentLevel, 1);
    },
    //根据级别显示警情上报
    async getPoliceIncidentsByLevel(level, currentPage) {
      this.isDetail = false;
      this.currentLevel = level;
      this.policeIncidents = {};
      this.piCurrentPage = currentPage;
      this.$forceUpdate();
      Object(_api_police_incident_controller__WEBPACK_IMPORTED_MODULE_16__["getPoliceIncidentsNeOver"])({
        pageIndex: currentPage,
        pageSize: this.piPageSize,
        level: level,
        status: "None"
      }).then(res => {
        console.log("PoliceIncidents", res);
        const {
          totalCount
        } = res; //总数
        this.piTotal = totalCount;
        this.policeIncidents = res;
        for (let i = 0; i < this.policeIncidents.data.length; i++) {
          let item = this.policeIncidents.data[i];
          item.isPoliceContact = true;
        }
      }).catch(err => {
        console.log(err);
      });
    },
    handleCurrentChange(val) {
      this.piCurrentPage = val;
      this.getPoliceIncidentsByLevel(this.currentLevel, val);
    },
    policeContact(index) {
      let that = this;
      let list = JSON.parse(JSON.stringify(that.policeIncidents.data));
      list[index].isPoliceContact = !list[index].isPoliceContact;
      this.$nextTick(() => {
        that.policeIncidents.data = [];
        this.$set(that.policeIncidents, "data", list);
      });
      console.log(that.policeIncidents.data[index].isPoliceContact);
    },
    lookContact(index, type) {
      console.log(index, type);
      this.resResult[index][type] = !this.resResult[index][type];
      this.$set(this.resResult, index, this.resResult[index]);
    },
    loadEmployee() {
      if (this.keywords) {
        this.noMore = false;
        this.employeePageIndex++;
        this.searchEmployees();
      }
    },
    //查询保安员
    async searchEmployees() {
      this.employeeLoading = true;
      var followed = null;
      if (this.formEmployee.followed == "2") {
        followed = true;
      } else if (this.formEmployee.followed == "3") {
        followed = false;
      }
      Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_10__["getEmployees"])({
        pageIndex: this.employeePageIndex,
        pageSize: this.pageSize,
        keyword: this.keywords,
        searchModel: this.keywords ? "Keyword" : "SecurityResource",
        deskTypes: this.deskTypesParam,
        resourceTypes: this.formEmployee.type,
        projectId: this.formEmployee.project,
        followed: followed,
        superviseDepartIds: this.formEmployee.superviseDepartIds,
        stationTypes: this.platform === "3" ? this.checkedActEmployeeTypes : []
      }).then(res => {
        if ([...res].length < this.pageSize) {
          this.noMore = true;
        } else {
          this.employeeCount += [...res].length;
        }
        const resResult = [...this.resResult, ...res];
        this.resResult = resResult.map(item => {
          const {
            proprietorCompanyName,
            securityStationName,
            idCardNo,
            contact,
            rts,
            name,
            companyName
          } = item;
          const isContact = false;
          const isIdCardNo = false;
          const type = "employee";
          if (this.keywords) {
            return {
              ...item,
              type,
              isIdCardNo,
              isContact,
              nameSlice: name.slice(-2),
              companyNameSlice: Object(_api_common__WEBPACK_IMPORTED_MODULE_18__["textSlice"])(companyName),
              proprietorCompanyNameSlice: Object(_api_common__WEBPACK_IMPORTED_MODULE_18__["textSlice"])(proprietorCompanyName),
              stationNameSlice: Object(_api_common__WEBPACK_IMPORTED_MODULE_18__["textSlice"])(securityStationName),
              idCardNoHide: this.parseStringToStar(idCardNo),
              contactHide: this.parseStringToStar(contact),
              isProprietor: !!rts.includes("Proprietor") //是否甲方管理员
            };
          } else {
            return {
              ...item,
              type,
              isIdCardNo,
              isContact
            };
          }
        });
        this.empoloyeesResultShow = this.keywords !== "";
        const roles = ["PoliceStation", "PopulationPoliceStation", "PopulationUrban", "PopulationSubUrb", "Proprietor"];
        if (!this.keywords && roles.includes(this.sysUserInfo.role) || this.platform === "3") {
          this.$emit("search", {
            type: 1,
            data: this.resResult,
            keywords: this.keywords
          });
        }
      }).catch(err => {
        console.log(err);
      }).finally(() => {
        this.employeeLoading = false;
        if (this.resResult.length >= 10) {
          this.$nextTick(() => {
            this.scrollToBottom("employeeRes");
          });
        }
      });
    },
    //查询驻勤点
    async searchStations() {
      this.stationLoading = true;
      Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_9__["getStations"])({
        pageIndex: this.stationPageIndex,
        pageSize: this.pageSize,
        searchModel: this.keywords ? "Name" : "SecurityResource",
        deskTypes: this.deskTypesParam,
        stationTypes: this.platform === "3" && this.orgInstitutional === "0201" ? this.checkedActEmployeeTypes : this.formStation.type === "Security" ? this.formStation.stationTypes : [],
        keyword: this.keywords,
        resourceType: this.keywords ? null : this.formStation.type,
        projectId: this.formStation.project,
        superviseDepartIds: this.formStation.superviseDepartIds
      }).then(res => {
        console.log(res);
        if ([...res].length < this.pageSize) {
          this.noMore = true;
        } else {
          this.stationCount += [...res].length;
        }
        this.resResult = [...this.resResult, ...res];
        this.stationsResultShow = this.keywords !== "";
        if (!this.keywords || this.platform === "3") {
          this.$emit("search", {
            type: 2,
            data: this.resResult.map(res => {
              return {
                ...res,
                type: "station"
              };
            }),
            keywords: this.keywords
          });
        }
      }).catch(err => {
        console.log(err);
      }).finally(() => {
        this.stationLoading = false;
        this.$nextTick(() => {
          this.scrollToBottom("stationRes");
        });
      });
    },
    loadStation() {
      console.log(this.keywords);
      if (this.keywords) {
        this.noMore = false;
        this.stationPageIndex++;
        this.searchStations();
      }
    },
    loadDevice() {
      if (this.keywords) {
        this.noMore = false;
        this.devicePageIndex++;
        this.searchDevices();
      }
    },
    //查询智能设备
    async searchDevices() {
      this.deviceLoading = true;
      Object(_api_device_controller__WEBPACK_IMPORTED_MODULE_12__["getDevices"])({
        pageIndex: this.devicePageIndex,
        pageSize: this.pageSize,
        searchModel: this.keywords ? "Keyword" : "SecurityResource",
        deskTypes: this.deskTypesParam,
        superviseDepartIds: this.formDevice.superviseDepartIds,
        keyword: this.keywords
      }).then(res => {
        console.log(res);
        if ([...res].length < this.pageSize) {
          this.noMore = true;
        } else {
          this.deviceCount += [...res].length;
        }
        this.resResult = [...this.resResult, ...res];
        this.devicesResultShow = this.keywords !== "";
        if (!this.keywords) {
          this.$emit("search", {
            type: 5,
            data: this.resResult.map(res => {
              return {
                ...res,
                type: "device"
              };
            })
          });
        }
      }).catch(err => {
        console.log(err);
      }).finally(() => {
        this.deviceLoading = false;
        this.$nextTick(() => {
          this.scrollToBottom("deviceRes");
        });
      });
    },
    //查询内保单位
    async searchProprietors() {
      this.proprietorLoading = true;
      console.log("institutional", this.formCompany.institutional);
      let institutional = this.proprietorTypesCode;
      if (this.formCompany.institutional && this.formCompany.institutional.length > 0) {
        institutional = this.formCompany.institutional;
      }
      Object(_api_company_controller__WEBPACK_IMPORTED_MODULE_11__["getCompanys"])({
        pageIndex: 1,
        pageSize: 5,
        institutionals: institutional,
        keyword: this.keywords,
        searchModel: this.keywords ? "Keyword" : "SecurityResource",
        superviseDepartIds: this.formCompany.superviseDepartIds,
        deskTypes: this.isCompany ? ["Normal", "Proprietor"] : this.deskTypes
      }).then(res => {
        console.log(res);
        if ([...res].length < this.pageSize) {
          this.noMore = true;
        } else {
          this.companyCount += [...res].length;
        }
        this.resResult = [...this.resResult, ...res];
        this.proprietorResultShow = this.keywords !== "";
        if (!this.keywords) {
          this.$emit("search", {
            type: 3,
            data: this.resResult.map(res => {
              return {
                ...res,
                type: "company"
              };
            })
          });
        }
      }).catch(err => {
        console.log(err);
      }).finally(() => {
        this.proprietorLoading = false;
        this.$nextTick(() => {
          this.scrollToBottom("proprietorRes");
        });
      });
    },
    loadProprietor() {
      console.log(this.keywords);
      if (this.keywords) {
        this.noMore = false;
        this.proprietorPageIndex++;
        this.searchProprietors();
      }
    },
    scrollToBottom(name) {
      const container = this.$refs[name];
      console.log(container.scrollHeight);
      container.scrollTop = container.scrollHeight;
    },
    //查询地址
    async getPlace() {
      if (this.mapType === "tianditu") {
        var _data$status;
        const params = {
          keyWord: this.keywords,
          mapBound: "-180,-90,180,90",
          level: 12,
          queryType: 1,
          start: 0,
          count: 10
        };
        const {
          data
        } = await Object(_api_amap__WEBPACK_IMPORTED_MODULE_8__["getPlaceByTiandi"])(params);
        if ((data === null || data === void 0 || (_data$status = data.status) === null || _data$status === void 0 ? void 0 : _data$status.infocode) === 1000) {
          if (data.pois) {
            this.resResult = data.pois.map(poi => {
              return {
                ...poi,
                type: "location",
                tel: poi.phone,
                location: poi.lonlat,
                id: poi.hotPointID
              };
            });
            this.resResultShow = true;
            this.$emit("search", {
              type: 4,
              data: this.resResult
            });
          }
        }
      } else {
        const city = (await Object(_api_amap__WEBPACK_IMPORTED_MODULE_8__["ipLocation"])(address__WEBPACK_IMPORTED_MODULE_5___default.a.ip())) || "厦门";
        console.log(city);
        Object(_api_amap__WEBPACK_IMPORTED_MODULE_8__["place"])({
          keywords: this.keywords,
          offset: 10,
          city
        }).then(res => {
          console.log("placeRes", res);
          const {
            status,
            data
          } = res;
          if (status === 200) {
            console.log("poidata", data);
            // if (data.infocode === "10044") {
            //   this.$message({
            //     message: "搜地点达到今日限额！",
            //     type: "warning",
            //   });
            //   return;
            // }
            if (data.tips) {
              this.resResult = data.tips.map(poi => {
                return {
                  ...poi,
                  type: "location"
                };
              }).filter(x => typeof x.id === "string");
              console.log("locationresResult", this.resResult);
              this.resResultShow = true;
              this.$emit("search", {
                type: 4,
                data: this.resResult
              });
            }
          }
        }).catch(err => {
          console.log(err);
        });
      }
    },
    onClickEmployee(employee) {
      if (employee.longitude && employee.latitude) {
        //有经纬度
        // 清空图标
        this.$emit("clearMap");
        console.log(employee);
        this.hideAllList();
        this.$emit("clickEmployee", employee, "isBack");
        this.$emit("addPolylineEntity");
      } else {
        this.$message({
          message: "该人员未完成签到，无位置坐标！",
          type: "warning"
        });
      }
    },
    onClickStation(stationId) {
      console.log("stationId", stationId);
      Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_9__["getStationDetail"])(stationId).then(station => {
        console.log("station", station);
        if (station) {
          const {
            longitude,
            latitude
          } = station;
          if (longitude && latitude) {
            //有经纬度
            this.$emit("clickStation", station, "station");
            // 清空图标
            this.$emit("clearMap");
            this.hideAllList();
            this.$emit("addPolylineEntity");
          } else {
            this.$message({
              message: "该驻勤点未完善位置坐标！",
              type: "warning"
            });
          }
        }
      }).catch(err => {
        console.log(err);
      });
    },
    onClickDevice(deviceId) {
      console.log("deviceId", deviceId);
      Object(_api_device_controller__WEBPACK_IMPORTED_MODULE_12__["getDeviceDetail"])(deviceId).then(device => {
        console.log("device", device);
        if (device) {
          const {
            longitude,
            latitude
          } = device;
          if (longitude && latitude) {
            //有经纬度
            this.$emit("clickDevice", device);
            // 清空图标
            this.$emit("clearMap");
            this.hideAllList();
          } else {
            this.$message({
              message: "该智能设备未完善位置坐标！",
              type: "warning"
            });
          }
        }
      }).catch(err => {
        console.log(err);
      });
    },
    onClickProprietor(company) {
      console.log("company", company);
      if (company) {
        if (company.longitude && company.latitude) {
          //有经纬度
          this.$emit("clickCompany", company, "company");
          // 清空图标
          this.$emit("clearMap");
          this.hideAllList();
        } else {
          this.$message({
            message: "该内保单位未完善位置坐标！",
            type: "warning"
          });
        }
      }
    },
    // * 搜考场
    loadExam() {
      if (this.keywords) {
        this.noMore = false;
        this.examPageIndex++;
        this.getExam();
      }
    },
    async getExam() {
      this.examLoading = true;
      Object(_api_exam_site_room_controller__WEBPACK_IMPORTED_MODULE_21__["getExamSiteRooms"])({
        pageIndex: 1,
        pageSize: this.pageSize,
        forExport: false,
        searchModel: "Keyword",
        keyword: this.keywords
      }).then(res => {
        console.log(res);
        if ([...res].length < this.pageSize) {
          this.noMore = true;
        }
        this.resResult = [...this.resResult, ...res];
        this.examResultShow = this.keywords !== "";
        this.$emit("search", {
          type: 7,
          data: this.resResult.map(res => {
            return {
              ...res,
              type: "exam"
            };
          })
        });
      }).catch(err => {
        this.$emit("search", {
          type: 7,
          data: []
        });
        this.$message.error(err);
      }).finally(() => {
        this.examLoading = false;
      });
    },
    // * 搜索结果点击某条考场
    onClickExam(exam) {
      console.log(exam);
      if (exam) {
        if (exam.longitude && exam.latitude) {
          //有经纬度
          this.$emit("clickExam", exam, "exam");
          // 清空图标
          this.$emit("clearMap");
          this.hideAllList();
        } else {
          this.$message({
            message: "该考场未完善位置坐标！",
            type: "warning"
          });
        }
      }
    },
    onClickPoi(poi) {
      // 清空图标
      this.$emit("clearMap");
      this.hideAllList();
      this.$emit("clickPoi", poi);
    },
    // 查看详情
    lookDetail(item, isFromWarn) {
      console.log("item", item);
      const {
        policeEventLevel
      } = item;
      this.isDetail = true;
      this.isFromWarn = isFromWarn;
      this.levelCountTabList.forEach(temp => {
        if (temp.label === policeEventLevel) {
          this.currentLevel = temp.level;
        }
      });
      Object(_api_police_incident_controller__WEBPACK_IMPORTED_MODULE_16__["policeIncidentsDetail"])(item.id).then(res => {
        console.log(res);
        this.policeIncidentsData = res;
      });
    },
    //关闭警情
    closeIncident(id) {
      this.$confirm("是否确认关闭事件，关闭事件后则默认事件状态为已处理", "提示", {
        confirmButtonText: "确认关闭",
        cancelButtonText: "取消",
        customClass: "del-model",
        type: "warning"
      }).then(() => {
        Object(_api_police_incident_controller__WEBPACK_IMPORTED_MODULE_16__["policeIncidentsHandle"])(id);
        this.$message({
          type: "success",
          message: "关闭成功!"
        });
        this.showPoliceIncidents(true);
      }).catch(() => {
        // this.$message({
        //   type: 'info',
        //   message: '已取消关闭'
        // });
      });
    },
    // 返回警情列表
    goBackList() {
      this.isDetail = false;
      if (this.isFromWarn) {
        //如果是预警处理，需要刷新页面
        this.showPoliceIncidents(true);
      }
    },
    showEmployeeByIncident(employeeId) {
      Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_10__["getEmployeeDetail"])(employeeId, this.deskTypes[0]).then(employee => {
        this.$emit("clickEmployee", employee);
      }).catch(err => {
        console.log(err);
      });
    },
    setActEmployeeTypes(list) {
      this.actAllEmployeeTypes = list;
      if (this.type == 1) {
        this.actEmployeeTypes = list.filter(el => !el.onlyForStation);
      } else if (this.type == 2) {
        this.actEmployeeTypes = list;
      }
    }
  },
  mounted() {
    this.init();
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/mqttClient/index.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/mqttClient/index.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_mixins_mqtt__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/components/mixins/mqtt */ "./src/components/mixins/mqtt.js");
/* harmony import */ var screenfull__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! screenfull */ "./node_modules/screenfull/index.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! dayjs */ "./node_modules/dayjs/dayjs.min.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! dayjs/locale/zh-cn */ "./node_modules/dayjs/locale/zh-cn.js");
/* harmony import */ var dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! dayjs/plugin/weekday */ "./node_modules/dayjs/plugin/weekday.js");
/* harmony import */ var dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _components_mqttClient_participatedList_vue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/components/mqttClient/participatedList.vue */ "./src/components/mqttClient/participatedList.vue");
/* harmony import */ var _components_mqttClient_unParticipatedList_vue__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/components/mqttClient/unParticipatedList.vue */ "./src/components/mqttClient/unParticipatedList.vue");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _components_mqttClient_utils_bus__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/components/mqttClient/utils/bus */ "./src/components/mqttClient/utils/bus.js");
/* harmony import */ var _services_mqttService__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/services/mqttService */ "./src/services/mqttService.js");




/**
 * 音视频的逻辑在mixins:mqtt里处理就好了
 * 这里只处理UI逻辑
 */











dayjs__WEBPACK_IMPORTED_MODULE_7___default.a.locale("zh-cn"); // 本地化
dayjs__WEBPACK_IMPORTED_MODULE_7___default.a.extend(dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_9___default.a); // 第一天为周一

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "mqttClient",
  mixins: [_components_mixins_mqtt__WEBPACK_IMPORTED_MODULE_4__["default"]],
  components: {
    UnParticipatedList: _components_mqttClient_unParticipatedList_vue__WEBPACK_IMPORTED_MODULE_11__["default"],
    participatedList: _components_mqttClient_participatedList_vue__WEBPACK_IMPORTED_MODULE_10__["default"]
  },
  props: {},
  data() {
    return {
      dialling: false,
      // 是否拨打电话中
      calling: false,
      // 是否通话中
      isDialled: false,
      // 是否被呼叫
      rightPanelVisible: true,
      isFullscreen: false,
      timer: null,
      // 当前时间定时器
      currentDatetime: dayjs__WEBPACK_IMPORTED_MODULE_7___default()().format("YYYY-MM-DD dddd HH:mm:ss"),
      // 当前时间
      timeTik: 0,
      timeTikFormat: "",
      timingTimer: null,
      openTime: null,
      allMembersTimer: null,
      connectingLimit: 60,
      // 拨号时长上限 单位秒 默认 1分钟（60秒）
      showAddUsers: false,
      layout: 3,
      showSwitchLayout: false,
      mute: false,
      micUserId: "",
      currentPage: 0,
      isFront: false // 是否前置摄像头
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_12__["mapState"])({
      account: ({
        gwsd
      }) => gwsd.account,
      memberList: ({
        gwsd
      }) => gwsd.memberList,
      currentUserProfile: ({
        user
      }) => user.currentUserProfile,
      participant: ({
        gwsd
      }) => gwsd.participant,
      yardmanType: ({
        gwsd
      }) => gwsd.yardman.type,
      type: ({
        gwsd
      }) => gwsd.yardman.callType,
      audio: ({
        gwsd
      }) => gwsd.yardman.audio,
      video: ({
        gwsd
      }) => gwsd.yardman.video,
      isMutedAudio: ({
        gwsd
      }) => gwsd.yardman.isMutedAudio,
      isMutedVideo: ({
        gwsd
      }) => gwsd.yardman.isMutedVideo,
      isCallVideo: ({
        gwsd
      }) => gwsd.yardman.isCallVideo
    }),
    memberListSort() {
      return [...this.memberList].sort((a, b) => {
        var _a$state;
        return a === null || a === void 0 || (_a$state = a.state) === null || _a$state === void 0 ? void 0 : _a$state.localeCompare(b === null || b === void 0 ? void 0 : b.state);
      });
    },
    memberListMoreSort() {
      return function (num) {
        return [...this.memberList].slice((num - 1) * (num <= 2 ? 8 : 9), (num <= 2 ? 8 : 9) * num).filter(x => x !== null && x !== undefined).sort((a, b) => {
          var _a$state2;
          return a === null || a === void 0 || (_a$state2 = a.state) === null || _a$state2 === void 0 ? void 0 : _a$state2.localeCompare(b === null || b === void 0 ? void 0 : b.state);
        });
      };
    },
    containerTranslate() {
      return {
        transform: `translate(${-this.currentPage * 100}%,0)`
      };
    }
  },
  watch: {
    memberList: {
      handler(value) {
        // console.log("memberList", value);
        const offlineMembers = [...value].filter(x => x.state === "DISCONNECTED").length;
        // console.log("offline members", offlineMembers, value.length);
        if (offlineMembers >= value.length && this.dialling) {
          this.handleLeave();
        }
      },
      deep: true,
      immediate: true
    }
  },
  methods: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_12__["mapMutations"])(["SET_YARDMAN_AUDIO_MUTED", "SET_YARDMAN_VIDEO_MUTED"]),
    handleScreen() {
      if (screenfull__WEBPACK_IMPORTED_MODULE_5__["default"].isEnabled) {
        // console.log("screen",this.$refs.container)
        screenfull__WEBPACK_IMPORTED_MODULE_5__["default"].toggle(this.$refs.container);
        this.isFullscreen = !this.isFullscreen;
        if (!this.isFullscreen) {
          this.$refs.container.style.top = "0";
          this.$refs.container.style.left = "50%";
          this.$refs.container.style.transform = "translate(-50%, 0)";
        }
      }
    },
    setTimer() {
      this.timer = setTimeout(() => {
        this.currentDatetime = dayjs__WEBPACK_IMPORTED_MODULE_7___default()().format("YYYY-MM-DD dddd HH:mm:ss");
        this.setTimer();
      }, 1000);
    },
    setTimingTimer() {
      this.timingTimer = setTimeout(() => {
        if (this.dialling) {
          this.timeTik = dayjs__WEBPACK_IMPORTED_MODULE_7___default()().diff(this.openTime) || 0;
          this.timeTikFormat = dayjs__WEBPACK_IMPORTED_MODULE_7___default()(this.timeTik).format("mm:ss");
        }
        this.setTimingTimer();
      }, 1000);
    },
    setAllMembersTimer() {
      this.allMembersTimer = setInterval(() => {
        const memberList = this.memberList.map(member => {
          const hasKey = Object.prototype.hasOwnProperty.call(member, "timer");
          const beKickOut = member.beKickOut;
          if (!hasKey || beKickOut || member.state === "CONNECTED") {
            member.timer = 0;
          } else {
            if (member.timer < this.connectingLimit && member.state === "CONNECTING") {
              member.timer++;
              member.timeout = false;
            } else {
              // 进入了超时判断
              if (member.state !== "DISCONNECTED") {
                member.timer = 0;
                member.timeout = true;
                member.state = "DISCONNECTED";
              }
            }
          }
          return member;
        });
        this.SET_MEMBER_LIST(memberList); // 更新被调度人数组
        // console.log(
        //   "%c群聊定时器 %c成员列表",
        //   "background: #E6A23C; color: #fff; padding:2px",
        //   "background: #00cc00; color: #fff; padding:2px",
        //   this.memberList
        // );
      }, 1000);
    },
    clearTimer() {
      if (this.timer) {
        clearTimeout(this.timer);
        this.timer = null;
      }
      if (this.timingTimer) {
        clearTimeout(this.timingTimer);
        this.timingTimer = null;
      }
      if (this.allMembersTimer) {
        clearInterval(this.allMembersTimer);
        this.allMembersTimer = null;
      }
      this.timeTikFormat = "";
    },
    handleLeave: lodash__WEBPACK_IMPORTED_MODULE_6___default.a.debounce(function () {
      var _this$memberList$;
      console.log("handleLeave");
      this.clearTimer();
      const toId = (_this$memberList$ = this.memberList[0]) === null || _this$memberList$ === void 0 ? void 0 : _this$memberList$.dispatchUid;
      this.leave(this.isCallVideo, toId).then(() => {
        console.log("leave success");
        this.dialling = false;
        this.SET_YARDMAN_VIDEO_MUTED(false);
        // this.isMutedAudio = false;
        this.SET_YARDMAN_AUDIO_MUTED(false);
        this.rightPanelVisible = true;
        this.rightPanelActiveName = "1";
      });
    }, 500),
    handleSwitchCamera(dispatchUid) {
      this.isFront = !this.isFront;
      this.client.switchCamera({
        toId: dispatchUid,
        isFront: this.isFront
      });
    },
    // 发起通话
    async videoCalling() {
      this.layout = 3;
      if (this.memberList.length >= 3) {
        this.layout = 6;
        if (this.memberList.length >= 6) {
          this.layout = 9;
        }
      }
      console.log("videoCalling---", this.account);
      this.initClient(this.account).then(() => {
        try {
          this.dialling = true; // 显示窗口
          this.initListener();
        } catch (e) {
          console.log("videoCalling error", e);
        }
      });
    },
    async pullRemoteVideo(toId) {
      console.log("toId", toId);
      console.log("pullRemoteVideo---", this.account);
      this.initClient(this.account).then(() => {
        try {
          this.dialling = true; // 显示窗口
          if (toId) {
            this.client.invite({
              audioonly: false,
              // 音频调度
              isCallVideo: this.isCallVideo,
              toId: toId
            });
          } else {
            this.inviteRemote(this.memberList, {
              audioonly: false,
              // 音频调度
              isCallVideo: this.isCallVideo
            });
          }
        } catch (e) {
          console.log("pullRemoteVideo error", e);
        }
      });
    },
    initListener(init = true) {
      // 连接音视频服务器成功
      this.client.on("connect", () => {
        if (!this.dialling) return;
        // 开始会话时开始计时
        this.openTime = dayjs__WEBPACK_IMPORTED_MODULE_7___default()();
        this.setTimingTimer();
        // 分别对所有参会人计时
        this.setAllMembersTimer();
        // 打开本地流
        this.initLocalStream({
          audio: this.audio,
          video: this.video
        });
      });
      // 发布本地流成功
      this.client.on("localVideoOpen", ({
        userId,
        mediaId
      }) => {
        console.log("发布本地流成功", userId, mediaId);
        // 邀请入会
        console.log("%c刚建立会议自动邀请 %c成员列表", "background: #E6A23C; color: #fff; padding:2px", "background: #00cc00; color: #fff; padding:2px", this.memberList);
        if (init) this.inviteRemote(this.memberList, {
          audioonly: this.type === "audio" // 音频调度
        });
      });
      // 发布本地流失败
      this.client.on("localVideoError", err => {
        this.$message.error(err);
      });
    },
    pagePre() {
      this.currentPage--;
      if (this.currentPage < 0) {
        this.currentPage = Math.ceil(this.memberList.length / 9) - 1;
      }
    },
    pageNext() {
      this.currentPage++;
      if (this.currentPage > Math.ceil((this.memberList.length + 1) / 9) - 1) {
        this.currentPage = 0;
      }
    },
    // 处理本地禁麦、取消禁麦
    handleMuteAudio: lodash__WEBPACK_IMPORTED_MODULE_6___default.a.debounce(function () {
      if (this.isMutedAudio) {
        this.unmuteAudio();
      } else {
        this.muteAudio();
      }
    }, 500),
    handleMuteVideo: lodash__WEBPACK_IMPORTED_MODULE_6___default.a.debounce(function () {
      if (this.isMutedVideo) {
        this.unmuteVideo();
      } else {
        this.muteVideo();
      }
    }, 500),
    switchLayout: lodash__WEBPACK_IMPORTED_MODULE_6___default.a.debounce(function () {
      this.showSwitchLayout = !this.showSwitchLayout;
    }, 500),
    setRightPanelVisible: lodash__WEBPACK_IMPORTED_MODULE_6___default.a.debounce(function () {
      this.rightPanelVisible = !this.rightPanelVisible;
    }, 500),
    // 新增成员后回调
    addMembers(memberList) {
      this.inviteRemote(memberList, {
        audioonly: this.type === "audio" // 音频调度或
      });
      if (this.memberList.length >= 3) {
        this.layout = 6;
        if (this.memberList.length >= 6) {
          this.layout = 9;
        }
      }
    },
    memberMute(id) {
      this.muteRemoteAudio(id);
    },
    memberUnmute(id) {
      this.unmuteRemoteAudio(id);
    },
    muteAll() {
      this.memberList.forEach(item => {
        this.muteRemoteAudio(item.dispatchUid);
      });
    },
    unMuteAll() {
      this.memberList.forEach(item => {
        this.unmuteRemoteAudio(item.dispatchUid);
      });
    },
    kickOut(id) {
      this.kickOutRemote(id);
    },
    recall(dispatchUid) {
      this.inviteRemote([{
        dispatchUid
      }], {
        audioonly: this.type === "audio" // 音频调度
      });
    },
    handup(dispatchUid) {
      this.handUpRemote(dispatchUid);
    }
  },
  created() {
    this.setTimer();
  },
  mounted() {
    window.addEventListener("sos-exit", () => {
      this.handleLeave();
    });
    this.$bus.$on("mqtt-call", this.videoCalling); // 发起通话
    this.$bus.$on("mqtt-pull-video", this.pullRemoteVideo); // 静默拉取远端视频
    // 远端流加入
    _components_mqttClient_utils_bus__WEBPACK_IMPORTED_MODULE_13__["bus"].$on("pull_video_message_new_remote", ack => {
      console.log("pull_video_message_new_remote", ack);
      if (ack.length > 0) {
        this.pullVideoFromServer(ack[0].id);
      }
    });
    // 监听远端离开
    _components_mqttClient_utils_bus__WEBPACK_IMPORTED_MODULE_13__["bus"].$on("remote_HangUp", ack => {
      console.log("监听远端离开", ack);
      // 这里ack里面是远端离开的uid 然后你可以写她离开的逻辑
      this.pullVideoLeave(ack);
    });
  },
  beforeDestroy() {
    // 清理定时器
    this.clearTimer();

    // 移除事件监听
    this.$bus.$off("mqtt-call", this.videoCalling);
    this.$bus.$off("mqtt-pull-video", this.pullRemoteVideo);
    _components_mqttClient_utils_bus__WEBPACK_IMPORTED_MODULE_13__["bus"].$off("pull_video_message_new_remote");
    _components_mqttClient_utils_bus__WEBPACK_IMPORTED_MODULE_13__["bus"].$off("remote_HangUp");
  },
  destroyed() {
    this.clearTimer();
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/mqttClient/participatedList.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/mqttClient/participatedList.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "participatedList",
  components: {},
  props: {
    visible: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      rightPanelActiveName: "1"
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_2__["mapState"])({
      memberList: ({
        gwsd
      }) => gwsd.memberList,
      currentUserProfile: ({
        user
      }) => user.currentUserProfile,
      participant: ({
        gwsd
      }) => gwsd.participant,
      yardmanType: ({
        gwsd
      }) => gwsd.yardman.type,
      type: ({
        gwsd
      }) => gwsd.yardman.callType,
      audio: ({
        gwsd
      }) => gwsd.yardman.audio,
      video: ({
        gwsd
      }) => gwsd.yardman.video,
      isMutedAudio: ({
        gwsd
      }) => gwsd.yardman.isMutedAudio,
      isMutedVideo: ({
        gwsd
      }) => gwsd.yardman.isMutedVideo
    }),
    tabsLabelConnecting() {
      return `调度中（${this.memberList.filter(x => x.state !== "DISCONNECTED").length}）`;
    },
    tabsLabelDisconnecting() {
      return `断联（${this.memberList.filter(x => x.state === "DISCONNECTED").length}）`;
    }
  },
  watch: {},
  methods: {
    close() {
      this.$emit("update:visible", false);
    },
    handleMuteAudio() {
      this.$emit("muteAudio");
    },
    handleMuteVideo() {
      this.$emit("muteVideo");
    },
    memberMute(id) {
      console.log("memberMute", id);
      this.$emit("memberMute", id);
    },
    memberUnmute(id) {
      console.log("memberUnmute", id);
      this.$emit("memberUnmute", id);
    },
    kickOut(id) {
      this.$emit("kickOut", id);
    },
    handup(id) {
      this.$emit("handup", id);
    },
    recall(id) {
      this.$emit("recall", id);
    },
    showAddMember() {
      this.$emit("showAddMember");
    },
    muteAll() {
      this.$emit("muteAll");
    },
    unMuteAll() {
      this.$emit("unMuteAll");
    }
  },
  created() {},
  mounted() {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/mqttClient/unParticipatedList.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/mqttClient/unParticipatedList.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "unParticipatedList",
  components: {},
  props: {},
  data() {
    return {
      pickupName: "",
      pickupMemberList: []
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_3__["mapState"])({
      unParticipated: ({
        gwsd
      }) => gwsd.unParticipated
    })
  },
  watch: {},
  methods: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_3__["mapActions"])(["getUnParticipated", "addMQTTGroupUsers"]),
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_3__["mapMutations"])(["UPDATE_UN_PARTICIPATED" /*更新在调度范围内但是未参会的人员信息*/, "UNCHECK_ALL_UN_PARTICIPANT" /*反选所有在调度范围内但是未参会的人员*/]),
    async onOpen() {
      // 获取在调度范围内但是未参会的人员
      this.pickupMemberList = await this.getUnParticipated();
    },
    close() {
      this.UNCHECK_ALL_UN_PARTICIPANT();
      this.$emit("close");
      this.$emit("update:visible", false);
    },
    queryPickup(val) {
      if (val) {
        this.pickupMemberList = this.unParticipated.filter(x => {
          return x.name.indexOf(val) >= 0;
        });
      } else {
        this.pickupMemberList = this.unParticipated;
      }
    },
    clearPickup() {
      this.UNCHECK_ALL_UN_PARTICIPANT();
    },
    setCheck(member, checked) {
      const index = this.unParticipated.findIndex(x => x.id === member.id);
      this.UPDATE_UN_PARTICIPATED({
        index,
        member: {
          ...member,
          checked
        }
      });
    },
    unCheck(member) {
      const index = this.unParticipated.findIndex(x => x.id === member.id);
      this.setCheck(index, member, false);
    },
    addMembers() {
      const members = this.unParticipated.filter(x => x.checked === true);
      console.log("%c add member members", "background: #00cc00; color: #fff; border-radius: 3px;padding:2px 5px", members);
      if (!members || members.length === 0) {
        return false;
      }
      // 更新调度窗口的勾选状态
      const unParticipated = this.unParticipated.filter(item => item.checked);
      const payload = unParticipated.map(item => item.dispatchNo);
      this.addMQTTGroupUsers(payload).then(() => {
        // 去client组件发送信令
        this.$emit("addMembers", members);
        // 关闭弹窗
        this.close();
      });
    }
  },
  created() {},
  mounted() {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/pttClient/index.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/pttClient/index.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_pttClient_unParticipatedList_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/components/pttClient/unParticipatedList.vue */ "./src/components/pttClient/unParticipatedList.vue");
/* harmony import */ var _components_pttClient_WebPtt__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/components/pttClient/WebPtt */ "./src/components/pttClient/WebPtt.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! dayjs */ "./node_modules/dayjs/dayjs.min.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var dayjs_plugin_duration__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! dayjs/plugin/duration */ "./node_modules/dayjs/plugin/duration.js");
/* harmony import */ var dayjs_plugin_duration__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_duration__WEBPACK_IMPORTED_MODULE_7__);








dayjs__WEBPACK_IMPORTED_MODULE_6___default.a.extend(dayjs_plugin_duration__WEBPACK_IMPORTED_MODULE_7___default.a);
window.PTTClient = null;
window.PTTClientLoginStatus = false;
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "pttClient",
  components: {
    unParticipatedList: _components_pttClient_unParticipatedList_vue__WEBPACK_IMPORTED_MODULE_2__["default"]
  },
  props: {
    multiple: Boolean
  },
  data() {
    return {
      userTalking: false,
      stream: {
        speak: false,
        listen: false
      },
      startCall: false,
      timeTikFormat: "00:00:00",
      timingTimer: null,
      openTime: null,
      timeTik: 0,
      /**
       * 双方都静默时长
       * 1、一建立连接就开始且持续计时(setTimingTimer，每秒+1)
       * 2、有人说话就赋值为0（onSpeak）
       * 3、一直没人讲话就会再持续累加（注意：就算有人说话也只是赋值把silenceTime赋值为0，setTimingTimer定时器没有结束，一直在更新silenceTime）
       * 4、直至双方都静默时长到达一分钟(silenceTime>60)触发挂断（watch silenceTime）
       */
      silenceTime: 0,
      pageIndex: 1,
      pageSize: 16,
      currentList: [],
      showAddUsers: false,
      spokespersonId: null
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_4__["mapState"])({
      pttAccount: state => state.gwsd.account,
      memberList: state => state.gwsd.memberList,
      sysUserInfo: state => state.user.sysUserInfo,
      participant: state => state.gwsd.participant
    }),
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_4__["mapGetters"])(["pttGroupId"]),
    total() {
      return this.participant.length;
    }
  },
  watch: {
    // 双方静默1分钟自动挂断
    // silenceTime(val) {
    //   if (val && val > 60) {
    //     this.hangup();
    //   }
    // },
  },
  methods: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_4__["mapActions"])(["dismissPTTGroup" /*删除组群*/, "removePTTGroupUser" /*删除组群成员*/, "getParticipant"]),
    clearTimer() {
      this.silenceTime = 0;
      this.openTime = null;
      if (this.timingTimer) {
        clearTimeout(this.timingTimer);
        this.timingTimer = null;
      }
    },
    // 挂断，直接触发关闭弹框回调onClose方法
    hangup() {
      if (this.$refs.speak && this.$refs.speak.srcObject) {
        // 结束通话
        window.PTTClient.stopCall();
      }
      this.$emit("close");
      this.$emit("update:visible", false);
    },
    // 关闭弹框回调
    onClose() {
      // 退出组群
      this.dismissPTTGroup({
        adminName: this.pttAccount.adminName,
        gid: this.pttGroupId
      }).then(res => {
        console.log(res);
        // if (window.PTTClient && window.PTTClientLoginStatus) {
        //   window.PTTClient.leaveGroup();
        //   window.PTTClient.logout();
        // }
        if (this.$refs.speak && this.$refs.speak.srcObject) {
          // 结束通话
          window.PTTClient.stopCall();
        }
      }).finally(() => {
        // 结束通话
        this.startCall = false;
      });
      // 清空定时器
      this.clearTimer();
      // 关闭弹框
      this.$emit("close");
      this.$emit("update:visible", false);
    },
    // 弹框打开时回调
    onOpen() {
      this.stream.listen = false;
      this.stream.speak = false;
      this.$emit("open");
      // 计算当前页显示的成员
      this.calcCurrentPage();
      // 初始化PTTClient
      this.initClient();
    },
    // 初始化PTTClient
    initClient() {
      // 窗口打开时判断是否已经生成了客户端
      if (!window.PTTClient) {
        window.PTTClientLoginStatus = false;
        const {
          account,
          password
        } = this.pttAccount; // 调度员PTT账号信息 sapi/misc/virtualAccount/detail 接口获取
        // 创建PTTClient客户端
        window.PTTClient = new _components_pttClient_WebPtt__WEBPACK_IMPORTED_MODULE_3__["default"]({
          speak: this.$refs.speak,
          listen: this.$refs.listen,
          account,
          password: password ? password : "111111",
          onLogin: (status, uid) => {
            console.log("ptt login status=", status, " uid=", uid);
            // 登录成功，更新登录状态
            window.PTTClientLoginStatus = Number(status) === 0;
            if (window.PTTClientLoginStatus) {
              // 自动加入组群
              window.PTTClient.joinGroup(this.pttGroupId);
            }
          },
          onLogout: () => {
            window.PTTClientLoginStatus = false;
          },
          onError: (code, info) => {
            if (Number(code) !== 0) {
              console.log("error happen=", code, info);
              // this.$message.error("对讲服务连接失败");
            } else {
              console.log("success no error");
              // this.$message.success("对讲服务连接成功");
              // ws 连接成功后 判断是否登录过，没有就自动登录
              // PTTClientLoginStatus在onLogin回调中更新
              if (!window.PTTClientLoginStatus) window.PTTClient.login();
            }
          },
          onAddStream: (dir, stream) => {
            console.log("add stream", dir, stream);
            // if (dir === 1) {
            //   this.stream.speak = stream;
            // } else {
            //   this.stream.listen = stream;
            // }
          },
          onSpeak: (status, uid) => {
            // 讲话状态回调
            // status < 0 本机讲话失败
            // status == 0 uid == 0 其他成员讲话结束
            // status == 0 uid > 0 其他成员讲话开始，uid 为讲话者 id
            console.log("ptt speak status=", status, " uid=", uid);
            if (status >= 0) {
              this.silenceTime = 0;
              if (uid > 0) {
                this.spokespersonId = uid;
                this.stream.listen = true;
              } else {
                this.stream.listen = false;
              }
            }
          }
        });
      } else {
        // 已经生成了客户端，是二次打开窗口，如果没登录就再登录一次
        if (!window.PTTClientLoginStatus) window.PTTClient.login();
      }
      // 开始计时
      this.openTime = dayjs__WEBPACK_IMPORTED_MODULE_6___default()();
      this.setTimingTimer();
    },
    // 根据participant的total和pageSize,pageIndex计算当前显示的currentList
    calcCurrentPage() {
      const {
        dispatchNo
      } = this.sysUserInfo;
      this.getParticipant().then(() => {
        const currentList = this.participant.slice((this.pageIndex - 1) * this.pageSize, this.pageIndex * this.pageSize);
        const list = currentList.map(item => {
          return {
            ...item,
            showRemove: false,
            host: dispatchNo === item.account
          };
        });
        // this.currentList按list数组host字段true在前false在后排序
        this.currentList = list.sort(a => a.host ? -1 : 1);
        console.log("currentList", this.currentList);
      });
    },
    // 开始or结束通话
    requestPttTalk: lodash__WEBPACK_IMPORTED_MODULE_5___default.a.debounce(/*加个防抖避免快速重复点击*/function () {
      if (window.PTTClient && window.PTTClientLoginStatus) {
        this.startCall = !this.startCall;
        if (this.startCall) {
          window.PTTClient.startCall();
        } else {
          window.PTTClient.stopCall();
          this.silenceTime = 0;
        }
      }
    }, 1000),
    setTimingTimer() {
      var _this$stream, _this$stream2;
      this.silenceTime++;
      if ((_this$stream = this.stream) !== null && _this$stream !== void 0 && _this$stream.speak || (_this$stream2 = this.stream) !== null && _this$stream2 !== void 0 && _this$stream2.listen) {
        this.silenceTime = 0;
      }
      this.timingTimer = setTimeout(() => {
        this.timeTik = dayjs__WEBPACK_IMPORTED_MODULE_6___default()().diff(this.openTime) || 0;
        const duration = dayjs__WEBPACK_IMPORTED_MODULE_6___default.a.duration(this.timeTik);
        const hours = duration.hours() < 10 ? `0${duration.hours()}` : duration.hours();
        const minutes = duration.minutes() < 10 ? `0${duration.minutes()}` : duration.minutes();
        const seconds = duration.seconds() < 10 ? `0${duration.seconds()}` : duration.seconds();
        this.timeTikFormat = hours + ":" + minutes + ":" + seconds;
        this.setTimingTimer();
      }, 1000);
    },
    onCurrentChange(val) {
      this.pageIndex = val;
      this.calcCurrentPage();
    },
    showRemove(item) {
      if (!item.host) item.showRemove = true;
    },
    // 删除组群成员
    removeUser(item) {
      this.removePTTGroupUser(item.account).then(res => {
        console.log(res);
        this.calcCurrentPage();
      });
    }
  },
  created() {},
  mounted() {},
  beforeDestroy() {
    this.dismissPTTGroup({
      adminName: this.pttAccount.adminName,
      gid: this.pttGroupId
    }).then(res => {
      console.log(res);
      // if (window.PTTClient && window.PTTClientLoginStatus) {
      //   window.PTTClient.leaveGroup();
      //   window.PTTClient.logout();
      // }
    });
    this.clearTimer();
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/pttClient/unParticipatedList.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/pttClient/unParticipatedList.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "unParticipatedList",
  components: {},
  props: {
    show: Boolean
  },
  data() {
    return {};
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_3__["mapState"])({
      unParticipated: state => state.gwsd.unParticipated
    })
  },
  watch: {},
  methods: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_3__["mapActions"])(["getUnParticipated" /*获取在调度范围内但是未参会的人员*/, "addPTTGroupUsers" /*添加组群成员*/]),
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_3__["mapMutations"])(["UPDATE_UN_PARTICIPATED" /*更新在调度范围内但是未参会的人员信息*/, "UNCHECK_ALL_UN_PARTICIPANT" /*反选所有在调度范围内但是未参会的人员*/]),
    // 打开弹框回调
    onOpenAddUsers() {
      // 获取在调度范围内但是未参会的人员
      this.getUnParticipated();
    },
    // 关闭弹框回调
    onClose() {
      this.cancelAddUser();
    },
    // 取消
    cancelAddUser() {
      // 反选所有在调度范围内但是未参会的人员，重置列表状态
      this.UNCHECK_ALL_UN_PARTICIPANT();
      this.$emit("close");
      this.$emit("update:visible", false);
    },
    // 确认添加成员
    addUsers() {
      const unParticipated = this.unParticipated.filter(item => item.checked);
      const payload = unParticipated.map(item => item.dispatchNo);
      this.addPTTGroupUsers(payload).then(res => {
        console.log(res);
        // this.calcCurrentPage();
        this.getUnParticipated();
        this.$emit("addUsers");
      });
      this.cancelAddUser();
    },
    /**
     * 勾选成员
     * @param index 下标
     * @param member 成员信息
     */
    select(index, member) {
      // 更新在调度范围内但是未参会的人员信息
      this.UPDATE_UN_PARTICIPATED({
        index,
        member: {
          ...member,
          checked: !member.checked
        }
      });
    }
  },
  created() {},
  mounted() {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/conversation/conversation-item.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/conversation/conversation-item.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _utils_date__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/utils/date */ "./src/utils/date.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "conversation-item",
  props: ["conversation"],
  data() {
    return {
      popoverVisible: false,
      showMessageAtMe_text: "",
      isImgError: false
    };
  },
  computed: {
    hasMessageAtMe() {
      return this.currentConversation.conversationID !== this.conversation.conversationID && this.conversation.groupAtInfoList && this.conversation.groupAtInfoList.length > 0;
    },
    messageAtMeText() {
      let text = "";
      if (this.conversation.groupAtInfoList.length > 0) {
        this.conversation.groupAtInfoList.forEach(item => {
          if (item.atTypeArray[0] === this.TIM.TYPES.CONV_AT_ME) {
            text.indexOf("[@所有人]") !== -1 ? text = "[@所有人][有人@我]" : text = "[有人@我]";
          }
          if (item.atTypeArray[0] === this.TIM.TYPES.CONV_AT_ALL) {
            text.indexOf("[有人@我]") !== -1 ? text = "[有人@我][@所有人]" : text = "[@所有人]";
          }
          if (item.atTypeArray[0] === this.TIM.TYPES.CONV_AT_ALL_AT_ME) {
            text = "[@所有人][有人@我]";
          }
        });
      }
      return text;
    },
    showUnreadCount() {
      if (this.$store.getters.hidden) {
        return this.conversation.unreadCount > 0;
      }
      // 是否显示未读计数。当前会话和未读计数为0的会话，不显示。
      return this.currentConversation.conversationID !== this.conversation.conversationID && this.conversation.unreadCount > 0;
    },
    date() {
      if (!this.conversation.lastMessage || !this.conversation.lastMessage.lastTime) {
        return "";
      }
      const date = new Date(this.conversation.lastMessage.lastTime * 1000);
      if (Object(_utils_date__WEBPACK_IMPORTED_MODULE_3__["isToday"])(date)) {
        return Object(_utils_date__WEBPACK_IMPORTED_MODULE_3__["getTime"])(date);
      }
      return Object(_utils_date__WEBPACK_IMPORTED_MODULE_3__["getDate"])(date);
    },
    avatar: function () {
      switch (this.conversation.type) {
        case "GROUP":
          return this.conversation.groupProfile.avatar;
        case "C2C":
          return this.conversation.userProfile.avatar;
        default:
          return "";
      }
    },
    conversationName: function () {
      if (this.conversation.type === this.TIM.TYPES.CONV_C2C) {
        return this.conversation.userProfile.nick || this.conversation.userProfile.userID;
      }
      if (this.conversation.type === this.TIM.TYPES.CONV_GROUP) {
        return this.conversation.groupProfile.name || this.conversation.groupProfile.groupID;
      }
      if (this.conversation.type === this.TIM.TYPES.CONV_SYSTEM) {
        return "系统通知";
      }
      return "";
    },
    showGrayBadge() {
      if (this.conversation.type !== this.TIM.TYPES.CONV_GROUP) {
        return false;
      }
      return this.conversation.groupProfile.selfInfo.messageRemindType === "AcceptNotNotify";
    },
    messageForShow() {
      if (this.conversation.lastMessage.isRevoked) {
        if (this.conversation.lastMessage.fromAccount === this.currentUserProfile.userID) {
          return "你撤回了一条消息";
        }
        if (this.conversation.type === this.TIM.TYPES.CONV_C2C) {
          return "对方撤回了一条消息";
        }
        return `${this.conversation.lastMessage.fromAccount}撤回了一条消息`;
      }
      return this.conversation.lastMessage.messageForShow;
    },
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_2__["mapState"])({
      currentConversation: state => state.conversation.currentConversation,
      currentUserProfile: state => state.user.currentUserProfile
    }),
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_2__["mapGetters"])(["toAccount"])
  },
  mounted() {},
  methods: {
    handleImgError() {
      this.isImgError = true;
    },
    selectConversation() {
      if (this.conversation.conversationID !== this.currentConversation.conversationID) {
        this.$store.dispatch("checkoutConversation", this.conversation.conversationID);
      }
    },
    deleteConversation(event) {
      // 停止冒泡，避免和点击会话的事件冲突
      event.stopPropagation();
      this.tim.deleteConversation(this.conversation.conversationID).then(() => {
        this.$store.commit("showMessage", {
          message: `会话【${this.conversationName}】删除成功!`,
          type: "success"
        });
        this.popoverVisible = false;
        this.$store.commit("resetCurrentConversation");
      }).catch(error => {
        this.$store.commit("showMessage", {
          message: `会话【${this.conversationName}】删除失败!, error=${error.message}`,
          type: "error"
        });
        this.popoverVisible = false;
      });
    },
    showContextMenu() {
      this.popoverVisible = true;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/conversation/current-conversation.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/conversation/current-conversation.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var tim_js_sdk_tim_js_friendship__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tim-js-sdk/tim-js-friendship */ "./node_modules/tim-js-sdk/tim-js-friendship.js");
/* harmony import */ var tim_js_sdk_tim_js_friendship__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(tim_js_sdk_tim_js_friendship__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _tim__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/tim */ "./src/tim.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _utils_emojiMap__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/utils/emojiMap */ "./src/utils/emojiMap.js");
/* harmony import */ var _components_timApp_message_message_item_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/components/timApp/message/message-item.vue */ "./src/components/timApp/message/message-item.vue");
/* harmony import */ var screenfull__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! screenfull */ "./node_modules/screenfull/index.js");
/* harmony import */ var _components_timApp_conversation_conversation_item_vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/components/timApp/conversation/conversation-item.vue */ "./src/components/timApp/conversation/conversation-item.vue");
/* harmony import */ var _components_timApp_group_group_item_vue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/components/timApp/group/group-item.vue */ "./src/components/timApp/group/group-item.vue");
/* harmony import */ var _api_employee_controller__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/api/employee-controller */ "./src/api/employee-controller.js");












/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CurrentConversation",
  components: {
    GroupItem: _components_timApp_group_group_item_vue__WEBPACK_IMPORTED_MODULE_10__["default"],
    ConversationItem: _components_timApp_conversation_conversation_item_vue__WEBPACK_IMPORTED_MODULE_9__["default"],
    messageItem: _components_timApp_message_message_item_vue__WEBPACK_IMPORTED_MODULE_7__["default"]
  },
  props: {
    isComplete: {
      type: Boolean,
      default: false
    },
    conversationID: {
      type: String
    },
    defaultMessage: {
      type: String
    }
  },
  data() {
    return {
      emojiMap: _utils_emojiMap__WEBPACK_IMPORTED_MODULE_6__["emojiMap"],
      emojiName: _utils_emojiMap__WEBPACK_IMPORTED_MODULE_6__["emojiName"],
      emojiUrl: _utils_emojiMap__WEBPACK_IMPORTED_MODULE_6__["emojiUrl"],
      disX: 0,
      disY: 0,
      down: false,
      isImgError: false,
      isImgLoad: false,
      message: "",
      isFullscreen: false,
      active: "C2C",
      groupAvatar: __webpack_require__(/*! @/assets/images/conversation/群组icon.png */ "./src/assets/images/conversation/群组icon.png"),
      isShowScrollButtomTips: false,
      preScrollHeight: 0,
      deskTypes: localStorage.getItem("platform") === "2" ? ["Proprietor"] : localStorage.getItem("platform") === "3" ? ["TemporarySecurity"] : ["Normal"]
    };
  },
  computed: {
    screenfull() {
      return screenfull__WEBPACK_IMPORTED_MODULE_8__["default"];
    },
    groupList: function () {
      return this.$store.state.group.groupList;
    },
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_5__["mapState"])({
      currentUnreadCount: state => state.conversation.currentConversation.unreadCount,
      conversationList: state => state.conversation.conversationList.filter(x => x.type === "C2C"),
      currentConversation: state => state.conversation.currentConversation,
      currentMessageList: state => state.conversation.currentMessageList,
      currentUserProfile: state => state.user.currentUserProfile,
      currentMemberList: state => state.group.currentMemberList
    }),
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_5__["mapGetters"])(["toAccount", "currentConversationType", "hidden"]),
    nick() {
      var _this$currentConversa;
      // console.log("currentConversation info",this.currentConversation.info)
      let name = (_this$currentConversa = this.currentConversation) === null || _this$currentConversa === void 0 || (_this$currentConversa = _this$currentConversa.info) === null || _this$currentConversa === void 0 ? void 0 : _this$currentConversa.name;
      if (!name) {
        const userInfo = localStorage.getItem("userInfo");
        if (userInfo) {
          console.log("userInfo", JSON.parse(userInfo));
          name = JSON.parse(userInfo).name;
        }
      }
      return name;
    },
    groupName() {
      return this.currentConversation.groupProfile.name;
    },
    avatarSrc: function () {
      return this.currentConversation.type === tim_js_sdk_tim_js_friendship__WEBPACK_IMPORTED_MODULE_3___default.a.TYPES.CONV_C2C ? this.currentConversation.userProfile.avatar : __webpack_require__(/*! @/assets/images/conversation/群组icon.png */ "./src/assets/images/conversation/群组icon.png");
    },
    defaultSrc: function () {
      switch (this.currentConversation.type) {
        case "C2C":
          // 个人头像
          return "https://gw.alipayobjects.com/zos/rmsportal/BiazfanxmamNRoxxVxka.png";
        case "GROUP":
          // 群默认头像
          return "https://imgcache.qq.com/open/qcloud/video/act/webim-avatar/avatar-3.png";
        case tim_js_sdk_tim_js_friendship__WEBPACK_IMPORTED_MODULE_3___default.a.TYPES.CONV_SYSTEM:
          return "https://gw.alipayobjects.com/zos/rmsportal/BiazfanxmamNRoxxVxka.png";
        default:
          // 默认头像
          return "https://gw.alipayobjects.com/zos/rmsportal/BiazfanxmamNRoxxVxka.png";
      }
    },
    showGroupList() {
      return this.active === "GROUP";
    },
    showConversationList() {
      return this.active === "C2C";
    }
  },
  watch: {
    currentUnreadCount(next) {
      if (!this.hidden && next > 0) {
        _tim__WEBPACK_IMPORTED_MODULE_4__["default"].setMessageRead({
          conversationID: this.currentConversation.conversationID
        });
      }
    },
    hidden(next) {
      if (!next && this.currentUnreadCount > 0) {
        _tim__WEBPACK_IMPORTED_MODULE_4__["default"].setMessageRead({
          conversationID: this.currentConversation.conversationID
        });
      }
    }
  },
  methods: {
    handleScreen() {
      if (screenfull__WEBPACK_IMPORTED_MODULE_8__["default"].isEnabled) {
        // console.log("screen",this.$refs.container)
        screenfull__WEBPACK_IMPORTED_MODULE_8__["default"].toggle(this.$refs.container);
        this.isFullscreen = !this.isFullscreen;
      }
    },
    /**
     * 监听鼠标移动事件
     * @param evt
     */
    onmousedown(evt) {
      if (this.isFullscreen) return false;
      // event的兼容性
      const ev = evt || event;

      // 获取鼠标按下的坐标
      const x1 = ev.clientX;
      const y1 = ev.clientY;

      // 获取元素的left，top值
      const l = this.$refs.container.offsetLeft;
      const t = this.$refs.container.offsetTop;

      // 给可视区域添加鼠标的移动事件
      document.onmousemove = eve => {
        // event的兼容性
        const evn = eve || event;

        // 获取鼠标移动时的坐标
        const x2 = evn.clientX;
        const y2 = evn.clientY;

        // 计算出鼠标的移动距离
        const x = x2 - x1;
        const y = y2 - y1;

        // 移动的数值与元素的left，top相加，得出元素的移动的距离
        const lt = y + t;
        const ls = x + l;

        // 更改元素的left，top值
        this.$refs.container.style.top = lt + "px";
        this.$refs.container.style.left = ls + "px";
        this.$emit("move", [ls, lt]);
      };
    },
    onmouseup(evt) {
      const evn = evt || event;
      this.down = false;
      document.removeEventListener("mousemove", this.onResize);
      document.onmousemove = null;
      document.onmousedown = null;
      document.onmouseup = null;
      const x2 = evn.clientX;
      const y2 = evn.clientY;
      this.$emit("moveEnd", [x2, y2]);
    },
    handleMousedown(e) {
      this.down = true;
      this.disX = e.clientX - this.$refs.resize.offsetLeft;
      this.disY = e.clientY - this.$refs.resize.offsetTop;
      document.addEventListener("mousemove", this.onResize);
      document.onmouseup = () => {
        this.down = false;
        document.removeEventListener("mousemove", this.onResize);
      };
    },
    onResize(e) {
      // 获取鼠标的实时位置
      const curX = e.clientX;
      const curY = e.clientY;
      // 获取拖拽的长度
      const increaseX = curX - this.disX;
      const increaseY = curY - this.disY;
      // 按下开始拖拽改变目标元素大小
      if (this.down) {
        const width = this.$refs.resize.offsetWidth + increaseX;
        const height = this.$refs.resize.offsetHeight + increaseY;
        width < 200 ? this.$refs.container.style.width = "200px" : this.$refs.container.style.width = width + "px";
        height < 452 ? this.$refs.container.style.height = "452px" : this.$refs.container.style.height = height + "px";
        this.$emit("resize", [curX, curY]);
      }
    },
    handleImgError() {
      this.isImgError = true;
    },
    handleImgLoad() {
      this.isImgLoad = true;
    },
    close() {
      this.$emit("close");
    },
    chooseEmoji(item) {
      this.message += item;
    },
    handleSendImageClick() {
      this.$refs.imagePicker.click();
    },
    handleSendFileClick() {
      this.$refs.filePicker.click();
    },
    sendFile() {
      const message = _tim__WEBPACK_IMPORTED_MODULE_4__["default"].createFileMessage({
        to: this.toAccount,
        conversationType: this.currentConversationType,
        payload: {
          file: document.getElementById("filePicker") // 或者用event.target
        },
        onProgress: percent => {
          this.$set(message, "progress", percent); // 手动给message 实例加个响应式属性: progress
        }
      });
      this.$store.commit("pushCurrentMessageList", message);
      _tim__WEBPACK_IMPORTED_MODULE_4__["default"].sendMessage(message).then(() => {
        this.$refs.filePicker.value = null;
      }).catch(imError => {
        this.$store.commit("showMessage", {
          message: imError.message,
          type: "error"
        });
      });
    },
    sendImage() {
      const message = _tim__WEBPACK_IMPORTED_MODULE_4__["default"].createImageMessage({
        to: this.toAccount,
        conversationType: this.currentConversationType,
        payload: {
          file: document.getElementById("imagePicker") // 或者用event.target
        },
        onProgress: percent => {
          this.$set(message, "progress", percent); // 手动给message 实例加个响应式属性: progress
        }
      });
      this.$store.commit("pushCurrentMessageList", message);
      _tim__WEBPACK_IMPORTED_MODULE_4__["default"].sendMessage(message).then(() => {
        // this.$refs.imagePicker.value = null;
        document.getElementById("imagePicker").value = null;
        this.scrollMessageListToButtom();
      }).catch(imError => {
        this.$store.commit("showMessage", {
          message: imError.message,
          type: "error"
        });
      });
    },
    send() {
      if (this.message === "" || this.message.trim().length === 0) {
        this.message = "";
        this.$store.commit("showMessage", {
          message: "不能发送空消息哦！",
          type: "info"
        });
        return;
      }
      let message = _tim__WEBPACK_IMPORTED_MODULE_4__["default"].createTextMessage({
        to: this.toAccount,
        conversationType: this.currentConversationType,
        // 消息优先级，用于群聊（v2.4.2起支持）。如果某个群的消息超过了频率限制，后台会优先下发高优先级的消息，详细请参考：https://cloud.tencent.com/document/product/269/3663#.E6.B6.88.E6.81.AF.E4.BC.98.E5.85.88.E7.BA.A7.E4.B8.8E.E9.A2.91.E7.8E.87.E6.8E.A7.E5.88.B6)
        // 支持的枚举值：TIM.TYPES.MSG_PRIORITY_HIGH, TIM.TYPES.MSG_PRIORITY_NORMAL（默认）, TIM.TYPES.MSG_PRIORITY_LOW, TIM.TYPES.MSG_PRIORITY_LOWEST
        // priority: TIM.TYPES.MSG_PRIORITY_NORMAL,
        payload: {
          text: this.message
        },
        // v2.20.0起支持C2C消息已读回执功能，如果您发消息需要已读回执，需购买旗舰版套餐，并且创建消息时将 needReadReceipt 设置为 true
        needReadReceipt: true
        // 消息自定义数据（云端保存，会发送到对端，程序卸载重装后还能拉取到，v2.10.2起支持）
        // cloudCustomData: 'your cloud custom data'
      });
      console.log(message);
      // 2. 发送消息
      let promise = _tim__WEBPACK_IMPORTED_MODULE_4__["default"].sendMessage(message);
      promise.then(imResponse => {
        // 发送成功
        console.log(imResponse);
        this.$store.commit("pushCurrentMessageList", message);
        this.scrollMessageListToBottom();
        this.message = "";
        this.$emit("update:defaultMessage", "");
        this.$bus.$emit("scroll-bottom");
      }).catch(imError => {
        // 发送失败
        console.warn("sendMessage error:", imError);
        this.$store.commit("showMessage", {
          type: "error",
          message: imError.message
        });
      });
    },
    // 直接滚到底部
    scrollMessageListToBottom() {
      this.$nextTick(() => {
        let messageListNode = this.$refs["message-list"];
        if (!messageListNode) {
          return;
        }
        messageListNode.scrollTop = messageListNode.scrollHeight;
        // this.preScrollHeight = messageListNode.scrollHeight;
        // this.isShowScrollButtomTips = false;
      });
    },
    switchType(type) {
      console.log(this.currentConversation);
      this.active = type;
    },
    onImageLoaded() {
      this.keepMessageListOnButtom();
    },
    // 如果滚到底部就保持在底部，否则提示是否要滚到底部
    keepMessageListOnButtom() {
      let messageListNode = this.$refs["message-list"];
      if (!messageListNode) {
        return;
      }
      // 距离底部20px内强制滚到底部,否则提示有新消息
      if (this.preScrollHeight - messageListNode.clientHeight - messageListNode.scrollTop < 20) {
        this.$nextTick(() => {
          messageListNode.scrollTop = messageListNode.scrollHeight;
        });
        this.isShowScrollButtomTips = false;
      } else {
        this.isShowScrollButtomTips = true;
      }
      this.preScrollHeight = messageListNode.scrollHeight;
    },
    // 直接滚到底部
    scrollMessageListToButtom() {
      this.$nextTick(() => {
        let messageListNode = this.$refs["message-list"];
        if (!messageListNode) {
          return;
        }
        messageListNode.scrollTop = messageListNode.scrollHeight;
        this.preScrollHeight = messageListNode.scrollHeight;
        this.isShowScrollButtomTips = false;
      });
    },
    onGroupShow() {
      console.log(this.currentMemberList);
      const currentMemberList = this.currentMemberList.map(async member => {
        if (member.avatar === "undefined") {
          const employeeDetail = await Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployeeDetail"])(member.userID, this.deskTypes[0]);
          console.log(employeeDetail);
        }
        return member;
      });
      console.log(currentMemberList);
    }
  },
  mounted() {
    console.log(this.toAccount);
    console.log("currentConversation", this.currentConversation);
    console.log("currentUserProfile", this.currentUserProfile);
    this.$bus.$on("image-loaded", this.onImageLoaded);
    this.$bus.$on("scroll-bottom", this.scrollMessageListToButtom);
    if (this.defaultMessage) {
      this.message = this.defaultMessage;
      this.send();
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/group/group-item.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/group/group-item.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _tim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/tim */ "./src/tim.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  props: ["group"],
  data() {
    return {
      visible: false,
      options: [{
        text: "退出群组",
        handler: this.quitGroup
      }],
      isImgError: false,
      closeVisible: false
    };
  },
  methods: {
    handleImgError() {
      this.isImgError = true;
    },
    handleGroupClick() {
      const conversationID = `GROUP${this.group.groupID}`;
      this.$store.dispatch("checkoutConversation", conversationID);
    },
    quitGroup() {
      this.tim.quitGroup(this.group.groupID).catch(error => {
        this.$store.commit("showMessage", {
          type: "error",
          message: error.message
        });
      });
    },
    disGroup() {
      console.log(this.group.groupID);
      let promise = _tim__WEBPACK_IMPORTED_MODULE_0__["default"].dismissGroup(this.group.groupID);
      promise.then(function (imResponse) {
        // 解散成功
        console.log(imResponse.data.groupID); // 被解散的群组 ID
      }).catch(function (imError) {
        console.warn("dismissGroup error:", imError); // 解散群组失败的相关信息
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/message/file-element.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/message/file-element.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.url-search-params.delete.js */ "./node_modules/core-js/modules/web.url-search-params.delete.js");
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.url-search-params.has.js */ "./node_modules/core-js/modules/web.url-search-params.has.js");
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.url-search-params.size.js */ "./node_modules/core-js/modules/web.url-search-params.size.js");
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/components/timApp/message/message-bubble.vue */ "./src/components/timApp/message/message-bubble.vue");
/* harmony import */ var element_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! element-ui */ "./node_modules/element-ui/lib/element-ui.common.js");
/* harmony import */ var element_ui__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(element_ui__WEBPACK_IMPORTED_MODULE_4__);





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "FileElement",
  props: {
    payload: {
      type: Object,
      required: true
    },
    message: {
      type: Object,
      required: true
    },
    isMine: {
      type: Boolean
    }
  },
  components: {
    messageBubble: _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
    ElProgress: element_ui__WEBPACK_IMPORTED_MODULE_4__["Progress"]
  },
  computed: {
    fileName() {
      return this.payload.fileName;
    },
    fileUrl() {
      return this.payload.fileUrl;
    },
    size() {
      const size = this.payload.fileSize;
      if (size > 1024) {
        if (size / 1024 > 1024) {
          return `${this.toFixed(size / 1024 / 1024)} Mb`;
        }
        return `${this.toFixed(size / 1024)} Kb`;
      }
      return `${this.toFixed(size)}B`;
    },
    showProgressBar() {
      return this.$parent.message.status === "unSend";
    },
    percentage() {
      return Math.floor((this.$parent.message.progress || 0) * 100);
    }
  },
  methods: {
    toFixed(number, precision = 2) {
      return number.toFixed(precision);
    },
    downloadFile() {
      // 浏览器支持fetch则用blob下载，避免浏览器点击a标签，跳转到新页面预览的行为
      if (window.fetch) {
        fetch(this.fileUrl).then(res => res.blob()).then(blob => {
          let a = document.createElement("a");
          let url = window.URL.createObjectURL(blob);
          a.href = url;
          a.download = this.fileName;
          a.click();
        });
      } else {
        let a = document.createElement("a");
        a.href = this.fileUrl;
        a.target = "_blank";
        a.download = this.filename;
        a.click();
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/message/image-element.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/message/image-element.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/timApp/message/message-bubble.vue */ "./src/components/timApp/message/message-bubble.vue");
/* harmony import */ var element_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! element-ui */ "./node_modules/element-ui/lib/element-ui.common.js");
/* harmony import */ var element_ui__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(element_ui__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ImageElement",
  props: {
    payload: {
      type: Object,
      required: true
    },
    message: {
      type: Object,
      required: true
    },
    isMine: {
      type: Boolean
    }
  },
  components: {
    messageBubble: _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
    ElProgress: element_ui__WEBPACK_IMPORTED_MODULE_1__["Progress"]
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_2__["mapGetters"])(["imgUrlList"]),
    imageUrl() {
      const url = this.payload.imageInfoArray[0].url;
      if (typeof url !== "string") {
        return "";
      }
      return url.slice(0, 2) === "//" ? `https:${url}` : url;
    },
    showProgressBar() {
      return this.$parent.message.status === "unSend";
    },
    percentage() {
      return Math.floor((this.$parent.message.progress || 0) * 100);
    }
  },
  methods: {
    onImageLoaded(event) {
      this.$bus.$emit("image-loaded", event);
    },
    handlePreview() {
      this.$bus.$emit("image-preview", {
        url: this.payload.imageInfoArray[0].url
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/message/image-previewer.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/message/image-previewer.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ImagePreviewer",
  data() {
    return {
      url: "",
      index: 0,
      visible: false,
      zoom: 1,
      rotate: 0,
      minZoom: 0.1,
      urlFlag: false
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_0__["mapGetters"])(["imgUrlList"]),
    showPreviewer() {
      return this.url.length > 0 && this.visible;
    },
    imageStyle() {
      return {
        transform: `scale(${this.zoom});`
      };
    },
    previewUrl() {
      if (this.urlFlag) {
        return this.url;
      } else {
        return this.formatUrl(this.imgUrlList[this.index]);
      }
      // this.urlFlag ? return this.url :
    }
  },
  mounted() {
    this.$bus.$on("image-preview", this.handlePreview);
  },
  methods: {
    handlePreview({
      url,
      flag = undefined
    }) {
      this.url = url;
      this.urlFlag = flag ? "merger" : false;
      this.index = this.imgUrlList.findIndex(item => item === url);
      this.visible = true;
    },
    handleMouseWheel(event) {
      if (event.wheelDelta > 0) {
        this.zoomIn();
      } else {
        this.zoomOut();
      }
    },
    zoomIn() {
      this.zoom += 0.1;
    },
    zoomOut() {
      this.zoom = this.zoom - 0.1 > this.minZoom ? this.zoom - 0.1 : this.minZoom;
    },
    close() {
      Object.assign(this, {
        zoom: 1
      });
      this.visible = false;
    },
    rotateLeft() {
      this.rotate -= 90;
    },
    rotateRight() {
      this.rotate += 90;
    },
    goNext() {
      this.index = (this.index + 1) % this.imgUrlList.length;
    },
    goPrev() {
      this.index = this.index - 1 >= 0 ? this.index - 1 : this.imgUrlList.length - 1;
    },
    formatUrl(url) {
      if (!url) {
        return "";
      }
      return url.slice(0, 2) === "//" ? `https:${url}` : url;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/message/message-bubble.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/message/message-bubble.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "MessageBubble",
  components: {},
  data() {
    return {
      isTimeout: false,
      showConversationList: false,
      relayMessage: {},
      selectedConversation: [],
      testMergerMessage: {}
    };
  },
  props: {
    isMine: {
      type: Boolean
    },
    isNew: {
      type: Boolean
    },
    message: {
      type: Object,
      required: true
    }
  },
  created() {
    this.isTimeoutHandler();
  },
  mounted() {
    if (this.$refs.dropdown && this.$refs.dropdown.$el) {
      this.$refs.dropdown.$el.addEventListener("mousedown", this.handleDropDownMousedown);
    }
  },
  beforeDestroy() {
    if (this.$refs.dropdown && this.$refs.dropdown.$el) {
      this.$refs.dropdown.$el.removeEventListener("mousedown", this.handleDropDownMousedown);
    }
  },
  updated() {},
  computed: {
    bubbleStyle() {
      let classString = "";
      if (this.isMine) {
        classString += "message-send";
      } else {
        classString += "message-received";
      }
      if (this.isNew) {
        classString += "new";
      }
      return classString;
    },
    text() {
      if (this.message.conversationType === this.TIM.TYPES.CONV_C2C && !this.isMine) {
        return "对方撤回了一条消息";
      }
      if (this.message.conversationType === this.TIM.TYPES.CONV_GROUP && !this.isMine) {
        return `${this.message.from}撤回了一条消息`;
      }
      return "你撤回了一条消息";
    },
    messageReadByPeer() {
      if (this.message.status !== "success") {
        return false;
      }
      if (this.message.conversationType === this.TIM.TYPES.CONV_C2C && this.message.isPeerRead) {
        return "已读";
      }
      if (this.message.conversationType === this.TIM.TYPES.CONV_C2C && !this.message.isPeerRead) {
        return "未读";
      }
      return "";
    },
    isEdit() {
      if (!this.isMine) {
        return false;
      }
      if (this.message.type !== this.TIM.TYPES.MSG_TEXT) {
        return false;
      }
      if (this.isTimeout) {
        return false;
      }
      return true;
    }
  },
  methods: {
    handleDropDownMousedown(e) {
      if (e.buttons === 2) {
        if (this.$refs.dropdown.visible) {
          this.$refs.dropdown.hide();
        } else {
          this.$refs.dropdown.show();
        }
      }
    },
    handleCommand(command) {
      switch (command) {
        case "revoke":
          this.tim.revokeMessage(this.message).then(() => {
            this.isTimeoutHandler();
          }).catch(err => {
            this.$store.commit("showMessage", {
              message: err,
              type: "warning"
            });
          });
          break;
        case "relay":
          this.showConversationList = true;
          this.$store.commit("setRelayType", 1);
          this.$store.commit("showConversationList", true);
          this.$store.commit("setRelayMessage", this.message);
          break;
        case "merger":
          this.$bus.$emit("mergerSelected", true);
          break;
        default:
          break;
      }
    },
    isTimeoutHandler() {
      // 从发送消息时间开始算起，两分钟内可以编辑
      let now = new Date();
      if (parseInt(now.getTime() / 1000) - this.message.time > 2 * 60) {
        this.isTimeout = true;
        return;
      }
      setTimeout(this.isTimeoutHandler, 1000);
    },
    reEdit() {
      this.$bus.$emit("reEditMessage", this.message.payload.text);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/message/message-item.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/message/message-item.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _components_timApp_message_text_element_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/components/timApp/message/text-element.vue */ "./src/components/timApp/message/text-element.vue");
/* harmony import */ var _components_timApp_message_sound_element_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/components/timApp/message/sound-element.vue */ "./src/components/timApp/message/sound-element.vue");
/* harmony import */ var _components_timApp_message_file_element_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/components/timApp/message/file-element.vue */ "./src/components/timApp/message/file-element.vue");
/* harmony import */ var _components_timApp_message_image_element_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/components/timApp/message/image-element.vue */ "./src/components/timApp/message/image-element.vue");
/* harmony import */ var _components_timApp_message_video_element_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/components/timApp/message/video-element.vue */ "./src/components/timApp/message/video-element.vue");






/* harmony default export */ __webpack_exports__["default"] = ({
  name: "MessageItem",
  components: {
    textElement: _components_timApp_message_text_element_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
    soundElement: _components_timApp_message_sound_element_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
    fileElement: _components_timApp_message_file_element_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
    imageElement: _components_timApp_message_image_element_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
    videoElement: _components_timApp_message_video_element_vue__WEBPACK_IMPORTED_MODULE_5__["default"]
  },
  props: {
    message: {
      type: Object,
      required: true
    }
  },
  data() {
    return {
      renderDom: [],
      isImgError: false
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_0__["mapState"])({
      currentConversation: state => state.conversation.currentConversation,
      currentUserProfile: state => state.user.currentUserProfile
    }),
    avatar() {
      if (this.currentConversation.type === "C2C") {
        return this.message.avatar;
      } else if (this.currentConversation.type === "GROUP") {
        console.log("currentConversation", this.currentUserProfile);
        return this.isMine ? this.currentUserProfile.avatar : this.message.avatar;
      } else {
        return "";
      }
    },
    nick() {
      console.log("message-item", this.message);
      return this.message.nick;
    },
    nickname() {
      var _this$currentConversa;
      return (_this$currentConversa = this.currentConversation) === null || _this$currentConversa === void 0 || (_this$currentConversa = _this$currentConversa.info) === null || _this$currentConversa === void 0 ? void 0 : _this$currentConversa.name;
    },
    currentConversationType() {
      return this.currentConversation.type;
    },
    isMine() {
      // console.log(this.currentUserProfile, this.currentConversation);
      return this.message.flow === "out";
    },
    messagePosition() {
      if (["TIMGroupTipElem", "TIMGroupSystemNoticeElem"].includes(this.message.type)) {
        return "position-center";
      }
      if (this.message.isRevoked) {
        // 撤回消息
        return "position-center";
      }
      if (this.isMine) {
        return "position-right";
      } else {
        return "position-left";
      }
    }
  },
  methods: {
    handleImgError() {
      this.isImgError = true;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/message/sound-element.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/message/sound-element.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/timApp/message/message-bubble.vue */ "./src/components/timApp/message/message-bubble.vue");
/* harmony import */ var flv_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! flv.js */ "./node_modules/flv.js/dist/flv.js");
/* harmony import */ var flv_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(flv_js__WEBPACK_IMPORTED_MODULE_1__);


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "SoundElement",
  props: {
    payload: {
      type: Object,
      required: true
    },
    message: {
      type: Object,
      required: true
    },
    isMine: {
      type: Boolean
    }
  },
  components: {
    messageBubble: _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  data() {
    return {
      amr: null,
      autoplay: false
    };
  },
  computed: {
    audioEl() {
      return `audio-${this.message.id}`;
    },
    url() {
      return this.payload.url;
    },
    size() {
      return this.payload.size;
    },
    second() {
      return this.payload.second;
    }
  },
  methods: {
    async play() {
      // 目前移动端的语音消息采用 aac 格式，以前用 amr 格式。默认先用 audio 标签播放，若无法播放则尝试 amr 格式播放。
      // const audio = document.createElement('audio')
      // audio.crossOrigin = "anonymous"
      // audio.addEventListener('error', this.tryPlayAMR) // 播放出错，则尝试使用 AMR 播放
      // audio.src = this.url
      // console.log(this.url)
      // // debugger
      // const promise = audio.play()
      // if (promise) {
      //   promise.catch(() => {})
      // }
      if (flv_js__WEBPACK_IMPORTED_MODULE_1___default.a.isSupported()) {
        const videoElement = this.$refs[this.audioEl];
        const flvPlayer = flv_js__WEBPACK_IMPORTED_MODULE_1___default.a.createPlayer({
          type: "aac",
          url: this.url,
          hasAudio: true,
          hasVideo: false,
          cors: true
        });
        flvPlayer.attachMediaElement(videoElement);
        flvPlayer.load();
        // flvPlayer.play();
        setTimeout(function () {
          flvPlayer.play(); // 播放数据流
        }, 0);
      }
      // this.$refs[this.audioEl].play()
      // const arrayBuffer = await fetchAudioFile(this.url);
      // console.log(arrayBuffer)
      // window.AudioContext = window.AudioContext || window.webkitAudioContext;
      // const context = new window.AudioContext();
      // const sourceBuffer = context.createBufferSource(); // creates a sound source
      //
      // fetch('test.amr')
      //   .then(res => res.arrayBuffer())
      //   .then(buffer => {
      //     console.log(buffer)
      //     context.decodeAudioData(buffer,audioBuffer => {
      //       sourceBuffer.buffer = audioBuffer
      //       sourceBuffer.connect(context.destination)
      //       sourceBuffer.start(0)
      //     },err=>{
      //       console.log(err)
      //     })
      //   })
    },
    tryPlayAMR() {
      try {
        const isIE = /MSIE|Trident|Edge/.test(window.navigator.userAgent);
        // amr 播放组件库在 IE 不支持
        if (isIE) {
          this.$store.commit("showMessage", {
            message: "您的浏览器不支持该格式的语音消息播放，请尝试更换浏览器，建议使用：谷歌浏览器",
            type: "warning"
          });
          return;
        }
        // 动态插入 amr 播放组件库
        if (!window.BenzAMRRecorder) {
          const script = document.createElement("script");
          script.addEventListener("load", this.playAMR);
          script.src = "BenzAMRRecorder.js";
          const firstScript = document.getElementsByTagName("script")[0];
          firstScript.parentNode.insertBefore(script, firstScript);
          return;
        }
        this.playAMR();
      } catch (error) {
        this.$store.commit("showMessage", {
          message: "您的浏览器不支持该格式的语音消息播放，请尝试更换浏览器，建议使用：谷歌浏览器",
          type: "warning"
        });
      }
    },
    playAMR() {
      if (!this.amr && window.BenzAMRRecorder) {
        this.amr = new window.BenzAMRRecorder();
      }
      if (this.amr.isInit()) {
        this.amr.play();
        return;
      }
      this.amr.initWithUrl(this.url).then(() => {
        this.amr.play();
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/message/text-element.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/message/text-element.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/timApp/message/message-bubble.vue */ "./src/components/timApp/message/message-bubble.vue");
/* harmony import */ var _utils_decodeText__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/utils/decodeText */ "./src/utils/decodeText.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "TextElement",
  components: {
    messageBubble: _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  props: {
    payload: {
      type: Object,
      required: true
    },
    message: {
      type: Object,
      required: true
    },
    isMine: {
      type: Boolean
    }
  },
  computed: {
    contentList() {
      return Object(_utils_decodeText__WEBPACK_IMPORTED_MODULE_1__["decodeText"])(this.payload);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/timApp/message/video-element.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/timApp/message/video-element.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/timApp/message/message-bubble.vue */ "./src/components/timApp/message/message-bubble.vue");
/* harmony import */ var element_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! element-ui */ "./node_modules/element-ui/lib/element-ui.common.js");
/* harmony import */ var element_ui__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(element_ui__WEBPACK_IMPORTED_MODULE_1__);


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "VideoElement",
  components: {
    messageBubble: _components_timApp_message_message_bubble_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
    ElProgress: element_ui__WEBPACK_IMPORTED_MODULE_1__["Progress"]
  },
  props: {
    payload: {
      type: Object,
      required: true
    },
    message: {
      type: Object,
      required: true
    },
    isMine: {
      type: Boolean
    }
  },
  computed: {
    showProgressBar() {
      return this.message.status === "unSend";
    },
    percentage() {
      return Math.floor((this.$parent.message.progress || 0) * 100);
    }
  },
  methods: {
    videoError(e) {
      this.$store.commit("showMessage", {
        type: "error",
        message: "视频出错，错误原因：" + e.target.error.message
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/visualConfig/index.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/visualConfig/index.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
/* harmony import */ var core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _api_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/api/common */ "./src/api/common.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "VisualConfig",
  data() {
    return {
      visible: false,
      imageUrl: "",
      file: null,
      fileList: [],
      logo: "",
      title: ""
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_1__["mapState"])({
      visualVisible: state => state.visualVisible
    }),
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_1__["mapGetters"])(["settings"]),
    dynamicImage() {
      var url = this.imageUrl;
      if (!this.imageUrl || this.imageUrl.indexOf("obpmnull") > 0) {
        url = 'static/img/警徽.d5689083.png';
      }
      console.log("当前的图标数据", this.imageUrl, url);
      return url;
    }
  },
  watch: {
    visualVisible(value) {
      this.visible = value;
    }
  },
  methods: {
    closeDialog() {
      this.$store.commit("SET_VISUAL_VISIBLE", false);
    },
    saveConfig() {
      if (this.logo && this.title) {
        Object(_api_common__WEBPACK_IMPORTED_MODULE_2__["visualSave"])({
          logo: this.logo,
          title: this.title
        }).then(() => {
          this.$message.success("保存成功");
          this.$store.commit("SET_APP_SETTING", {
            logo: this.logo,
            title: this.title
          });
        }).catch(err => {
          this.$message.error("保存失败");
          throw new Error(err);
        }).finally(() => {
          this.closeDialog();
        });
      } else {
        this.$message.error("请选择图片和输入标题");
      }
    },
    onClose() {
      this.closeDialog();
    },
    onOpened() {
      console.log("on opened===" + "staging");
      const {
        logo,
        title
      } = this.settings;
      const url = "https://v5qy.te.baibaodun.com.cn";
      this.imageUrl = logo;
      this.logo = logo.split(`${url}/obpm`)[1];
      this.title = title;
    },
    reUpload() {
      if (this.imageUrl) {
        this.$refs.upload.clearFiles();
        this.$refs.upload.$children[0].handleClick();
      }
    },
    openCropper() {
      this.$emit("openCropper", this.imageUrl);
    },
    onUploadChange(file, fileList) {
      console.log("on change", file, fileList);
    },
    handleUploadSuccess(response, file, fileList) {
      console.log("on success", response, file, fileList);
    },
    beforeUpload(file) {
      this.file = file;
      // let isSize = getImgInfo(file, 88, 92);
      // isSize.catch(() => {
      //   this.$message({
      //     message: "注意:88*92！",
      //     type: "warning",
      //   });
      // });
      // return isSize;
      return true;
    },
    uploadAvatar({
      file
    }) {
      //必须
      const formData = new FormData();
      if (file) {
        formData.append("file", file);
      } else {
        formData.append("file", this.file);
      }
      // console.log(formData);
      Object(_api_common__WEBPACK_IMPORTED_MODULE_2__["uploadFileApi"])(formData).then(response => {
        const {
          data
        } = response;
        if (data.status === 200) {
          this.logo = data.data;
          const url = "https://v5qy.te.baibaodun.com.cn";
          this.imageUrl = url + "/obpm" + data.data;
          // this.frontPhoto = response.data; /uploads/2023/07-12/0f02f06f-b6ec-4ee3-9d11-4dc5064eb1b7/警徽-2.png
        }
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/common/ElectronWindowsControlButtonView.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/common/ElectronWindowsControlButtonView.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/store.js */ "./src/store.js");



// import {app} from "../../platform";

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ElectronWindowsControlButtonView",
  props: {
    maximizable: {
      type: Boolean,
      required: false,
      default: true
    },
    macos: {
      type: Boolean,
      required: false,
      default: false
    },
    title: {
      type: String,
      required: false,
      default: ""
    }
  },
  data() {
    return {
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].state.misc
    };
  },
  mounted() {
    if (!this.maximizable) {
      this.$refs.content.style.setProperty("--control-count", "2");
      this.$refs.content.style.setProperty("--close-button-column", "2");
    }
  },
  methods: {
    minimize() {
      const win = _platform__WEBPACK_IMPORTED_MODULE_0__["remote"].getCurrentWindow();
      win.minimize();
    },
    maximize() {
      const win = _platform__WEBPACK_IMPORTED_MODULE_0__["remote"].getCurrentWindow();
      if (win.isMaximized()) {
        win.unmaximize();
      } else {
        win.maximize();
      }
      this.$nextTick(() => {
        this.toggleMaxRestoreButtons();
      });
    },
    close() {
      if (process.platform === "linux") {
        this.$alert({
          content: "确定退出野火 IM？",
          cancelCallback: () => {
            // do nothing
          },
          confirmCallback: () => {
            _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].disconnect();
            setTimeout(() => {
              // app.exit(0)
            }, 1000);
          }
        });
      } else {
        const win = _platform__WEBPACK_IMPORTED_MODULE_0__["remote"].getCurrentWindow();
        win.close();
        if (!_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].isLogin() && this.sharedMiscState.isMainWindow) {
          // app.exit(0)
        }
      }
    },
    toggleMaxRestoreButtons() {
      const win = _platform__WEBPACK_IMPORTED_MODULE_0__["remote"].getCurrentWindow();
      if (win.isMaximized()) {
        document.body.classList.add("maximized");
      } else {
        document.body.classList.remove("maximized");
      }
    }
  }
});
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! process/browser */ "./node_modules/process/browser.js")))

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/common/ListView.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/common/ListView.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ListView",
  props: {
    list: {
      type: Array,
      required: true
    }
  },
  methods: {
    onItemClick(index, data) {
      this.$modal.hide("list-item-modal", {
        position: index,
        data: data
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/common/LoadingView.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/common/LoadingView.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "LoadingView"
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/CompositeMessagePage.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/CompositeMessagePage.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _conversation_message_content_TextMessageContentView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conversation/message/content/TextMessageContentView */ "./src/ui/main/conversation/message/content/TextMessageContentView.vue");
/* harmony import */ var _conversation_message_content_UnsupportMessageContentView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./conversation/message/content/UnsupportMessageContentView */ "./src/ui/main/conversation/message/content/UnsupportMessageContentView.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _conversation_message_content_CompositeMessageContentView__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./conversation/message/content/CompositeMessageContentView */ "./src/ui/main/conversation/message/content/CompositeMessageContentView.vue");
/* harmony import */ var _conversation_message_content_ImageMessageContentView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./conversation/message/content/ImageMessageContentView */ "./src/ui/main/conversation/message/content/ImageMessageContentView.vue");
/* harmony import */ var _conversation_message_content_VideoMessageContentView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./conversation/message/content/VideoMessageContentView */ "./src/ui/main/conversation/message/content/VideoMessageContentView.vue");
/* harmony import */ var _conversation_message_content_FileMessageContentView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./conversation/message/content/FileMessageContentView */ "./src/ui/main/conversation/message/content/FileMessageContentView.vue");
/* harmony import */ var _conversation_message_content_StickerMessageContentView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./conversation/message/content/StickerMessageContentView */ "./src/ui/main/conversation/message/content/StickerMessageContentView.vue");
/* harmony import */ var _conversation_message_content_UnknownMessageContentView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./conversation/message/content/UnknownMessageContentView */ "./src/ui/main/conversation/message/content/UnknownMessageContentView.vue");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../wfc/util/longUtil */ "./src/wfc/util/longUtil.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_model_favItem__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../wfc/model/favItem */ "./src/wfc/model/favItem.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../platform */ "./src/platform.js");
















/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CompositeMessagePage",
  props: {
    message: {
      required: false,
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_9__["default"],
      default: null
    }
  },
  data() {
    return {
      compositeMessage: null,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].state.misc
    };
  },
  mounted() {
    if (this.message) {
      this.compositeMessage = this.message;
      this.loadMediaCompositeMessage(this.compositeMessage);
      return;
    }
    let hash = window.location.hash;
    if (hash.indexOf("messageUid=") >= 0) {
      let messageUid = hash.substring(hash.indexOf("=") + 1);
      this.compositeMessage = _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].getMessageByUid(messageUid);
    } else {
      let faveItemData = hash.substring(hash.indexOf("=") + 1);
      let favItemRaw = JSON.parse(_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_11__["default"].b64_to_utf8(_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_11__["default"].unescape(faveItemData)));
      let favItem = Object.assign(new _wfc_model_favItem__WEBPACK_IMPORTED_MODULE_12__["default"](), favItemRaw);
      favItem.conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_13__["default"](favItem.convType, favItem.convTarget, favItem.convLine);
      favItem.favType = favItem.type;
      this.compositeMessage = favItem.toMessage();
    }
    _store_js__WEBPACK_IMPORTED_MODULE_2__["default"]._patchMessage(this.compositeMessage, 0);
    document.title = this.compositeMessage.messageContent.title;
    this.loadMediaCompositeMessage(this.compositeMessage);
  },
  methods: {
    hideCompositeMessagePage() {
      this.$modal.hide("show-composite-message-modal" + "-" + Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_10__["stringValue"])(this.message.messageUid));
    },
    loadMediaCompositeMessage(msg) {
      let content = msg.messageContent;
      if (content.remotePath) {
        if (Object(_platform__WEBPACK_IMPORTED_MODULE_15__["isElectron"])()) {
          if (content.localPath && __webpack_require__(/*! fs */ "./node_modules/node-libs-browser/mock/empty.js").existsSync(content.localPath)) {
            return;
          }
        } else {
          // web 每次加载
          // do nothing
        }
        axios__WEBPACK_IMPORTED_MODULE_14__["default"].get(content.remotePath, {
          responseType: "arraybuffer"
        }).then(value => {
          content._decodeMessages(new TextDecoder("utf-8").decode(value.data));
          _store_js__WEBPACK_IMPORTED_MODULE_2__["default"]._patchMessage(this.compositeMessage, 0);
          content.loaded = true;
        });
      }
    },
    previewCompositeMessage(focusMessageUid) {
      _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].previewCompositeMessage(this.compositeMessage, focusMessageUid);
    }
  },
  components: {
    UnknowntMessageContentView: _conversation_message_content_UnknownMessageContentView__WEBPACK_IMPORTED_MODULE_8__["default"],
    // ConferenceInviteMessageContentView,
    CompositeMessageContentView: _conversation_message_content_CompositeMessageContentView__WEBPACK_IMPORTED_MODULE_3__["default"],
    // AudioMessageContentView,
    // CallStartMessageContentView,
    UnsupportMessageContentView: _conversation_message_content_UnsupportMessageContentView__WEBPACK_IMPORTED_MODULE_1__["default"],
    TextMessageContentView: _conversation_message_content_TextMessageContentView__WEBPACK_IMPORTED_MODULE_0__["default"],
    ImageMessageContentView: _conversation_message_content_ImageMessageContentView__WEBPACK_IMPORTED_MODULE_4__["default"],
    VideoMessageContentView: _conversation_message_content_VideoMessageContentView__WEBPACK_IMPORTED_MODULE_5__["default"],
    FileMessageContentView: _conversation_message_content_FileMessageContentView__WEBPACK_IMPORTED_MODULE_6__["default"],
    StickerMessageContentView: _conversation_message_content_StickerMessageContentView__WEBPACK_IMPORTED_MODULE_7__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/ContactListPanel.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/ContactListPanel.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _search_SearchView_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./search/SearchView.vue */ "./src/ui/main/search/SearchView.vue");
/* harmony import */ var _contact_ContactListView_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./contact/ContactListView.vue */ "./src/ui/main/contact/ContactListView.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _search_SearchResultView_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./search/SearchResultView.vue */ "./src/ui/main/search/SearchResultView.vue");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ContactListPanel",
  data() {
    return {
      sharedSearchState: _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].state.search
    };
  },
  methods: {},
  components: {
    SearchResultView: _search_SearchResultView_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
    ContactListView: _contact_ContactListView_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
    SearchView: _search_SearchView_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/ContactPage.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/ContactPage.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ContactListPanel_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ContactListPanel.vue */ "./src/ui/main/ContactListPanel.vue");
/* harmony import */ var _contact_GroupDetailView_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./contact/GroupDetailView.vue */ "./src/ui/main/contact/GroupDetailView.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _contact_UserDetailView_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./contact/UserDetailView.vue */ "./src/ui/main/contact/UserDetailView.vue");
/* harmony import */ var _contact_FrienRequestDetailView_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./contact/FrienRequestDetailView.vue */ "./src/ui/main/contact/FrienRequestDetailView.vue");
/* harmony import */ var _contact_ChannelListView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./contact/ChannelListView */ "./src/ui/main/contact/ChannelListView.vue");
/* harmony import */ var _contact_ChannelDetailView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./contact/ChannelDetailView */ "./src/ui/main/contact/ChannelDetailView.vue");
/* harmony import */ var _contact_OrganizationTreeView_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./contact/OrganizationTreeView.vue */ "./src/ui/main/contact/OrganizationTreeView.vue");








/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ContactPage",
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].state.contact
    };
  },
  components: {
    ChannelDetailView: _contact_ChannelDetailView__WEBPACK_IMPORTED_MODULE_6__["default"],
    ChannelListView: _contact_ChannelListView__WEBPACK_IMPORTED_MODULE_5__["default"],
    FriendRequestDetailView: _contact_FrienRequestDetailView_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
    UserDetailView: _contact_UserDetailView_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
    GroupDetailView: _contact_GroupDetailView_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
    ContactListPanel: _ContactListPanel_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
    OrganizationDetailView: _contact_OrganizationTreeView_vue__WEBPACK_IMPORTED_MODULE_7__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/ConversationListPanel.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/ConversationListPanel.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _conversationList_ConversationListView_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conversationList/ConversationListView.vue */ "./src/ui/main/conversationList/ConversationListView.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _search_SearchResultView_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./search/SearchResultView.vue */ "./src/ui/main/search/SearchResultView.vue");
/* harmony import */ var _search_SearchView_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./search/SearchView.vue */ "./src/ui/main/search/SearchView.vue");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConversationListPanel",
  data() {
    return {
      sharedSearchState: _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.search
    };
  },
  methods: {},
  components: {
    SearchResultView: _search_SearchResultView_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
    ConversationListView: _conversationList_ConversationListView_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
    SearchView: _search_SearchView_vue__WEBPACK_IMPORTED_MODULE_3__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/ConversationPage.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/ConversationPage.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _conversation_ConversationView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conversation/ConversationView */ "./src/ui/main/conversation/ConversationView.vue");
/* harmony import */ var _ConversationListPanel_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ConversationListPanel.vue */ "./src/ui/main/ConversationListPanel.vue");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConversationPage",
  props: {
    single: Boolean
  },
  destroyed() {
    console.log("conversation page destroyed");
  },
  methods: {},
  components: {
    ConversationListPanel: _ConversationListPanel_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
    ConversationView: _conversation_ConversationView__WEBPACK_IMPORTED_MODULE_0__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/HomePage.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/HomePage.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _user_UserCardView_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./user/UserCardView.vue */ "./src/ui/main/user/UserCardView.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../wfc/client/wfcEvent */ "./src/wfc/client/wfcEvent.js");
/* harmony import */ var _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../wfc/client/connectionStatus */ "./src/wfc/client/connectionStatus.js");
/* harmony import */ var _ui_common_ElectronWindowsControlButtonView_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/ui/common/ElectronWindowsControlButtonView.vue */ "./src/ui/common/ElectronWindowsControlButtonView.vue");
/* harmony import */ var _util_storageHelper__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/storageHelper */ "./src/ui/util/storageHelper.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../wfc/av/internal/engine.min */ "./src/wfc/av/internal/engine.min.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../wfc/av/engine/avenginekitproxy */ "./src/wfc/av/engine/avenginekitproxy.js");
/* harmony import */ var draggable_vue_directive__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! draggable-vue-directive */ "./node_modules/draggable-vue-directive/dist/index.js");
/* harmony import */ var draggable_vue_directive__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(draggable_vue_directive__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _ui_main_ConversationPage__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/ui/main/ConversationPage */ "./src/ui/main/ConversationPage.vue");
/* harmony import */ var _ContactPage_vue__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./ContactPage.vue */ "./src/ui/main/ContactPage.vue");
/* harmony import */ var _ui_voip_conference_ConferencePortalPage__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/ui/voip/conference/ConferencePortalPage */ "./src/ui/voip/conference/ConferencePortalPage.vue");
/* harmony import */ var _ui_main_setting_SettingPage__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/ui/main/setting/SettingPage */ "./src/ui/main/setting/SettingPage.vue");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");









// import { ipcRenderer } from "@/platform";



// import IpcEventType from "@/wfc/ipcEventType";






/* harmony default export */ __webpack_exports__["default"] = ({
  components: {
    UserCardView: _user_UserCardView_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
    ElectronWindowsControlButtonView: _ui_common_ElectronWindowsControlButtonView_vue__WEBPACK_IMPORTED_MODULE_7__["default"],
    ConversationPage: _ui_main_ConversationPage__WEBPACK_IMPORTED_MODULE_13__["default"],
    ContactPage: _ContactPage_vue__WEBPACK_IMPORTED_MODULE_14__["default"],
    ConferencePortalPage: _ui_voip_conference_ConferencePortalPage__WEBPACK_IMPORTED_MODULE_15__["default"],
    SettingPage: _ui_main_setting_SettingPage__WEBPACK_IMPORTED_MODULE_16__["default"]
  },
  props: {
    visible: {
      type: Boolean
    },
    single: Boolean
  },
  directives: {
    Draggable: draggable_vue_directive__WEBPACK_IMPORTED_MODULE_11__["Draggable"]
  },
  data() {
    return {
      showContact: false,
      showSetting: false,
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.contact,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.misc,
      shareConversationState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.conversation,
      supportConference: false,
      // supportConference: avenginekit.startConference !== undefined,
      isSetting: false,
      fileWindow: null,
      voipProxy: _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_10__["default"]
    };
  },
  methods: {
    onClickPortrait() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getUserInfo(this.sharedContactState.selfUserInfo.uid, true);
    },
    go2Conversation() {
      if (this.pageName === "ConversationPage") {
        return;
      }
      // this.pageName = "ConversationPage";
      this.$store.commit("SET_PAGE_NAME", "ConversationPage");
      this.isSetting = false;
    },
    go2Contact() {
      if (this.pageName === "ContactPage") {
        return;
      }
      // this.pageName = "ContactPage";
      this.$store.commit("SET_PAGE_NAME", "ContactPage");
      this.isSetting = false;
    },
    go2Fav() {
      if (this.$router.currentRoute.path === "/home/fav") {
        return;
      }
      this.$router.replace("/home/fav");
      this.isSetting = false;
    },
    // go2Files() {
    //   let hash = window.location.hash;
    //   let url = window.location.origin;
    //   if (hash) {
    //     url = window.location.href.replace(hash, "#/files");
    //   } else {
    //     url += "/files";
    //   }
    //   ipcRenderer.send(IpcEventType.SHOW_FILE_WINDOW, {
    //     url: url,
    //     source: "file",
    //   });
    //   console.log("show-file-window", url);
    // },
    go2Workspace() {
      if (this.$router.currentRoute.path === "/home/workspace") {
        return;
      }
      this.$router.replace("/home/workspace");
      this.isSetting = false;
    },
    go2Conference() {
      if (this.pageName === "ConferencePortalPage") {
        return;
      }
      // this.pageName = "ConferencePortalPage";
      this.$store.commit("SET_PAGE_NAME", "ConferencePortalPage");
      this.isSetting = true;
    },
    go2Setting() {
      if (this.pageName === "SettingPage") {
        return;
      }
      // this.pageName = "SettingPage";
      this.$store.commit("SET_PAGE_NAME", "SettingPage");
      this.isSetting = true;
    },
    closeUserCard() {
      console.log("closeUserCard");
      this.$refs["userCardTippy"]._tippy.hide();
    },
    onConnectionStatusChange(status) {
      if (status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusRejected || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusLogout || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusSecretKeyMismatch || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusTokenIncorrect || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusKickedOff ||
      // TODO 断网时，显示网络断开状态
      // || status === ConnectionStatus.ConnectionStatusUnconnected
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getUserId() === "") {
        // if (this.$router.currentRoute.path !== "/") {
        //   this.$router.replace({ path: "/" });
        // }
        if (this.pageName !== "ConversationPage") {
          // this.pageName = "ConversationPage";
          this.$store.commit("SET_PAGE_NAME", "ConversationPage");
        }
        if (status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusSecretKeyMismatch || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusLogout || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusTokenIncorrect || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusKickedOff || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].ConnectionStatusRejected) {
          Object(_util_storageHelper__WEBPACK_IMPORTED_MODULE_8__["removeItem"])("wfcUserId");
          Object(_util_storageHelper__WEBPACK_IMPORTED_MODULE_8__["removeItem"])("wfcToken");
          _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_10__["default"].forceCloseVoipWindow();
          console.error("连接失败", _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_6__["default"].desc(status));
        }
      }
    },
    close() {
      this.$emit("update:visible", false);
    }
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_17__["mapGetters"])(["pageName"]),
    unread() {
      let count = 0;
      this.shareConversationState.conversationInfoList.forEach(info => {
        if (info.isSilent) {
          return;
        }
        let unreadCount = info.unreadCount;
        count += unreadCount.unread;
      });
      return count;
    },
    dragAreaLeft() {
      // 60为左边菜单栏的宽度，261为会话列表的宽度
      if (this.isSetting) {
        return {
          left: "60px"
        };
      } else {
        return {
          left: "calc(60px + 261px)"
        };
      }
    }
  },
  created() {
    console.log("avenginekit.startConference", _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_9___default.a.startConference);
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].eventEmitter.on(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_5__["default"].ConnectionStatusChanged, this.onConnectionStatusChange);
  },
  mounted() {
    if (_wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_10__["default"].useIframe) {
      let voipIframe = this.$refs["voip-iframe"];
      _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_10__["default"].setVoipIframe(voipIframe);
    }
    _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_10__["default"].onVoipCallErrorCallback = errorCode => {
      if (errorCode === -1) {
        this.$notify({
          title: "不能发起或接听新的音视频通话",
          text: "目前有音视频通话正在进行中",
          type: "warn"
        });
      } else if (errorCode === -2) {
        if (Object(_platform__WEBPACK_IMPORTED_MODULE_12__["isElectron"])()) {
          console.error(`不支持音视频通话，原因可能是:
                        1. 可通过这个网页测试浏览器对音视频通话的支持情况，https://docs.wildfirechat.cn/webrtc/abilitytest/
                        2. 确保系统已授予当前应用 摄像头 和 麦克风 权限
                    `);
        } else {
          console.error(`不支持音视频通话，原因可能是:
                        1. 浏览器上，只有通过 http://localhost 或 https://xxxx 访问的网页才支持音视频通话
                        2. 可通过这个网页测试浏览器对音视频通话的支持情况，https://docs.wildfirechat.cn/webrtc/abilitytest/
                        3. 确保浏览器已授予网页 摄像头 和 麦克风 权限
                        4. 确保系统已授予浏览器 摄像头 和麦克风 权限
                        5. 配置 https，请参考：https://docs.wildfirechat.cn/faq/web/https.html
                    `);
        }
        this.$notify({
          title: "不支持音视频通话",
          text: "请到手机上接听音视频通话",
          type: "warn"
        });
      }
    };
  },
  destroyed() {
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].eventEmitter.removeListener(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_5__["default"].ConnectionStatusChanged, this.onConnectionStatusChange);
    console.log("home destroy");
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/ChannelCardView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/ChannelCardView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ChannelCardView",
  props: {
    channelId: {
      type: String,
      required: true
    },
    enableUpdatePortrait: {
      type: Boolean,
      required: false
    }
  },
  data() {
    return {
      channelInfo: null
    };
  },
  created() {
    this.channelInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].getChannelInfo(this.channelId, false);
  },
  methods: {
    share() {
      this.close();
    },
    chat() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_1__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_2__["default"].Single, this.channelInfo.uid, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentConversation(conversation);
      this.close();
    },
    subscribe(toSubscribe) {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].listenChannel(this.channelId, toSubscribe);
      this.close();
    },
    close() {
      this.$emit("close");
    }
  },
  computed: {
    isSubscribed() {
      return _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].isListenedChannel(this.channelId);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/ChannelDetailView.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/ChannelDetailView.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ChannelDetailView",
  props: {},
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact
    };
  },
  methods: {
    chat() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_1__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_2__["default"].Channel, this.sharedContactState.currentChannel.channelId, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentConversation(conversation);
      // this.$router.replace('/home');
      this.$store.commit("SET_PAGE_NAME", "ConversationPage");
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/ChannelListView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/ChannelListView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ChannelListView",
  props: {},
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact
    };
  },
  methods: {
    showChannel(channel) {
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentChannel(channel);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/ContactItemView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/ContactItemView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../config */ "./src/config.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ContactItemView",
  props: {
    source: {
      type: Object,
      required: true
    }
  },
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact
    };
  },
  methods: {
    clickUserItem() {
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentFriend(this.source);
    },
    imgUrlAlt(e) {
      e.target.src = _config__WEBPACK_IMPORTED_MODULE_1__["default"].DEFAULT_PORTRAIT_URL;
    },
    showContactContextMenu(event) {
      this.$eventBus.$emit("showContactContextMenu", event, this.source);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/ContactListView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/ContactListView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _main_contact_FriendRequestListView__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../main/contact/FriendRequestListView */ "./src/ui/main/contact/FriendRequestListView.vue");
/* harmony import */ var _main_contact_GroupListView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../main/contact/GroupListView */ "./src/ui/main/contact/GroupListView.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _user_UserListView_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../user/UserListView.vue */ "./src/ui/main/user/UserListView.vue");
/* harmony import */ var _ChannelListView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ChannelListView */ "./src/ui/main/contact/ChannelListView.vue");
/* harmony import */ var _ContactItemView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ContactItemView */ "./src/ui/main/contact/ContactItemView.vue");
/* harmony import */ var _OrganizationListView_vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./OrganizationListView.vue */ "./src/ui/main/contact/OrganizationListView.vue");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _conversation_message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../conversation/message/forward/ForwardType */ "./src/ui/main/conversation/message/forward/ForwardType.js");
/* harmony import */ var _wfc_messages_cardMessageContent__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../wfc/messages/cardMessageContent */ "./src/wfc/messages/cardMessageContent.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../../wfc/messages/message */ "./src/wfc/messages/message.js");
















/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ContactListView",
  components: {
    OrganizationListView: _OrganizationListView_vue__WEBPACK_IMPORTED_MODULE_9__["default"],
    ChannelListView: _ChannelListView__WEBPACK_IMPORTED_MODULE_7__["default"],
    UserListView: _user_UserListView_vue__WEBPACK_IMPORTED_MODULE_6__["default"],
    GroupListVue: _main_contact_GroupListView__WEBPACK_IMPORTED_MODULE_4__["default"],
    NewFriendListView: _main_contact_FriendRequestListView__WEBPACK_IMPORTED_MODULE_3__["default"]
  },
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].state.contact,
      contactItemView: _ContactItemView__WEBPACK_IMPORTED_MODULE_8__["default"],
      rootOrganizations: []
    };
  },
  created() {
    this.$eventBus.$on("showContactContextMenu", (event, userInfo) => {
      this.showContactContextMenu(event, userInfo);
    });
  },
  destroyed() {
    this.$eventBus.$off("showContactContextMenu");
  },
  methods: {
    setCurrentUser(userInfo) {
      _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].setCurrentFriend(userInfo);
    },
    showNewFriends() {
      _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].toggleFriendRequestList();
    },
    showGroups() {
      _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].toggleGroupList();
    },
    showChannels() {
      _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].toggleChannelList();
    },
    showContacts() {
      _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].toggleFriendList();
    },
    showOrganization() {
      _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].toggleOrganizationList();
    },
    sendMessage(userInfo) {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_10__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_11__["default"].Single, userInfo.uid, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].setCurrentConversation(conversation);
      // this.$router.replace('/home');
      this.$store.commit("SET_PAGE_NAME", "ConversationPage");
    },
    sendUserCard(userInfo) {
      let userCardMessageContent = new _wfc_messages_cardMessageContent__WEBPACK_IMPORTED_MODULE_13__["default"](0, userInfo.uid, userInfo.displayName, userInfo.portrait, _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_14__["default"].getUserId());
      userCardMessageContent.name = userInfo.name;
      let message = new _wfc_messages_message__WEBPACK_IMPORTED_MODULE_15__["default"](null, userCardMessageContent);
      return this.$forwardMessage({
        forwardType: _conversation_message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_12__["default"].NORMAL,
        messages: [message]
      });
    },
    showContactContextMenu(event, userInfo) {
      if (!this.$refs.menu) {
        return;
      }
      console.log("showContactContextMenu");
      this.sharedContactState.contextMenuUserInfo = userInfo;
      this.$refs.menu.open(event, userInfo);
    },
    onContactContextMenuClose() {
      this.sharedContactState.contextMenuUserInfo = null;
    }
  },
  computed: {
    groupedContacts() {
      let groupedUsers = [];
      let currentCategory = {};
      let lastCategory = null;
      this.users.forEach(user => {
        if (!lastCategory || lastCategory !== user._category) {
          lastCategory = user._category;
          currentCategory = {
            type: "category",
            category: user._category,
            uid: user._category
          };
          groupedUsers.push(currentCategory);
          groupedUsers.push(user);
        } else {
          groupedUsers.push(user);
        }
      });
      return groupedUsers;
    },
    users() {
      return _store_js__WEBPACK_IMPORTED_MODULE_5__["default"].state.contact.favContactList.concat(_store_js__WEBPACK_IMPORTED_MODULE_5__["default"].state.contact.friendList);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/FrienRequestDetailView.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/FrienRequestDetailView.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "UserDetailView",
  props: {
    user: null,
    friendRequest: null
  },
  data() {
    return {
      sharedStateContact: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact
    };
  },
  methods: {
    chat() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_1__["default"].Single, this.user.uid, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentConversation(conversation);
      // this.$router.replace('/home');
      this.$store.commit("SET_PAGE_NAME", "ConversationPage");
    },
    updateFriendAlias() {
      let friendAlias = this.$refs.input.value;
      if (friendAlias.trim() && friendAlias !== this.user.friendAlias) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].setFriendAlias(this.user.uid, friendAlias, () => {
          // do nothing
          console.log("setFriendAlias success", this.user, friendAlias);
        }, () => {
          // do nothing
        });
      }
    },
    startAudioCall() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_1__["default"].Single, this.user.uid, 0);
      this.$startVoipCall({
        audioOnly: true,
        conversation: conversation
      });
    },
    startVideoCall() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_1__["default"].Single, this.user.uid, 0);
      this.$startVoipCall({
        audioOnly: false,
        conversation: conversation
      });
    }
  },
  computed: {
    name: function () {
      let name;
      let friend = this.user;
      if (friend.displayName) {
        name = friend.displayName;
      } else {
        name = friend.name;
      }
      // side
      (async () => {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].getUserInfo(friend.uid, true);
      })();
      return name;
    },
    isFriend() {
      return _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].isMyFriend(this.user.uid);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/FriendRequestListView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/FriendRequestListView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/client/wfcEvent */ "./src/wfc/client/wfcEvent.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "NewFriendListView",
  props: {
    newFriends: null
  },
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact,
      isActive: false
    };
  },
  methods: {
    showFriendRequest(friendRequest) {
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentFriendRequest(friendRequest);
    },
    accept(friendRequest) {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].handleFriendRequest(friendRequest.target, true, "", () => {
        friendRequest.status = 1;
      }, err => {
        console.log("accept friend request error", err);
      });
    },
    onFriendRequestUpdate() {
      if (this.isActive) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].clearUnreadFriendRequestStatus();
      }
    }
  },
  activated() {
    this.isActive = true;
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].clearUnreadFriendRequestStatus();
  },
  deactivated() {
    this.isActive = false;
  },
  mounted() {
    this.isActive = true;
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].clearUnreadFriendRequestStatus();
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].eventEmitter.on(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_2__["default"].FriendRequestUpdate, this.onFriendRequestUpdate);
  },
  beforeDestroy() {
    this.isActive = false;
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].eventEmitter.removeListener(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_2__["default"].FriendRequestUpdate, this.onFriendRequestUpdate);
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/FriendRequestView.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/FriendRequestView.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/store.js */ "./src/store.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "FriendRequestView",
  props: {
    userInfo: {
      type: Object,
      required: true
    }
  },
  data() {
    return {
      reason: "",
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.contact
    };
  },
  methods: {
    cancel() {
      this.$modal.hide("friend-request-modal");
    },
    invite() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__["default"].sendFriendRequest(this.userInfo.uid, this.reason, null, () => {
        // TODO
        console.log("send friendRequest success", this.userInfo.uid);
      }, err => {
        // TODO
      });
      this.$modal.hide("friend-request-modal");
    }
  },
  computed: {
    defaultReason() {
      let userInfo = this.sharedContactState.selfUserInfo;
      return this.$t("friend_request.im") + userInfo.displayName;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/GroupDetailView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/GroupDetailView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "GroupDetailView",
  props: {},
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact
    };
  },
  methods: {
    chat() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_1__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_2__["default"].Group, this.sharedContactState.currentGroup.target, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentConversation(conversation);
      // this.$router.replace('/home');
      this.$store.commit("SET_PAGE_NAME", "ConversationPage");
    },
    unfavGroup() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].setFavGroup(this.sharedContactState.currentGroup.target, false, () => {
        this.sharedContactState.currentGroup = null;
        _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].reloadFavGroupList();
      }, err => {
        console.error("setFavGroup error", err);
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/GroupListView.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/GroupListView.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "GroupListView",
  props: {},
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact
    };
  },
  methods: {
    showGroup(group) {
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentGroup(group);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/OrganizationListView.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/OrganizationListView.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _api_organizationServerApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../api/organizationServerApi */ "./src/api/organizationServerApi.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../config */ "./src/config.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "OrganizationListView",
  props: {},
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact,
      rootOrganizations: [],
      defaultPortraitUrl: _config__WEBPACK_IMPORTED_MODULE_2__["default"].DEFAULT_ORGANIZATION_PORTRAIT_URL
    };
  },
  mounted() {
    _api_organizationServerApi__WEBPACK_IMPORTED_MODULE_1__["default"].getRootOrganization().then(orgs => {
      this.rootOrganizations = orgs;
    });
  },
  methods: {
    showOrganization(organization) {
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentOrganization(organization);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/OrganizationTreeView.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/OrganizationTreeView.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../config */ "./src/config.js");
/* harmony import */ var _api_organizationServerApi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../api/organizationServerApi */ "./src/api/organizationServerApi.js");
/* harmony import */ var _user_UserCardView_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../user/UserCardView.vue */ "./src/ui/main/user/UserCardView.vue");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "OrganizationTreeView",
  props: {},
  components: {
    UserCardView: _user_UserCardView_vue__WEBPACK_IMPORTED_MODULE_3__["default"]
  },
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact,
      subOrganizations: [],
      employees: [],
      currentOrganizationPathList: [],
      defaultDepartmentPortraitUrl: _config__WEBPACK_IMPORTED_MODULE_1__["default"].DEFAULT_DEPARTMENT_PORTRAIT_URL,
      defaultEmployeePortraitUrl: _config__WEBPACK_IMPORTED_MODULE_1__["default"].DEFAULT_PORTRAIT_URL,
      activeTippy: null
    };
  },
  mounted() {
    this.loadAndShowOrganization(this.sharedContactState.currentOrganization);
  },
  methods: {
    loadAndShowOrganization(org) {
      _api_organizationServerApi__WEBPACK_IMPORTED_MODULE_2__["default"].getOrganizationEx(org.id).then(res => {
        this.subOrganizations = res.subOrganizations;
        this.employees = res.employees;
      });
      _api_organizationServerApi__WEBPACK_IMPORTED_MODULE_2__["default"].getOrganizationPath(org.id).then(orgs => {
        this.currentOrganizationPathList = orgs.reverse();
      });
    },
    employeeToUserInfo(employee) {
      return _api_organizationServerApi__WEBPACK_IMPORTED_MODULE_2__["default"].employeeToUserInfo(employee);
    },
    showUserCardView(employee) {
      if (this.activeTippy) {
        this.activeTippy.hide();
        this.activeTippy = null;
        return;
      }
      let employeeItem = this.$refs["ref-employee-" + employee.employeeId][0];
      this.activeTippy = employeeItem._tippy;
      this.activeTippy.show();
    },
    closeUserCard() {
      if (this.activeTippy) {
        this.activeTippy.hide();
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/contact/UserDetailView.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/contact/UserDetailView.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "UserDetailView",
  props: {
    user: null
  },
  data() {
    return {
      sharedStateContact: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact
    };
  },
  methods: {
    chat() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_1__["default"].Single, this.user.uid, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentConversation(conversation);
      // this.$router.replace('/home');
      this.$store.commit("SET_PAGE_NAME", "ConversationPage");
    },
    updateFriendAlias() {
      let friendAlias = this.$refs.input.value;
      if (friendAlias.trim() && friendAlias !== this.sharedStateContact.currentFriend.friendAlias) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].setFriendAlias(this.user.uid, friendAlias, () => {
          // do nothing
          console.log("setFriendAlias success", this.user, friendAlias);
        }, () => {
          // do nothing
        });
      }
    },
    startAudioCall() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_1__["default"].Single, this.user.uid, 0);
      this.$startVoipCall({
        audioOnly: true,
        conversation: conversation
      });
    },
    startVideoCall() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_1__["default"].Single, this.user.uid, 0);
      this.$startVoipCall({
        audioOnly: false,
        conversation: conversation
      });
    }
  },
  computed: {
    name: function () {
      let name;
      let friend = this.sharedStateContact.currentFriend;
      if (friend.displayName) {
        name = friend.displayName;
      } else {
        name = friend.name;
      }
      // side
      (async () => {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].getUserInfo(friend.uid, true);
      })();
      return name;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/ChannelConversationInfoView.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/ChannelConversationInfoView.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/model/conversationInfo */ "./src/wfc/model/conversationInfo.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ChannelConversationInfoView",
  props: {
    conversationInfo: {
      type: _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.contact,
      newChannelName: "",
      newChannelDesc: ""
    };
  },
  components: {},
  methods: {
    updateChannelName() {},
    updateChannelDesc() {},
    isSubscribedChannel() {
      return _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_2__["default"].isListenedChannel(this.conversationInfo.conversation.target);
    },
    subscribeChannel() {
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].subscribeChannel(this.conversationInfo.conversation.target, !this.isSubscribedChannel());
    }
  },
  computed: {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/ChannelMenuView.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/ChannelMenuView.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_channelMenuEventMessageContent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/messages/channelMenuEventMessageContent */ "./src/wfc/messages/channelMenuEventMessageContent.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ChannelMenuView",
  props: {
    menus: {
      type: Array,
      required: true
    },
    conversation: {
      type: _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"],
      required: true
    }
  },
  methods: {
    toggleMessageInput() {
      this.$parent.toggleChannelMenu(false);
    },
    menuTile(menu) {
      if (menu.subMenus && menu.subMenus.length) {
        return "≡ " + menu.name;
      }
      return menu.name;
    },
    openChannelMenu(event, menu) {
      console.log("open menu", menu);
      if (menu.subMenus && menu.subMenus.length) {
        return;
      }
      // TODO send channelMenuEventMessage
      // ChannelMenuEventMessageContent content = new ChannelMenuEventMessageContent();
      // content.setMenu(menu);
      // ChatManager.Instance().sendMessage(conversation, content, null, 0, null);
      //
      switch (menu.type) {
        case "view":
          if (menu.url) {
            //WfcWebViewActivity.loadUrl(getContext(), "", menu.url);
            open(menu.url);
          }
          break;
        case "click":
          let content = new _wfc_messages_channelMenuEventMessageContent__WEBPACK_IMPORTED_MODULE_0__["default"](menu);
          _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].sendConversationMessage(this.conversation, content);
          break;
        case "miniprogram":
          break;
        default:
          break;
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/ConversationView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/ConversationView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _main_conversation_SingleConversationInfoView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../main/conversation/SingleConversationInfoView */ "./src/ui/main/conversation/SingleConversationInfoView.vue");
/* harmony import */ var _main_conversation_SecretConversationInfoView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../main/conversation/SecretConversationInfoView */ "./src/ui/main/conversation/SecretConversationInfoView.vue");
/* harmony import */ var _main_conversation_GroupConversationInfoView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../main/conversation/GroupConversationInfoView */ "./src/ui/main/conversation/GroupConversationInfoView.vue");
/* harmony import */ var _main_conversation_MessageInputView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../main/conversation/MessageInputView */ "./src/ui/main/conversation/MessageInputView.vue");
/* harmony import */ var vue_click_outside__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vue-click-outside */ "./node_modules/vue-click-outside/index.js");
/* harmony import */ var vue_click_outside__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(vue_click_outside__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _main_conversation_message_NormalOutMessageContentContainerView__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../main/conversation/message/NormalOutMessageContentContainerView */ "./src/ui/main/conversation/message/NormalOutMessageContentContainerView.vue");
/* harmony import */ var _main_conversation_message_NormalInMessageContentContainerView__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../main/conversation/message/NormalInMessageContentContainerView */ "./src/ui/main/conversation/message/NormalInMessageContentContainerView.vue");
/* harmony import */ var _main_conversation_message_NotificationMessageContentView__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../main/conversation/message/NotificationMessageContentView */ "./src/ui/main/conversation/message/NotificationMessageContentView.vue");
/* harmony import */ var _main_conversation_message_RecallNotificationMessageContentView__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../main/conversation/message/RecallNotificationMessageContentView */ "./src/ui/main/conversation/message/RecallNotificationMessageContentView.vue");
/* harmony import */ var _wfc_messages_notification_notificationMessageContent__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../wfc/messages/notification/notificationMessageContent */ "./src/wfc/messages/notification/notificationMessageContent.js");
/* harmony import */ var _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../wfc/messages/textMessageContent */ "./src/wfc/messages/textMessageContent.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/wfc/util/longUtil */ "./src/wfc/util/longUtil.js");
/* harmony import */ var vue_infinite_loading__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! vue-infinite-loading */ "./node_modules/vue-infinite-loading/dist/vue-infinite-loading.js");
/* harmony import */ var vue_infinite_loading__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(vue_infinite_loading__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _main_conversation_MessageMultiSelectActionView__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../main/conversation/MessageMultiSelectActionView */ "./src/ui/main/conversation/MessageMultiSelectActionView.vue");
/* harmony import */ var vue_spinner_src_ScaleLoader__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! vue-spinner/src/ScaleLoader */ "./node_modules/vue-spinner/src/ScaleLoader.vue");
/* harmony import */ var _main_conversation_message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../main/conversation/message/forward/ForwardType */ "./src/ui/main/conversation/message/forward/ForwardType.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _wfc_messages_fileMessageContent__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../../wfc/messages/fileMessageContent */ "./src/wfc/messages/fileMessageContent.js");
/* harmony import */ var _wfc_messages_imageMessageContent__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../../wfc/messages/imageMessageContent */ "./src/wfc/messages/imageMessageContent.js");
/* harmony import */ var _ui_util_clipboard__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @/ui/util/clipboard */ "./src/ui/util/clipboard.js");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _platformHelper__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @/platformHelper */ "./src/platformHelper.js");
/* harmony import */ var _wfc_messages_videoMessageContent__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../../wfc/messages/videoMessageContent */ "./src/wfc/messages/videoMessageContent.js");
/* harmony import */ var _ipc_localStorageEmitter__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../../ipc/localStorageEmitter */ "./src/ipc/localStorageEmitter.js");
/* harmony import */ var _wfc_messages_soundMessageContent__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../../wfc/messages/soundMessageContent */ "./src/wfc/messages/soundMessageContent.js");
/* harmony import */ var _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../../../wfc/messages/messageContentType */ "./src/wfc/messages/messageContentType.js");
/* harmony import */ var benz_amr_recorder__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! benz-amr-recorder */ "./node_modules/benz-amr-recorder/BenzAMRRecorder.js");
/* harmony import */ var benz_amr_recorder__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(benz_amr_recorder__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../../wfc/model/groupMemberType */ "./src/wfc/model/groupMemberType.js");
/* harmony import */ var _wfc_messages_compositeMessageContent__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../../../wfc/messages/compositeMessageContent */ "./src/wfc/messages/compositeMessageContent.js");
/* harmony import */ var _wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../../../wfc/client/wfcEvent */ "./src/wfc/client/wfcEvent.js");
/* harmony import */ var _wfc_av_messages_multiCallOngoingMessageContent__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../../../wfc/av/messages/multiCallOngoingMessageContent */ "./src/wfc/av/messages/multiCallOngoingMessageContent.js");
/* harmony import */ var _wfc_av_messages_joinCallRequestMessageContent__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ../../../wfc/av/messages/joinCallRequestMessageContent */ "./src/wfc/av/messages/joinCallRequestMessageContent.js");
/* harmony import */ var _wfc_messages_notification_richNotificationMessageContent__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../../../wfc/messages/notification/richNotificationMessageContent */ "./src/wfc/messages/notification/richNotificationMessageContent.js");
/* harmony import */ var _wfc_messages_messageStatus__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../../../wfc/messages/messageStatus */ "./src/wfc/messages/messageStatus.js");
/* harmony import */ var _wfc_messages_mediaMessageContent__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../../../wfc/messages/mediaMessageContent */ "./src/wfc/messages/mediaMessageContent.js");
/* harmony import */ var _wfc_messages_articlesMessageContent__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../../../wfc/messages/articlesMessageContent */ "./src/wfc/messages/articlesMessageContent.js");
/* harmony import */ var _message_ContextableNotificationMessageContentContainerView__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./message/ContextableNotificationMessageContentContainerView */ "./src/ui/main/conversation/message/ContextableNotificationMessageContentContainerView.vue");
/* harmony import */ var _ChannelConversationInfoView__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./ChannelConversationInfoView */ "./src/ui/main/conversation/ChannelConversationInfoView.vue");
/* harmony import */ var _contact_FriendRequestView__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ../contact/FriendRequestView */ "./src/ui/main/contact/FriendRequestView.vue");
/* harmony import */ var _api_appServerApi__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ../../../api/appServerApi */ "./src/api/appServerApi.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../../../config */ "./src/config.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! @/wfc/ipcEventType */ "./src/wfc/ipcEventType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_48___default = /*#__PURE__*/__webpack_require__.n(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_48__);
/* harmony import */ var _ipc_localStorageIpcEventType__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ../../../ipc/localStorageIpcEventType */ "./src/ipc/localStorageIpcEventType.js");
/* harmony import */ var _ui_util_imageUtil__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! @/ui/util/imageUtil */ "./src/ui/util/imageUtil.js");




















































var amr;
/* harmony default export */ __webpack_exports__["default"] = ({
  components: {
    ChannelConversationInfoView: _ChannelConversationInfoView__WEBPACK_IMPORTED_MODULE_44__["default"],
    ContextableNotificationMessageContentContainerView: _message_ContextableNotificationMessageContentContainerView__WEBPACK_IMPORTED_MODULE_43__["default"],
    MultiSelectActionView: _main_conversation_MessageMultiSelectActionView__WEBPACK_IMPORTED_MODULE_19__["default"],
    NotificationMessageContentView: _main_conversation_message_NotificationMessageContentView__WEBPACK_IMPORTED_MODULE_11__["default"],
    RecallNotificationMessageContentView: _main_conversation_message_RecallNotificationMessageContentView__WEBPACK_IMPORTED_MODULE_12__["default"],
    NormalInMessageContentView: _main_conversation_message_NormalInMessageContentContainerView__WEBPACK_IMPORTED_MODULE_10__["default"],
    NormalOutMessageContentView: _main_conversation_message_NormalOutMessageContentContainerView__WEBPACK_IMPORTED_MODULE_9__["default"],
    MessageInputView: _main_conversation_MessageInputView__WEBPACK_IMPORTED_MODULE_7__["default"],
    GroupConversationInfoView: _main_conversation_GroupConversationInfoView__WEBPACK_IMPORTED_MODULE_6__["default"],
    SingleConversationInfoView: _main_conversation_SingleConversationInfoView__WEBPACK_IMPORTED_MODULE_4__["default"],
    SecretConversationInfoView: _main_conversation_SecretConversationInfoView__WEBPACK_IMPORTED_MODULE_5__["default"],
    InfiniteLoading: (vue_infinite_loading__WEBPACK_IMPORTED_MODULE_18___default()),
    ScaleLoader: vue_spinner_src_ScaleLoader__WEBPACK_IMPORTED_MODULE_20__["default"]
  },
  props: {
    inputOptions: {
      type: Object,
      required: false
    },
    title: {
      type: String,
      required: false
    }
  },
  data() {
    return {
      conversationInfo: null,
      showConversationInfo: false,
      sharedConversationState: _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].state.conversation,
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].state.contact,
      sharedPickState: _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].state.pick,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].state.misc,
      isHandlerDragging: false,
      savedMessageListViewHeight: -1,
      saveMessageListViewFlexGrow: -1,
      dragAndDropEnterCount: 0,
      // FIXME 选中一个会话，然后切换到其他page，比如联系人，这时该会话收到新消息或发送消息，会导致新收到/发送的消息的界面错乱，尚不知道原因，但这么做能解决。
      fixTippy: true,
      ongoingCalls: [],
      ongoingCallTimer: 0,
      messageInputViewResized: false,
      unreadMessageCount: 0,
      isWindowAlwaysTop: _platform__WEBPACK_IMPORTED_MODULE_22__["currentWindow"] && _platform__WEBPACK_IMPORTED_MODULE_22__["currentWindow"].isAlwaysOnTop()
    };
  },
  activated() {
    this.fixTippy = true;
  },
  deactivated() {
    this.fixTippy = false;
  },
  methods: {
    async dragEvent(e, v) {
      if (v === "dragenter") {
        this.dragAndDropEnterCount++;
      } else if (v === "dragleave") {
        this.dragAndDropEnterCount--;
      } else if (v === "drop") {
        this.dragAndDropEnterCount--;
        let isFile;
        if (e.dataTransfer.items && e.dataTransfer.items.length > 0) {
          if (e.dataTransfer.items[0].kind === "file") {
            if (typeof e.dataTransfer.items[0].webkitGetAsEntry == "function") {
              isFile = e.dataTransfer.items[0].webkitGetAsEntry().isFile;
            } else if (typeof e.dataTransfer.items[0].getAsEntry == "function") {
              isFile = e.dataTransfer.items[0].getAsEntry().isFile;
            }
            if (!isFile) {
              this.$notify({
                // title: '不支持',
                text: this.$t("conversation.not_support_send_folder"),
                type: "warn"
              });
              return true;
            }
          }
        }
        let length = e.dataTransfer.files.length;
        if (length > 0 && length <= 5) {
          for (let i = 0; i < length; i++) {
            this.$eventBus.$emit("uploadFile", e.dataTransfer.files[i]);
            _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].sendFile(this.sharedConversationState.currentConversationInfo.conversation, e.dataTransfer.files[i]);
          }
        } else if (length > 5) {
          this.$notify({
            // title: '大文件提示',
            text: this.$t("conversation.drag_to_send_limit_tip"),
            type: "warn"
          });
        }
        let dragUrl = e.dataTransfer.getData("URL");
        if (dragUrl) {
          // 根据后缀判断类型
          if (dragUrl.endsWith(".png") || dragUrl.endsWith(".jpg") || dragUrl.endsWith("jpeg")) {
            //constructor(fileOrLocalPath, remotePath, thumbnail) {
            let {
              thumbnail: it,
              width: iw,
              height: ih
            } = await Object(_ui_util_imageUtil__WEBPACK_IMPORTED_MODULE_50__["imageThumbnail"])(dragUrl);
            it = it ? it : _config__WEBPACK_IMPORTED_MODULE_47__["default"].DEFAULT_THUMBNAIL_URL;
            if (it.length > 15 * 1024) {
              it = _config__WEBPACK_IMPORTED_MODULE_47__["default"].DEFAULT_THUMBNAIL_URL;
            }
            let content = new _wfc_messages_imageMessageContent__WEBPACK_IMPORTED_MODULE_24__["default"](null, dragUrl, it.split(",")[1]);
            content.imageWidth = iw;
            content.imageHeight = ih;
            _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].sendConversationMessage(this.conversationInfo.conversation, content);
          } else {
            // TODO blob uri
          }
        }
        console.log("drag Url", dragUrl);
      } else if (v === "dragover") {
        // TODO 可以判断一些，不支持的，dropEffect 置为 none
        // 支持那些类型的数据 drop，参考上面 drop 部分的处理
        // If not st as 'copy', electron will open the drop file
        e.dataTransfer.dropEffect = "copy";
      }
    },
    toggleConversationInfo() {
      this.showConversationInfo = !this.showConversationInfo;
    },
    setWindowAlwaysTop() {
      this.isWindowAlwaysTop = !_platform__WEBPACK_IMPORTED_MODULE_22__["currentWindow"].isAlwaysOnTop();
      _platform__WEBPACK_IMPORTED_MODULE_22__["currentWindow"].setAlwaysOnTop(this.isWindowAlwaysTop);
    },
    clickConversationDesc() {
      if (this.conversationInfo.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_33__["default"].Single && !_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].isMyFriend(this.conversationInfo.conversation.target)) {
        this.$modal.show(_contact_FriendRequestView__WEBPACK_IMPORTED_MODULE_45__["default"], {
          userInfo: this.conversationInfo.conversation._target
        }, {
          name: "friend-request-modal",
          width: 600,
          height: 250,
          clickToClose: false
        }, {});
      }
    },
    toggleMessageMultiSelectionActionView(message) {
      if (!this.sharedConversationState.enableMessageMultiSelection) {
        this.saveMessageListViewFlexGrow = this.$refs["conversationMessageList"].style.flexGrow;
        this.savedMessageListViewHeight = this.$refs["conversationMessageList"].style.height;
        this.$refs["conversationMessageList"].style.flexGrow = 1;
      } else {
        if (this.saveMessageListViewFlexGrow !== -1 && this.savedMessageListViewHeight !== -1) {
          this.$refs["conversationMessageList"].style.height = this.savedMessageListViewHeight;
          this.$refs["conversationMessageList"].style.flexGrow = this.saveMessageListViewFlexGrow;
        }
      }
      this.sharedPickState.messages.forEach(m => console.log(m.messageId));
      _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].toggleMessageMultiSelection(message);
    },
    clickMessageItem(event, message) {
      if (message.messageContent instanceof _wfc_messages_notification_notificationMessageContent__WEBPACK_IMPORTED_MODULE_13__["default"]) {
        return;
      }
      if (this.sharedConversationState.enableMessageMultiSelection) {
        _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].selectOrDeselectMessage(message);
        event.stopPropagation();
      }
    },
    hideConversationInfo() {
      // TODO
      // 是否在创建群聊，或者是在查看会话参与者信息
      this.showConversationInfo && (this.showConversationInfo = false);
    },
    isNotificationMessage(message) {
      return message && message.messageContent instanceof _wfc_messages_notification_notificationMessageContent__WEBPACK_IMPORTED_MODULE_13__["default"] && message.messageContent.type !== _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].RecallMessage_Notification && message.messageContent.type !== _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].Rich_Notification;
    },
    isContextableNotificationMessage(message) {
      return message && (message.messageContent instanceof _wfc_messages_notification_richNotificationMessageContent__WEBPACK_IMPORTED_MODULE_39__["default"] || message.messageContent instanceof _wfc_messages_articlesMessageContent__WEBPACK_IMPORTED_MODULE_42__["default"]);
    },
    isRecallNotificationMessage(message) {
      return message && message.messageContent.type === _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].RecallMessage_Notification;
    },
    isCancelable(message) {
      return message && message.messageContent instanceof _wfc_messages_mediaMessageContent__WEBPACK_IMPORTED_MODULE_41__["default"] && message.status === _wfc_messages_messageStatus__WEBPACK_IMPORTED_MODULE_40__["default"].Sending;
    },
    reedit(message) {
      this.$refs.messageInputView.insertText(message.messageContent.originalSearchableContent);
    },
    onScroll(e) {
      // hide tippy userCard
      for (const popper of document.querySelectorAll(".tippy-popper")) {
        const instance = popper._tippy;
        if (instance.state.isVisible) {
          instance.hide();
        }
      }
      // hide message context menu
      this.$refs.menu && this.$refs.menu.close();

      // 当用户往上滑动一段距离之后，收到新消息，不自动滚到到最后
      if (e.target.scrollHeight > e.target.clientHeight + e.target.scrollTop + e.target.clientHeight / 2) {
        _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].setShouldAutoScrollToBottom(false);
      } else {
        _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].setShouldAutoScrollToBottom(true);
        this.clearConversationUnreadStatus();
      }
    },
    dragStart() {
      this.isHandlerDragging = true;
      console.log("drag start");
    },
    drag(e) {
      // Don't do anything if dragging flag is false
      if (!this.isHandlerDragging) {
        return false;
      }

      // Get offset
      let containerOffsetTop = this.$refs["conversationContentContainer"].offsetTop;

      // Get x-coordinate of pointer relative to container
      let pointerRelativeYpos = e.clientY - containerOffsetTop;

      // Arbitrary minimum width set on box A, otherwise its inner content will collapse to width of 0
      let boxAminHeight = 150;

      // Resize box A
      // * 8px is the left/right spacing between .handler and its inner pseudo-element
      // * Set flex-grow to 0 to prevent it from growing
      this.$refs["conversationMessageList"].style.height = Math.max(boxAminHeight, pointerRelativeYpos) + "px";
      this.$refs["conversationMessageList"].style.flexGrow = 0;
      this.messageInputViewResized = true;
    },
    dragEnd() {
      this.isHandlerDragging = false;
    },
    onMenuClose() {
      this.$emit("contextMenuClosed");
    },
    onMessageSenderContextMenuClose() {
      console.log("onMessageSenderContextMenuClose");
    },
    // message context menu
    isCopyable(message) {
      return message && (message.messageContent instanceof _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_14__["default"] || message.messageContent instanceof _wfc_messages_imageMessageContent__WEBPACK_IMPORTED_MODULE_24__["default"] || (message.messageContent instanceof _wfc_messages_videoMessageContent__WEBPACK_IMPORTED_MODULE_28__["default"] || message.messageContent instanceof _wfc_messages_fileMessageContent__WEBPACK_IMPORTED_MODULE_23__["default"]) && this.isLocalFile(message));
    },
    isDownloadable(message) {
      return message && (message.messageContent instanceof _wfc_messages_imageMessageContent__WEBPACK_IMPORTED_MODULE_24__["default"] || message.messageContent instanceof _wfc_messages_fileMessageContent__WEBPACK_IMPORTED_MODULE_23__["default"] || message.messageContent instanceof _wfc_messages_videoMessageContent__WEBPACK_IMPORTED_MODULE_28__["default"]);
    },
    isForwardable(message) {
      if (message && message.messageContent instanceof _wfc_messages_soundMessageContent__WEBPACK_IMPORTED_MODULE_30__["default"]) {
        return false;
      }
      return true;
    },
    isFavable(message) {
      if (!message) {
        return false;
      }
      return [_wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].VOIP_CONTENT_TYPE_START, _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].CONFERENCE_CONTENT_TYPE_INVITE].indexOf(message.messageContent.type) <= -1;
    },
    isRecallable(message) {
      if (message) {
        if (message.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_33__["default"].Group) {
          let groupInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getGroupInfo(message.conversation.target);
          let selfUserId = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getUserId();
          if (groupInfo && groupInfo.owner === selfUserId) {
            return true;
          }
          let fromGroupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getGroupMember(message.conversation.target, message.from);
          let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getGroupMember(message.conversation.target, selfUserId);
          if (!fromGroupMember || !groupMember) {
            return false;
          }
          if (groupMember.type === _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_34__["default"].Manager && [_wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_34__["default"].Manager, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_34__["default"].Owner].indexOf(fromGroupMember.type) === -1) {
            return true;
          }
        }
        let delta = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getServerDeltaTime();
        let now = new Date().getTime();
        if (message.direction === 0 && now - (Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_17__["numberValue"])(message.timestamp) - delta) < 60 * 1000) {
          return true;
        }
      }
      return false;
    },
    isLocalFile(message) {
      if (message && Object(_platform__WEBPACK_IMPORTED_MODULE_22__["isElectron"])()) {
        let media = message.messageContent;
        let localPath = media.localPath;
        if (localPath) {
          return _platform__WEBPACK_IMPORTED_MODULE_22__["fs"].existsSync(localPath);
        }
      }
      return false;
    },
    isQuotable(message) {
      if (!message) {
        return false;
      }
      return [_wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].VOIP_CONTENT_TYPE_START, _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].Voice, _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].Video, _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].Composite_Message, _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].Articles, _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_31__["default"].CONFERENCE_CONTENT_TYPE_INVITE].indexOf(message.messageContent.type) <= -1;
    },
    copy(message) {
      let content = message.messageContent;
      if (content instanceof _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_14__["default"]) {
        let selectedText = window.getSelection().toString();
        if (selectedText) {
          Object(_ui_util_clipboard__WEBPACK_IMPORTED_MODULE_25__["copyText"])(selectedText);
        } else {
          Object(_ui_util_clipboard__WEBPACK_IMPORTED_MODULE_25__["copyText"])(content.content);
        }
      } else if (content instanceof _wfc_messages_imageMessageContent__WEBPACK_IMPORTED_MODULE_24__["default"]) {
        Object(_ui_util_clipboard__WEBPACK_IMPORTED_MODULE_25__["copyImg"])(content.remotePath);
      } else if (content instanceof _wfc_messages_mediaMessageContent__WEBPACK_IMPORTED_MODULE_41__["default"]) {
        if (Object(_platform__WEBPACK_IMPORTED_MODULE_22__["isElectron"])()) {
          _platform__WEBPACK_IMPORTED_MODULE_22__["ipcRenderer"].send(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_48___default.a.FILE_COPY, {
            path: content.localPath
          });
        }
      }
    },
    download(message) {
      if (!_store_js__WEBPACK_IMPORTED_MODULE_15__["default"].isDownloadingMessage(message.messageId)) {
        Object(_platformHelper__WEBPACK_IMPORTED_MODULE_27__["downloadFile"])(message);
        _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].addDownloadingMessage(message.messageId);
      } else {
        // TODO toast 下载中
        console.log("file isDownloading");
      }
    },
    openFile(message) {
      let file = message.messageContent;
      _platform__WEBPACK_IMPORTED_MODULE_22__["shell"].openItem(file.localPath);
    },
    openDir(message) {
      let file = message.messageContent;
      _platform__WEBPACK_IMPORTED_MODULE_22__["shell"].showItemInFolder(file.localPath);
    },
    recallMessage(message) {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].recallMessage(message.messageUid, null, null);
    },
    cancelMessage(message) {
      let canceled = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].cancelSendingMessage(message.messageId);
      if (!canceled) {
        this.$notify({
          text: "取消失败",
          type: "warn"
        });
      }
    },
    delMessage(message) {
      this.$alert({
        title: " 删除消息",
        content: "确定删除消息？",
        confirmText: "本地删除",
        cancelText: "远程删除",
        cancelCallback: () => {
          _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].deleteRemoteMessageByUid(message.messageUid, null, null);
        },
        confirmCallback: () => {
          _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].deleteMessage(message.messageId);
        }
      });
    },
    forward(message) {
      return this.$forwardMessage({
        forwardType: _main_conversation_message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_21__["default"].NORMAL,
        messages: [message]
      });
    },
    _forward(message) {
      this.forward(message).catch(reason => {
        // do nothing
        console.log("foward errro", reason);
      });
    },
    quoteMessage(message) {
      _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].quoteMessage(message);
    },
    // call from child
    favMessages(messages) {
      console.log("fav messages");
      let compositeMessageContent = new _wfc_messages_compositeMessageContent__WEBPACK_IMPORTED_MODULE_35__["default"]();
      let title = "";
      let msgConversation = messages[0].conversation;
      if (msgConversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_33__["default"].Single) {
        let users = _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].getUserInfos([_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getUserId(), msgConversation.target], "");
        title = users[0]._displayName + "和" + users[1]._displayName + "的聊天记录";
      } else {
        title = "群的聊天记录";
      }
      compositeMessageContent.title = title;
      compositeMessageContent.messages = messages;
      let message = new _wfc_messages_message__WEBPACK_IMPORTED_MODULE_26__["default"](msgConversation, compositeMessageContent);
      message.from = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getUserId();
      this.favMessage(message);
    },
    favMessage(message) {
      _api_appServerApi__WEBPACK_IMPORTED_MODULE_46__["default"].favMessage(message).then(() => {
        this.$notify({
          // title: '收藏成功',
          text: "收藏成功",
          type: "info"
        });
      }).catch(err => {
        console.log("fav error", err);
        this.$notify({
          // title: '收藏失败',
          text: "收藏失败",
          type: "error"
        });
      });
    },
    multiSelect(message) {
      this.toggleMessageMultiSelectionActionView(message);
    },
    infiniteHandler($state) {
      console.log("to load more message");
      _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].loadConversationHistoryMessages(() => {
        console.log("loaded");
        $state.loaded();
      }, () => {
        console.log("complete");
        $state.complete();
      });
    },
    playVoice(message) {
      if (amr) {
        amr.stop();
      }
      amr = new benz_amr_recorder__WEBPACK_IMPORTED_MODULE_32___default.a();
      let voice = message.messageContent;
      amr.initWithUrl(voice.remotePath).then(() => {
        message._isPlaying = true;
        amr.play();
      });
      amr.onEnded(() => {
        message._isPlaying = false;
        _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].playVoice(null);
        if (message.status === _wfc_messages_messageStatus__WEBPACK_IMPORTED_MODULE_40__["default"].Unread) {
          _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].updateMessageStatus(message.messageId, _wfc_messages_messageStatus__WEBPACK_IMPORTED_MODULE_40__["default"].Played);
        }
      });
    },
    mentionMessageSenderTitle(message) {
      if (!message) {
        return "";
      }
      let displayName = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getGroupMemberDisplayName(message.conversation.target, message.from);
      return "@" + displayName;
    },
    mentionMessageSender(message) {
      this.$refs.messageInputView.mention(message.conversation.target, message.from);
    },
    onReceiveMessage(message, hasMore) {
      console.log(hasMore);
      if (this.conversationInfo && this.conversationInfo.conversation.equal(message.conversation) && message.messageContent instanceof _wfc_av_messages_multiCallOngoingMessageContent__WEBPACK_IMPORTED_MODULE_37__["default"]) {
        // 自己是不是已经在通话中
        console.log("MultiCallOngoingMessageContent", message.messageContent);
        if (message.messageContent.targets.indexOf(_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getUserId()) >= 0) {
          return;
        }
        let index = this.ongoingCalls.findIndex(call => call.messageContent.callId === message.messageContent.callId);
        if (index > -1) {
          this.ongoingCalls[index] = message;
        } else {
          this.ongoingCalls.push(message);
        }
        if (!this.ongoingCallTimer) {
          this.ongoingCallTimer = setInterval(() => {
            this.ongoingCalls = this.ongoingCalls.filter(call => {
              return new Date().getTime() - (Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_17__["numberValue"])(call.timestamp) - Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_17__["numberValue"])(_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getServerDeltaTime())) < 3 * 1000;
            });
            if (this.ongoingCalls.length === 0) {
              clearInterval(this.ongoingCallTimer);
              this.ongoingCallTimer = 0;
            }
            console.log("ongoing calls", this.ongoingCalls.length);
          }, 1000);
        }
      }
    },
    joinMultiCall(message) {
      let request = new _wfc_av_messages_joinCallRequestMessageContent__WEBPACK_IMPORTED_MODULE_38__["default"](message.messageContent.callId, _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].getClientId());
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].sendConversationMessage(this.conversationInfo.conversation, request);
    },
    showUnreadMessage() {
      let messageListElement = this.$refs["conversationMessageList"];
      messageListElement.scroll({
        top: messageListElement.scrollHeight,
        left: 0,
        behavior: "auto"
      });
      this.unreadMessageCount = 0;
    },
    clearConversationUnreadStatus() {
      let info = this.sharedConversationState.currentConversationInfo;
      if (info.unreadCount.unread + info.unreadCount.unreadMention + info.unreadCount.unreadMentionAll > 0) {
        _store_js__WEBPACK_IMPORTED_MODULE_15__["default"].clearConversationUnreadStatus(info.conversation);
        // this.unreadMessageCount = 0;
      }
    }
  },
  mounted() {
    this.popupItem = this.$refs["setting"];
    document.addEventListener("mouseup", this.dragEnd);
    document.addEventListener("mousemove", this.drag);
    this.$on("openMessageContextMenu", (event, message) => {
      this.$refs.menu.open(event, message);
    });
    this.$on("openMessageSenderContextMenu", (event, message) => {
      // 目前只支持群会话里面，消息发送者右键@
      if (message.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_33__["default"].Group) {
        this.$refs.messageSenderContextMenu.open(event, message);
      }
    });
    this.$eventBus.$on("send-file", args => {
      let fileMessageContent = new _wfc_messages_fileMessageContent__WEBPACK_IMPORTED_MODULE_23__["default"](null, args.remoteUrl, args.name, args.size);
      let message = new _wfc_messages_message__WEBPACK_IMPORTED_MODULE_26__["default"](null, fileMessageContent);
      this.forward(message);
    });
    this.$eventBus.$on("forward-fav", args => {
      let favItem = args.favItem;
      let message = favItem.toMessage();
      this.forward(message);
    });
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].eventEmitter.on(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_36__["default"].ReceiveMessage, this.onReceiveMessage);
  },
  beforeDestroy() {
    document.removeEventListener("mouseup", this.dragEnd);
    document.removeEventListener("mousemove", this.drag);
    this.$eventBus.$off("send-file");
    this.$eventBus.$off("forward-fav");
    this.$off("openMessageContextMenu");
    this.$off("openMessageSenderContextMenu");
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].eventEmitter.removeListener(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_36__["default"].ReceiveMessage, this.onReceiveMessage);
  },
  updated() {
    if (!this.sharedConversationState.currentConversationInfo) {
      return;
    }
    this.popupItem = this.$refs["setting"];
    // refer to http://iamdustan.com/smoothscroll/
    console.log("conversationView updated", this.sharedConversationState.currentConversationInfo, this.sharedConversationState.shouldAutoScrollToBottom, this.sharedMiscState.isPageHidden);
    if (this.sharedConversationState.shouldAutoScrollToBottom && !this.sharedMiscState.isPageHidden) {
      let messageListElement = this.$refs["conversationMessageList"];
      messageListElement.scroll({
        top: messageListElement.scrollHeight,
        left: 0,
        behavior: "auto"
      });
      this.clearConversationUnreadStatus();
    } else {
      // 用户滑动到上面之后，收到新消息，不自动滑动到最下面
    }
    if (this.sharedConversationState.currentConversationInfo) {
      let unreadCount = this.sharedConversationState.currentConversationInfo.unreadCount;
      if (unreadCount.unread > 0) {
        if (this.sharedMiscState.isPageHidden) {
          this.unreadMessageCount = unreadCount.unread;
        }
      } else {
        this.unreadMessageCount = 0;
      }
    }

    // 切换到新的会话
    if (this.conversationInfo && this.sharedConversationState.currentConversationInfo && !this.conversationInfo.conversation.equal(this.sharedConversationState.currentConversationInfo.conversation)) {
      this.showConversationInfo = false;
      this.ongoingCalls = null;
      if (this.ongoingCallTimer) {
        clearInterval(this.ongoingCallTimer);
        this.ongoingCallTimer = 0;
      }
    }
    this.conversationInfo = this.sharedConversationState.currentConversationInfo;
  },
  computed: {
    conversationTitle() {
      if (this.title) {
        return this.title;
      }
      let info = this.sharedConversationState.currentConversationInfo;
      if (info.conversation._target) {
        if (info.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_33__["default"].Group) {
          return info.conversation._target._displayName + " (" + info.conversation._target.memberCount + ")";
        } else {
          return info.conversation._target._displayName;
        }
      } else {
        return "会话";
      }
    },
    targetUserOnlineStateDesc() {
      let msg = "";
      let info = this.sharedConversationState.currentConversationInfo;
      if (info.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_33__["default"].Single && info.conversation.target !== _config__WEBPACK_IMPORTED_MODULE_47__["default"].FILE_HELPER_ID) {
        if (!_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_16__["default"].isMyFriend(info.conversation.target)) {
          msg = "你们还不是好友，点击添加好友";
        }
        if (info.conversation._target.type === 0) {
          msg = info.conversation._targetOnlineStateDesc;
        } else if (info.conversation._target.type === 1) {
          msg = "bot";
        }
      } else if (info.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_33__["default"].Channel) {
        let desc = info.conversation._target.desc;
        if (!desc) {
          desc = "channel";
        }
        msg = desc;
      } else {
        msg = "";
      }
      return msg;
    },
    loadingIdentifier() {
      let conversation = this.sharedConversationState.currentConversationInfo.conversation;
      return conversation.type + "-" + conversation.target + "-" + conversation.line;
    },
    currentVoiceMessage() {
      let voice = this.sharedConversationState.currentVoiceMessage;
      if (voice) {
        this.playVoice(voice);
      } else {
        if (amr) {
          amr.stop();
        }
      }
      return null;
    }
  },
  // watch: {
  //     conversationInfo() {
  //         console.log('conversationInfo changed', this.conversationInfo);
  //     }
  // },

  directives: {
    ClickOutside: (vue_click_outside__WEBPACK_IMPORTED_MODULE_8___default())
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/GroupConversationInfoView.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/GroupConversationInfoView.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _user_UserListView_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../user/UserListView.vue */ "./src/ui/main/user/UserListView.vue");
/* harmony import */ var _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/model/conversationInfo */ "./src/wfc/model/conversationInfo.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../wfc/model/groupMemberType */ "./src/wfc/model/groupMemberType.js");
/* harmony import */ var _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../wfc/model/groupType */ "./src/wfc/model/groupType.js");
/* harmony import */ var _wfc_model_modifyGroupInfoType__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../wfc/model/modifyGroupInfoType */ "./src/wfc/model/modifyGroupInfoType.js");
/* harmony import */ var _wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../wfc/client/wfcEvent */ "./src/wfc/client/wfcEvent.js");
/* harmony import */ var _api_appServerApi__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../api/appServerApi */ "./src/api/appServerApi.js");
/* harmony import */ var _wfc_messages_messageContentMediaType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../wfc/messages/messageContentMediaType */ "./src/wfc/messages/messageContentMediaType.js");












/* harmony default export */ __webpack_exports__["default"] = ({
  name: "GroupConversationInfoView",
  props: {
    conversationInfo: {
      type: _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_3__["default"],
      required: true
    }
  },
  data() {
    return {
      groupMemberUserInfos: _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].getConversationMemberUsrInfos(this.conversationInfo.conversation),
      filterQuery: "",
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].state.contact,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].state.misc,
      groupAnnouncement: "",
      newGroupName: "",
      newGroupAnnouncement: "",
      newGroupAlias: "",
      groupAlias: ""
    };
  },
  mounted() {
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].eventEmitter.on(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_9__["default"].UserInfosUpdate, this.onUserInfosUpdate);
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].eventEmitter.on(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_9__["default"].GroupMembersUpdate, this.onUserInfosUpdate);
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getGroupMembers(this.conversationInfo.conversation.target, true);
    let userInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getUserInfo(_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getUserId(), false, this.conversationInfo.conversation.target);
    this.groupAlias = userInfo.groupAlias ? userInfo.groupAlias : userInfo.displayName;
  },
  beforeDestroy() {
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].eventEmitter.removeListener(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_9__["default"].UserInfosUpdate, this.onUserInfosUpdate);
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].eventEmitter.removeListener(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_9__["default"].GroupMembersUpdate, this.onUserInfosUpdate);
  },
  components: {
    UserListView: _user_UserListView_vue__WEBPACK_IMPORTED_MODULE_2__["default"]
  },
  methods: {
    onUserInfosUpdate() {
      this.groupMemberUserInfos = _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].getConversationMemberUsrInfos(this.conversationInfo.conversation);
    },
    showCreateConversationModal() {
      let successCB = users => {
        let ids = users.map(u => u.uid);
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].addGroupMembers(this.conversationInfo.conversation.target, ids, null, [0]);
      };
      let groupMemberUserInfos = _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].getGroupMemberUserInfos(this.conversationInfo.conversation.target, false);
      this.$pickContact({
        successCB,
        initialCheckedUsers: groupMemberUserInfos,
        uncheckableUsers: groupMemberUserInfos,
        confirmTitle: this.$t("common.add")
      });
    },
    showRemoveGroupMemberModal() {
      let successCB = users => {
        let ids = users.map(u => u.uid);
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].kickoffGroupMembers(this.conversationInfo.conversation.target, ids, [0]);
      };
      let groupMemberUserInfos = _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].getGroupMemberUserInfos(this.conversationInfo.conversation.target, false, false);
      this.$pickContact({
        successCB,
        users: groupMemberUserInfos
      });
    },
    showUserInfo(user) {
      console.log("todo show userInfo", user);
    },
    async getGroupAnnouncement() {
      _api_appServerApi__WEBPACK_IMPORTED_MODULE_10__["default"].getGroupAnnouncement(this.conversationInfo.conversation.target).then(response => {
        if (response.text) {
          this.groupAnnouncement = response.text;
        }
      }).catch(err => {
        console.log("getGroupAnnouncement", err);
        if (this.enableEditGroupNameOrAnnouncement) {
          this.groupAnnouncement = this.$t("conversation.click_to_edit_group_announcement");
        }
      });
    },
    updateGroupName() {
      let groupId = this.conversationInfo.conversation.target;
      if (!this.newGroupName || this.newGroupName === this.conversationInfo.conversation._target._displayName) {
        return;
      }
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].modifyGroupInfo(groupId, _wfc_model_modifyGroupInfoType__WEBPACK_IMPORTED_MODULE_8__["default"].Modify_Group_Name, this.newGroupName, [0], null, () => {
        this.conversationInfo.conversation._target._displayName = this.newGroupName;
        this.$refs.groupNameInput.blur();
      }, err => {
        // do nothing
      });
    },
    async updateGroupAnnouncement() {
      if (!this.newGroupAnnouncement || this.newGroupAnnouncement === this.groupAnnouncement) {
        return;
      }
      await _api_appServerApi__WEBPACK_IMPORTED_MODULE_10__["default"].updateGroupAnnouncement(_wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getUserId(), this.conversationInfo.conversation.target, this.newGroupAnnouncement);
      this.groupAnnouncement = this.newGroupAnnouncement;
      this.$refs.groupAnnouncementInput.blur();
    },
    updateGroupAlias() {
      if (this.newGroupAlias && this.newGroupAlias !== this.groupAlias) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].modifyGroupAlias(this.conversationInfo.conversation.target, this.newGroupAlias, [0], null, () => {
          this.groupAlias = this.newGroupAlias;
        }, null);
      }
    },
    quitGroup() {
      this.$alert({
        title: "退出群组",
        content: "确定退出群组？",
        confirmText: "确定",
        cancelText: "取消",
        cancelCallback: () => {
          // do nothing
        },
        confirmCallback: () => {
          _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].quitGroup(this.conversationInfo.conversation.target);
        }
      });
    },
    dismissGroup() {
      this.$alert({
        title: "解散群组",
        content: "确定解散群组？",
        confirmText: "确定",
        cancelText: "取消",
        cancelCallback: () => {
          // do nothing
        },
        confirmCallback: () => {
          _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].dismissGroup(this.conversationInfo.conversation.target);
        }
      });
    },
    setFavGroup(groupId, fav) {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].setFavGroup(groupId, fav, () => {
        this.conversationInfo.conversation._target._isFav = fav;
        _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].reloadFavGroupList();
      }, err => {
        console.log("setFavGroup error", err);
      });
    },
    pickFile() {
      if (!this.enableEditGroupNameOrAnnouncement) {
        this.$notify({
          text: "群主或管理员，才能更新头像",
          type: "warn"
        });
        return;
      }
      this.$refs["fileInput"].click();
    },
    onPickFile(event) {
      let file = event.target.files[0];
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].uploadMedia(file.name, file, _wfc_messages_messageContentMediaType__WEBPACK_IMPORTED_MODULE_11__["default"].Portrait, url => {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].modifyGroupInfo(this.conversationInfo.conversation.target, _wfc_model_modifyGroupInfoType__WEBPACK_IMPORTED_MODULE_8__["default"].Modify_Group_Portrait, url, [], null, () => {
          console.log("modify group portrait success", url);
        }, err => {
          console.log("err", err);
        });
      }, err => {
        console.log("update media error", err);
      }, (p, t) => {});
    },
    clearConversationHistory() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].clearMessages(this.conversationInfo.conversation);
    },
    clearRemoteConversationHistory() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].clearRemoteConversationMessages(this.conversationInfo.conversation);
    }
  },
  created() {
    this.getGroupAnnouncement();
  },
  computed: {
    enableQuitGroup() {
      let groupInfo = this.conversationInfo.conversation._target;
      if (groupInfo.type === _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_7__["default"].Organization) {
        return false;
      }
      return true;
    },
    clickGroupMemberItemFunc() {
      let groupInfo = this.conversationInfo.conversation._target;
      let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getGroupMember(this.conversationInfo.conversation.target, _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getUserId());
      if (groupInfo.privateChat === 1 && [_wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__["default"].Manager, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__["default"].Owner].indexOf(groupMember.type) === -1) {
        return () => {
          // 群里面，禁止发起私聊
        };
      }
      return null;
    },
    enableDismissGroup() {
      let groupInfo = this.conversationInfo.conversation._target;
      if (groupInfo.type === _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_7__["default"].Organization) {
        return false;
      }
      if (groupInfo.owner === _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getUserId()) {
        return true;
      }
      return false;
    },
    enableAddGroupMember() {
      let selfUid = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getUserId();
      let groupInfo = this.conversationInfo.conversation._target;
      if (groupInfo.type === _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_7__["default"].Organization) {
        return false;
      }
      //在group type为Restricted时，0 开放加入权限（群成员可以拉人，用户也可以主动加入）；1 只能群成员拉人入群；2 只能群管理拉人入群
      if (groupInfo.type === _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_7__["default"].Restricted) {
        if (groupInfo.joinType === 0 || groupInfo.joinType === 1) {
          return true;
        } else if (groupInfo.joinType === 2) {
          let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getGroupMember(this.conversationInfo.conversation.target, selfUid);
          return [_wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__["default"].Manager, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__["default"].Owner].indexOf(groupMember.type) >= 0;
        }
      }
      return true;
    },
    enableRemoveGroupMember() {
      let groupInfo = this.conversationInfo.conversation._target;
      if (groupInfo.type === _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_7__["default"].Organization) {
        return false;
      }
      let selfUid = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getUserId();
      let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getGroupMember(this.conversationInfo.conversation.target, selfUid);
      if (groupMember) {
        return [_wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__["default"].Manager, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__["default"].Owner].indexOf(groupMember.type) >= 0;
      }
      return false;
    },
    enableEditGroupNameOrAnnouncement() {
      let groupInfo = this.conversationInfo.conversation._target;
      if (groupInfo.type === _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_7__["default"].Organization) {
        return false;
      }
      let selfUid = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getUserId();
      let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].getGroupMember(this.conversationInfo.conversation.target, selfUid);
      if (groupMember) {
        return [_wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__["default"].Manager, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_6__["default"].Owner].indexOf(groupMember.type) >= 0;
      }
      return false;
    },
    users() {
      if (this.filterQuery) {
        return _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].filterUsers(this.groupMemberUserInfos, this.filterQuery);
      } else {
        return this.groupMemberUserInfos;
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/MessageInputView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/MessageInputView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.url-search-params.delete.js */ "./node_modules/core-js/modules/web.url-search-params.delete.js");
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/web.url-search-params.has.js */ "./node_modules/core-js/modules/web.url-search-params.has.js");
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.url-search-params.size.js */ "./node_modules/core-js/modules/web.url-search-params.size.js");
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../wfc/messages/textMessageContent */ "./src/wfc/messages/textMessageContent.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _imndx_v_emoji_picker__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @imndx/v-emoji-picker */ "./node_modules/@imndx/v-emoji-picker/lib/v-emoji-picker.esm.js");
/* harmony import */ var vue_click_outside__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! vue-click-outside */ "./node_modules/vue-click-outside/index.js");
/* harmony import */ var vue_click_outside__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(vue_click_outside__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var tributejs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tributejs */ "./node_modules/tributejs/dist/tribute.min.js");
/* harmony import */ var tributejs__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(tributejs__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _tribute_css__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../tribute.css */ "./src/tribute.css");
/* harmony import */ var _tribute_css__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_tribute_css__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../../wfc/model/conversationInfo */ "./src/wfc/model/conversationInfo.js");
/* harmony import */ var _wfc_model_groupInfo__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../../wfc/model/groupInfo */ "./src/wfc/model/groupInfo.js");
/* harmony import */ var _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../../wfc/model/groupMemberType */ "./src/wfc/model/groupMemberType.js");
/* harmony import */ var _wfc_model_quoteInfo__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../../wfc/model/quoteInfo */ "./src/wfc/model/quoteInfo.js");
/* harmony import */ var _util_draft__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../util/draft */ "./src/ui/util/draft.js");
/* harmony import */ var _wfc_model_mention__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../../wfc/model/mention */ "./src/wfc/model/mention.js");
/* harmony import */ var _util_emoji__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../util/emoji */ "./src/ui/util/emoji.js");
/* harmony import */ var _main_conversation_message_QuoteMessageView__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../main/conversation/message/QuoteMessageView */ "./src/ui/main/conversation/message/QuoteMessageView.vue");
/* harmony import */ var _ui_util_imageUtil__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @/ui/util/imageUtil */ "./src/ui/util/imageUtil.js");
/* harmony import */ var _wfc_messages_stickerMessageContent__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../../wfc/messages/stickerMessageContent */ "./src/wfc/messages/stickerMessageContent.js");
/* harmony import */ var _main_conversation_EmojiAndStickerConfig__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../main/conversation/EmojiAndStickerConfig */ "./src/ui/main/conversation/EmojiAndStickerConfig.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _ui_util_clipboard__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @/ui/util/clipboard */ "./src/ui/util/clipboard.js");
/* harmony import */ var _wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../../wfc/client/wfcEvent */ "./src/wfc/client/wfcEvent.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @/wfc/ipcEventType */ "./src/wfc/ipcEventType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var _ChannelMenuView__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./ChannelMenuView */ "./src/ui/main/conversation/ChannelMenuView.vue");
/* harmony import */ var _ipc_ipcSub__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../../../ipc/ipcSub */ "./src/ipc/ipcSub.js");
/* harmony import */ var _wfc_ptt_client_pttClient__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../../../wfc/ptt/client/pttClient */ "./src/wfc/ptt/client/pttClient.js");
/* harmony import */ var _wfc_ptt_client_talkingCallback__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../../wfc/ptt/client/talkingCallback */ "./src/wfc/ptt/client/talkingCallback.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../../config */ "./src/config.js");
/* harmony import */ var _wfc_messages_soundMessageContent__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../../../wfc/messages/soundMessageContent */ "./src/wfc/messages/soundMessageContent.js");
/* harmony import */ var benz_amr_recorder__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! benz-amr-recorder */ "./node_modules/benz-amr-recorder/BenzAMRRecorder.js");
/* harmony import */ var benz_amr_recorder__WEBPACK_IMPORTED_MODULE_36___default = /*#__PURE__*/__webpack_require__.n(benz_amr_recorder__WEBPACK_IMPORTED_MODULE_36__);
/* harmony import */ var _wfc_messages_typingMessageContent__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../../../wfc/messages/typingMessageContent */ "./src/wfc/messages/typingMessageContent.js");







































/* harmony default export */ __webpack_exports__["default"] = ({
  name: "MessageInputView",
  props: {
    conversationInfo: {
      type: _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_15__["default"],
      required: true,
      default: null
    },
    inputOptions: {
      type: Object,
      required: false,
      default: () => ({})
    }
  },
  data() {
    return {
      sharedConversationState: _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].state.conversation,
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].state.contact,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].state.misc,
      showEmojiDialog: false,
      tribute: null,
      mentions: [],
      emojiCategories: _imndx_v_emoji_picker__WEBPACK_IMPORTED_MODULE_10__["categoriesDefault"],
      emojis: _imndx_v_emoji_picker__WEBPACK_IMPORTED_MODULE_10__["emojisDefault"],
      lastConversationInfo: null,
      storeDraftIntervalId: 0,
      tributeReplaced: false,
      enablePtt: false,
      // enablePtt: wfc.isCommercialServer() && Config.ENABLE_PTT,
      amrRecorder: null,
      lastTypingMessageTimestamp: 0
    };
  },
  methods: {
    onTributeReplaced(e) {
      // 正常下面这两行应当就生效了，不知道为啥不生效，所以采用了后面的 trick
      e.detail.event.preventDefault();
      e.detail.event.stopPropagation();
      this.tributeReplaced = true;
    },
    canisend() {
      let target = this.conversationInfo.conversation._target;
      if (target instanceof _wfc_model_groupInfo__WEBPACK_IMPORTED_MODULE_16__["default"]) {
        let groupInfo = target;
        let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].getGroupMember(groupInfo.target, _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].getUserId());
        if (groupInfo.mute === 1) {
          return [_wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Owner, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Manager, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Allowed].indexOf(groupMember.type) >= 0 || groupMember.type === _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Allowed;
        }
      }
      return true;
    },
    cancelQuoteMessage() {
      this.conversationInfo._quotedMessage = null;
      _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].quoteMessage(null);
    },
    onInput(e) {
      this.notifyTyping(_wfc_messages_typingMessageContent__WEBPACK_IMPORTED_MODULE_37__["default"].TYPING_TEXT);
    },
    notifyTyping(type) {
      if ([_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_14__["default"].Single, _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_14__["default"].Group].indexOf(this.conversationInfo.conversation.type) >= 0) {
        let now = new Date().getTime();
        if (now - this.lastTypingMessageTimestamp > 10 * 1000) {
          let typing = new _wfc_messages_typingMessageContent__WEBPACK_IMPORTED_MODULE_37__["default"](type);
          _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].sendConversationMessage(this.conversationInfo.conversation, typing);
          this.lastTypingMessageTimestamp = now;
        }
      }
    },
    async handlePaste(e, source) {
      let text;
      e.preventDefault();
      if ((e.originalEvent || e).clipboardData) {
        text = (e.originalEvent || e).clipboardData.getData("text/plain");
      } else {
        text = await navigator.clipboard.readText();
      }
      console.log("handlePaste", e, source);
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_26__["isElectron"])() && false) {
        let args = _platform__WEBPACK_IMPORTED_MODULE_26__["ipcRenderer"].sendSync(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_29___default.a.FILE_PASTE);
        if (args.hasImage) {
          document.execCommand("insertText", false, " ");
          document.execCommand("insertImage", false, "local-resource://" + args.filename);
          return;
        } else if (args.hasFile) {
          args.files.forEach(file => {
            _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].sendFile(this.conversationInfo.conversation, file);
          });
          return;
        }
      } else {
        const dT = e.clipboardData || window.clipboardData;
        if (dT) {
          let fileList = dT.files;
          if (fileList.length > 0) {
            for (let i = 0; i < fileList.length; i++) {
              let file = fileList.item(i);
              console.log("handle paste file", file);
              if (file.type.indexOf("image") !== -1) {
                // image
                document.execCommand("insertImage", false, URL.createObjectURL(file));
              } else {
                // file
                if (Object(_platform__WEBPACK_IMPORTED_MODULE_26__["isElectron"])()) {
                  if (_platform__WEBPACK_IMPORTED_MODULE_26__["fs"].lstatSync(file.path).isDirectory()) {
                    this.$notify({
                      // title: '不支持',
                      message: this.$t("conversation.not_support_send_folder"),
                      type: "warn"
                    });
                    break;
                  }
                } else {
                  // TODO 浏览器端，不能判断是否是文件夹
                  if (file.size < 1024 && file.type === "") {
                    this.$notify({
                      // title: '不支持',
                      message: this.$t("conversation.not_support_send_such_file"),
                      type: "warn"
                    });
                    break;
                  }
                }
                _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].sendFile(this.conversationInfo.conversation, file);
              }
            }
            return;
          }
        } else {
          const clipboardContents = await navigator.clipboard.read();
          for (const item of clipboardContents) {
            console.log("clipboard item", item.types, item);
            if (item.types.includes("image/png")) {
              const blob = await item.getType("image/png");
              document.execCommand("insertImage", false, URL.createObjectURL(blob));
              return;
            }
          }
        }
      }
      if (text && text.trim()) {
        document.execCommand("insertText", false, text);
        // Safari 浏览器 execCommand 失效，可以采用下面这种方式处理粘贴
        // this.$refs.input.innerText += text;
      }
    },
    mention(groupId, memberId) {
      let displayName = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].getGroupMemberDisplayName(groupId, memberId);
      this.mentions.push({
        key: displayName,
        value: "@" + memberId
      });
      let text = this.$refs.input.innerText;
      let mentionValue;
      if (text.endsWith(" ")) {
        mentionValue = "@" + displayName + " ";
      } else {
        mentionValue = " @" + displayName + " ";
      }
      document.execCommand("insertText", false, mentionValue);
    },
    insertText(text) {
      // this.$refs['input'].innerText = text;
      this.$refs.input.focus();
      document.execCommand("insertText", false, text);
    },
    copy() {
      let text = this.$refs["input"].innerText;
      if (text) {
        Object(_ui_util_clipboard__WEBPACK_IMPORTED_MODULE_27__["copyText"])(text);
      }
    },
    cut() {
      this.copy();
      this.$refs["input"].innerHTML = "";
    },
    async send(e) {
      console.log("send", e);
      if (this.tribute && this.tribute.isActive) {
        this.tributeReplaced = false;
        return;
      }

      // let text = this.$refs['input'].textContent;
      // if (!text.trim()) {
      //   return;
      // }
      // this.$refs['input'].textContent = '';
      // // 发送消息时，会话消息列表需要滚动到最后
      // store.setShouldAutoScrollToBottom(true)
      //
      // let textMessageContent = this.handleMention(text)
      // let conversation = this.conversationInfo.conversation;
      // wfc.sendConversationMessage(conversation, textMessageContent);
      //

      let input = this.$refs["input"];
      let message = input.innerHTML.trim();
      let conversation = this.conversationInfo.conversation;
      if (!conversation || !this.canisend() || !message) return;
      if (e.ctrlKey) {
        // e.preventDefault();
        // this.refs.input.innerHTML = this.refs.input.innerHTML+ "<div><br></div>";
        if (window.getSelection) {
          let nextChar = window.getSelection().focusNode.textContent.charAt(window.getSelection().focusOffset);
          if (!nextChar) {
            document.execCommand("InsertHTML", true, "<br>");
          }
          let selection = window.getSelection(),
            range = selection.getRangeAt(0),
            br = document.createElement("br");
          range.deleteContents();
          range.insertNode(br);
          range.setStartAfter(br);
          range.setEndAfter(br);
          // range.collapse(false);
          selection.removeAllRanges();
          selection.addRange(range);
          // return false;
        }
        return;
      }

      // if(!message.startsWith('<')){
      //     message = message.replace(/<br>/g, '\n').trim()
      // }

      let imgs = [...input.getElementsByTagName("img")];
      if (imgs) {
        for (const img of imgs) {
          if (img.className.indexOf("emoji") >= 0) {
            continue;
          }
          let src = img.src;
          let file;
          // 截图
          if (Object(_platform__WEBPACK_IMPORTED_MODULE_26__["isElectron"])() && src.startsWith("local-resource")) {
            // 'local-resource://' + 绝对路径
            file = decodeURI(src.substring(17, src.length));
          } else {
            if (src.startsWith("blob:")) {
              let blob = await fetch(src).then(r => r.blob());
              file = new File([blob], new Date().getTime() + ".png");
            } else {
              file = Object(_ui_util_imageUtil__WEBPACK_IMPORTED_MODULE_23__["fileFromDataUri"])(src, new Date().getTime() + ".png");
            }
          }
          this.$eventBus.$emit("uploadFile", file);
          _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].setShouldAutoScrollToBottom(true);
          _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].sendFile(this.conversationInfo.conversation, file);
          // 会影响 input.getElementsByTagName 返回的数组，所以上面拷贝了一下
          img.parentNode.removeChild(img);
        }
      }
      message = input.innerHTML.trim();
      message = message.replace(/<br>/g, "\n").replace(/<div>/g, "\n").replace(/<\/div>/g, "").replace(/<b>/g, "").replace(/<\/b>/g, "").replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&nbsp;/g, " ").replace(/&amp;/g, "&");

      //  自行部署表情时，需要手动替换下面的正则
      // TODO 在正则中使用变量，避免手动替换
      let p = `" src="${_config__WEBPACK_IMPORTED_MODULE_34__["default"].emojiBaseUrl()}72x72\\/[0-9a-z-]+\\.png">`;
      let re = new RegExp(p, "g");
      message = message.replace(/<img class="emoji" draggable="false" alt="/g, "").replace(re, "");
      if (message && message.trim()) {
        let textMessageContent = this.handleMention(message);
        let quotedMessage = this.sharedConversationState.quotedMessage;
        if (quotedMessage) {
          let quoteInfo = _wfc_model_quoteInfo__WEBPACK_IMPORTED_MODULE_18__["default"].initWithMessage(quotedMessage);
          textMessageContent.setQuoteInfo(quoteInfo);
        }
        _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].setShouldAutoScrollToBottom(true);
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].sendConversationMessage(conversation, textMessageContent);
        this.$refs["input"].innerHTML = "";
      }
      input.innerHTML = "";
      _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].quoteMessage(null);
      this.conversationInfo._quotedMessage = null;
      _util_draft__WEBPACK_IMPORTED_MODULE_19__["default"].setConversationDraft(conversation, "", null, null);
      e.preventDefault();
    },
    toggleEmojiView() {
      this.showEmojiDialog = !this.showEmojiDialog;
      this.focusInput();
    },
    screenShot(hideCurrentWindow = false) {
      if (hideCurrentWindow) {
        _platform__WEBPACK_IMPORTED_MODULE_26__["currentWindow"].hide();
      }
      console.log("screenShot", hideCurrentWindow);
      _platform__WEBPACK_IMPORTED_MODULE_26__["ipcRenderer"].send(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_29___default.a.START_SCREEN_SHOT, {});
    },
    showMessageHistory() {
      let hash = window.location.hash;
      let url = window.location.origin;
      if (hash) {
        url = window.location.href.replace(hash, "#/conversation-message-history");
      } else {
        url += "/conversation-message-history";
      }
      let conversation = this.conversationInfo.conversation;
      _platform__WEBPACK_IMPORTED_MODULE_26__["ipcRenderer"].send(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_29___default.a.showConversationMessageHistoryPage, {
        url: url,
        type: conversation.type,
        target: conversation.target,
        line: conversation.line
      });
      console.log(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_29___default.a.showConversationMessageHistoryPage, url);
    },
    hideEmojiView(e) {
      if (e.target.id !== "showEmoji") {
        this.showEmojiDialog = false;
      }
    },
    onSelectEmoji(emoji) {
      this.showEmojiDialog = false;
      if (emoji.data.indexOf("http") >= 0) {
        let sticker = new _wfc_messages_stickerMessageContent__WEBPACK_IMPORTED_MODULE_24__["default"]("", emoji.data, 200, 200);
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].sendConversationMessage(this.conversationInfo.conversation, sticker);
        return;
      }
      this.$refs.input.focus();
      this.insertHTML(Object(_util_emoji__WEBPACK_IMPORTED_MODULE_21__["parser"])(emoji.data));
      this.focusInput();
    },
    createElementFromHTML(htmlString) {
      let div = document.createElement("div");
      div.innerHTML = htmlString.trim();

      // Change this to div.childNodes to support multiple top-level nodes
      return div.firstChild;
    },
    insertHTML(html) {
      let sel, range;
      if (window.getSelection && (sel = window.getSelection())) {
        range = sel.getRangeAt(0);
        range.collapse(true);
        let imgEmoji = this.createElementFromHTML(html);
        range.insertNode(imgEmoji);

        // Move the caret immediately after the inserted span
        range.setStartAfter(imgEmoji);
        range.collapse(true);
        sel.removeAllRanges();
        sel.addRange(range);
      } else if (document.selection && document.selection.createRange) {
        document.selection.createRange().text = html;
      }
    },
    pickFile() {
      this.$refs["fileInput"].click();
      this.notifyTyping(_wfc_messages_typingMessageContent__WEBPACK_IMPORTED_MODULE_37__["default"].TYPING_FILE);
    },
    startAudioCall() {
      console.log(`startAudioCall from mainWindow ${this.sharedMiscState.isMainWindow}`);
      let conversation = this.conversationInfo.conversation;
      if (this.sharedMiscState.isMainWindow) {
        this.$startVoipCall({
          audioOnly: true,
          conversation: conversation
        });
      } else {
        _ipc_ipcSub__WEBPACK_IMPORTED_MODULE_31__["default"].startVoipCall(conversation, true);
      }
    },
    startVideoCall() {
      console.log(`startVideoCall from mainWindow ${this.sharedMiscState.isMainWindow}`);
      let conversation = this.conversationInfo.conversation;
      if (this.sharedMiscState.isMainWindow) {
        this.$startVoipCall({
          audioOnly: false,
          conversation: conversation
        });
      } else {
        _ipc_ipcSub__WEBPACK_IMPORTED_MODULE_31__["default"].startVoipCall(conversation, false);
      }
    },
    toggleChannelMenu(toggle = true) {
      if (toggle) {
        this.$parent.$refs["conversationMessageList"].style.flexGrow = 1;
        this.storeDraft(this.lastConversationInfo);
      } else {
        if (this.$parent.messageInputViewResized) {
          this.$parent.$refs["conversationMessageList"].style.flexGrow = 0;
        }
      }
      _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].toggleChannelMenu(toggle);
    },
    onPickFile(event) {
      // this.batchProcess(e.target.files[0]);
      console.log("onPickFile", event.target.files[0]);
      let file = event.target.files[0];
      event.target.value = "";

      // TODO
      // var showMessage = snackbar.showMessage;
      //
      // if (!file || file.size === 0) {
      //   showMessage('You can\'t send an empty file.');
      //   return false;
      // }
      //
      // if (!file
      //     || file.size >= 100 * 1024 * 1024) {
      //   showMessage('Send file not allowed to exceed 100M.');
      //   return false;
      // }
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_26__["isElectron"])()) {
        if (new Date().getTime() - file.lastModified < 30 * 1000 && file.path.indexOf("/var/folders") === 0) {
          console.log("not support file", file);
          this.$notify({
            message: " 不支持的文件类型",
            type: "warn"
          });
          return;
        }
      }
      this.$eventBus.$emit("uploadFile", file);
      _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].sendFile(this.conversationInfo.conversation, file);
    },
    initEmojiPicker() {
      window.__twemoji_base_url__ = _config__WEBPACK_IMPORTED_MODULE_34__["default"].emojiBaseUrl();
      let config = Object(_main_conversation_EmojiAndStickerConfig__WEBPACK_IMPORTED_MODULE_25__["config"])();
      if (this.conversationInfo.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_14__["default"].SecretChat) {
        this.emojiCategories = config.emojiCategories.filter(c => !c.name.startsWith("Sticker"));
        this.emojis = config.emojis.filter(c => !c.category.startsWith("Sticker"));
        this.$refs.emojiPicker.changeCategory({
          name: "Peoples"
        });
      } else {
        this.emojiCategories = config.emojiCategories;
        this.emojis = config.emojis;
      }
    },
    initMention(conversation) {
      // TODO group, channel

      if (this.tribute) {
        this.tribute.detach(this.$refs["input"]);
        this.tribute = null;
      }
      let type = conversation.conversationType;
      if (type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_14__["default"].Single || type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_14__["default"].ChatRoom || type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_14__["default"].Channel) {
        return;
      }
      let mentionMenuItems = [];
      let groupInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].getGroupInfo(conversation.target);
      mentionMenuItems.push({
        key: this.$t("conversation.all_people"),
        value: "@" + conversation.target,
        avatar: groupInfo.portrait ? groupInfo.portrait : _config__WEBPACK_IMPORTED_MODULE_34__["default"].DEFAULT_GROUP_PORTRAIT_URL,
        //searchKey: '所有人' + pinyin.letter('所有人', '', null)
        searchKey: this.$t("conversation.all_people") + "suoyouren" + "syr"
      });
      let groupMemberUserInfos = _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].getGroupMemberUserInfos(conversation.target, false);
      groupMemberUserInfos.forEach(e => {
        mentionMenuItems.push({
          key: e._displayName,
          value: "@" + e.uid,
          avatar: e.portrait,
          searchKey: e._displayName + e._pinyin + e._firstLetters
        });
      });
      this.tribute = new tributejs__WEBPACK_IMPORTED_MODULE_12___default.a({
        values: mentionMenuItems,
        selectTemplate: item => {
          if (typeof item === "undefined") return null;
          // if (this.range.isContentEditable(this.current.element)) {
          //     return '<span contenteditable="false"><a href="http://zurb.com" target="_blank" title="' + item.original.email + '">' + item.original.value + '</a></span>';
          // }
          this.mentions.push({
            key: item.original.key,
            value: item.original.value
          });
          return "@" + item.original.key;
        },
        menuItemTemplate: function (item) {
          return '<img width="24" height="24" src="' + item.original.avatar + ' "> ' + item.original.key;
        },
        noMatchTemplate: function () {
          return '<span style:"visibility: hidden;"></span>';
        },
        lookup: item => {
          return item.searchKey;
        },
        menuContainer: document.getElementById("conversation-content")
      });
      this.tribute.attach(this.$refs["input"]);
    },
    handleMention(text) {
      let textMessageContent = new _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_8__["default"]();
      textMessageContent.content = text.trim();
      this.mentions.forEach(e => {
        if (text.indexOf(e.key) > -1) {
          if (e.value === "@" + this.conversationInfo.conversation.target) {
            textMessageContent.mentionedType = 2;
          } else {
            if (textMessageContent.mentionedType !== 2) {
              textMessageContent.mentionedType = 1;
              textMessageContent.mentionedTargets.push(e.value.substring(1));
            }
          }
        }
      });
      this.mentions.length = 0;
      return textMessageContent;
    },
    focusInput() {
      this.$nextTick(() => {
        if (this.$refs["input"]) {
          this.$refs["input"].focus();
          console.log("focus end");
        }
      });
    },
    moveCursorToEnd(contentEditableDiv) {
      let range = document.createRange();
      range.selectNodeContents(contentEditableDiv);
      range.collapse(false);
      let sel = window.getSelection();
      sel.removeAllRanges();
      sel.addRange(range);
    },
    restoreDraft() {
      let draft = _util_draft__WEBPACK_IMPORTED_MODULE_19__["default"].getConversationDraftEx(this.conversationInfo);
      if (!draft) {
        return;
      }
      console.log("restore draft", this.conversationInfo, draft);
      _store_js__WEBPACK_IMPORTED_MODULE_9__["default"].quoteMessage(draft.quotedMessage);
      let input = this.$refs["input"];
      if (input.innerHTML.trim()) {
        console.log("inputting, ignore", draft.text);
      } else {
        input.innerHTML = draft.text.replace(/ /g, "&nbsp").replace(/\n/g, "<br>");
        this.moveCursorToEnd(input);
      }
    },
    storeDraft(conversationInfo) {
      if (!this.$refs["input"]) {
        return;
      }
      let draftText = this.$refs["input"].innerHTML.trim();
      let p = `" src="${_config__WEBPACK_IMPORTED_MODULE_34__["default"].emojiBaseUrl()}72x72\\/[0-9a-z-]+\\.png">`;
      let re = new RegExp(p, "g");
      draftText = draftText.replace(/<br>/g, "\n").replace(/<div>/g, "\n").replace(/<\/div>/g, "").replace(/<div><\/div>/g, " ").replace(/&nbsp;/g, " ").replace(/<img class="emoji" draggable="false" alt="/g, "").replace(re, "").replace(/<img src="local-resource:.*">/g, "").trimStart().replace(/\s+$/g, " ");
      let mentions = [];
      this.mentions.forEach(e => {
        let mention;
        /**
         *  e.key: "13866666666"
         *  e.value: "@q0H7q7MM"
         */
        let start = draftText.indexOf("@" + e.key);
        let end = start + 1 + e.key.length;
        if (start > -1) {
          if (e.value === "@" + this.conversationInfo.conversation.target) {
            mention = new _wfc_model_mention__WEBPACK_IMPORTED_MODULE_20__["default"](start, end, this.conversationInfo.conversation.target, true);
          } else {
            mention = new _wfc_model_mention__WEBPACK_IMPORTED_MODULE_20__["default"](start, end, e.value.substring(1), false);
          }
          mentions.push(mention);
        }
      });
      let mentionCount = this.mentions ? this.mentions.length : 0;
      if (mentionCount > 0 && draftText.endsWith("@" + this.mentions[mentionCount - 1].key + " ")) {
        // @的最后一个空格不能删除
        // do nothing
      } else {
        draftText = draftText.trimEnd();
      }
      let quoteInfo = null;
      if (conversationInfo._quotedMessage) {
        quoteInfo = _wfc_model_quoteInfo__WEBPACK_IMPORTED_MODULE_18__["default"].initWithMessage(conversationInfo._quotedMessage);
      }
      if (draftText.length === 0 && !quoteInfo) {
        if (conversationInfo.draft !== "") {
          _util_draft__WEBPACK_IMPORTED_MODULE_19__["default"].setConversationDraft(conversationInfo.conversation, draftText, quoteInfo, mentions);
        }
      } else {
        if (draftText !== conversationInfo.draft || !conversationInfo.draft && quoteInfo) {
          _util_draft__WEBPACK_IMPORTED_MODULE_19__["default"].setConversationDraft(conversationInfo.conversation, draftText, quoteInfo, mentions);
        }
      }
    },
    onGroupMembersUpdate(groupId, groupMembers) {
      console.log("messageInput onGroupMembersUpdate", groupId);
      if (this.conversationInfo && this.conversationInfo.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_14__["default"].Group && this.conversationInfo.conversation.target === groupId) {
        this.initMention(this.conversationInfo.conversation);
        let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].getGroupMember(groupId, _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].getUserId());
        if (groupMember && groupMember.type === _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Muted) {
          this.muted = true;
        }
      }
    },
    requestPttTalk(request) {
      if (request) {
        let talkingCallback = new _wfc_ptt_client_talkingCallback__WEBPACK_IMPORTED_MODULE_33__["default"]();
        talkingCallback.onStartTalking = conversation => {
          console.log("onStartTalking", conversation);
          this.$notify({
            message: "请开始说话",
            type: "info"
          });
        };
        talkingCallback.onRequestFail = (conversation, reason) => {
          this.$notify({
            message: "对讲请求失败: " + reason,
            type: "error"
          });
        };
        _wfc_ptt_client_pttClient__WEBPACK_IMPORTED_MODULE_32__["default"].requestTalk(this.conversationInfo.conversation, talkingCallback);
      } else {
        _wfc_ptt_client_pttClient__WEBPACK_IMPORTED_MODULE_32__["default"].releaseTalk(this.conversationInfo.conversation);
      }
    },
    recordAudio(start) {
      this.notifyTyping(_wfc_messages_typingMessageContent__WEBPACK_IMPORTED_MODULE_37__["default"].TYPING_VOICE);
      if (start) {
        if (!this.amrRecorder) {
          this.amrRecorder = new benz_amr_recorder__WEBPACK_IMPORTED_MODULE_36___default.a();
          this.amrRecorder.initWithRecord().then(() => {
            this.amrRecorder.startRecord();
            this.$notify({
              message: "请开始说话",
              type: "info"
            });
          }).catch(e => {
            this.$notify({
              message: "录音失败",
              type: "error"
            });
            console.log("录音失败", e);
            this.amrRecorder = null;
          });
        }
      } else {
        if (this.amrRecorder) {
          this.amrRecorder.finishRecord().then(() => {
            let duration = this.amrRecorder.getDuration();
            if (duration > 1) {
              let blob = this.amrRecorder.getBlob();
              let file = new File([blob], new Date().getTime() + ".amr");
              let content = new _wfc_messages_soundMessageContent__WEBPACK_IMPORTED_MODULE_35__["default"](file, null, Math.ceil(duration));
              _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].sendConversationMessage(this.conversationInfo.conversation, content);
            } else {
              this.$notify({
                message: "录音时间太短",
                type: "warn"
              });
            }
            this.amrRecorder = null;
          });
        }
      }
    }
  },
  activated() {
    if (!this.sharedConversationState.showChannelMenu) {
      this.restoreDraft();
      this.focusInput();
    }
  },
  deactivated() {
    if (!this.sharedConversationState.showChannelMenu) {
      this.storeDraft(this.lastConversationInfo);
      this.$refs["input"].innerHTML = "";
    }
  },
  mounted() {
    if (!this.sharedConversationState.showChannelMenu) {
      if (this.conversationInfo) {
        this.initMention(this.conversationInfo.conversation);
        this.initEmojiPicker();
        this.restoreDraft();
      }
      this.focusInput();
    }
    this.lastConversationInfo = this.conversationInfo;
    if (Object(_platform__WEBPACK_IMPORTED_MODULE_26__["isElectron"])()) {
      _platform__WEBPACK_IMPORTED_MODULE_26__["ipcRenderer"].on("screenshots-ok", (event, args) => {
        console.log("screenshots-ok", args);
        if (args.filePath) {
          setTimeout(() => {
            document.execCommand("insertImage", false, "local-resource://" + args.filePath);
          }, 100);
        }
      });
    }
    this.storeDraftIntervalId = setInterval(() => {
      this.storeDraft(this.conversationInfo);
    }, 5 * 1000);
  },
  created() {
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].eventEmitter.on(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_28__["default"].GroupMembersUpdate, this.onGroupMembersUpdate);
  },
  destroyed() {
    if (Object(_platform__WEBPACK_IMPORTED_MODULE_26__["isElectron"])()) {
      _platform__WEBPACK_IMPORTED_MODULE_26__["ipcRenderer"].removeAllListeners("screenshots-ok");
    }
    if (this.storeDraftIntervalId) {
      clearInterval(this.storeDraftIntervalId);
    }
    _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].eventEmitter.removeListener(_wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_28__["default"].GroupMembersUpdate, this.onGroupMembersUpdate);
  },
  watch: {
    conversationInfo() {
      if (this.lastConversationInfo && !this.conversationInfo.conversation.equal(this.lastConversationInfo.conversation)) {
        this.$nextTick(() => {
          if (this.sharedConversationState.showChannelMenu) {
            this.$parent.$refs["conversationMessageList"].style.flexGrow = 1;
            return;
          }
          if (this.$parent.messageInputViewResized) {
            this.$parent.$refs["conversationMessageList"].style.flexGrow = 0;
          }
          if (this.lastConversationInfo && !this.conversationInfo.conversation.equal(this.lastConversationInfo.conversation)) {
            this.storeDraft(this.lastConversationInfo);
          }
          if (this.conversationInfo && (!this.lastConversationInfo || !this.conversationInfo.conversation.equal(this.lastConversationInfo.conversation))) {
            this.$refs.input.innerHTML = "";
            this.restoreDraft();
            this.initMention(this.conversationInfo.conversation);
          }
          this.lastConversationInfo = this.conversationInfo;
          this.focusInput();
          this.initEmojiPicker();
        });
      } else {
        // 其他端更新了草稿
        // fixme
        // this.restoreDraft();
      }
    }
  },
  computed: {
    quotedMessage() {
      // side affect
      this.$refs.input && this.$refs.input.focus();
      return this.sharedConversationState.quotedMessage;
    },
    hasInputTextOrImage() {
      // TODO 监听input的输入情况
      return true;
    },
    muted() {
      let target = this.conversationInfo.conversation._target;
      if (target instanceof _wfc_model_groupInfo__WEBPACK_IMPORTED_MODULE_16__["default"]) {
        let groupInfo = target;
        let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].getGroupMember(groupInfo.target, _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].getUserId());
        if (groupInfo.mute === 1) {
          return [_wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Owner, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Manager, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Allowed].indexOf(groupMember.type) < 0;
        } else {
          return groupMember && groupMember.type === _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_17__["default"].Muted;
        }
      }
      return false;
    }
  },
  components: {
    ChannelMenuView: _ChannelMenuView__WEBPACK_IMPORTED_MODULE_30__["default"],
    QuoteMessageView: _main_conversation_message_QuoteMessageView__WEBPACK_IMPORTED_MODULE_22__["default"],
    VEmojiPicker: _imndx_v_emoji_picker__WEBPACK_IMPORTED_MODULE_10__["VEmojiPicker"]
  },
  directives: {
    ClickOutside: (vue_click_outside__WEBPACK_IMPORTED_MODULE_11___default()),
    focus
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/MessageMultiSelectActionView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/MessageMultiSelectActionView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./message/forward/ForwardType */ "./src/ui/main/conversation/message/forward/ForwardType.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "MessageMultiSelectionActionView",
  data() {
    return {
      sharedPickState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.pick
    };
  },
  methods: {
    deleteMultiMessage() {
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].deleteSelectedMessages();
    },
    hideMultiSelectionActionView() {
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].toggleMessageMultiSelection();
    },
    forwardOneByOne() {
      let messages = [...this.sharedPickState.messages];
      this.$forwardMessage({
        forwardType: _message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_1__["default"].ONE_BY_ONE,
        messages
      });
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].toggleMessageMultiSelection();
    },
    forwardComposite() {
      let messages = [...this.sharedPickState.messages];
      this.$forwardMessage({
        forwardType: _message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_1__["default"].COMPOSITE,
        messages
      });
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].toggleMessageMultiSelection();
    },
    fav() {
      let messages = [...this.sharedPickState.messages];
      this.$parent.favMessages(messages);
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].toggleMessageMultiSelection();
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/SecretConversationInfoView.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/SecretConversationInfoView.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/model/conversationInfo */ "./src/wfc/model/conversationInfo.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _common_ListView_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../common/ListView.vue */ "./src/ui/common/ListView.vue");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "SecretConversationInfoView",
  props: {
    conversationInfo: {
      type: _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  data() {
    return {
      users: _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].getConversationMemberUsrInfos(this.conversationInfo.conversation),
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.contact
    };
  },
  methods: {
    showCreateConversationModal() {
      this.$modal.show(_common_ListView_vue__WEBPACK_IMPORTED_MODULE_2__["default"], {
        list: ["不销毁", "3秒", "10秒", "30秒", "1 分钟", "10 分钟"]
      }, {
        name: "list-item-modal",
        width: 320,
        height: 320,
        clickToClose: true
      }, {
        "before-open": this.beforeOpen,
        "before-close": this.beforeClose,
        closed: this.closed
      });
    },
    showUserInfo(user) {
      // TODO
      console.log("todo show userInfo", user);
    },
    beforeOpen(event) {
      console.log("Opening...");
    },
    beforeClose(event) {
      console.log("Closing...", event, event.params);
      let burnMs = [0, 3000, 10000, 30000, 60000, 600000];
      if (event.params && event.params.position >= 0) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].setSecretChatBurnTime(this.conversationInfo.conversation.target, burnMs[event.params.position]);
      }
    },
    closed(event) {
      console.log("Close...", event);
    },
    destroySecretChat() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].destroySecretChat(this.conversationInfo.conversation.target, () => {
        console.log("xxx de ss");
        _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setCurrentConversation(null);
      }, err => {
        console.log("destroySecretChat failed", err);
      });
    }
  },
  computed: {
    burnTimeDesc() {
      let secretChatInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_3__["default"].getSecretChatInfo(this.conversationInfo.conversation.target);
      let desc = ["不销毁", "3秒", "10秒", "30秒", "1分钟", "10分钟"];
      let burnMs = [0, 3000, 10000, 30000, 60000, 600000];
      let tmp = desc[burnMs.indexOf(secretChatInfo.burnTime)];
      return `设置密聊焚毁时间(${tmp})`;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/SingleConversationInfoView.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/SingleConversationInfoView.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _user_UserListView_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../user/UserListView.vue */ "./src/ui/main/user/UserListView.vue");
/* harmony import */ var _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversationInfo */ "./src/wfc/model/conversationInfo.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "SingleConversationInfoView",
  props: {
    conversationInfo: {
      type: _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_2__["default"],
      required: true
    }
  },
  data() {
    return {
      users: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].getConversationMemberUsrInfos(this.conversationInfo.conversation),
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.contact,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.misc
    };
  },
  components: {
    UserListView: _user_UserListView_vue__WEBPACK_IMPORTED_MODULE_1__["default"]
  },
  methods: {
    showCreateConversationModal() {
      let successCB = users => {
        users.push(this.conversationInfo.conversation._target);
        _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].createConversation(users);
      };
      this.$pickContact({
        successCB,
        initialCheckedUsers: [this.conversationInfo.conversation._target],
        uncheckableUsers: [this.conversationInfo.conversation._target],
        confirmTitle: this.$t("common.add")
      });
    },
    showUserInfo(user) {
      // TODO
      console.log("todo show userInfo", user);
    },
    clearConversationHistory() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].clearMessages(this.conversationInfo.conversation);
    },
    clearRemoteConversationHistory() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].clearRemoteConversationMessages(this.conversationInfo.conversation);
    }
  },
  computed: {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/ArticlesMessageContentView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/ArticlesMessageContentView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../wfc/messages/message */ "./src/wfc/messages/message.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ArticlesMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  methods: {
    openArticle(article) {
      open(article.url);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/ContextableNotificationMessageContentContainerView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/ContextableNotificationMessageContentContainerView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _RichNotificationMessageContentView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RichNotificationMessageContentView */ "./src/ui/main/conversation/message/RichNotificationMessageContentView.vue");
/* harmony import */ var _ArticlesMessageContentView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ArticlesMessageContentView */ "./src/ui/main/conversation/message/ArticlesMessageContentView.vue");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../store */ "./src/store.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ContextableNotificationMessageContentContainerView",
  components: {
    ArticlesMessageContentView: _ArticlesMessageContentView__WEBPACK_IMPORTED_MODULE_1__["default"],
    RichNotificationMessageContentView: _RichNotificationMessageContentView__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_2__["default"],
      required: true
    }
  },
  data() {
    return {
      sharedConversationState: _store__WEBPACK_IMPORTED_MODULE_3__["default"].state.conversation,
      sharedPickState: _store__WEBPACK_IMPORTED_MODULE_3__["default"].state.pick,
      highLight: false
    };
  },
  methods: {
    openMessageContextMenu(event, message) {
      this.$parent.$emit("openMessageContextMenu", event, message);
      this.highLight = true;
    },
    onContextMenuClosed() {
      this.highLight = false;
    }
  },
  mounted() {
    this.$parent.$on("contextMenuClosed", this.onContextMenuClosed);
  },
  beforeDestroy() {
    this.$parent.$off("contextMenuClosed", this.onContextMenuClosed);
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/MessageContentContainerView.vue?vue&type=script&lang=js":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/MessageContentContainerView.vue?vue&type=script&lang=js ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _main_conversation_message_content_TextMessageContentView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../main/conversation/message/content/TextMessageContentView */ "./src/ui/main/conversation/message/content/TextMessageContentView.vue");
/* harmony import */ var _main_conversation_message_content_ImageMessageContentView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../main/conversation/message/content/ImageMessageContentView */ "./src/ui/main/conversation/message/content/ImageMessageContentView.vue");
/* harmony import */ var _main_conversation_message_content_VideoMessageContentView__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../main/conversation/message/content/VideoMessageContentView */ "./src/ui/main/conversation/message/content/VideoMessageContentView.vue");
/* harmony import */ var _main_conversation_message_content_UnsupportMessageContentView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../main/conversation/message/content/UnsupportMessageContentView */ "./src/ui/main/conversation/message/content/UnsupportMessageContentView.vue");
/* harmony import */ var _main_conversation_message_content_FileMessageContentView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../main/conversation/message/content/FileMessageContentView */ "./src/ui/main/conversation/message/content/FileMessageContentView.vue");
/* harmony import */ var _main_conversation_message_content_StickerMessageContentView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../main/conversation/message/content/StickerMessageContentView */ "./src/ui/main/conversation/message/content/StickerMessageContentView.vue");
/* harmony import */ var _main_conversation_message_content_CallStartMessageContentView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../main/conversation/message/content/CallStartMessageContentView */ "./src/ui/main/conversation/message/content/CallStartMessageContentView.vue");
/* harmony import */ var _main_conversation_message_content_AudioMessageContentViewAMR__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../main/conversation/message/content/AudioMessageContentViewAMR */ "./src/ui/main/conversation/message/content/AudioMessageContentViewAMR.vue");
/* harmony import */ var _main_conversation_message_content_CompositeMessageContentView__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../main/conversation/message/content/CompositeMessageContentView */ "./src/ui/main/conversation/message/content/CompositeMessageContentView.vue");
/* harmony import */ var _content_UserCardMessageContentView__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./content/UserCardMessageContentView */ "./src/ui/main/conversation/message/content/UserCardMessageContentView.vue");
/* harmony import */ var _content_ConferenceInviteMessageContentView__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./content/ConferenceInviteMessageContentView */ "./src/ui/main/conversation/message/content/ConferenceInviteMessageContentView.vue");
/* harmony import */ var _content_UnknownMessageContentView__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./content/UnknownMessageContentView */ "./src/ui/main/conversation/message/content/UnknownMessageContentView.vue");
/* harmony import */ var _content_LinkMessageContentView__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./content/LinkMessageContentView */ "./src/ui/main/conversation/message/content/LinkMessageContentView.vue");








// 语音消息说明
//  目前提供连个实现版：
//  1. 基于APP_SERVER做编码转换，采用audio标签，播放mp3文件，对应AudioMessageContentViewAPP
//  2. 本地解码，采用自定义UI，直接播放AMR文件，对应AudioMessageContentViewAMR

// import AudioMessageContentView from "../../../main/conversation/message/content/AudioMessageContentViewAPP";





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "MessageContentContainerView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  components: {
    LinkMessageContentView: _content_LinkMessageContentView__WEBPACK_IMPORTED_MODULE_13__["default"],
    UnknownMessageContentView: _content_UnknownMessageContentView__WEBPACK_IMPORTED_MODULE_12__["default"],
    ConferenceInviteMessageContentView: _content_ConferenceInviteMessageContentView__WEBPACK_IMPORTED_MODULE_11__["default"],
    CompositeMessageContentView: _main_conversation_message_content_CompositeMessageContentView__WEBPACK_IMPORTED_MODULE_9__["default"],
    AudioMessageContentView: _main_conversation_message_content_AudioMessageContentViewAMR__WEBPACK_IMPORTED_MODULE_8__["default"],
    CallStartMessageContentView: _main_conversation_message_content_CallStartMessageContentView__WEBPACK_IMPORTED_MODULE_7__["default"],
    UnsupportMessageContentView: _main_conversation_message_content_UnsupportMessageContentView__WEBPACK_IMPORTED_MODULE_4__["default"],
    TextMessageContentView: _main_conversation_message_content_TextMessageContentView__WEBPACK_IMPORTED_MODULE_1__["default"],
    ImageMessageContentView: _main_conversation_message_content_ImageMessageContentView__WEBPACK_IMPORTED_MODULE_2__["default"],
    VideoMessageContentView: _main_conversation_message_content_VideoMessageContentView__WEBPACK_IMPORTED_MODULE_3__["default"],
    FileMessageContentView: _main_conversation_message_content_FileMessageContentView__WEBPACK_IMPORTED_MODULE_5__["default"],
    StickerMessageContentView: _main_conversation_message_content_StickerMessageContentView__WEBPACK_IMPORTED_MODULE_6__["default"],
    UserCardMessageContentView: _content_UserCardMessageContentView__WEBPACK_IMPORTED_MODULE_10__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/MessageReceiptDetailView.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/MessageReceiptDetailView.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _user_UserListView_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../user/UserListView.vue */ "./src/ui/main/user/UserListView.vue");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "MessageReceiptDetailView",
  components: {
    UserListView: _user_UserListView_vue__WEBPACK_IMPORTED_MODULE_2__["default"]
  },
  props: {
    readUsers: {
      type: Array,
      required: true,
      default: null
    },
    unreadUsers: {
      type: Array,
      required: true,
      default: null
    }
  },
  methods: {
    readUsersDesc() {
      let desc = "";
      if (this.readUsers) {
        this.readUsers.forEach(u => {
          desc += u._displayName + "、";
        });
        desc = desc.substring(0, desc.length - 1);
      }
      return desc ? desc : this.$t("common.none");
    },
    unrreadUsersDesc() {
      let desc = "";
      if (this.unreadUsers) {
        this.unreadUsers.forEach(u => {
          desc += u._displayName + "、";
        });
        desc = desc.substring(0, desc.length - 1);
      }
      return desc ? desc : this.$t("common.none");
    }
  },
  computed: {
    unreadTitle() {
      if (this.unreadUsers.length > 0) {
        return `未读(${this.unreadUsers.length})`;
      } else {
        return "未读";
      }
    },
    readTitle() {
      if (this.readUsers.length > 0) {
        return `已读(${this.readUsers.length})`;
      } else {
        return "已读";
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/NormalInMessageContentContainerView.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/NormalInMessageContentContainerView.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _user_UserCardView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../user/UserCardView */ "./src/ui/main/user/UserCardView.vue");
/* harmony import */ var _MessageContentContainerView_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageContentContainerView.vue */ "./src/ui/main/conversation/message/MessageContentContainerView.vue");
/* harmony import */ var _QuoteMessageView_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./QuoteMessageView.vue */ "./src/ui/main/conversation/message/QuoteMessageView.vue");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../store */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _contact_ChannelCardView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../contact/ChannelCardView */ "./src/ui/main/contact/ChannelCardView.vue");
/* harmony import */ var _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../wfc/model/groupMemberType */ "./src/wfc/model/groupMemberType.js");








/* harmony default export */ __webpack_exports__["default"] = ({
  name: "NormalInMessageContentView",
  props: {
    message: null
  },
  data() {
    return {
      sharedConversationState: _store__WEBPACK_IMPORTED_MODULE_3__["default"].state.conversation,
      sharedPickState: _store__WEBPACK_IMPORTED_MODULE_3__["default"].state.pick,
      highLight: false,
      quotedMessage: null
    };
  },
  methods: {
    onClickUserPortrait(userId) {
      if (this.message.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_5__["default"].Channel) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getChannelInfo(this.message.conversation.target, true);
      } else {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getUserInfo(userId, true);
      }
    },
    closeUserCard() {
      console.log("closeUserCard");
      this.$refs["userCardTippy"]._tippy.hide();
    },
    openMessageContextMenu(event, message) {
      this.$parent.$emit("openMessageContextMenu", event, message);
      this.highLight = true;
    },
    openMessageSenderContextMenu(event, message) {
      this.$parent.$emit("openMessageSenderContextMenu", event, message);
    },
    onContextMenuClosed() {
      this.highLight = false;
    }
  },
  mounted() {
    this.$parent.$on("contextMenuClosed", this.onContextMenuClosed);
    if (this.message.messageContent.quoteInfo) {
      let messageUid = this.message.messageContent.quoteInfo.messageUid;
      let msg = _store__WEBPACK_IMPORTED_MODULE_3__["default"].getMessageByUid(messageUid);
      if (!msg) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].loadRemoteMessage(messageUid, ms => {
          msg = _store__WEBPACK_IMPORTED_MODULE_3__["default"]._patchMessage(ms[0]);
          this.quotedMessage = msg;
        }, err => {
          console.log("load remote message error", messageUid, err);
        });
      } else {
        this.quotedMessage = msg;
      }
    }
  },
  beforeDestroy() {
    this.$parent.$off("contextMenuClosed", this.onContextMenuClosed);
  },
  computed: {
    isDownloading() {
      return _store__WEBPACK_IMPORTED_MODULE_3__["default"].isDownloadingMessage(this.message.messageId);
    },
    messageSenderPortrait() {
      if (this.message.conversation.type === 3) {
        let channelInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getChannelInfo(this.message.conversation.target, false);
        return channelInfo.portrait;
      } else {
        return this.message._from.portrait;
      }
    },
    enableClickMessageSenderPortrait() {
      if (this.message.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_5__["default"].Group) {
        let groupInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getGroupInfo(this.message.conversation.target);
        let groupMember = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getGroupMember(this.message.conversation.target, _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getUserId());
        if (groupInfo.privateChat === 1 && [_wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_7__["default"].Manager, _wfc_model_groupMemberType__WEBPACK_IMPORTED_MODULE_7__["default"].Owner].indexOf(groupMember.type) === -1) {
          return false;
        }
      }
      return true;
    }
  },
  components: {
    ChannelCardView: _contact_ChannelCardView__WEBPACK_IMPORTED_MODULE_6__["default"],
    MessageContentContainerView: _MessageContentContainerView_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
    UserCardView: _user_UserCardView__WEBPACK_IMPORTED_MODULE_0__["default"],
    QuoteMessageView: _QuoteMessageView_vue__WEBPACK_IMPORTED_MODULE_2__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/NormalOutMessageContentContainerView.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/NormalOutMessageContentContainerView.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _user_UserCardView_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../user/UserCardView.vue */ "./src/ui/main/user/UserCardView.vue");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _MessageContentContainerView_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MessageContentContainerView.vue */ "./src/ui/main/conversation/message/MessageContentContainerView.vue");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../store */ "./src/store.js");
/* harmony import */ var _common_LoadingView_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/LoadingView.vue */ "./src/ui/common/LoadingView.vue");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../../wfc/util/longUtil */ "./src/wfc/util/longUtil.js");
/* harmony import */ var _MessageReceiptDetailView_vue__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./MessageReceiptDetailView.vue */ "./src/ui/main/conversation/message/MessageReceiptDetailView.vue");
/* harmony import */ var _QuoteMessageView_vue__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./QuoteMessageView.vue */ "./src/ui/main/conversation/message/QuoteMessageView.vue");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../../config */ "./src/config.js");














/* harmony default export */ __webpack_exports__["default"] = ({
  name: "NormalOutMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_4__["default"],
      required: true
    }
  },
  data() {
    return {
      sharedConversationState: _store__WEBPACK_IMPORTED_MODULE_6__["default"].state.conversation,
      sharedPickState: _store__WEBPACK_IMPORTED_MODULE_6__["default"].state.pick,
      highLight: false,
      quotedMessage: null
    };
  },
  components: {
    QuoteMessageView: _QuoteMessageView_vue__WEBPACK_IMPORTED_MODULE_12__["default"],
    LoadingView: _common_LoadingView_vue__WEBPACK_IMPORTED_MODULE_7__["default"],
    MessageContentContainerView: _MessageContentContainerView_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
    UserCardView: _user_UserCardView_vue__WEBPACK_IMPORTED_MODULE_3__["default"]
    // TextMessageContentView,
  },
  mounted() {
    this.$parent.$on("contextMenuClosed", this.onContextMenuClosed);
    if (this.message.messageContent.quoteInfo) {
      let messageUid = this.message.messageContent.quoteInfo.messageUid;
      let msg = _store__WEBPACK_IMPORTED_MODULE_6__["default"].getMessageByUid(messageUid);
      if (!msg) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_8__["default"].loadRemoteMessage(messageUid, ms => {
          msg = _store__WEBPACK_IMPORTED_MODULE_6__["default"]._patchMessage(ms[0]);
          this.quotedMessage = msg;
        }, err => {
          console.log("load remote message error", messageUid, err);
        });
      } else {
        this.quotedMessage = msg;
      }
    }
  },
  beforeDestroy() {
    this.$parent.$off("contextMenuClosed", this.onContextMenuClosed);
  },
  methods: {
    onContextMenuClosed() {
      this.highLight = false;
    },
    onClickUserPortrait(userId) {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_8__["default"].getUserInfo(userId, true);
    },
    closeUserCard() {
      console.log("closeUserCard", this.$refs["userCardTippy"]);
      this.$refs["userCardTippy"]._tippy.hide();
    },
    resend() {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_8__["default"].deleteMessage(this.message.messageId);
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_8__["default"].sendMessage(this.message);
    },
    openMessageContextMenu(event, message) {
      this.$parent.$emit("openMessageContextMenu", event, message);
      this.highLight = true;
    },
    showMessageReceiptDetail() {
      let conversation = this.message.conversation;
      if (conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_9__["default"].Single) {
        return;
      }
      let timestamp = this.message.timestamp;
      let readEntries = this.sharedConversationState.currentConversationRead;
      if (conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_9__["default"].Group) {
        let groupMembers = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_8__["default"].getGroupMemberIds(conversation.target, false);
        if (!groupMembers || groupMembers.length === 0) {
          // do nothing
        } else {
          let readUserIds = [];
          let unreadUserIds = [];
          groupMembers.forEach(memberId => {
            let readDt = readEntries ? readEntries.get(memberId) : 0;
            if (readDt && Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_10__["gte"])(readDt, timestamp)) {
              readUserIds.push(memberId);
            } else {
              unreadUserIds.push(memberId);
            }
          });
          let readUsers = _store__WEBPACK_IMPORTED_MODULE_6__["default"].getUserInfos(readUserIds, conversation.target);
          let unreadUsers = _store__WEBPACK_IMPORTED_MODULE_6__["default"].getUserInfos(unreadUserIds, conversation.target);
          this.$modal.show(_MessageReceiptDetailView_vue__WEBPACK_IMPORTED_MODULE_11__["default"], {
            readUsers: readUsers,
            unreadUsers: unreadUsers
          }, {
            name: "message-receipt-detail-modal",
            width: 480,
            height: 300,
            clickToClose: true
          }, {});
        }
      }
    }
  },
  computed: {
    messageReceipt() {
      let conversation = this.message.conversation;
      let timestamp = this.message.timestamp;
      let receiptDesc = "";
      let deliveries = this.sharedConversationState.currentConversationDeliveries;
      let readEntries = this.sharedConversationState.currentConversationRead;
      if (conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_9__["default"].Single) {
        let readDt = readEntries ? readEntries.get(conversation.target) : 0;
        readDt = readDt ? readDt : 0;
        let recvDt = deliveries ? deliveries.get(conversation.target) : 0;
        recvDt = recvDt ? recvDt : 0;
        if (Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_10__["gte"])(readDt, timestamp)) {
          receiptDesc = "已读";
        } else if (Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_10__["gte"])(recvDt, timestamp)) {
          receiptDesc = "已送达";
        } else {
          receiptDesc = "未送达";
        }
      } else {
        let groupMembers = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_8__["default"].getGroupMemberIds(conversation.target, false);
        if (!groupMembers || groupMembers.length === 0) {
          receiptDesc = "";
        } else {
          let memberCount = groupMembers.length;
          let readCount = 0;
          let readUserIds = [];
          let unreadUserIds = [];
          groupMembers.forEach(memberId => {
            let readDt = readEntries ? readEntries.get(memberId) : 0;
            if (readDt && Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_10__["gte"])(readDt, timestamp)) {
              readCount++;
              readUserIds.push(memberId);
            } else {
              unreadUserIds.push(memberId);
            }
          });
          receiptDesc = `已读 ${readCount}/${memberCount}`;
        }
      }
      return receiptDesc;
    },
    isDownloading() {
      return _store__WEBPACK_IMPORTED_MODULE_6__["default"].isDownloadingMessage(this.message.messageId);
    },
    shouldShowMessageReceipt() {
      return this.sharedConversationState.isMessageReceiptEnable && ["FireRobot", _config__WEBPACK_IMPORTED_MODULE_13__["default"].FILE_HELPER_ID].indexOf(this.message.conversation.target) < 0;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/NotificationMessageContentView.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/NotificationMessageContentView.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../wfc/messages/message */ "./src/wfc/messages/message.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "NotificationMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  components: {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/PreviewQuotedMessageView.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/PreviewQuotedMessageView.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _util_emoji__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../util/emoji */ "./src/ui/util/emoji.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "previewQuotedMessageView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  computed: {
    textContent() {
      return Object(_util_emoji__WEBPACK_IMPORTED_MODULE_1__["parser"])(this.message.messageContent.digest(this.message));
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/QuoteMessageView.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/QuoteMessageView.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../wfc/messages/messageContentType */ "./src/wfc/messages/messageContentType.js");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _PreviewQuotedMessageView_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./PreviewQuotedMessageView.vue */ "./src/ui/main/conversation/message/PreviewQuotedMessageView.vue");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _platformHelper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/platformHelper */ "./src/platformHelper.js");






/* harmony default export */ __webpack_exports__["default"] = ({
  name: "QuoteMessageView",
  props: {
    showCloseButton: {
      type: Boolean,
      required: false,
      default: false
    },
    // 原始消息
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_2__["default"],
      required: false
    },
    // 被引用的消息
    quotedMessage: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_2__["default"],
      required: true
    },
    quotedMessageDigest: {
      type: String,
      required: false,
      default: ""
    },
    enableMessagePreview: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  data() {
    return {
      shareConversation: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.conversation
    };
  },
  methods: {
    cancelQuoteMessage() {
      this.$emit("cancelQuoteMessage");
    },
    onMessageClick() {
      if (!this.enableMessagePreview) {
        return;
      }
      if (this.quotedMessage) {
        switch (this.quotedMessage.messageContent.type) {
          case _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__["default"].Video:
          case _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__["default"].Image:
            Object(_platformHelper__WEBPACK_IMPORTED_MODULE_5__["previewMM"])(this.quotedMessage);
            break;
          case _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__["default"].File:
            this.downloadQuotedFile(this.quotedMessage);
            break;
          case _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__["default"].Text:
            // do nothing
            break;
          default:
            // TODO
            console.log("TODO: preview quotedMessage");
            break;
        }
      }
    },
    downloadQuotedFile(quotedFileMessage) {
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_4__["isElectron"])()) {
        let localPath = quotedFileMessage.messageContent.localPath;
        if (localPath && _platform__WEBPACK_IMPORTED_MODULE_4__["fs"].existsSync(localPath)) {
          // shell.openPath(localPath);
        } else {
          if (!_store_js__WEBPACK_IMPORTED_MODULE_0__["default"].isDownloadingMessage(quotedFileMessage.messageId)) {
            Object(_platformHelper__WEBPACK_IMPORTED_MODULE_5__["downloadFile"])(quotedFileMessage);
            _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].addDownloadingMessage(quotedFileMessage.messageId);
          } else {
            // TODO toast 下载中
            console.log("file isDownloading");
          }
        }
      } else {
        Object(_platformHelper__WEBPACK_IMPORTED_MODULE_5__["downloadFile"])(quotedFileMessage);
      }
    }
  },
  computed: {
    quotedMessageStr() {
      let str = "";
      if (this.quotedMessage) {
        str = this.quotedMessage._from._displayName + ":";
        if ([_wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__["default"].Image, _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__["default"].Video, _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__["default"].Sticker].indexOf(this.quotedMessage.messageContent.type) < 0) {
          str += this.quotedMessage.messageContent.digest(this.quotedMessage);
        }
        if (_wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_1__["default"].RecallMessage_Notification === this.quotedMessage.messageContent.type) {
          str = "引用内容已撤回";
        }
      } else {
        str = this.quotedMessageDigest;
      }
      return str;
    },
    mediaSrc() {
      let src;
      let msgCnt = this.quotedMessage.messageContent;
      src = msgCnt.thumbnail ? "data:video/jpeg;base64," + msgCnt.thumbnail : msgCnt.remotePath;
      return src;
    }
  },
  components: {
    PreviewQuotedMessageView: _PreviewQuotedMessageView_vue__WEBPACK_IMPORTED_MODULE_3__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/RecallNotificationMessageContentView.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/RecallNotificationMessageContentView.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../wfc/messages/messageContentType */ "./src/wfc/messages/messageContentType.js");
/* harmony import */ var _wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../wfc/util/longUtil */ "./src/wfc/util/longUtil.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../config */ "./src/config.js");





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "RecallNotificationMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  methods: {
    isReeditable() {
      let delta = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].getServerDeltaTime();
      let now = new Date().getTime();
      let recallMessageContent = this.message.messageContent;
      if (recallMessageContent.originalContentType === _wfc_messages_messageContentType__WEBPACK_IMPORTED_MODULE_2__["default"].Text && recallMessageContent.fromSelf && now - (Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_3__["numberValue"])(this.message.timestamp) - delta) < _config__WEBPACK_IMPORTED_MODULE_4__["default"].RECALL_REEDIT_TIME_LIMIT * 1000) {
        return true;
      }
      return false;
    },
    reedit() {
      this.$parent.reedit(this.message);
    }
  },
  components: {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/RichNotificationMessageContentView.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/RichNotificationMessageContentView.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/wfc/ipcEventType */ "./src/wfc/ipcEventType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_2__);



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "RichNotificationMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  methods: {
    onClickRichNotification() {
      // TODO 打开 app 或者链接
      console.log("onClickRichNotification");
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_1__["isElectron"])()) {
        let hash = window.location.hash;
        let url = window.location.origin;
        if (hash) {
          url = window.location.href.replace(hash, "#/workspace");
        } else {
          url += "/workspace";
        }
        url += "?url=" + encodeURIComponent(this.message.messageContent.exUrl);
        _platform__WEBPACK_IMPORTED_MODULE_1__["ipcRenderer"].send(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_2___default.a.OPEN_H5_APP_WINDOW, {
          hostUrl: location.href,
          url: encodeURI(url)
        });
      } else {
        this.$notify({
          title: "不支持打开该类型的消息",
          text: "请使用手机或者 PC 端打开",
          type: "warn"
        });
      }
    }
  },
  components: {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/AudioMessageContentViewAMR.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/AudioMessageContentViewAMR.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var vue_spinner_src_ScaleLoader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue-spinner/src/ScaleLoader */ "./node_modules/vue-spinner/src/ScaleLoader.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/store.js */ "./src/store.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "AudioMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    },
    data() {
      return {};
    },
    widthStyle() {
      return {
        width: "10px"
      };
    }
  },
  mounted() {
    if (this.duration) {
      let width = Math.ceil(this.duration / 60 * 300);
      width = width < 70 ? 70 : width;
      this.$refs.container.style.setProperty("--voice-width", width + "px");
    }
  },
  methods: {
    playVoice() {
      this.$set(this.message, "_isPlaying", true);
      _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].playVoice(this.message);
    }
  },
  computed: {
    duration() {
      let voice = this.message.messageContent;
      let times = voice.duration * 1000;
      let seconds = 0;
      if (times <= 60 * 1000) {
        seconds = Math.ceil(times / 1000);
      } else {
        seconds = 60;
      }
      return seconds;
    }
  },
  components: {
    ScaleLoader: vue_spinner_src_ScaleLoader__WEBPACK_IMPORTED_MODULE_1__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/CallStartMessageContentView.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/CallStartMessageContentView.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../wfc/av/engine/callEndReason */ "./src/wfc/av/engine/callEndReason.js");
/* harmony import */ var _ipc_ipcSub__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../ipc/ipcSub */ "./src/ipc/ipcSub.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../wfc/util/longUtil */ "./src/wfc/util/longUtil.js");





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CallStartMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  data() {
    return {
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.misc,
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.contact
    };
  },
  mounted() {},
  methods: {
    startCall() {
      let callStartMsgContent = this.message.messageContent;
      let audioOnly = callStartMsgContent.audioOnly;
      if (this.sharedMiscState.isMainWindow) {
        this.$startVoipCall({
          audioOnly: audioOnly,
          conversation: this.message.conversation
        });
      } else {
        _ipc_ipcSub__WEBPACK_IMPORTED_MODULE_2__["default"].startVoipCall(this.message.conversation, audioOnly);
      }
    }
  },
  computed: {
    textContent() {
      let voip = this.message.messageContent;
      let desc = this.$t("voip.desc");
      if (voip.endTime > 0 && voip.connectTime > 0) {
        let duration = parseInt((Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_4__["numberValue"])(voip.endTime) - Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_4__["numberValue"])(voip.connectTime)) / 1000);
        desc = `通话时长：${duration}''`;
      } else {
        let reason = voip.status;
        switch (reason) {
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_Unknown:
            desc = this.$t("voip.not_answer");
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_Busy:
            desc = "线路忙";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_SignalError:
            desc = "网络错误";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_Hangup:
            desc = "已取消";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_RemoteHangup:
            desc = "对方已取消";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_OpenCameraFailure:
            desc = "网络错误";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_Timeout:
            desc = "未接听";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_AcceptByOtherClient:
            desc = "已在其他端接听";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].REASON_AllLeft:
            desc = "通话已结束";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].RemoteBusy:
            desc = "对方忙";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].RemoteTimeout:
            desc = "对方未接听";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].RemoteNetworkError:
            desc = "对方网络错误";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].RoomDestroyed:
            desc = "通话已结束";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].RoomNotExist:
            desc = "通话已结束";
            break;
          case _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_1__["default"].RoomParticipantsFull:
            desc = " 已达最大通话人数";
            break;
          default:
            break;
        }
      }
      return desc;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/CompositeMessageContentView.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/CompositeMessageContentView.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_reduce_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.reduce.js */ "./node_modules/core-js/modules/es.iterator.reduce.js");
/* harmony import */ var core_js_modules_es_iterator_reduce_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_reduce_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _util_emoji__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../util/emoji */ "./src/ui/util/emoji.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/wfc/util/longUtil */ "./src/wfc/util/longUtil.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/wfc/ipcEventType */ "./src/wfc/ipcEventType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/wfc/messages/textMessageContent */ "./src/wfc/messages/textMessageContent.js");
/* harmony import */ var _ui_util_helper__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/ui/util/helper */ "./src/ui/util/helper.js");













/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CompositeMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_4__["default"],
      required: true
    }
  },
  computed: {
    title() {
      let compositeMessageContent = this.message.messageContent;
      return compositeMessageContent.title;
    },
    content() {
      let compositeMessageContent = this.message.messageContent;
      let messages = compositeMessageContent.messages;
      let str = "";
      let conversation = messages[0].conversation;
      let groupId = conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_7__["default"].Group ? conversation.target : "";
      for (let i = 0; i < messages.length && i < 4; i++) {
        if (messages[i].messageContent instanceof _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_11__["default"]) {
          str += _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_6__["default"].getGroupMemberDisplayName(groupId, messages[i].from) + ": " + this.textMessageContent(messages[i]);
        } else {
          str += _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_6__["default"].getGroupMemberDisplayName(groupId, messages[i].from) + ": " + messages[i].messageContent.digest(messages[i]);
        }
        str += "\n";
      }
      return str;
    }
  },
  methods: {
    textMessageContent(message) {
      let content = message.messageContent.digest(message);
      let lines = content.split("\n");
      if (lines.length > 1) {
        content = lines.map(line => `<span>${_ui_util_helper__WEBPACK_IMPORTED_MODULE_12__["default"].escapeHtml(line)}</span>\n`).reduce((total, cv, ci, arr) => total + cv, "");
      } else {
        content = _ui_util_helper__WEBPACK_IMPORTED_MODULE_12__["default"].escapeHtml(content);
      }
      content = Object(_util_emoji__WEBPACK_IMPORTED_MODULE_5__["parser"])(content);
      // tmp = marked.parse(tmp);
      if (content.indexOf("<img") >= 0) {
        content = content.replace(/<img/g, '<img style="max-width:400px;"');
        return content;
      }
      return content;
    },
    showCompositePage() {
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_8__["isElectron"])()) {
        let hash = window.location.hash;
        let url = window.location.origin;
        if (hash) {
          url = window.location.href.replace(hash, "#/composite");
        } else {
          url += "/composite";
        }
        _platform__WEBPACK_IMPORTED_MODULE_8__["ipcRenderer"].send(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_10___default.a.SHOW_COMPOSITE_MESSAGE_WINDOW, {
          messageUid: Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_9__["stringValue"])(this.message.messageUid),
          url: url
        });
      } else {
        let CompositeMessagePage = __webpack_require__(/*! ../../../CompositeMessagePage */ "./src/ui/main/CompositeMessagePage.vue").default;
        let beforeClose = () => {
          // todo
        };
        this.$modal.show(CompositeMessagePage, {
          message: this.message,
          isInCompositeView: true
        }, {
          name: "show-composite-message-modal" + "-" + Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_9__["stringValue"])(this.message.messageUid),
          width: 800,
          height: 600,
          clickToClose: true
        }, {
          "before-close": beforeClose
        });
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/ConferenceInviteMessageContentView.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/ConferenceInviteMessageContentView.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../wfc/av/engine/avenginekitproxy */ "./src/wfc/av/engine/avenginekitproxy.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../wfc/av/internal/engine.min */ "./src/wfc/av/internal/engine.min.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _voip_conference_ConferenceInfoView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../voip/conference/ConferenceInfoView */ "./src/ui/voip/conference/ConferenceInfoView.vue");
/* harmony import */ var _api_conferenceApi__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../../api/conferenceApi */ "./src/api/conferenceApi.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../../config */ "./src/config.js");








/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceInviteMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  mounted() {},
  methods: {
    joinConference() {
      if (_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2___default.a.sendConferenceRequest) {
        let cmc = this.message.messageContent;
        _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_1__["default"].joinConference(cmc.callId, cmc.audioOnly, cmc.pin, cmc.host, cmc.title, cmc.desc, cmc.audience, cmc.advanced, false, false);
      } else {
        this.$notify({
          title: "不支持会议功能",
          text: "请使用会议版engine文件",
          type: "warn"
        });
      }
    },
    showConferenceInfo() {
      if (_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2___default.a.sendConferenceRequest) {
        let cmc = this.message.messageContent;
        _api_conferenceApi__WEBPACK_IMPORTED_MODULE_6__["default"].queryConferenceInfo(cmc.callId, cmc.pin).then(info => {
          this.showConferenceInfoDialog(info);
        }).catch(err => {
          console.error("query conference info error", err);
          this.$notify({
            title: "加载会议信息失败",
            text: err.message,
            type: "warn"
          });
        });
      } else {
        this.$notify({
          title: "不支持会议功能",
          text: "请使用会议版engine文件",
          type: "warn"
        });
      }
    },
    showConferenceInfoDialog(info) {
      let beforeOpen = () => {
        console.log("Opening...");
      };
      let beforeClose = event => {
        console.log("Closing...", event, event.params);
      };
      let closed = event => {
        console.log("Close...", event);
      };
      this.$modal.show(_voip_conference_ConferenceInfoView__WEBPACK_IMPORTED_MODULE_5__["default"], {
        conferenceInfo: info
      }, {
        name: "conference-info-modal",
        width: 320,
        height: 600,
        clickToClose: true
      }, {
        "before-open": beforeOpen,
        "before-close": beforeClose,
        closed: closed
      });
    }
  },
  computed: {
    textContent() {
      let conferenceInviteMessageContent = this.message.messageContent;
      return "会议邀请" + " " + conferenceInviteMessageContent.title + " " + conferenceInviteMessageContent.desc;
    },
    portrait() {
      let content = this.message.messageContent;
      if (!content.host) {
        return _config__WEBPACK_IMPORTED_MODULE_7__["default"].DEFAULT_PORTRAIT_URL;
      }
      let groupId = this.message.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_4__["default"].Group ? this.message.conversation.target : "";
      let userInfos = _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].getUserInfos([content.host], groupId);
      return userInfos[0].portrait;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/FileMessageContentView.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/FileMessageContentView.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _util_helper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../util/helper */ "./src/ui/util/helper.js");
/* harmony import */ var _platformHelper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/platformHelper */ "./src/platformHelper.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/store.js */ "./src/store.js");





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "FileMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  data() {
    return {
      sharedConversationState: _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].state.conversation
    };
  },
  methods: {
    clickFile() {
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_3__["isElectron"])()) {
        let localPath = this.message.messageContent.localPath;
        if (localPath && _platform__WEBPACK_IMPORTED_MODULE_3__["fs"].existsSync(localPath)) {
          // shell.openPath(localPath);
        } else {
          if (!this.isDownloading()) {
            Object(_platformHelper__WEBPACK_IMPORTED_MODULE_2__["downloadFile"])(this.message);
            _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].addDownloadingMessage(this.message.messageId);
          } else {
            this.$notify({
              title: "下载中",
              text: "文件下载中，请稍后",
              type: "warn"
            });
          }
        }
      } else {
        Object(_platformHelper__WEBPACK_IMPORTED_MODULE_2__["downloadFile"])(this.message);
      }
    },
    dragFile(event) {
      let file = this.message.messageContent;
      let fileObj = {
        url: file.remotePath,
        name: file.name,
        size: file.size
      };
      event.dataTransfer.setData("text", JSON.stringify(fileObj));
    },
    isDownloading() {
      return _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].isDownloadingMessage(this.message.messageId);
    }
  },
  computed: {
    size() {
      let fileMsgContent = this.message.messageContent;
      return _util_helper__WEBPACK_IMPORTED_MODULE_1__["default"].humanSize(fileMsgContent.size);
    },
    fileIcon() {
      let fileName = this.message.messageContent.name;
      let icon = _util_helper__WEBPACK_IMPORTED_MODULE_1__["default"].getFiletypeIcon(fileName.substring(fileName.lastIndexOf(".") + 1));
      return __webpack_require__("./src/assets/images/filetypes sync recursive ^\\.\\/.*$")("./" + icon);
    },
    downloadStats() {
      let dm = _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].getDownloadingMessageStatus(this.message.messageId);
      return dm;
    },
    sendStats() {
      let sm = _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].getSendingStatus(this.message.messageId);
      return sm;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/ImageMessageContentView.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/ImageMessageContentView.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _platformHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../platformHelper */ "./src/platformHelper.js");
/* harmony import */ var _util_imageUtil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../util/imageUtil */ "./src/ui/util/imageUtil.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ImageMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    },
    isInCompositeView: {
      default: false,
      type: Boolean,
      required: false
    }
  },
  data() {
    return {
      imageLoaded: false
    };
  },
  mounted() {
    let iw = this.message.messageContent.imageWidth;
    let ih = this.message.messageContent.imageHeight;
    if (iw && ih) {
      let size = Object(_util_imageUtil__WEBPACK_IMPORTED_MODULE_2__["scaleDown"])(iw, ih, 300, 300);
      if (size) {
        this.$refs.img.style.height = size.height + "px";
        this.$refs.img.style.width = size.width + "px";
        this.$refs.thumbnail.style.height = size.height + "px";
        this.$refs.thumbnail.style.width = size.width + "px";
      }
    }
  },
  methods: {
    preview(message) {
      if (this.isInCompositeView) {
        this.$parent.previewCompositeMessage(message.messageUid);
      } else {
        console.log("preview", message);
        Object(_platformHelper__WEBPACK_IMPORTED_MODULE_1__["previewMM"])(message);
      }
    },
    onImageLoaded() {
      this.imageLoaded = true;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/LinkMessageContentView.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/LinkMessageContentView.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/platform */ "./src/platform.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "LinkMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  methods: {
    clickLink() {
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_1__["isElectron"])()) {
        // shell.openExternal(this.message.messageContent.url);
      } else {
        window.open(this.message.messageContent.url);
      }
    }
  },
  computed: {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/StickerMessageContentView.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/StickerMessageContentView.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _util_imageUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../util/imageUtil */ "./src/ui/util/imageUtil.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "StickerMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  data() {
    return {
      imageLoaded: false
    };
  },
  mounted() {
    let iw = this.message.messageContent.width;
    let ih = this.message.messageContent.height;
    if (iw && ih) {
      let size = Object(_util_imageUtil__WEBPACK_IMPORTED_MODULE_1__["scaleDown"])(iw, ih, 200, 200);
      if (size) {
        this.$refs.img.style.height = size.height + "px";
        this.$refs.img.style.width = size.width + "px";
        this.$refs.thumbnail.style.height = size.height + "px";
        this.$refs.thumbnail.style.width = size.width + "px";
      }
    }
  },
  methods: {
    preview(message) {
      // TODO
      console.log("TODO, preview sticker collection");
    },
    onImageLoaded() {
      this.imageLoaded = true;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/TextMessageContentView.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/TextMessageContentView.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_reduce_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.reduce.js */ "./node_modules/core-js/modules/es.iterator.reduce.js");
/* harmony import */ var core_js_modules_es_iterator_reduce_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_reduce_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _util_emoji__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../util/emoji */ "./src/ui/util/emoji.js");
/* harmony import */ var _util_helper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../util/helper */ "./src/ui/util/helper.js");







//import {marked} from "marked";

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "TextMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_4__["default"],
      required: true
    }
  },
  data() {
    return {
      textSelected: false
    };
  },
  mounted() {},
  methods: {
    mouseUp(event) {
      let selection = window.getSelection().toString();
      this.textSelected = !!selection;
    },
    preventContextMenuTextSelection(event) {
      if (!this.textSelected) {
        if (window.getSelection) {
          if (window.getSelection().empty) {
            // Chrome
            window.getSelection().empty();
          } else if (window.getSelection().removeAllRanges) {
            // Firefox
            window.getSelection().removeAllRanges();
          }
        } else if (document.selection) {
          // IE?
          document.selection.empty();
        }
      }
    }
  },
  computed: {
    textContent() {
      let content = this.message.messageContent.digest(this.message);
      let lines = content.split("\n");
      if (lines.length > 1) {
        content = lines.map(line => `<span>${_util_helper__WEBPACK_IMPORTED_MODULE_6__["default"].escapeHtml(line)}</span>\n`).reduce((total, cv, ci, arr) => total + cv, "");
      } else {
        content = _util_helper__WEBPACK_IMPORTED_MODULE_6__["default"].escapeHtml(content);
      }
      content = Object(_util_emoji__WEBPACK_IMPORTED_MODULE_5__["parser"])(content);
      // tmp = marked.parse(tmp);
      if (content.indexOf("<img") >= 0) {
        content = content.replace(/<img/g, '<img style="max-width:400px;"');
        return content;
      }
      return content;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/UnknownMessageContentView.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/UnknownMessageContentView.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");


// 未知消息
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "UnknownMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  mounted() {
    console.log("UnknownMessageContentView", this.message);
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/UnsupportMessageContentView.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/UnsupportMessageContentView.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");


// pc/web端不支持的消息，比如红包等
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "UnsupportMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    }
  },
  mounted() {
    console.log("UnsupportMessageContentView", this.message);
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/UserCardMessageContentView.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/UserCardMessageContentView.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _user_UserCardView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../user/UserCardView */ "./src/ui/main/user/UserCardView.vue");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "UserCardMessageContentView",
  props: {
    message: {
      required: true,
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"]
    }
  },
  components: {
    UserCardView: _user_UserCardView__WEBPACK_IMPORTED_MODULE_1__["default"]
  },
  methods: {
    closeUserCard() {
      console.log("closeUserCard");
      this.$refs["userCardTippy"]._tippy.hide();
    },
    userInfo() {
      let userCard = this.message.messageContent;
      if (userCard.cardType === 0) {
        return _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_2__["default"].getUserInfo(userCard.target);
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversation/message/content/VideoMessageContentView.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversation/message/content/VideoMessageContentView.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _platformHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../platformHelper */ "./src/platformHelper.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "VideoMessageContentView",
  props: {
    message: {
      type: _wfc_messages_message__WEBPACK_IMPORTED_MODULE_0__["default"],
      required: true
    },
    isInCompositeView: {
      default: false,
      type: Boolean,
      required: false
    }
  },
  methods: {
    preview(message) {
      if (this.isInCompositeView) {
        this.$parent.previewCompositeMessage(message.messageUid);
      } else {
        Object(_platformHelper__WEBPACK_IMPORTED_MODULE_1__["previewMM"])(message);
      }
    },
    dragVideo(event) {
      let video = this.message.messageContent;
      event.dataTransfer.setData("URL", video.remotePath);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversationList/ConversationItemView.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversationList/ConversationItemView.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _util_draft__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/draft */ "./src/ui/util/draft.js");
/* harmony import */ var _wfc_messages_fileMessageContent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/messages/fileMessageContent */ "./src/wfc/messages/fileMessageContent.js");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_messages_notification_notificationMessageContent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../wfc/messages/notification/notificationMessageContent */ "./src/wfc/messages/notification/notificationMessageContent.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../config */ "./src/config.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../wfc/model/groupType */ "./src/wfc/model/groupType.js");









/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConversationItemView",
  props: {
    source: {
      type: Object,
      required: true
    }
  },
  data() {
    return {
      dragAndDropEnterCount: 0,
      shareConversationState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.conversation,
      groupPortrait: _config__WEBPACK_IMPORTED_MODULE_6__["default"].DEFAULT_GROUP_PORTRAIT_URL
    };
  },
  mounted() {
    // this.refreshGroupPortrait();
  },
  methods: {
    dragEvent(e, v) {
      if (v === "dragenter") {
        this.dragAndDropEnterCount++;
      } else if (v === "dragleave") {
        this.dragAndDropEnterCount--;
      } else if (v === "drop") {
        this.dragAndDropEnterCount--;
        let length = e.dataTransfer.files.length;
        if (length > 0 && length <= 5) {
          for (let i = 0; i < length; i++) {
            this.$eventBus.$emit("uploadFile", e.dataTransfer.files[i]);
            _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].sendFile(this.source.conversation, e.dataTransfer.files[i]);
          }
        } else {
          // TODO
          let url = e.dataTransfer.getData("URL");
          if (url) {
            _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].sendFile(this.source.conversation, url);
          } else {
            let text = e.dataTransfer.getData("text");
            if (text.startsWith("{")) {
              let obj = JSON.parse(text);
              let file = new _wfc_messages_fileMessageContent__WEBPACK_IMPORTED_MODULE_2__["default"](null, obj.url, obj.name, obj.size);
              let message = new _wfc_messages_message__WEBPACK_IMPORTED_MODULE_3__["default"](this.source.conversation, file);
              _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].sendMessage(message);
            }
          }
          console.log(this.$t("conversation.drag_to_send_limit_tip"), e.dataTransfer, e.dataTransfer.getData("URL"));
        }
      } else if (v === "dragover") {
        // If not st as 'copy', electron will open the drop file
        e.dataTransfer.dropEffect = "copy";
      }
    },
    imgUrlAlt(e) {
      if (this.source.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_7__["default"].Group) {
        e.target.src = _config__WEBPACK_IMPORTED_MODULE_6__["default"].DEFAULT_GROUP_PORTRAIT_URL;
      } else {
        e.target.src = _config__WEBPACK_IMPORTED_MODULE_6__["default"].DEFAULT_PORTRAIT_URL;
      }
    },
    showConversation() {
      _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentConversationInfo(this.source);
      if (this.unread > 0) {
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].clearConversationUnreadStatus(this.source.conversation);
      }
      // this.refreshGroupPortrait();
    },
    showConversationInfoContextMenu(event) {
      this.$eventBus.$emit("showConversationContextMenu", event, this.source);
    }
  },
  computed: {
    conversationTitle() {
      let info = this.source;
      if (info.conversation._target) {
        return info.conversation._target._displayName;
      }
      return "";
    },
    isOrganizationGroupConversation() {
      let info = this.source;
      if (info.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_7__["default"].Group && info.conversation._target && info.conversation._target.type === _wfc_model_groupType__WEBPACK_IMPORTED_MODULE_8__["default"].Organization) {
        return true;
      }
      return false;
    },
    shouldShowDraft() {
      if (this.shareConversationState.currentConversationInfo && this.shareConversationState.currentConversationInfo.conversation.equal(this.source.conversation)) {
        return false;
      }
      if (this.source.unreadCount.unreadMention + this.source.unreadCount.unreadMentionAll > 0) {
        return false;
      }
      let draft = _util_draft__WEBPACK_IMPORTED_MODULE_1__["default"].getConversationDraftEx(this.source);
      return draft.text.trim() !== "" || draft.quotedMessage !== null;
    },
    shouldShowVoipStatus() {
      return this.source._isVoipOngoing;
    },
    draft() {
      let draft = _util_draft__WEBPACK_IMPORTED_MODULE_1__["default"].getConversationDraftEx(this.source);
      let draftText = `<em>[${this.$t("common.draft")}]</em>` + draft.text;
      draftText = draftText.replace(/<img [:a-zA-Z0-9_+; ,\-=\/."]+>/g, "[图片]");
      draftText = draftText.replace(/&nbsp;/g, " ");
      draftText = draftText.replace(/<br>/g, "");
      if (draft.quotedMessage) {
        draftText += "...";
      }
      return draftText;
    },
    voipOngoingDesc() {
      let voipStatus = `<em>[音视频通话进行中]</em>`;
      return voipStatus;
    },
    lastMessageContent() {
      let conversationInfo = this.source;
      if (conversationInfo.lastMessage && conversationInfo.lastMessage.messageContent) {
        let senderName = "";
        if (conversationInfo.conversation.type === 1 && conversationInfo.lastMessage.direction === 1 && !(conversationInfo.lastMessage.messageContent instanceof _wfc_messages_notification_notificationMessageContent__WEBPACK_IMPORTED_MODULE_5__["default"])) {
          if (conversationInfo.lastMessage._from) {
            senderName = conversationInfo.lastMessage._from._displayName + ": ";
          } else {
            conversationInfo.lastMessage = _store_js__WEBPACK_IMPORTED_MODULE_0__["default"]._patchMessage(conversationInfo.lastMessage, 0);
            if (conversationInfo.lastMessage._from) {
              senderName = conversationInfo.lastMessage._from._displayName + ": ";
            } else {
              senderName = "<" + conversationInfo.lastMessage.from + ">: ";
            }
          }
        }
        return senderName + conversationInfo.lastMessage.messageContent.digest(conversationInfo.lastMessage);
      } else {
        return "";
      }
    },
    unread() {
      let conversationInfo = this.source;
      let unreadCount = conversationInfo.unreadCount;
      return unreadCount ? unreadCount.unread + unreadCount.unreadMention + unreadCount.unreadMentionAll : 0;
    },
    unreadMention() {
      let conversationInfo = this.source;
      let unreadCount = conversationInfo.unreadCount;
      return unreadCount ? unreadCount.unreadMention + unreadCount.unreadMentionAll : 0;
    },
    portrait() {
      let info = this.source;
      if (info.conversation.type === _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_7__["default"].Group) {
        if (info.conversation._target.portrait) {
          return info.conversation._target.portrait;
        } else {
          return this.groupPortrait;
        }
      } else {
        return info.conversation._target.portrait;
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/conversationList/ConversationListView.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/conversationList/ConversationListView.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ConversationItemView_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ConversationItemView.vue */ "./src/ui/main/conversationList/ConversationItemView.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/wfc/ipcEventType */ "./src/wfc/ipcEventType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../platform */ "./src/platform.js");







/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConversationListView",
  data() {
    return {
      sharedConversationState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.conversation,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.misc,
      conversationItemView: _ConversationItemView_vue__WEBPACK_IMPORTED_MODULE_2__["default"]
    };
  },
  created() {
    this.$eventBus.$on("showConversationContextMenu", (event, conversationInfo) => {
      this.showConversationItemContextMenu(event, conversationInfo);
    });
  },
  destroyed() {
    this.$eventBus.$off("showConversationContextMenu");
  },
  methods: {
    setConversationTop(conversationInfo) {
      _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].setConversationTop(conversationInfo.conversation, conversationInfo.top > 0 ? 0 : 1);
    },
    setConversationSilent(conversationInfo) {
      _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].setConversationSilent(conversationInfo.conversation, !conversationInfo.isSilent);
    },
    removeConversation(conversationInfo) {
      _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].removeConversation(conversationInfo.conversation);
    },
    conversationInfoKey(conversationInfo) {
      let conv = conversationInfo.conversation;
      return conv.target + "-" + conv.type + "-" + conv.line;
    },
    scrollActiveElementCenter() {
      let el = this.$el.getElementsByClassName("active")[0];
      el && el.scrollIntoView({
        behavior: "instant",
        block: "center"
      });
    },
    showConversationItemContextMenu(event, conversationInfo) {
      if (!this.$refs.menu) {
        return;
      }
      this.sharedConversationState.contextMenuConversationInfo = conversationInfo;
      this.$refs.menu.open(event, conversationInfo);
    },
    onConversationItemContextMenuClose() {
      this.sharedConversationState.contextMenuConversationInfo = null;
    },
    clearConversationUnreadStatus(conversation) {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].clearConversationUnreadStatus(conversation);
    },
    markConversationAsUnread(conversation) {
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].markConversationAsUnread(conversation, true);
    },
    showConversationFloatPage(conversation) {
      let hash = window.location.hash;
      let url = window.location.origin;
      if (hash) {
        url = window.location.href.replace(hash, "#/conversation-window");
      } else {
        url += "/conversation-window";
      }
      _platform__WEBPACK_IMPORTED_MODULE_6__["ipcRenderer"].send(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5___default.a.showConversationFloatPage, {
        url: url,
        type: conversation.type,
        target: conversation.target,
        line: conversation.line
      });
      _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].addFloatingConversation(conversation);
      if (this.sharedConversationState.currentConversationInfo && this.sharedConversationState.currentConversationInfo.conversation.equal(conversation)) {
        _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].setCurrentConversation(null);
      }
    }
  },
  activated() {
    this.scrollActiveElementCenter();
  },
  computed: {
    conversationInfoList() {
      return this.sharedConversationState.conversationInfoList.filter(ci => {
        const index = this.sharedConversationState.floatingConversations.findIndex(c => c.equal(ci.conversation));
        return index === -1;
      });
    }
  },
  components: {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/search/SearchResultView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/search/SearchResultView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_click_outside__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-click-outside */ "./node_modules/vue-click-outside/index.js");
/* harmony import */ var vue_click_outside__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vue_click_outside__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _contact_FriendRequestView_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../contact/FriendRequestView.vue */ "./src/ui/main/contact/FriendRequestView.vue");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/wfc/ipcEventType */ "./src/wfc/ipcEventType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../platform */ "./src/platform.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");








/* harmony default export */ __webpack_exports__["default"] = ({
  name: "SearchResultView",
  props: ["query"],
  data() {
    return {
      sharedSearchState: _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.search,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.misc,
      shouldShowAllUser: false,
      shouldShowAllChannel: false,
      shouldShowAllContact: false,
      shouldShowAllGroup: false
    };
  },
  mounted() {
    // do nothing
  },
  beforeDestroy() {
    _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setSearchQuery("");
  },
  watch: {
    // "query":function (val, oldVal){
    //   console.log('searchView query changed:', val, oldVal)
    // }
    // or
    query() {
      console.log("searchView query changed:", this.query);
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setSearchQuery(this.query);
    }
  },
  methods: {
    isFriend(userId) {
      return _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_7__["default"].isMyFriend(userId);
    },
    addFriend(user) {
      this.$modal.show(_contact_FriendRequestView_vue__WEBPACK_IMPORTED_MODULE_4__["default"], {
        userInfo: user
      }, {
        name: "friend-request-modal",
        width: 600,
        height: 250,
        clickToClose: false
      }, {});
    },
    showAllUser() {
      this.shouldShowAllUser = true;
    },
    showAllChannel() {
      this.shouldShowAllChannel = true;
    },
    showAllContact() {
      this.shouldShowAllContact = true;
    },
    showAllGroup() {
      this.shouldShowAllGroup = true;
    },
    hideSearchView(e) {
      if (e.target.id !== "searchInput") {
        _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].toggleSearchView(false);
      }
    },
    chatToContact(contact) {
      if (this.$router.currentRoute.path !== "/home") {
        this.$router.replace("/home");
      }
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_3__["default"].Single, contact.uid, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setCurrentConversation(conversation);
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].toggleSearchView(false);
    },
    chatToChannel(channel) {
      if (this.$router.currentRoute.path !== "/home") {
        this.$router.replace("/home");
      }
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_3__["default"].Channel, channel.channelId, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setCurrentConversation(conversation);
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].toggleSearchView(false);
    },
    chatToGroup(group) {
      if (this.$router.currentRoute.path !== "/home") {
        this.$router.replace("/home");
      }
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_3__["default"].Group, group.target, 0);
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setCurrentConversation(conversation);
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].toggleSearchView(false);
    },
    showMessageHistoryPage() {
      let hash = window.location.hash;
      let url = window.location.origin;
      if (hash) {
        url = window.location.href.replace(hash, "#/message-history");
      } else {
        url += "/message-history";
      }
      _platform__WEBPACK_IMPORTED_MODULE_6__["ipcRenderer"].send(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5___default.a.showMessageHistoryPage, {
        url: url
      });
      console.log(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_5___default.a.showMessageHistoryPage, url);
    }
  },
  computed: {
    toShowUserList: function () {
      return !this.shouldShowAllUser && this.sharedSearchState.userSearchResult.length > 5 ? this.sharedSearchState.userSearchResult.slice(0, 4) : this.sharedSearchState.userSearchResult;
    },
    toShowChannelList: function () {
      return !this.shouldShowAllChannel && this.sharedSearchState.channelSearchResult.length > 5 ? this.sharedSearchState.channelSearchResult.slice(0, 4) : this.sharedSearchState.channelSearchResult;
    },
    toShowContactList: function () {
      return !this.shouldShowAllContact && this.sharedSearchState.contactSearchResult.length > 5 ? this.sharedSearchState.contactSearchResult.slice(0, 4) : this.sharedSearchState.contactSearchResult;
    },
    toShowGroupList: function () {
      return !this.shouldShowAllGroup && this.sharedSearchState.groupSearchResult.length > 5 ? this.sharedSearchState.groupSearchResult.slice(0, 4) : this.sharedSearchState.groupSearchResult;
    }
  },
  directives: {
    ClickOutside: (vue_click_outside__WEBPACK_IMPORTED_MODULE_0___default())
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/search/SearchView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/search/SearchView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../config */ "./src/config.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "SearchView",
  props: {
    showAddButton: {
      type: Boolean,
      default: true
    },
    searchType: {
      type: String,
      default: ""
    }
  },
  data() {
    return {
      sharedSearchState: _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].state.search,
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].state.contact
    };
  },
  methods: {
    onFocus(focused) {
      _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].toggleSearchView(focused);
    },
    showCreateConversationModal() {
      let successCB = users => {
        _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].createConversation(users);
      };
      let users = this.sharedContactState.favContactList.concat(this.sharedContactState.friendList);
      users = users.filter(u => {
        return u.uid !== _config__WEBPACK_IMPORTED_MODULE_3__["default"].FILE_HELPER_ID;
      });
      this.$pickContact({
        users,
        successCB,
        showOrganization: true
      });
    },
    cancel() {
      _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].toggleSearchView(false);
      this.$refs["input"].blur();
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/setting/ChangePasswordView.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/setting/ChangePasswordView.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _api_appServerApi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../api/appServerApi */ "./src/api/appServerApi.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CreateConferenceView",
  data() {
    return {
      oldPassword: "",
      newPassword: "",
      confirmPassword: ""
    };
  },
  methods: {
    async changePassword() {
      this.$modal.hide("change-password-modal");
      _api_appServerApi__WEBPACK_IMPORTED_MODULE_0__["default"].changePassword(this.oldPassword, this.newPassword).then(response => {
        this.$notify({
          text: "修改密码成功",
          type: "info"
        });
      }).catch(err => {
        this.$notify({
          title: "修改密码失败",
          text: err.message,
          type: "error"
        });
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/setting/ResetPasswordView.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/setting/ResetPasswordView.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _api_appServerApi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../api/appServerApi */ "./src/api/appServerApi.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CreateConferenceView",
  data() {
    return {
      resetAuthCode: "",
      newPassword: "",
      confirmPassword: ""
    };
  },
  methods: {
    async requestResetAuthCode() {
      this.$modal.hide("reset-password-modal");
      _api_appServerApi__WEBPACK_IMPORTED_MODULE_0__["default"].requestResetPasswordAuthCode().then(response => {
        this.$notify({
          text: "发送重置验证码成功",
          type: "info"
        });
      }).catch(err => {
        this.mobile = "";
        this.$notify({
          title: "发送重置验证码失败",
          text: err.message,
          type: "error"
        });
      });
    },
    async resetPassword() {
      _api_appServerApi__WEBPACK_IMPORTED_MODULE_0__["default"].resetPassword(this.resetAuthCode, this.newPassword).then(response => {
        this.$notify({
          text: "重置密码成功",
          type: "info"
        });
      }).catch(err => {
        this.mobile = "";
        this.$notify({
          title: "重置密码失败",
          text: err.message,
          type: "error"
        });
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/setting/SettingPage.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/setting/SettingPage.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var vue_dropdowns__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue-dropdowns */ "./node_modules/vue-dropdowns/Dropdown.vue");
/* harmony import */ var _util_storageHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/storageHelper */ "./src/ui/util/storageHelper.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../platform */ "./src/platform.js");
/* harmony import */ var _ChangePasswordView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ChangePasswordView */ "./src/ui/main/setting/ChangePasswordView.vue");
/* harmony import */ var _ResetPasswordView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ResetPasswordView */ "./src/ui/main/setting/ResetPasswordView.vue");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/wfc/ipcEventType */ "./src/wfc/ipcEventType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../wfc/av/internal/engine.min */ "./src/wfc/av/internal/engine.min.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_8__);










/* harmony default export */ __webpack_exports__["default"] = ({
  name: "SettingPage",
  data() {
    return {
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.misc,
      openPcChatTimeoutHandler: 0,
      langs: [{
        lang: "zh-CN",
        name: "简体中文"
      }, {
        lang: "zh-TW",
        name: "繁體中文"
      }, {
        lang: "en",
        name: "English"
      }]
    };
  },
  methods: {
    showChangePasswordContextMenu(event) {
      this.$refs.changePasswordContextMenu.open(event);
    },
    onChangePasswordContextMenuClose() {},
    showChangePasswordDialog() {
      let beforeOpen = () => {
        console.log("Opening...");
      };
      let beforeClose = event => {
        console.log("Closing...", event, event.params);
      };
      let closed = event => {
        console.log("Close...", event);
      };
      this.$modal.show(_ChangePasswordView__WEBPACK_IMPORTED_MODULE_5__["default"], {}, {
        name: "change-password-modal",
        width: 320,
        height: 400,
        clickToClose: true
      }, {
        "before-open": beforeOpen,
        "before-close": beforeClose,
        closed: closed
      });
    },
    showResetPasswordDialog() {
      let beforeOpen = () => {
        console.log("Opening...");
      };
      let beforeClose = event => {
        console.log("Closing...", event, event.params);
      };
      let closed = event => {
        console.log("Close...", event);
      };
      this.$modal.show(_ResetPasswordView__WEBPACK_IMPORTED_MODULE_6__["default"], {}, {
        name: "rest-password-modal",
        width: 320,
        height: 400,
        clickToClose: true
      }, {
        "before-open": beforeOpen,
        "before-close": beforeClose,
        closed: closed
      });
    },
    logout() {
      Object(_util_storageHelper__WEBPACK_IMPORTED_MODULE_3__["clear"])();
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__["default"].disconnect();
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_4__["isElectron"])()) {
        _platform__WEBPACK_IMPORTED_MODULE_4__["ipcRenderer"].send(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_7___default.a.LOGOUT);
      }
    },
    enableNotification(enable) {
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setEnableNotification(enable);
    },
    enableMinimize(enable) {
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setEnableMinimize(enable);
    },
    enableNotificationDetail(enable) {
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setEnableNotificationDetail(enable);
    },
    enableCloseWindowToExit(enable) {
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setEnableCloseWindowToExit(enable);
    },
    enableAutoLogin(enable) {
      _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].setEnableAutoLogin(enable);
    },
    setLang(lang) {
      Object(_util_storageHelper__WEBPACK_IMPORTED_MODULE_3__["setItem"])("lang", lang.lang);
      // this.$router.go();
    },
    openPcChat() {
      // pc 端，deeplink 的 scheme 是 wfc://
      // 打开和 小火的会话
      let url = "wfc://conversation?target=FireRobot&line=0&type=0";
      // 未安装 pc  版时，跳转到 pc 版的下载链接
      let fallback = "https://github.com/wildfirechat/vue-pc-chat";
      window.location = url;
      this.openPcChatTimeoutHandler = setTimeout(() => {
        window.open(fallback, "_blank");
      }, 1000);
    },
    blurListener() {
      if (this.openPcChatTimeoutHandler) {
        clearTimeout(this.openPcChatTimeoutHandler);
        this.openPcChatTimeoutHandler = 0;
      }
    },
    protoRevision() {
      let version = "";
      try {
        version = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__["default"].getProtoRevision();
      } catch (e) {
        version = "unknown proto version";
        console.log(e);
      }
      let supportConference = _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_8___default.a.startConference !== undefined;
      return version + (supportConference ? " av-conference" : " av-multi");
    },
    webrtcTest() {
      if (!location.href.startsWith("https://") && !location.href.startsWith("http://localhost")) {
        this.$notify({
          text: "只有通过https://，或者http://localhost 访问站点时，才支持音视频通话功能",
          type: "warn"
        });
      } else {
        this.$notify({
          title: "请稍后",
          text: "将进入新页面测试音视频能力",
          type: "info"
        });
        setTimeout(() => {
          window.open("https://docs.wildfirechat.cn/webrtc/abilitytest/");
        }, 2000);
      }
    }
  },
  mounted() {
    window.addEventListener("blur", this.blurListener);
  },
  beforeDestroy() {
    window.removeEventListener("blur", this.blurListener);
  },
  computed: {
    currentLang() {
      let lang = Object(_util_storageHelper__WEBPACK_IMPORTED_MODULE_3__["getItem"])("lang");
      lang = lang ? lang : "zh-CN";
      let index = this.langs.findIndex(l => l.lang === lang);
      index = index >= 0 ? index : 0;
      return this.langs[index];
    }
  },
  components: {
    dropdown: vue_dropdowns__WEBPACK_IMPORTED_MODULE_2__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/user/UserCardView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/user/UserCardView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _main_contact_FriendRequestView__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../main/contact/FriendRequestView */ "./src/ui/main/contact/FriendRequestView.vue");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_messages_messageContentMediaType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../wfc/messages/messageContentMediaType */ "./src/wfc/messages/messageContentMediaType.js");
/* harmony import */ var _wfc_model_modifyMyInfoEntry__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../wfc/model/modifyMyInfoEntry */ "./src/wfc/model/modifyMyInfoEntry.js");
/* harmony import */ var _wfc_model_modifyMyInfoType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../wfc/model/modifyMyInfoType */ "./src/wfc/model/modifyMyInfoType.js");
/* harmony import */ var _ipc_ipcSub__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../ipc/ipcSub */ "./src/ipc/ipcSub.js");









/* harmony default export */ __webpack_exports__["default"] = ({
  name: "UserCardView",
  props: {
    userInfo: {
      type: Object,
      required: true
    },
    enableUpdatePortrait: {
      type: Boolean,
      required: false
    }
  },
  data() {
    return {
      friendAlias: this.userInfo.uid === _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getUserId() ? this.userInfo.displayName : this.userInfo.friendAlias,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.misc
    };
  },
  methods: {
    share() {
      // TODO share
      this.close();
    },
    chat() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_1__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_2__["default"].Single, this.userInfo.uid, 0);
      if (_store_js__WEBPACK_IMPORTED_MODULE_0__["default"].isConversationInCurrentWindow(conversation)) {
        _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].setCurrentConversation(conversation);
      } else {
        _ipc_ipcSub__WEBPACK_IMPORTED_MODULE_8__["default"].startConversation(conversation);
      }
      this.close();
      // 跳转到会话列表页
      // this.$router.replace('/home');
      this.$store.commit("SET_PAGE_NAME", "ConversationPage");
    },
    addFriend() {
      this.close();
      this.$modal.show(_main_contact_FriendRequestView__WEBPACK_IMPORTED_MODULE_3__["default"], {
        userInfo: this.userInfo
      }, {
        name: "friend-request-modal",
        width: 600,
        height: 250,
        clickToClose: false
      }, {});
    },
    updateFriendAlias() {
      if (this.userInfo.uid === _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getUserId()) {
        if (this.friendAlias !== this.userInfo.displayName) {
          let entry = new _wfc_model_modifyMyInfoEntry__WEBPACK_IMPORTED_MODULE_6__["default"]();
          entry.type = _wfc_model_modifyMyInfoType__WEBPACK_IMPORTED_MODULE_7__["default"].Modify_DisplayName;
          entry.value = this.friendAlias;
          _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].modifyMyInfo([entry]);
        }
      } else {
        if (this.friendAlias !== this.userInfo.friendAlias) {
          _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].setFriendAlias(this.userInfo.uid, this.friendAlias, () => {
            // do nothing
          }, error => {
            // do nothing
          });
        }
      }
      this.close();
    },
    close() {
      this.$emit("close");
    },
    pickFile() {
      if (!this.enableUpdatePortrait) {
        return;
      }
      this.$refs["fileInput"].click();
    },
    onPickFile(event) {
      // this.batchProcess(e.target.files[0]);
      let file = event.target.files[0];
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].uploadMedia(file.name, file, _wfc_messages_messageContentMediaType__WEBPACK_IMPORTED_MODULE_5__["default"].Portrait, url => {
        let entry = new _wfc_model_modifyMyInfoEntry__WEBPACK_IMPORTED_MODULE_6__["default"]();
        entry.type = _wfc_model_modifyMyInfoType__WEBPACK_IMPORTED_MODULE_7__["default"].Modify_Portrait;
        entry.value = url;
        _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].modifyMyInfo([entry], () => {
          //this.userInfo.portrait = url;
          // 会触发userInfosUpdate 通知
        }, err => {
          console.log("modify my info error", err);
        });
      }, err => {
        console.log("err", err);
      }, (p, t) => {
        console.log("progress", p, t);
      });
    }
  },
  computed: {
    isFriend() {
      return _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].getUserId() === this.userInfo.uid || _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_4__["default"].isMyFriend(this.userInfo.uid);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/user/UserItemView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/user/UserItemView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _UserCardView_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./UserCardView.vue */ "./src/ui/main/user/UserCardView.vue");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../config */ "./src/config.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "UserListVue",
  props: {
    source: {
      type: Object,
      required: true
    },
    currentUser: {
      type: Object,
      default: null
    },
    showCategoryLabel: {
      type: Boolean,
      required: false,
      default: true
    },
    enableCategoryLabelSticky: {
      type: Boolean,
      required: false,
      default: false
    },
    clickUserItemFunc: {
      type: Function,
      required: false
    },
    paddingLeft: {
      type: String,
      required: false,
      default: "5px"
    },
    enableContactContextMenu: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_0__["default"].state.contact
    };
  },
  methods: {
    clickUserItem(user) {
      this.clickUserItemFunc && this.clickUserItemFunc(user);
    },
    scrollActiveElementCenter() {
      let el = this.$el.getElementsByClassName("active")[0];
      el && el.scrollIntoView({
        behavior: "instant",
        block: "center"
      });
    },
    tippyStyleFix() {
      let root = document.documentElement;
      root.style.setProperty("--tippy-right", "261px");
    },
    tippyStyleReset() {
      let root = document.documentElement;
      root.style.setProperty("--tippy-right", "0");
    },
    closeUserCard(user) {
      this.$refs["userCardTippy-" + user.uid]._tippy.hide();
    },
    imgUrlAlt(e) {
      e.target.src = _config__WEBPACK_IMPORTED_MODULE_2__["default"].DEFAULT_PORTRAIT_URL;
    },
    showContactContextMenu(event, user) {
      if (this.enableContactContextMenu) {
        this.$eventBus.$emit("showContactContextMenu", event, user);
      }
    }
  },
  mounted() {
    if (!this.clickUserItemFunc) {
      this.tippyStyleFix();
    }
  },
  activated() {
    this.scrollActiveElementCenter();
  },
  destroyed() {
    if (!this.clickUserItemFunc) {
      this.tippyStyleReset();
    }
  },
  computed: {
    paddingStyle() {
      return {
        paddingLeft: this.paddingLeft
      };
    }
  },
  components: {
    UserCardView: _UserCardView_vue__WEBPACK_IMPORTED_MODULE_1__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/main/user/UserListView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/main/user/UserListView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _UserCardView_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./UserCardView.vue */ "./src/ui/main/user/UserCardView.vue");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../config */ "./src/config.js");
/* harmony import */ var _UserItemView_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./UserItemView.vue */ "./src/ui/main/user/UserItemView.vue");







/* harmony default export */ __webpack_exports__["default"] = ({
  name: "UserListView",
  props: {
    users: {
      type: Array,
      required: true
    },
    currentUser: {
      type: Object,
      default: null
    },
    showCategoryLabel: {
      type: Boolean,
      required: false,
      default: true
    },
    enableCategoryLabelSticky: {
      type: Boolean,
      required: false,
      default: false
    },
    clickUserItemFunc: {
      type: Function,
      required: false
    },
    paddingLeft: {
      type: String,
      required: false,
      default: "5px"
    },
    enableContactContextMenu: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  data() {
    return {
      sharedContactState: _store_js__WEBPACK_IMPORTED_MODULE_3__["default"].state.contact
    };
  },
  methods: {
    clickUserItem(user) {
      this.clickUserItemFunc && this.clickUserItemFunc(user);
    },
    scrollActiveElementCenter() {
      let el = this.$el.getElementsByClassName("active")[0];
      el && el.scrollIntoView({
        behavior: "instant",
        block: "center"
      });
    },
    tippyStyleFix() {
      let root = document.documentElement;
      root.style.setProperty("--tippy-right", "261px");
    },
    tippyStyleReset() {
      let root = document.documentElement;
      root.style.setProperty("--tippy-right", "0");
    },
    closeUserCard(user) {
      this.$refs["userCardTippy-" + user.uid][0]._tippy.hide();
    },
    imgUrlAlt(e) {
      e.target.src = _config__WEBPACK_IMPORTED_MODULE_5__["default"].DEFAULT_PORTRAIT_URL;
    },
    showContactContextMenu(event, user) {
      if (this.enableContactContextMenu) {
        this.$eventBus.$emit("showContactContextMenu", event, user);
      }
    }
  },
  mounted() {
    if (!this.clickUserItemFunc) {
      this.tippyStyleFix();
    }
  },
  activated() {
    this.scrollActiveElementCenter();
  },
  destroyed() {
    if (!this.clickUserItemFunc) {
      this.tippyStyleReset();
    }
  },
  computed: {
    UserItemView() {
      return _UserItemView_vue__WEBPACK_IMPORTED_MODULE_6__["default"];
    },
    virtualListGroupedUsers() {
      let groupedUsers = [];
      let currentCategory = {};
      let lastCategory = null;
      let index = 0;
      this.users.forEach(user => {
        index++;
        if (this.showCategoryLabel && (!lastCategory || lastCategory !== user._category)) {
          lastCategory = user._category;
          currentCategory = {
            type: "category",
            category: user._category,
            uid: user._category + index
          };
          groupedUsers.push(currentCategory);
          groupedUsers.push(user);
        } else {
          groupedUsers.push(user);
        }
      });
      console.log("xxx xxx", groupedUsers);
      return groupedUsers;
    },
    groupedUsers() {
      let groupedUsers = [];
      if (!this.showCategoryLabel) {
        groupedUsers.push({
          category: "not-show-category",
          users: this.users
        });
      } else {
        let current = {};
        let lastCategory = null;
        this.users.forEach(user => {
          if (!lastCategory || lastCategory !== user._category) {
            lastCategory = user._category;
            current = {
              category: user._category,
              users: [user]
            };
            groupedUsers.push(current);
          } else {
            current.users.push(user);
          }
        });
      }
      return groupedUsers;
    },
    paddingStyle() {
      return {
        paddingLeft: this.paddingLeft
      };
    }
  },
  components: {
    UserCardView: _UserCardView_vue__WEBPACK_IMPORTED_MODULE_4__["default"]
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/Multi.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/Multi.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../wfc/av/internal/engine.min */ "./src/wfc/av/internal/engine.min.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wfc_av_engine_callSessionCallback__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../wfc/av/engine/callSessionCallback */ "./src/wfc/av/engine/callSessionCallback.js");
/* harmony import */ var _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../wfc/av/engine/callState */ "./src/wfc/av/engine/callState.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _ScreenOrWindowPicker__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ScreenOrWindowPicker */ "./src/ui/voip/ScreenOrWindowPicker.vue");
/* harmony import */ var _wfc_av_messages_multiCallOngoingMessageContent__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../wfc/av/messages/multiCallOngoingMessageContent */ "./src/wfc/av/messages/multiCallOngoingMessageContent.js");
/* harmony import */ var _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../wfc/av/engine/videoType */ "./src/wfc/av/engine/videoType.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/config */ "./src/config.js");














/* harmony default export */ __webpack_exports__["default"] = ({
  name: "Multi",
  data() {
    return {
      session: null,
      audioOnly: false,
      status: 1,
      selfUserInfo: null,
      initiatorUserInfo: null,
      participantUserInfos: [],
      groupMemberUserInfos: [],
      startTimestamp: 0,
      currentTimestamp: 0,
      videoInputDeviceIndex: 0,
      broadcastMultiCallOngoingTimer: 0,
      autoPlayInterval: 0,
      showWebrtcTip: false,
      ringAudio: null
    };
  },
  methods: {
    // 用来解决 iOS 上，不能自动播放问题
    autoPlay() {
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_8__["isElectron"])()) {
        return;
      }
      console.log("auto play");
      if (!this.autoPlayInterval) {
        this.autoPlayInterval = setInterval(() => {
          try {
            let videos = document.getElementsByTagName("video");
            let allPlaying = true;
            for (const video of videos) {
              if (video.paused) {
                allPlaying = false;
                break;
              }
            }
            // participantUserInfos 不包含自己
            if (allPlaying && videos.length === this.participantUserInfos.length + 1) {
              clearInterval(this.autoPlayInterval);
              this.autoPlayInterval = 0;
              console.log("auto play, allPlaying", videos.length);
              return;
            }
            for (const video of videos) {
              if (video.paused) {
                video.play();
              }
            }
          } catch (e) {
            // do nothing
          }
        }, 100);
      }
    },
    switchVideoType(userId, screenSharing) {
      if (!this.session) {
        return;
      }
      let subscriber = this.session.getSubscriber(userId, screenSharing);
      if (subscriber) {
        let currentVideoType = subscriber.currentVideoType;
        let videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_11__["default"].NONE;
        if (currentVideoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_11__["default"].NONE) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_11__["default"].BIG_STREAM;
        } else if (currentVideoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_11__["default"].BIG_STREAM) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_11__["default"].SMALL_STREAM;
        } else if (currentVideoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_11__["default"].SMALL_STREAM) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_11__["default"].NONE;
        }
        this.session.setParticipantVideoType(userId, screenSharing, videoType);
      }
    },
    setupSessionCallback() {
      let sessionCallback = new _wfc_av_engine_callSessionCallback__WEBPACK_IMPORTED_MODULE_6__["default"]();
      sessionCallback.didChangeState = state => {
        this.status = state;
        if (state === _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_7__["default"].STATUS_CONNECTED) {
          if (this.startTimestamp === 0) {
            this.startTimestamp = new Date().getTime();
            this.timer = setInterval(() => {
              this.currentTimestamp = new Date().getTime();
            }, 1000);
          }
        } else if (state === _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_7__["default"].STATUS_IDLE) {
          if (this.timer) {
            clearInterval(this.timer);
          }
        }
      };
      sessionCallback.onInitial = (session, selfUserInfo, initiatorUserInfo, participantUserInfos, groupMemberUserInfos) => {
        this.session = session;
        this.audioOnly = session.audioOnly;
        this.selfUserInfo = selfUserInfo;
        this.initiatorUserInfo = initiatorUserInfo;
        // 为了逻辑更清晰，参数引用传递，参数中传入的participantUserInfos会变化，如果直接使用的话，didParticipantJoined里面，可啥都不做
        this.participantUserInfos = [...participantUserInfos];
        this.groupMemberUserInfos = groupMemberUserInfos;

        // pls refer to: https://vuejs.org/v2/guide/reactivity.html
        this.$set(this.selfUserInfo, "_stream", null);
        this.participantUserInfos.forEach(p => this.$set(p, "_stream", null));
        this.groupMemberUserInfos.forEach(m => this.$set(m, "_stream", null));
        if (selfUserInfo.uid === initiatorUserInfo.uid) {
          this.broadcastMultiCallOngoingTimer = setInterval(this.broadcastMultiCallOngoing, 1000);
        }
      };
      sessionCallback.didChangeMode = audioOnly => {
        this.audioOnly = audioOnly;
      };
      sessionCallback.didCreateLocalVideoTrack = stream => {
        this.selfUserInfo._stream = stream;
        this.autoPlay();
      };
      sessionCallback.didReceiveRemoteVideoTrack = (userId, stream) => {
        let p;
        for (let i = 0; i < this.participantUserInfos.length; i++) {
          p = this.participantUserInfos[i];
          if (p.uid === userId) {
            p._stream = stream;
            break;
          }
        }
        this.autoPlay();
      };
      sessionCallback.didParticipantJoined = (userId, screenSharing) => {
        console.log(screenSharing);
        let userInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_12__["default"].getUserInfo(userId);
        console.log("didParticipantJoined", userInfo);
        userInfo._stream = null;
        this.participantUserInfos.push(userInfo);
      };
      sessionCallback.didParticipantLeft = userId => {
        console.log("didParticipantLeft", userId, this.participantUserInfos.length);
        this.participantUserInfos = this.participantUserInfos.filter(p => p.uid !== userId);
        console.log("didParticipantLeft d", userId, this.participantUserInfos.length);
      };
      sessionCallback.didCallEndWithReason = reason => {
        console.log("callEndWithReason", reason);
        this.session.closeVoipWindow();
        this.session = null;
      };
      sessionCallback.didVideoMuted = (userId, muted) => {
        console.log(muted);
        this.participantUserInfos.forEach(u => {
          if (u.uid === userId) {
            let client = this.session.getSubscriber(userId);
            u._isVideoMuted = client.videoMuted;
            console.log("didMuteStateChanged", client.videoMuted, client.audioMuted);
          }
        });
      };
      sessionCallback.didMediaLostPacket = (media, lostPacket) => {
        if (lostPacket > 6) {
          console.log("您的网络不好");
        }
      };
      sessionCallback.didUserMediaLostPacket = (userId, media, lostPacket, uplink) => {
        //如果uplink ture对方网络不好，false您的网络不好
        //接收方丢包超过10为网络不好
        if (lostPacket > 10) {
          if (uplink) {
            let userInfos = this.participantUserInfos.filter(u => u.uid === userId);
            if (userInfos && userInfos.length > 0) {
              console.log(userInfos[0].displayName, "网络不好");
            }
          } else {
            console.log("您的网络不好");
          }
        }
      };
      sessionCallback.didChangeInitiator = initiator => {
        this.initiatorUserInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_12__["default"].getUserInfo(initiator);
        if (!this.broadcastMultiCallOngoingTimer) {
          this.broadcastMultiCallOngoingTimer = setInterval(this.broadcastMultiCallOngoing, 200);
        }
      };
      _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_5___default.a.sessionCallback = sessionCallback;
    },
    answer() {
      this.session.call();
    },
    hangup() {
      this.session.hangup();
    },
    switchCamera() {
      if (!this.session || this.session.isScreenSharing()) {
        return;
      }
      // The order is significant - the default capture devices will be listed first.
      // navigator.mediaDevices.enumerateDevices()
      navigator.mediaDevices.enumerateDevices().then(devices => {
        devices = devices.filter(d => d.kind === "videoinput");
        if (devices.length < 2) {
          console.log("switchCamera error, no more video input device");
          return;
        }
        this.videoInputDeviceIndex++;
        if (this.videoInputDeviceIndex >= devices.length) {
          this.videoInputDeviceIndex = 0;
        }
        this.session.setVideoInputDeviceId(devices[this.videoInputDeviceIndex].deviceId);
        console.log("setVideoInputDeviceId", devices[this.videoInputDeviceIndex]);
      });
    },
    mute() {
      let toMute = this.session.audioMuted ? false : true;
      this.selfUserInfo._isAudioMuted = toMute;
      this.session.muteAudio(toMute);
    },
    muteVideo() {
      let toMute = this.session.videoMuted ? false : true;
      this.selfUserInfo._isVideoMuted = toMute;
      this.session.muteVideo(toMute);
    },
    down2voice() {
      this.session.downgrade2Voice();
    },
    screenShare() {
      if (this.session.isScreenSharing()) {
        this.session.stopScreenShare();
      } else {
        if (Object(_platform__WEBPACK_IMPORTED_MODULE_8__["isElectron"])()) {
          let beforeClose = event => {
            // What a gamble... 50% chance to cancel closing
            if (!event.params) {
              return;
            }
            if (event.params.source) {
              let source = event.params.source;
              let desktopShareOptions = {
                sourceId: source.id,
                minWidth: 1280,
                maxWidth: 1280,
                minHeight: 720,
                maxHeight: 720
              };
              this.session.startScreenShare(desktopShareOptions);
            }
          };
          this.$modal.show(_ScreenOrWindowPicker__WEBPACK_IMPORTED_MODULE_9__["default"], {}, {
            width: 800,
            height: 600,
            name: "screen-window-picker-modal",
            clickToClose: false
          }, {
            // 'before-open': beforeOpen,
            "before-close": beforeClose
            // 'closed': closed,
          });
        } else {
          this.session.startScreenShare();
        }
      }
    },
    invite() {
      let successCB = users => {
        let userIds = users.map(u => u.uid);
        this.session.inviteNewParticipants(userIds);
      };
      this.$pickContact({
        successCB,
        users: this.session.groupMemberUserInfos,
        initialCheckedUsers: [...this.session.participantUserInfos, this.session.selfUserInfo],
        uncheckableUsers: [...this.session.participantUserInfos, this.session.selfUserInfo],
        showCategoryLabel: false,
        confirmTitle: "确定"
      });
    },
    userName(user) {
      let name = "";
      if (user.groupAlias) {
        name = user.groupAlias;
      } else if (user.friendAlias) {
        name = user.friendAlias;
      } else if (user.displayName) {
        name = user.displayName;
      } else {
        name = user.name;
      }
      return name;
    },
    timestampFormat(timestamp) {
      timestamp = ~~(timestamp / 1000);
      let str = "";
      let hour = ~~(timestamp / 3600);
      str = hour > 0 ? (hour < 10 ? "0" : "") + hour + ":" : "";
      let min = ~~(timestamp % 3600 / 60);
      str += (min < 10 ? "0" : "") + min + ":";
      let sec = ~~(timestamp % 60);
      str += (sec < 10 ? "0" : "") + sec;
      return str;
    },
    broadcastMultiCallOngoing() {
      let participants = this.participantUserInfos.map(pu => pu.uid).filter(uid => uid !== this.selfUserInfo.uid);
      let ongoing = new _wfc_av_messages_multiCallOngoingMessageContent__WEBPACK_IMPORTED_MODULE_10__["default"](this.session.callId, this.session.initiatorId, this.session.audioOnly, participants);
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_12__["default"].sendConversationMessage(this.session.conversation, ongoing);
    }
  },
  computed: {
    duration() {
      if (this.currentTimestamp <= 0) {
        return "00:00";
      }
      let escapeMillis = this.currentTimestamp - this.startTimestamp;
      return this.timestampFormat(escapeMillis);
    }
  },
  mounted() {
    let supportConference = _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_5___default.a.startConference !== undefined;
    if (!supportConference) {
      let host = window.location.host;
      if (host.indexOf("wildfirechat.cn") === -1 && host.indexOf("localhost") === -1) {
        for (const ice of _config__WEBPACK_IMPORTED_MODULE_13__["default"].ICE_SERVERS) {
          if (ice[0].indexOf("turn.wildfirechat.net") >= 0) {
            // 显示自行部署 turn 提示
            this.showWebrtcTip = true;
            setTimeout(() => {
              this.showWebrtcTip = false;
            }, 10 * 1000);
            break;
          }
        }
      }
    }
    if (Object(_platform__WEBPACK_IMPORTED_MODULE_8__["isElectron"])()) {
      _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_5___default.a.setup();
    }
    this.setupSessionCallback();
  },
  destroyed() {
    // reset
    this.$set(this.selfUserInfo, "_stream", null);
    this.groupMemberUserInfos.forEach(m => this.$set(m, "_stream", null));
    if (this.broadcastMultiCallOngoingTimer) {
      clearInterval(this.broadcastMultiCallOngoingTimer);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/ScreenOrWindowPicker.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/ScreenOrWindowPicker.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../platform */ "./src/platform.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ScreenOrWindowPicker",
  data() {
    return {
      currentCategory: "screen",
      // window
      selectedSource: "",
      screenSources: [],
      /*id: "window:94694:0"
            name: "微信 (聊天)"
            thumbnail: NativeImage {}
            display_id: ""
            appIcon: NativeImage {}
             */
      windowSources: []
    };
  },
  methods: {
    selectSource(source) {
      console.log("select", source);
      this.selectedSource = source;
    },
    setCategory(category) {
      if (this.currentCategory !== category) {
        this.currentCategory = category;
        this.selectedSource = null;
        let width = category === "screen" ? "50%" : "33%";
        this.$refs.contentContainer.style.setProperty("--source-width", width);
      }
    },
    cancel() {
      this.$modal.hide("screen-window-picker-modal");
    },
    share(ev, source) {
      if (source) {
        this.selectedSource = source;
      }
      this.$modal.hide("screen-window-picker-modal", {
        source: this.selectedSource
      });
    }
  },
  mounted() {
    let types = ["screen", "window"];
    _platform__WEBPACK_IMPORTED_MODULE_2__["desktopCapturer"].getSources({
      types: types,
      thumbnailSize: {
        width: 200,
        height: 200
      },
      fetchWindowIcons: true
    }).then(sources => {
      this.screenSources = sources.filter(source => source.id.startsWith("screen"));
      this.windowSources = sources.filter(source => source.id.startsWith("window"));
    });
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/ScreenShareControlView.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/ScreenShareControlView.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../wfc/av/internal/engine.min */ "./src/wfc/av/internal/engine.min.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../wfc/av/engine/avenginekitproxy */ "./src/wfc/av/engine/avenginekitproxy.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ScreenShareControlView",
  props: {
    type: {
      required: false,
      type: String,
      default: null
    }
  },
  data() {
    return {
      session: null,
      screenShareCheckIntervalId: 0,
      screenShareActiveTime: -1,
      isScreenSharePaused: false
    };
  },
  mounted() {
    this.session = _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_0___default.a.getCurrentSession();
    this.screenShareCheckIntervalId = setInterval(() => {
      if (this.screenShareActiveTime !== -1) {
        if (this.screenShareActiveTime === this.$refs.screenShareVideo.currentTime) {
          if (!this.isScreenSharePaused) {
            this.isScreenSharePaused = true;
            console.log("屏幕共享暂停");
          }
        } else {
          if (this.isScreenSharePaused) {
            this.isScreenSharePaused = false;
            console.log("屏幕共享恢复");
          }
        }
      }
      this.screenShareActiveTime = this.$refs.screenShareVideo.currentTime;
    }, 1000);
  },
  beforeDestroy() {
    clearInterval(this.screenShareCheckIntervalId);
  },
  methods: {
    audioMute() {
      this.session.muteAudio(!this.session.audioMuted);
    },
    videoMute() {
      // this.stopScreenShare();
      // this.session.muteVideo(false);
      // this.$parent.$forceUpdate();

      this.$parent.test();
    },
    stopScreenShare() {
      console.log("stopScreenShare", this.session);
      this.session.stopScreenShare();
      console.log("stopScreenShare", this.session.videoMuted, this.session.audioMuted);
      if (this.session.videoMuted && this.session.audioMuted) {
        this.session.switchAudience(true);
      }
      _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_1__["default"].emitToMain("stop-screen-share", {
        type: this.type
      });
      // 不太明白session明显变动了，但父组件没有去刷新，所以强制刷新下
      // 奇怪：直接用音视频SDK源码调试的时候，会正常刷新，但有编译出的SDK时，就不会刷新
      this.$parent.$forceUpdate();
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/Single.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/Single.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../wfc/av/internal/engine.min */ "./src/wfc/av/internal/engine.min.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wfc_av_engine_callSessionCallback__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../wfc/av/engine/callSessionCallback */ "./src/wfc/av/engine/callSessionCallback.js");
/* harmony import */ var _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../wfc/av/engine/callState */ "./src/wfc/av/engine/callState.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _ScreenOrWindowPicker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ScreenOrWindowPicker */ "./src/ui/voip/ScreenOrWindowPicker.vue");
/* harmony import */ var _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../wfc/av/engine/videoType */ "./src/wfc/av/engine/videoType.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/config */ "./src/config.js");
/* harmony import */ var screenfull__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! screenfull */ "./node_modules/screenfull/index.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! dayjs */ "./node_modules/dayjs/dayjs.min.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! dayjs/locale/zh-cn */ "./node_modules/dayjs/locale/zh-cn.js");
/* harmony import */ var dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! dayjs/plugin/weekday */ "./node_modules/dayjs/plugin/weekday.js");
/* harmony import */ var dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_12__);













dayjs__WEBPACK_IMPORTED_MODULE_10___default.a.locale("zh-cn"); // 本地化
dayjs__WEBPACK_IMPORTED_MODULE_10___default.a.extend(dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_12___default.a); // 第一天为周一

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "Single",
  data() {
    return {
      timer: null,
      currentDatetime: dayjs__WEBPACK_IMPORTED_MODULE_10___default()().format("YYYY-MM-DD dddd HH:mm:ss"),
      isFullscreen: false,
      session: null,
      audioOnly: false,
      participantUserInfos: [],
      muted: false,
      status: 4,
      startTimestamp: 0,
      currentTimestamp: 0,
      localStream: null,
      remoteStream: null,
      videoInputDeviceIndex: 0,
      autoPlayInterval: 0,
      showWebrtcTip: false,
      ringAudio: null
    };
  },
  computed: {
    participantUserInfo() {
      return this.session.participantUserInfos[0];
    },
    duration() {
      if (this.currentTimestamp <= 0) {
        return "00:00";
      }
      let escapeMillis = this.currentTimestamp - this.startTimestamp;
      return this.timestampFormat(escapeMillis);
    }
  },
  methods: {
    setTimer() {
      this.timer = setTimeout(() => {
        this.currentDatetime = dayjs__WEBPACK_IMPORTED_MODULE_10___default()().format("YYYY-MM-DD dddd HH:mm:ss");
        this.setTimer();
      }, 1000);
    },
    handleScreen() {
      if (screenfull__WEBPACK_IMPORTED_MODULE_9__["default"].isEnabled) {
        // console.log("screen",this.$refs.container)
        screenfull__WEBPACK_IMPORTED_MODULE_9__["default"].toggle(this.$refs.rootContainer);
        this.isFullscreen = !this.isFullscreen;
        // if (!this.isFullscreen) {
        //   this.$refs.rootContainer.style.top = "0";
        //   this.$refs.rootContainer.style.left = "50%";
        //   this.$refs.rootContainer.style.transform = "translate(-50%, 0)";
        // }
      }
    },
    autoPlay() {
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_5__["isElectron"])()) {
        return;
      }
      console.log("can play");
      if (!this.autoPlayInterval) {
        this.autoPlayInterval = setInterval(() => {
          try {
            if (this.$refs.localVideo && this.$refs.localVideo.paused) {
              this.$refs.localVideo.play();
              console.log("can play local");
            }
            if (this.$refs.remoteVideo && this.$refs.remoteVideo.paused) {
              this.$refs.remoteVideo.play();
              console.log("can play remote");
            }
          } catch (e) {
            // do nothing
          }
          if (this.$refs.localVideo && !this.$refs.localVideo.paused && this.$refs.remoteVideo && !this.$refs.remoteVideo.paused) {
            clearInterval(this.autoPlayInterval);
            this.autoPlayInterval = 0;
          }
        }, 100);
      }
    },
    switchVideoType() {
      if (!this.session) {
        return;
      }
      let userId = this.session.getParticipantIds()[0];
      let subscriber = this.session.getSubscriber(userId, false);
      if (subscriber) {
        let currentVideoType = subscriber.currentVideoType;
        let videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_7__["default"].NONE;
        if (currentVideoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_7__["default"].NONE) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_7__["default"].BIG_STREAM;
        } else if (currentVideoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_7__["default"].BIG_STREAM) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_7__["default"].SMALL_STREAM;
        } else if (currentVideoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_7__["default"].SMALL_STREAM) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_7__["default"].NONE;
        }
        console.log("setParticipantVideoType", userId, videoType);
        this.session.setParticipantVideoType(userId, false, videoType);
      }
    },
    setupSessionCallback() {
      let sessionCallback = new _wfc_av_engine_callSessionCallback__WEBPACK_IMPORTED_MODULE_3__["default"]();

      // 可能回调多次
      sessionCallback.didChangeState = state => {
        this.status = state;
        console.log("didChangeState", state);
        if (state === _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_4__["default"].STATUS_CONNECTED) {
          if (this.startTimestamp === 0) {
            this.startTimestamp = new Date().getTime();
            this.timer = setInterval(() => {
              this.currentTimestamp = new Date().getTime();
            }, 1000);
          }
        } else if (state === _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_4__["default"].STATUS_IDLE) {
          if (this.timer) {
            clearInterval(this.timer);
          }
        }
        console.log("status change", state);
      };
      sessionCallback.onInitial = (session, selfUserInfo, initiatorUserInfo, participantUserInfos) => {
        this.session = session;
        this.audioOnly = session.audioOnly;
        this.participantUserInfos = [...participantUserInfos];
      };
      sessionCallback.didChangeMode = audioOnly => {
        this.audioOnly = audioOnly;
      };
      sessionCallback.didCreateLocalVideoTrack = stream => {
        this.localStream = stream;
        this.autoPlay();
      };
      sessionCallback.didReceiveRemoteVideoTrack = (userId, stream) => {
        this.remoteStream = stream;
        this.autoPlay();
      };
      sessionCallback.didCallEndWithReason = reason => {
        console.log("callEndWithReason", reason);
        this.session.closeVoipWindow();
        this.session = null;
      };
      sessionCallback.didVideoMuted = (userId, muted) => {
        console.log("didVideoMuted", userId, muted);
        this.muted = muted;
      };
      sessionCallback.didMediaLostPacket = (media, lostPacket) => {
        if (lostPacket > 6) {
          console.log("您的网络不好");
        }
      };
      sessionCallback.didUserMediaLostPacket = (userId, media, lostPacket, uplink) => {
        //如果uplink ture对方网络不好，false您的网络不好
        //接收方丢包超过10为网络不好
        if (lostPacket > 10) {
          if (uplink) {
            console.log("对方网络不好");
          } else {
            console.log("您的网络不好");
          }
        }
      };
      sessionCallback.didParticipantConnected = userId => {
        console.log("didParticipantConnected", userId);
      };
      sessionCallback.didReportAudioVolume = (userId, volume) => {
        // console.log('didReportAudioVolume', userId, volume)
      };
      _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2___default.a.sessionCallback = sessionCallback;
    },
    answer() {
      this.session.call();
    },
    hangup() {
      this.session.hangup();
    },
    switchCamera() {
      if (!this.session || this.session.isScreenSharing()) {
        return;
      }
      // The order is significant - the default capture devices will be listed first.
      // navigator.mediaDevices.enumerateDevices()
      navigator.mediaDevices.enumerateDevices().then(devices => {
        devices = devices.filter(d => d.kind === "videoinput");
        if (devices.length < 2) {
          console.log("switchCamera error, no more video input device");
          return;
        }
        this.videoInputDeviceIndex++;
        if (this.videoInputDeviceIndex >= devices.length) {
          this.videoInputDeviceIndex = 0;
        }
        this.session.setVideoInputDeviceId(devices[this.videoInputDeviceIndex].deviceId);
        console.log("setVideoInputDeviceId", devices[this.videoInputDeviceIndex]);
      });
    },
    mute() {
      let enable = this.session.audioMuted ? true : false;
      this.session.selfUserInfo._isAudioMuted = !enable;
      this.session.setAudioEnabled(enable);
    },
    down2voice() {
      this.session.downgrade2Voice();
    },
    screenShare() {
      if (this.session.isScreenSharing()) {
        this.session.stopScreenShare();
      } else {
        if (Object(_platform__WEBPACK_IMPORTED_MODULE_5__["isElectron"])()) {
          let beforeClose = event => {
            // What a gamble... 50% chance to cancel closing
            if (!event.params) {
              return;
            }
            if (event.params.source) {
              let source = event.params.source;
              let desktopShareOptions = {
                sourceId: source.id
                // minWidth: 1280,
                // maxWidth: 1280,
                // minHeight: 720,
                // maxHeight: 720
              };
              this.session.startScreenShare(desktopShareOptions);
            }
          };
          this.$modal.show(_ScreenOrWindowPicker__WEBPACK_IMPORTED_MODULE_6__["default"], {}, {
            width: 360,
            height: 620,
            name: "screen-window-picker-modal",
            clickToClose: false
          }, {
            // 'before-open': beforeOpen,
            "before-close": beforeClose
            // 'closed': closed,
          });
        } else {
          this.session.startScreenShare();
        }
      }
    },
    timestampFormat(timestamp) {
      timestamp = ~~(timestamp / 1000);
      let str = "";
      let hour = ~~(timestamp / 3600);
      str = hour > 0 ? (hour < 10 ? "0" : "") + hour + ":" : "";
      let min = ~~(timestamp % 3600 / 60);
      str += (min < 10 ? "0" : "") + min + ":";
      let sec = ~~(timestamp % 60);
      str += (sec < 10 ? "0" : "") + sec;
      return str;
    }
  },
  mounted() {
    console.log("single mounted");
    let supportConference = _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2___default.a.startConference !== undefined;
    if (!supportConference) {
      let host = window.location.host;
      if (host.indexOf("wildfirechat.cn") === -1 && host.indexOf("localhost") === -1) {
        for (const ice of _config__WEBPACK_IMPORTED_MODULE_8__["default"].ICE_SERVERS) {
          if (ice[0].indexOf("turn.wildfirechat.net") >= 0) {
            // 显示自行部署 turn 提示
            this.showWebrtcTip = true;
            setTimeout(() => {
              this.showWebrtcTip = false;
            }, 10 * 1000);
            break;
          }
        }
      }
    }
    // 必须
    if (Object(_platform__WEBPACK_IMPORTED_MODULE_5__["isElectron"])()) {
      _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_2___default.a.setup();
    }
    this.setupSessionCallback();
    this.setTimer();
  },
  destroyed() {
    if (this.timer) {
      clearTimeout(this.timer);
      this.timer = null;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ChooseConferenceLayoutView.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ChooseConferenceLayoutView.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ChooseConferenceLayoutView",
  props: {
    currentLayout: {
      type: Number,
      required: true
    }
  },
  methods: {
    setCurrentLayout(layout) {
      this.$parent.setCurrentLayout(layout);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/Conference.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/Conference.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.find.js */ "./node_modules/core-js/modules/es.iterator.find.js");
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../wfc/av/internal/engine.min */ "./src/wfc/av/internal/engine.min.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wfc_av_engine_callSessionCallback__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../wfc/av/engine/callSessionCallback */ "./src/wfc/av/engine/callSessionCallback.js");
/* harmony import */ var _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../wfc/av/engine/callState */ "./src/wfc/av/engine/callState.js");
/* harmony import */ var vue_click_outside__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! vue-click-outside */ "./node_modules/vue-click-outside/index.js");
/* harmony import */ var vue_click_outside__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(vue_click_outside__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _ipc_localStorageEmitter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../ipc/localStorageEmitter */ "./src/ipc/localStorageEmitter.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _ScreenOrWindowPicker__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../ScreenOrWindowPicker */ "./src/ui/voip/ScreenOrWindowPicker.vue");
/* harmony import */ var _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../wfc/av/engine/callEndReason */ "./src/wfc/av/engine/callEndReason.js");
/* harmony import */ var _ScreenShareControlView__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../ScreenShareControlView */ "./src/ui/voip/ScreenShareControlView.vue");
/* harmony import */ var _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../../wfc/av/engine/avenginekitproxy */ "./src/wfc/av/engine/avenginekitproxy.js");
/* harmony import */ var _common_ElectronWindowsControlButtonView__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../common/ElectronWindowsControlButtonView */ "./src/ui/common/ElectronWindowsControlButtonView.vue");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../../wfc/av/engine/videoType */ "./src/wfc/av/engine/videoType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @/wfc/ipcEventType */ "./src/wfc/ipcEventType.js");
/* harmony import */ var _wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _ConferenceParticipantVideoView__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./ConferenceParticipantVideoView */ "./src/ui/voip/conference/ConferenceParticipantVideoView.vue");
/* harmony import */ var _main_conversation_ConversationView__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../main/conversation/ConversationView */ "./src/ui/main/conversation/ConversationView.vue");
/* harmony import */ var _ConferenceSimpleInfoView__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./ConferenceSimpleInfoView */ "./src/ui/voip/conference/ConferenceSimpleInfoView.vue");
/* harmony import */ var _ChooseConferenceLayoutView__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./ChooseConferenceLayoutView */ "./src/ui/voip/conference/ChooseConferenceLayoutView.vue");
/* harmony import */ var _ConferenceConversationFloatingView__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./ConferenceConversationFloatingView */ "./src/ui/voip/conference/ConferenceConversationFloatingView.vue");
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");
/* harmony import */ var _ConferenceManageView__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./ConferenceManageView */ "./src/ui/voip/conference/ConferenceManageView.vue");
/* harmony import */ var _ui_voip_conference_ConferenceMemberListView_vue__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @/ui/voip/conference/ConferenceMemberListView.vue */ "./src/ui/voip/conference/ConferenceMemberListView.vue");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _ipc_localStorageIpcEventType__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../../ipc/localStorageIpcEventType */ "./src/ipc/localStorageIpcEventType.js");
/* harmony import */ var _wfc_model_userInfo__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../../wfc/model/userInfo */ "./src/wfc/model/userInfo.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../../wfc/model/conversationInfo */ "./src/wfc/model/conversationInfo.js");
/* harmony import */ var _wfc_model_chatRoomInfo__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../../wfc/model/chatRoomInfo */ "./src/wfc/model/chatRoomInfo.js");
/* harmony import */ var screenfull__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! screenfull */ "./node_modules/screenfull/index.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! dayjs */ "./node_modules/dayjs/dayjs.min.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_36___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_36__);
/* harmony import */ var dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! dayjs/locale/zh-cn */ "./node_modules/dayjs/locale/zh-cn.js");
/* harmony import */ var dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_37___default = /*#__PURE__*/__webpack_require__.n(dayjs_locale_zh_cn__WEBPACK_IMPORTED_MODULE_37__);
/* harmony import */ var dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! dayjs/plugin/weekday */ "./node_modules/dayjs/plugin/weekday.js");
/* harmony import */ var dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_38___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_38__);







































dayjs__WEBPACK_IMPORTED_MODULE_36___default.a.locale("zh-cn"); // 本地化
dayjs__WEBPACK_IMPORTED_MODULE_36___default.a.extend(dayjs_plugin_weekday__WEBPACK_IMPORTED_MODULE_38___default.a); // 第一天为周一

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "Conference",
  props: {
    memberList: {
      type: Array,
      default() {
        return [];
      }
    },
    allMembers: {
      type: Array,
      default() {
        return [];
      }
    },
    isSingle: Boolean,
    callType: String
  },
  data() {
    return {
      voipProxy: _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_15__["default"],
      conferenceLimit: 3600,
      // 会议时长上限 单位秒 默认一小时（3600秒）
      connectingLimit: 60,
      // 拨号时长上限 单位秒 默认 1分钟（60秒）
      timer: null,
      timeTik: 0,
      timeTikFormat: "",
      diallingTimer: null,
      diallingTime: 0,
      currentDatetime: dayjs__WEBPACK_IMPORTED_MODULE_36___default()().format("YYYY-MM-DD dddd HH:mm:ss"),
      isFullscreen: false,
      session: null,
      audioOnly: false,
      status: 1,
      selfUserInfo: null,
      participantUserInfos: [],
      startTimestamp: 0,
      currentTimestamp: 0,
      showSlider: true,
      showConferenceManageView: true,
      showConversationView: false,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_17__["default"].state.misc,
      videoInputDeviceIndex: 0,
      refreshUserInfoInternal: 0,
      endReason: undefined,
      conferenceManager: _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"],
      // -1，默认布局，也就是宫格布局；0, 宫格视图；1，演讲者视图
      currentLayout: -1,
      // 宫格视图
      currentGridPageIndex: 0,
      participantCountPerGridPage: 9,
      // 演讲者视图
      speakingVideoParticipant: null,
      hideFocusLayoutParticipantListVideoView: false,
      showConferenceSimpleInfoView: false,
      showChooseLayoutView: false,
      dialling: false,
      // 是否拨打电话中
      calling: false // 是否通话中
    };
  },
  components: {
    ConferenceManageView: _ConferenceManageView__WEBPACK_IMPORTED_MODULE_26__["default"],
    ConferenceConversationFloatingView: _ConferenceConversationFloatingView__WEBPACK_IMPORTED_MODULE_24__["default"],
    ChooseConferenceLayoutView: _ChooseConferenceLayoutView__WEBPACK_IMPORTED_MODULE_23__["default"],
    ConferenceSimpleInfoView: _ConferenceSimpleInfoView__WEBPACK_IMPORTED_MODULE_22__["default"],
    ConferenceParticipantVideoView: _ConferenceParticipantVideoView__WEBPACK_IMPORTED_MODULE_20__["default"],
    ScreenShareControlView: _ScreenShareControlView__WEBPACK_IMPORTED_MODULE_14__["default"],
    ElectronWindowsControlButtonView: _common_ElectronWindowsControlButtonView__WEBPACK_IMPORTED_MODULE_16__["default"],
    ConversationView: _main_conversation_ConversationView__WEBPACK_IMPORTED_MODULE_21__["default"],
    ConferenceMemberListView: _ui_voip_conference_ConferenceMemberListView_vue__WEBPACK_IMPORTED_MODULE_27__["default"]
  },
  methods: {
    setTimer() {
      this.timer = setTimeout(() => {
        this.timeTik++;
        this.currentDatetime = dayjs__WEBPACK_IMPORTED_MODULE_36___default()().format("YYYY-MM-DD dddd HH:mm:ss");
        this.setTimer();
      }, 1000);
    },
    /**
     * * 多人会议发起后给每个参会人计时
     */
    setAllMembersTimer() {
      this.allMembersTimer = setInterval(() => {
        this.memberList.forEach(member => {
          const hasKey = Object.prototype.hasOwnProperty.call(member, "timer");
          const beKickOut = member.beKickOut;
          if (!hasKey || beKickOut || member.state === "CONNECTED") {
            member.timer = 0;
          } else {
            // console.log("现在的人员状态是。。", member.state);
            if (member.timer < this.connectingLimit && member.state === "CONNECTING") {
              member.timer++;
              member.timeout = false;
            } else {
              // console.log("进入了超时判断", member.state);
              if (member.state !== "DISCONNECTED") {
                member.timer = 0;
                member.timeout = true;
                member.state = "DISCONNECTED";
              }
            }
          }
        });
        this.$emit("update:memberList", JSON.parse(JSON.stringify(this.memberList)));
        // console.log("%c memberList", "background: #00cc00; color: #fff; border-radius: 3px;padding:2px 5px", this.memberList);
      }, 1000);
    },
    // 用来解决 iOS 上，不能自动播放问题
    autoPlay() {
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_11__["isElectron"])()) {
        return;
      }
      console.log("auto play");
      if (!this.autoPlayInterval) {
        this.autoPlayInterval = setInterval(() => {
          try {
            let videos = document.getElementsByTagName("video");
            let allPlaying = true;
            for (const video of videos) {
              if (video.paused) {
                allPlaying = false;
                break;
              }
            }
            // participantUserInfos 不包含自己
            if (allPlaying && videos.length === this.participantUserInfos.filter(p => !p._isAudience).length + 1) {
              clearInterval(this.autoPlayInterval);
              this.autoPlayInterval = 0;
              console.log("auto play, allPlaying", videos.length);
              return;
            }
            for (const video of videos) {
              if (video.paused) {
                video.play();
              }
            }
          } catch (e) {
            // do nothing
          }
        }, 100);
      }
    },
    setupSessionCallback() {
      let sessionCallback = new _wfc_av_engine_callSessionCallback__WEBPACK_IMPORTED_MODULE_7__["default"]();
      sessionCallback.didChangeState = state => {
        console.log("didChangeState", state);
        this.status = state;
        if (state === _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_8__["default"].STATUS_CONNECTED) {
          // 比如没有摄像头，但发起视频通话时，会自动 muteVideo
          this.selfUserInfo._isVideoMuted = this.session.videoMuted;
          if (this.startTimestamp === 0) {
            this.startTimestamp = new Date().getTime();
            this.timer = setInterval(() => {
              this.currentTimestamp = new Date().getTime();
            }, 1000);
          }
        } else if (state === _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_8__["default"].STATUS_IDLE) {
          if (this.timer) {
            clearInterval(this.timer);
          }
        }
      };
      sessionCallback.onInitial = (session, selfUserInfo) => {
        //this.session.rotateAng = 90;

        selfUserInfo._isHost = session.host === selfUserInfo.uid;
        selfUserInfo._isAudience = session.audience;
        selfUserInfo._isVideoMuted = session.videoMuted;
        selfUserInfo._isAudioMuted = session.audioMuted;
        selfUserInfo._volume = 0;
        // 先添加属性，在赋值，才能 reactive
        this.selfUserInfo = selfUserInfo;
        this.participantUserInfos = [selfUserInfo];
        console.log("oninitial", selfUserInfo._isAudience);
        // pls refer to: https://vuejs.org/v2/guide/reactivity.html
        this.$set(this.selfUserInfo, "_stream", null);
        this.$set(this.selfUserInfo, "_screenShareStream", null);
        this.$set(this.selfUserInfo, "_isScreenSharing", false);
        this.participantUserInfos.forEach(p => this.$set(p, "_stream", null));
        this.session = session;
        document.title = session.title;
        _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].getConferenceInfo(session.callId);
      };
      sessionCallback.didCreateLocalVideoTrack = (stream, screenShare) => {
        console.log("didCreateLocalVideoTrack", screenShare);
        if (screenShare) {
          this.selfUserInfo._screenShareStream = stream;
        } else {
          this.selfUserInfo._stream = stream;
          this.selfUserInfo._screenShareStream = null;
          this.selfUserInfo._isVideoMuted = false;
        }
        this.selfUserInfo._isScreenSharing = screenShare;
        this.autoPlay();
      };
      sessionCallback.didRotateLocalVideoTrack = stream => {
        console.log("didRotateLocalVideoTrack", stream.getAudioTracks());
        this.selfUserInfo._stream = stream;
        this.selfUserInfo._stream.timestamp = new Date().getTime();
      };
      sessionCallback.didScreenShareEnded = () => {
        console.log("didScreenShareEnded", this.session.videoMuted, this.session.audioMuted);
        if (Object(_platform__WEBPACK_IMPORTED_MODULE_11__["isElectron"])()) {
          _platform__WEBPACK_IMPORTED_MODULE_11__["currentWindow"].setIgnoreMouseEvents(false);
        }
        this.selfUserInfo._isScreenSharing = false;
        this.selfUserInfo._isVideoMuted = this.session.videoMuted;
      };
      sessionCallback.didCreateLocalVideoTrackError = () => {
        // TODO
        // 没有摄像头或者麦克风，加入会议时，会回调到此处，自己断会显示自己的头像，其他端会显示黑屏
        // 可以进行相关提示
      };
      sessionCallback.didReceiveRemoteVideoTrack = (userId, stream, screenSharing) => {
        let p;
        console.log("didReceiveRemoteVideoTrack", userId, stream, screenSharing);
        // let index = -1;
        for (let i = 0; i < this.participantUserInfos.length; i++) {
          p = this.participantUserInfos[i];
          if (p.uid === userId && p._isScreenSharing === screenSharing) {
            // index = i;
            p._stream = stream;
            p._stream.timestamp = new Date().getTime();
            break;
          }
        }
        // if (index > -1) {
        //     this.$set(this.participantUserInfos, index, p);
        // }
        this.autoPlay();
      };
      sessionCallback.didRemoveRemoteVideoTrack = userId => {
        console.log("didRemoveRemoteVideoTrack", userId);
      };

      /**
       * * 新参与者加入
       * @param userId
       * @param screenSharing
       */
      sessionCallback.didParticipantJoined = (userId, screenSharing) => {
        console.log("didParticipantJoined", userId, screenSharing);
        let userInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_28__["default"].getUserInfo(userId);
        let subscriber = this.session.getSubscriber(userId, screenSharing);
        userInfo._stream = subscriber.stream;
        userInfo._isAudience = subscriber.audience;
        userInfo._isHost = this.session.host === userId;
        userInfo._isVideoMuted = subscriber.videoMuted;
        userInfo._isAudioMuted = subscriber.audioMuted;
        userInfo._volume = 0;
        userInfo._isScreenSharing = screenSharing;
        // 动态添加的属性不是 reactive 的，故直接创建个新的对象
        // 其实这个问题很奇怪，只有发起会议，第一次进入该会议的时候，其他端加入，参与者列表会不刷新；重新进入等，都一切正常
        this.participantUserInfos.push(Object.assign(new _wfc_model_userInfo__WEBPACK_IMPORTED_MODULE_30__["default"](), userInfo));
        console.log("members ls", this.memberList);
        this.memberList.forEach(x => {
          if (x.tencentUserId === userId) {
            x.state = "CONNECTED";
          }
        });
        this.$emit("update:memberList", [...this.memberList]);
        this.$emit("participantJoined", userId);
        console.log("joined", userInfo, subscriber.audience, this.participantUserInfos.length);
      };
      sessionCallback.didParticipantLeft = (userId, endReason, screenSharing) => {
        console.log("didParticipantLeft", userId, endReason, screenSharing, JSON.stringify(this.participantUserInfos), this.participantUserInfos.length);
        //this.participantUserInfos = this.participantUserInfos.filter(p => p.uid !== userId && p._isScreenSharing !== screenSharing);
        this.participantUserInfos = this.participantUserInfos.filter(p => {
          return !(p.uid === userId && p._isScreenSharing === screenSharing);
        });
        const memberList = [...this.memberList];
        memberList.forEach(item => {
          if (item.tencentUserId === userId) {
            item.state = "DISCONNECTED";
            item.beKickOut = true;
          }
        });
        this.$emit("update:memberList", memberList);
        this.$emit("participantLeft", userId);
        //fixme 上面可能会没有触发重新计算 focusVideoParticipant
        console.log("didParticipantLeft d", userId, endReason, screenSharing, this.participantUserInfos.length);
      };
      sessionCallback.didCallEndWithReason = reason => {
        console.log("callEndWithReason", reason);
        _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].addHistory(_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].conferenceInfo, new Date().getTime() - _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].conferenceInfo.startTime * 1000);
        // 可以根据reason，进行一些提示
        // alert('会议已结束');

        this.endReason = reason;
        if (reason === _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_13__["default"].REASON_MediaError) {
          return;
        }
        if (reason === _wfc_av_engine_callEndReason__WEBPACK_IMPORTED_MODULE_13__["default"].RoomNotExist) {
          console.log("join conference failed", reason, this.session);
          let obj = {
            reason: reason,
            session: this.session
          };
          _ipc_localStorageEmitter__WEBPACK_IMPORTED_MODULE_10__["default"].send(_ipc_localStorageIpcEventType__WEBPACK_IMPORTED_MODULE_29__["default"].joinConferenceFailed, obj);
        }
        this.session.closeVoipWindow();
        this.session = null;
      };
      sessionCallback.onRequestChangeMode = audience => {
        console.log("onRequestChangeMode", audience);
        if (audience) {
          this.session.switchAudience(true);
          return;
        }
        this.$alert({
          content: "主持人邀请你参与互动",
          cancelCallback: () => {
            // do nothing
          },
          confirmCallback: () => {
            this.session.switchAudience(false);
          }
        });
      };
      sessionCallback.didChangeType = (userId, audience, screenSharing) => {
        console.log("didChangeType", userId, audience, screenSharing);
        this.participantUserInfos.forEach(u => {
          if (u.uid === userId && u._isScreenSharing === screenSharing) {
            u._isAudience = audience;
            if (audience) {
              u._stream = null;
            }
            if (this.speakingVideoParticipant && this.speakingVideoParticipant.uid === u.uid) {
              this.speakingVideoParticipant = null;
            }
          }
        });
      };
      sessionCallback.didReportAudioVolume = (userId, volume) => {
        let userInfo;
        if (userId === this.selfUserInfo.uid) {
          this.selfUserInfo._volume = volume;
          userInfo = this.selfUserInfo;
        } else {
          this.participantUserInfos.forEach(u => {
            if (u.uid === userId && u._isScreenSharing === false) {
              u._volume = volume;
              userInfo = u;
            }
          });
        }
        if (this.currentLayout === 0) {
          return;
        }
        if (!userInfo) {
          return;
        }
        if (userInfo._isVideoMuted) {
          return;
        }
        if (this.conferenceFocusUser) {
          return this.conferenceFocusUser;
        }
        if (!this.speakingVideoParticipant) {
          this.speakingVideoParticipant = userInfo;
        } else if (userInfo._volume > this.speakingVideoParticipant._volume) {
          this.speakingVideoParticipant = userInfo;
        }
      };
      sessionCallback.didMuteStateChanged = participants => {
        console.log("conference", "didMuteStateChanged", participants);
        participants.forEach(p => {
          // 自己
          if (p === this.selfUserInfo.uid) {
            console.log("conference", "didMuteStateChanged self", this.session.videoMuted);
            this.selfUserInfo._isVideoMuted = this.session.videoMuted;
            return;
          }
          let s = this.session.getSubscriber(p);
          if (!s) {
            return;
          }
          console.log("conference", "didMuteStateChanged", p, s.videoMuted, s.audioMuted);
          this.participantUserInfos.forEach(u => {
            if (u.uid === p && u._isScreenSharing === false) {
              let subscriber = this.session.getSubscriber(p);
              u._isVideoMuted = subscriber.videoMuted;
              u._isAudioMuted = subscriber.audioMuted;
              if (this.speakingVideoParticipant && this.speakingVideoParticipant.uid === u.uid) {
                this.speakingVideoParticipant = null;
              }
            }
          });
        });
      };
      sessionCallback.didMediaLostPacket = (media, lostPacket, screenSharing) => {
        console.log("didMediaLostPacket", media, lostPacket, screenSharing);
        if (lostPacket > 6) {
          console.log("您的网络不好");
        }
      };
      sessionCallback.didUserMediaLostPacket = (userId, media, lostPacket, uplink, screenSharing) => {
        console.log("didUserMediaLostPacket", userId, media, lostPacket, uplink, screenSharing);
        //如果uplink ture对方网络不好，false您的网络不好
        //接收方丢包超过10为网络不好
        if (lostPacket > 10) {
          if (uplink) {
            let userInfos = this.participantUserInfos.filter(u => u.uid === userId && u._isScreenSharing === screenSharing);
            if (userInfos && userInfos.length > 0) {
              console.log(userInfos[0].displayName, "网络不好");
            }
          } else {
            console.log("您的网络不好");
          }
        }
      };
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_11__["isElectron"])()) {
        _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_6___default.a.setup(sessionCallback);
      } else {
        _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_6___default.a.sessionCallback = sessionCallback;
      }
    },
    handleScreen() {
      if (screenfull__WEBPACK_IMPORTED_MODULE_35__["default"].isEnabled) {
        // console.log("screen",this.$refs.container)
        screenfull__WEBPACK_IMPORTED_MODULE_35__["default"].toggle(this.$refs.rootContainer);
        this.isFullscreen = !this.isFullscreen;
        if (!this.isFullscreen) {
          this.$refs.rootContainer.style.top = "0";
          this.$refs.rootContainer.style.left = "50%";
          this.$refs.rootContainer.style.transform = "translate(-50%, 0)";
        }
      }
    },
    hangup() {
      if (this.allMembersTimer) {
        clearInterval(this.allMembersTimer);
        this.allMembersTimer = null;
      }
      const memberList = this.memberList.map(x => {
        return {
          ...x,
          state: "CONNECTING",
          action: "",
          timer: 0,
          timeout: false,
          beKickOut: false,
          hangup: false
        };
      });
      this.$emit("update:memberList", memberList);
      this.$emit("hangup");
      this.session.leaveConference(true);
      _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].addHistory(_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].conferenceInfo, new Date().getTime() - _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].conferenceInfo.startTime * 1000);
    },
    muteAudio() {
      let enable = this.session.audioMuted ? true : false;
      if (enable && !_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].isOwner() && !_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].conferenceInfo.allowSwitchMode) {
        this.requestUnmute(true);
        return;
      }
      this._muteAudio(enable);
    },
    async _muteAudio(enable) {
      let result = await this.session.setAudioEnabled(enable);
      if (!result) {
        return;
      }
      this.selfUserInfo._isAudioMuted = !enable;
      console.log("muteAudio", this.selfUserInfo._isAudioMuted, this.session.audience);
      if (enable) {
        if (this.session.audience) {
          await this.session.switchAudience(false);
          this.selfUserInfo._isAudience = false;
        }
      } else {
        if (this.session.videoMuted && !this.session.audience) {
          await this.session.switchAudience(true);
          this.selfUserInfo._isAudience = true;
        }
      }
    },
    muteVideo() {
      let enable = this.session.videoMuted ? true : false;
      if (enable && !_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].isOwner() && !_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].conferenceInfo.allowSwitchMode) {
        this.requestUnmute(false);
        return;
      }
      this._muteVideo(enable);
    },
    async _muteVideo(enable) {
      let result = await this.session.setVideoEnabled(enable);
      if (!result) {
        return;
      }
      this.selfUserInfo._isVideoMuted = !enable;
      console.log("muteVideo result", this.selfUserInfo._isVideoMuted, this.session.audience);
      if (enable) {
        if (this.session.audience) {
          await this.session.switchAudience(false);
          this.selfUserInfo._isAudience = false;
        }
      } else {
        if (this.session.audioMuted && !this.session.audience) {
          await this.session.switchAudience(true);
          this.selfUserInfo._isAudience = true;
        }
      }
    },
    requestUnmute() {
      this.$alert({
        content: "主持人不允许解除静音，您可以向主持人申请解除静音",
        confirmText: "申请",
        cancelCallback: () => {
          // do nothing
        },
        confirmCallback: () => {
          _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].applyUnmute(false);
        }
      });
    },
    down2voice() {
      this.session.downgrade2Voice();
    },
    members() {
      this.showConferenceManageView = !this.showConferenceManageView;
      this.toggleSliderView();
    },
    chat() {
      if (Object(_platform__WEBPACK_IMPORTED_MODULE_11__["isElectron"])()) {
        this.showConversationView = !this.showConversationView;
        this.toggleSliderView();
      } else {
        let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_32__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_31__["default"].ChatRoom, this.session.callId, 0);
        let chatroomInfo = new _wfc_model_chatRoomInfo__WEBPACK_IMPORTED_MODULE_34__["default"]();
        chatroomInfo.chatRoomId = this.session.callId;
        chatroomInfo.title = this.session.title;
        conversation._target = chatroomInfo;
        conversation._target._displayName = chatroomInfo.title;
        let conversationInfo = new _wfc_model_conversationInfo__WEBPACK_IMPORTED_MODULE_33__["default"]();
        conversationInfo.conversation = conversation;
        _store_js__WEBPACK_IMPORTED_MODULE_17__["default"].setCurrentConversationInfo(conversationInfo);
        this.$router.replace("/home");
      }
    },
    hideParticipantList() {
      this.showConferenceManageView && (this.showConferenceManageView = false);
      this.toggleSliderView();
    },
    toggleSliderView() {
      if (!this.showSlider) {
        // if (isElectron()) {
        //   let size = currentWindow.getSize();
        //   currentWindow.setSize(size[0] + 350, size[1], false);
        // } else {
        //   window.resizeTo(window.innerWidth + 360, window.outerHeight);
        // }
        this.$refs.rootContainer.style.setProperty("--slider-width", "350px");
      } else {
        // if (isElectron()) {
        //   let size = currentWindow.getSize();
        //   this.$refs.rootContainer.style.setProperty("--slider-width", "0px");
        //   currentWindow.setSize(size[0] - 350, size[1], false);
        // } else {
        this.$refs.rootContainer.style.setProperty("--slider-width", "0px");
        window.resizeTo(window.innerWidth - 350, window.outerHeight);
        // }

        this.showConferenceManageView = false;
        this.showConversationView = false;
      }
      this.showSlider = !this.showSlider;
    },
    async screenShare() {
      // if (true) {
      //     navigator.mediaDevices.enumerateDevices().then(deviceInfos => {
      //         // test input
      //         for (const deviceInfo of deviceInfos) {
      //             if (this.testCount % 2 === 0) {
      //                    //仅仅是为测试了，生成不能这么写死
      //                 if (deviceInfo.label === "外置麦克风 (Built-in)") {
      //                     console.log('audioInput 外置');
      //                     this.session.setAudioInputDeviceId(deviceInfo.deviceId);
      //                     break;
      //                 }
      //             } else {
      //                 if (deviceInfo.label === "MacBook Pro麦克风 (Built-in)") {
      //                     console.log('audioInput 内置');
      //                     this.session.setAudioInputDeviceId(deviceInfo.deviceId);
      //                     break;
      //                 }
      //             }
      //         }
      //
      //         // test output
      //         // for (const deviceInfo of deviceInfos) {
      //         //     if (this.testCount % 2 === 0) {
      //         //         if (deviceInfo.label === "外置耳机 (Built-in)") {
      //         //             console.log('audioOut 外置');
      //         //             this.setAudioOutputDeviceId(deviceInfo.deviceId)
      //         //             break;
      //         //         }
      //         //     } else {
      //         //         if (deviceInfo.label === "MacBook Pro扬声器 (Built-in)") {
      //         //             console.log('audioOutput 内置');
      //         //             this.setAudioOutputDeviceId(deviceInfo.deviceId)
      //         //             break;
      //         //         }
      //         //     }
      //         // }
      //
      //     }).catch(err => {
      //         console.log()
      //     })
      //     this.testCount++;
      //     return;
      // }

      if (this.session.screenSharing) {
        this.session.stopScreenShare();
        console.log("stopScreenShare", this.session.videoMuted, this.session.audioMuted);
        if (this.session.videoMuted && this.session.audioMuted) {
          this.session.switchAudience(true);
        }
        // currentWindow.setIgnoreMouseEvents(false)
      } else {
        if (Object(_platform__WEBPACK_IMPORTED_MODULE_11__["isElectron"])()) {
          let beforeClose = event => {
            // What a gamble... 50% chance to cancel closing
            if (!event.params) {
              return;
            }
            if (event.params.source) {
              let source = event.params.source;
              let desktopShareOptions = {
                sourceId: source.id,
                minWidth: 1280,
                maxWidth: 1280,
                minHeight: 720,
                maxHeight: 720
              };
              if (this.session.audience) {
                this.session.switchAudience(false).then(() => {
                  this.session.startScreenShare(desktopShareOptions);
                }).catch(err => {
                  console.error(err);
                });
              } else {
                this.session.startScreenShare(desktopShareOptions);
              }
              _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_15__["default"].emitToMain(_wfc_ipcEventType__WEBPACK_IMPORTED_MODULE_19___default.a.START_SCREEN_SHARE, {});
            }
          };
          this.$modal.show(_ScreenOrWindowPicker__WEBPACK_IMPORTED_MODULE_12__["default"], {}, {
            width: 800,
            height: 600,
            name: "screen-window-picker-modal",
            clickToClose: false
          }, {
            // 'before-open': beforeOpen,
            "before-close": beforeClose
            // 'closed': closed,
          });
        } else {
          if (this.session.audience) {
            await this.session.switchAudience(false);
          }
          this.session.startScreenShare({
            frameRate: 30
          });
        }
      }
    },
    // 设置音频输出设备
    setAudioOutputDeviceId(deviceId) {
      let audioEls = this.$el.getElementsByTagName("audio");
      for (const audioEl of audioEls) {
        audioEl.setSinkId(deviceId);
      }
      let videoEls = this.$el.getElementsByTagName("video");
      for (const videoEl of videoEls) {
        videoEl.setSinkId(deviceId);
      }
    },
    handup() {
      _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].handUp(!_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].isHandUp);
    },
    userName(user) {
      let name = "";
      if (user.groupAlias) {
        name = user.groupAlias;
      } else if (user.friendAlias) {
        name = user.friendAlias;
      } else if (user.displayName) {
        name = user.displayName;
      } else {
        name = user.name;
      }
      return name;
    },
    timestampFormat(timestamp) {
      timestamp = ~~(timestamp / 1000);
      let str = "";
      let hour = ~~(timestamp / 3600);
      str = hour > 0 ? (hour < 10 ? "0" : "") + hour + ":" : "";
      let min = ~~(timestamp % 3600 / 60);
      str += (min < 10 ? "0" : "") + min + ":";
      let sec = ~~(timestamp % 60);
      str += (sec < 10 ? "0" : "") + sec;
      return str;
    },
    // TODO 删除，可以直接监听用户信息变化了
    refreshUserInfos() {
      let toRefreshUsers = [];
      this.participantUserInfos.forEach(pu => {
        if (!pu.updateDt) {
          toRefreshUsers.push(pu.uid);
        }
      });
      if (toRefreshUsers.length > 0) {
        console.log("to refreshUsers", toRefreshUsers);
        let userInfos = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_28__["default"].getUserInfos(toRefreshUsers, "");
        userInfos.forEach(u => {
          let index = this.participantUserInfos.findIndex(p => p.uid === u.uid);
          if (u.updateDt && index > -1) {
            let ou = this.participantUserInfos[index];
            u._stream = ou._stream;
            u._isAudience = ou._isAudience;
            u._isHost = ou._isHost;
            u._isVideoMuted = ou._isVideoMuted;
            u._isAudioMuted = ou._isAudioMuted;
            u._volume = ou._volume;
            // FYI: https://v2.vuejs.org/v2/guide/reactivity#Change-Detection-Caveats
            this.participantUserInfos.splice(index, 1, u);
          }
        });
      }
    },
    rejoinConference() {
      _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_6___default.a.joinConference({
        callId: this.session.callId,
        pin: this.session.pin,
        host: this.session.host,
        tile: this.session.title,
        desc: this.session.desc,
        audioOnly: this.session.audioOnly,
        audience: this.session.audience,
        advance: this.session.advance,
        muteVideo: this.session.videoMuted,
        muteAudio: this.session.audioMuted,
        extra: this.session.extra,
        callExtra: this.session.callExtra,
        selfUserInfo: this.selfUserInfo
      });
      this.endReason = undefined;
    },
    prePage() {
      this.currentGridPageIndex--;
      if (this.currentGridPageIndex < 0) {
        this.currentGridPageIndex = Math.ceil(this.participantUserInfos.length / this.participantCountPerGridPage) - 1;
      }
    },
    nextPage() {
      if (this.participantUserInfos.length / this.participantCountPerGridPage > this.currentGridPageIndex + 1) {
        this.currentGridPageIndex++;
      } else {
        this.currentGridPageIndex = 0;
      }
    },
    updateCountPerPage(count) {
      this.participantCountPerGridPage = count;
    },
    setCurrentLayout(layout) {
      if (this.currentLayout === layout) {
        return;
      }
      // 演讲者布局
      if (layout === 1) {
        // 演讲者布局，切换为小流，然后焦点用户切换为大流
        this.participantUserInfos.forEach(u => {
          if (u.uid !== this.selfUserInfo.uid && !u._isAudience && !u._isVideoMuted) {
            this.session.setParticipantVideoType(u.uid, u._isScreenSharing, _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_18__["default"].SMALL_STREAM);
          }
        });
      } else {
        //宫格布局， 当前页切换为大流，未显示的，取消订阅，由 currentPageParticipants 副作用触发
        this.currentGridPageIndex = 0;
        _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].currentFocusUser = null;
      }
      this.currentLayout = layout;
      this.showChooseLayoutView = false;
    },
    toggleParticipantListVideoView() {
      this.hideFocusLayoutParticipantListVideoView = !this.hideFocusLayoutParticipantListVideoView;
    },
    hideConferenceSimpleInfoView(event) {
      if (event.target.id === "info-icon") {
        return;
      }
      this.showConferenceSimpleInfoView = false;
    },
    hideChooseLayoutView(event) {
      if (event.target.id === "grid-icon") {
        return;
      }
      this.showChooseLayoutView = false;
    }
  },
  computed: {
    duration() {
      if (this.currentTimestamp <= 0) {
        return "00:00";
      }
      let escapeMillis = this.currentTimestamp - this.startTimestamp;
      return this.timestampFormat(escapeMillis);
    },
    speakingUserName() {
      let maxVolume = this.selfUserInfo._volume;
      let speakingUserInfo = this.selfUserInfo;
      this.participantUserInfos.forEach(u => {
        if (u._volume > maxVolume) {
          speakingUserInfo = u;
          maxVolume = u._volume;
        }
      });
      if (!maxVolume) {
        return "";
      }
      return this.userName(speakingUserInfo);
    },
    currentPageParticipants() {
      if (this.currentLayout === 1) {
        return [];
      }
      let focusUser = this.conferenceFocusUser;
      // sort not in place，避免副作用
      let sortedParticipantUserInfos = [...this.participantUserInfos].sort((o1, o2) => {
        if (focusUser) {
          if (o1.uid === focusUser.uid && o1._isScreenSharing === focusUser._isScreenSharing) {
            return -1;
          }
          if (o2.uid === focusUser.uid && o2._isScreenSharing === focusUser._isScreenSharing) {
            return 1;
          }
        }
        if (o1._isAudience && !o2._isAudience) {
          return 1;
        } else if (!o1._isAudience && o2._isAudience) {
          return -1;
        } else if (o1._isAudience && o2._isAudience) {
          return o1.uid.localeCompare(o2.uid);
        } else {
          if (o1._isScreenSharing && !o2._isScreenSharing) {
            return -1;
          }
          if (!o1._isScreenSharing && o2._isScreenSharing) {
            return 1;
          }
          if (!o1._isVideoMuted && o2._isVideoMuted) {
            return -1;
          }
          if (o1._isVideoMuted && !o2._isVideoMuted) {
            return 1;
          }
          return o1.uid.localeCompare(o2.uid);
        }
      });
      let start = this.currentGridPageIndex * this.participantCountPerGridPage;
      let end = start + this.participantCountPerGridPage > sortedParticipantUserInfos.length ? sortedParticipantUserInfos.length : start + this.participantCountPerGridPage;
      // side effect
      // TODO 优化
      // 相邻页切换时，不能理解取消订阅，可能还切换回去，那样的话，就会有一小段时间，不显示视频流
      for (let i = 0; i < sortedParticipantUserInfos.length; i++) {
        let u = sortedParticipantUserInfos[i];
        if (u.uid === this.selfUserInfo.uid || u._isAudience || u._isVideoMuted) {
          continue;
        }
        if (i >= start && i < end) {
          console.log("set video type big", u.uid);
          this.session.setParticipantVideoType(u.uid, u._isScreenSharing, _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_18__["default"].BIG_STREAM);
        } else {
          console.log("set video type none", u.uid);
          this.session.setParticipantVideoType(u.uid, u._isScreenSharing, _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_18__["default"].NONE);
        }
      }
      // side effect
      return sortedParticipantUserInfos.slice(start, end);
    },
    gridPageCount() {
      return Math.ceil(this.participantUserInfos.length / this.participantCountPerGridPage);
    },
    conferenceFocusUser() {
      let focus = _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].conferenceInfo.focus;
      if (!focus) {
        return null;
      }
      let focusUser = this.participantUserInfos.find(u => u.uid === focus && u._isScreenSharing === true);
      if (!focusUser) {
        focusUser = this.participantUserInfos.find(u => u.uid === focus);
      }
      return focusUser;
    },
    conferenceLocalFocusUser() {
      return _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].localFocusUser;
    },
    // 以用户手动选择的为准
    computedCurrentLayout() {
      if (this.currentLayout === -1 && this.conferenceFocusUser) {
        return 1;
      }
      return this.currentLayout;
    },
    // TODO 可以缓存到 conferenceManager 里面
    computedFocusVideoParticipant() {
      if (this.currentLayout === 0) {
        console.log("computedSpeakingParticipant null");
        return null;
      }
      let sp;
      if (this.conferenceFocusUser && !this.conferenceFocusUser._isVideoMuted) {
        sp = this.conferenceFocusUser;
      } else if (this.conferenceLocalFocusUser && !this.conferenceLocalFocusUser._isVideoMuted) {
        sp = this.conferenceLocalFocusUser;
      } else if (this.speakingVideoParticipant) {
        sp = this.speakingVideoParticipant;
      } else {
        sp = this.participantUserInfos.find(u => !u._isAudience && !u._isVideoMuted && u._isScreenSharing === true);
        if (!sp) {
          sp = this.participantUserInfos.find(u => !u._isAudience && !u._isVideoMuted);
        }
      }
      if (_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].currentFocusUser) {
        this.session.setParticipantVideoType(_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].currentFocusUser.uid, _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].currentFocusUser._isScreenSharing, _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_18__["default"].SMALL_STREAM);
      }
      if (sp) {
        _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].currentFocusUser = sp;
        this.session.setParticipantVideoType(_conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].currentFocusUser.uid, _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].currentFocusUser._isScreenSharing, _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_18__["default"].BIG_STREAM);
      } else {
        if (this.session.screenSharing) {
          sp = this.selfUserInfo;
        }
      }
      console.log("computedSpeakingParticipant", sp);
      return sp;
    }
  },
  watch: {
    participantUserInfos: {
      deep: true,
      handler() {
        let audioOnly = true;
        // console.log('participantUserInfos', this.session.screenSharing);
        if (this.session.screenSharing) {
          audioOnly = false;
        } else {
          for (let i = 0; i < this.participantUserInfos.length; i++) {
            let u = this.participantUserInfos[i];
            if (!u._isAudience && !u._isVideoMuted) {
              audioOnly = false;
              break;
            }
          }
        }
        this.audioOnly = audioOnly;

        // mute self audio
        let ref = this.$refs[this.selfUserInfo.uid + "-audio"];
        if (ref && ref.length > 0) {
          this.$refs[this.selfUserInfo.uid + "-audio"][0].muted = true;
        }
        if (this.audioOnly) {
          return;
        }
        // 宫格布局
        if (this.currentLayout === 0) {
          let start = this.currentGridPageIndex * this.participantCountPerGridPage;
          let end = start + this.participantCountPerGridPage > this.participantUserInfos.length ? this.participantUserInfos.length : start + this.participantCountPerGridPage;
          let count = end - start;
          let width = "100%";
          let height = "100%";
          if (count <= 1) {
            width = "100%";
            height = "100%";
          } else if (count <= 4) {
            width = "50%";
            height = "45%";
          } else if (count <= 9) {
            width = "33%";
            height = "33%";
          } else {
            // max 16
            width = "25%";
            height = "25%";
          }
          if (this.$refs.rootContainer) {
            this.$refs.rootContainer.style.setProperty("--participant-video-item-width", width);
            this.$refs.rootContainer.style.setProperty("--participant-video-item-height", height);
          }
        }
      }
    },
    currentPageParticipants: {
      deep: true,
      handler() {
        if (this.audioOnly) {
          return;
        }
        if (this.currentLayout === 0) {
          let count = this.currentPageParticipants.length;
          let width = "100%";
          let height = "100%";
          if (count <= 1) {
            width = "100%";
            height = "100%";
          } else if (count <= 4) {
            width = "50%";
            height = "45%";
          } else if (count <= 9) {
            width = "33%";
            height = "33%";
          } else {
            // max 16
            width = "25%";
            height = "25%";
          }
          if (this.$refs.rootContainer) {
            this.$refs.rootContainer.style.setProperty("--participant-video-item-width", width);
            this.$refs.rootContainer.style.setProperty("--participant-video-item-height", height);
          }
        }
      }
    },
    /**
     * * 监听已调度时长，超过限度conferenceLimit（一小时）就自动挂断
     * @param val
     */
    timeTik(val) {
      if (val && val > this.conferenceLimit) {
        this.hangup();
      }
    },
    /**
     * * 监听参会人状态，如果每个人都断联了就自动挂断
     */
    memberList: {
      handler(value) {
        const offlineMembers = [...value].filter(x => x.state === "DISCONNECTED").length;
        console.log("watching status", this.status);
        console.log("offline members", offlineMembers);
        if (offlineMembers >= value.length /* && process.env.VUE_APP_ENV !== "development"*/ && (this.status === _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_8__["default"].STATUS_CONNECTED || this.status === _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_8__["default"].STATUS_CONNECTING)) {
          this.hangup();
        }
      },
      deep: true,
      immediate: true
    }
  },
  directives: {
    ClickOutside: (vue_click_outside__WEBPACK_IMPORTED_MODULE_9___default())
  },
  created() {
    document.title = "在线会议";
    _conferenceManager__WEBPACK_IMPORTED_MODULE_25__["default"].setVueInstance(this);
    this.refreshUserInfoInternal = setInterval(() => {
      this.refreshUserInfos();
    }, 3 * 1000);
    this.$eventBus.$on("muteVideo", mute => {
      if (this.session.videoMuted !== mute) {
        let enable = this.session.videoMuted ? true : false;
        this._muteVideo(enable);
      }
    });
    this.$eventBus.$on("muteAudio", mute => {
      if (this.session.audioMuted !== mute) {
        let enable = this.session.audioMuted ? true : false;
        this._muteAudio(enable);
      }
    });
    this.setTimer();
    // 分别对所有参会人计时
    this.setAllMembersTimer();
  },
  mounted() {
    this.setupSessionCallback();
    if (Object(_platform__WEBPACK_IMPORTED_MODULE_11__["isElectron"])()) {
      //
      // this.$on('stop-screen-share', () => {
      //     this.session.stopScreenShare();
      //     this.$forceUpdate();
      // })
      window.addEventListener("mousemove", event => {
        if (!this.session || !this.session.screenSharing) {
          return;
        }
        if (event.target.id === "main-content-container") {
          _platform__WEBPACK_IMPORTED_MODULE_11__["currentWindow"].setIgnoreMouseEvents(true, {
            forward: true
          });
        } else {
          _platform__WEBPACK_IMPORTED_MODULE_11__["currentWindow"].setIgnoreMouseEvents(false);
        }
      });
      window.addEventListener("mouseleave", () => {
        _platform__WEBPACK_IMPORTED_MODULE_11__["currentWindow"].setIgnoreMouseEvents(false);
      });
      this.$refs.rootContainer.style.setProperty("--conference-container-margin-top", "30px");
    } else {
      this.$refs.rootContainer.style.setProperty("--conference-container-margin-top", "0px");
    }
  },
  destroyed() {
    // reset
    this.$set(this.selfUserInfo, "_stream", null);
    this.participantUserInfos.forEach(m => this.$set(m, "_stream", null));
    clearInterval(this.refreshUserInfoInternal);
    if (this.timer) {
      clearTimeout(this.timer);
      this.timer = null;
    }
    this.$eventBus.$off("muteVideo");
    this.$eventBus.$off("muteAudio");
    // this.conferenceManager.destroy(); // 换成定制的参会人选择了。这个没用了反而会报错。
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceApplyUnmuteListView.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceApplyUnmuteListView.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/store.js */ "./src/store.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceApplyUnmuteListView",
  data() {
    return {
      conferenceManager: _conferenceManager__WEBPACK_IMPORTED_MODULE_1__["default"]
    };
  },
  computed: {
    applyUnmuteParticipantList() {
      let applyList = this.conferenceManager.applyingUnmuteMembers;
      let test = _store_js__WEBPACK_IMPORTED_MODULE_2__["default"].getUserInfos(applyList);
      for (let i = 0; i < 50; i++) {
        test.push(test[0]);
      }
      console.log("applyList", applyList, test);
      return test;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceConversationFloatingView.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceConversationFloatingView.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/model/conversation */ "./src/wfc/model/conversation.js");
/* harmony import */ var _wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/model/conversationType */ "./src/wfc/model/conversationType.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../wfc/messages/textMessageContent */ "./src/wfc/messages/textMessageContent.js");
/* harmony import */ var _wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../wfc/util/longUtil */ "./src/wfc/util/longUtil.js");








/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceConversationFloatingView",
  props: {
    session: {
      type: Object,
      required: true
    }
  },
  data() {
    return {
      sharedConversationState: _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].state.conversation,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].state.misc,
      filteredMessages: [],
      filterInternal: 0,
      text: ""
    };
  },
  created() {
    let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_3__["default"].ChatRoom, this.session.callId, 0);
    console.log("setCurrentConversation ", conversation);
    _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].setCurrentConversation(conversation);
    this.filterInternal = setInterval(() => {
      this.filterMessage();
    }, 1 * 1000);
  },
  updated() {
    let messageListElement = this.$refs["messageList"];
    messageListElement.scroll({
      top: messageListElement.scrollHeight,
      left: 0,
      behavior: "auto"
    });
  },
  destroyed() {
    console.log("setCurrentConversation null");
    _store_js__WEBPACK_IMPORTED_MODULE_4__["default"].setCurrentConversation(null);
    clearInterval(this.filterInternal);
  },
  methods: {
    sendMessage() {
      let conversation = new _wfc_model_conversation__WEBPACK_IMPORTED_MODULE_2__["default"](_wfc_model_conversationType__WEBPACK_IMPORTED_MODULE_3__["default"].ChatRoom, this.session.callId, 0);
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_5__["default"].sendConversationMessage(conversation, new _wfc_messages_textMessageContent__WEBPACK_IMPORTED_MODULE_6__["default"](this.text));
      this.text = "";
    },
    filterMessage() {
      let now = new Date().getTime();
      this.filteredMessages = this.sharedConversationState.currentConversationMessageList.filter(m => {
        return Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_7__["gt"])(m.timestamp, now - 30 * 1000);
      });
    }
  },
  watch: {
    "sharedConversationState.currentConversationMessageList": {
      handler(newValue) {
        let now = new Date().getTime();
        this.filteredMessages = this.sharedConversationState.currentConversationMessageList.filter(m => {
          return Object(_wfc_util_longUtil__WEBPACK_IMPORTED_MODULE_7__["gt"])(m.timestamp, now - 30 * 1000);
        });
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceHandUpListView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceHandUpListView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/store.js */ "./src/store.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceApplyUnmuteListView",
  data() {
    return {
      conferenceManager: _conferenceManager__WEBPACK_IMPORTED_MODULE_0__["default"]
    };
  },
  computed: {
    handUpParticipantList() {
      let applyList = this.conferenceManager.handUpMembers;
      return _store_js__WEBPACK_IMPORTED_MODULE_1__["default"].getUserInfos(applyList);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceInfoView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceInfoView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/av/engine/avenginekitproxy */ "./src/wfc/av/engine/avenginekitproxy.js");
/* harmony import */ var _api_conferenceApi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../api/conferenceApi */ "./src/api/conferenceApi.js");
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceInfoView",
  props: {
    conferenceInfo: {
      type: Object,
      required: true
    }
  },
  data() {
    return {
      enableVideo: false,
      enableAudio: false,
      ownerName: ""
    };
  },
  mounted() {
    console.log("conferenceInfo", this.conferenceInfo);
    this.ownerName = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__["default"].getUserDisplayName(this.conferenceInfo.owner);
  },
  methods: {
    favConference() {
      _api_conferenceApi__WEBPACK_IMPORTED_MODULE_2__["default"].favConference(this.conferenceInfo.conferenceId).then(r => {
        this.$refs.favButton.title = "已收藏";
        this.$refs.favButton.disabled = true;
      }).catch(err => {
        console.error("favConference error", err);
      });
    },
    joinConference() {
      let info = this.conferenceInfo;
      console.log("joinConference", info);
      let audience = !this.enableVideo && !this.enableAudio;
      _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_1__["default"].joinConference(info.conferenceId, false, info.pin, info.owner, info.conferenceTitle, "", audience, info.advance, !this.enableAudio, !this.enableVideo);
      this.$modal.hide("conference-info-modal");
    }
  },
  computed: {
    startTime() {
      let date = new Date(this.conferenceInfo.startTime * 1000);
      return date.toString();
    },
    endTime() {
      if (!this.conferenceInfo.endTime) {
        return "-";
      }
      let date = new Date(this.conferenceInfo.endTime * 1000);
      return date.toString();
    },
    audience() {
      return !(this.conferenceInfo.owner === _conferenceManager__WEBPACK_IMPORTED_MODULE_3__["default"].selfUserId || !this.conferenceInfo.audience || this.conferenceInfo.allowSwitchMode) ||
      // Safari 浏览器，不支持直接静音自动播放音视频
      navigator.vendor.indexOf("Apple") > 0;
    },
    enableDestroy() {
      return this.conferenceInfo.owner === _conferenceManager__WEBPACK_IMPORTED_MODULE_3__["default"].selfUserId && new Date().getTime() < this.conferenceInfo.startTime * 1000;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceManageView.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceManageView.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");
/* harmony import */ var _ConferenceParticipantListView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ConferenceParticipantListView */ "./src/ui/voip/conference/ConferenceParticipantListView.vue");
/* harmony import */ var _ConferenceApplyUnmuteListView__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ConferenceApplyUnmuteListView */ "./src/ui/voip/conference/ConferenceApplyUnmuteListView.vue");
/* harmony import */ var _ConferenceHandUpListView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ConferenceHandUpListView */ "./src/ui/voip/conference/ConferenceHandUpListView.vue");





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceManageView",
  props: {
    participants: {
      type: Array,
      required: true
    },
    session: {
      type: Object,
      required: true
    },
    allMembers: {
      type: Array,
      default() {
        return [];
      }
    }
  },
  data() {
    return {
      conferenceManager: _conferenceManager__WEBPACK_IMPORTED_MODULE_1__["default"],
      selfUserId: _conferenceManager__WEBPACK_IMPORTED_MODULE_1__["default"].selfUserId,
      isContextMenuShow: false,
      currentParticipant: {},
      showParticipantList: true,
      showApplyList: false,
      showHandUpList: false,
      handUpTip: "",
      applyUnmuteTip: ""
    };
  },
  components: {
    ConferenceHandUpListView: _ConferenceHandUpListView__WEBPACK_IMPORTED_MODULE_4__["default"],
    ConferenceApplyUnmuteListView: _ConferenceApplyUnmuteListView__WEBPACK_IMPORTED_MODULE_3__["default"],
    ConferenceParticipantListView: _ConferenceParticipantListView__WEBPACK_IMPORTED_MODULE_2__["default"]
  },
  methods: {
    updateHandUpTip() {
      let ids = _conferenceManager__WEBPACK_IMPORTED_MODULE_1__["default"].handUpMembers;
      let userInfos = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__["default"].getUserInfos(ids, "");
      let desc = userInfos[0].displayName;
      if (userInfos.length > 1) {
        desc += " 等";
      }
      desc += "正在举手";
      this.handUpTip = desc;
    },
    updateapplyUnmuteTip() {
      let ids = _conferenceManager__WEBPACK_IMPORTED_MODULE_1__["default"].applyingUnmuteMembers;
      let userInfos = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_0__["default"].getUserInfos(ids, "");
      let desc = userInfos[0].displayName;
      if (userInfos.length > 1) {
        desc += " 等";
      }
      desc += "正在申请解除静音";
      this.applyUnmuteTip = desc;
    }
  },
  computed: {
    handUpMembers() {
      return this.conferenceManager.handUpMembers;
    },
    applyingUnmuteMembers() {
      return this.conferenceManager.applyingUnmuteMembers;
    }
  },
  watch: {
    handUpMembers() {
      this.updateHandUpTip();
    },
    applyingUnmuteMembers() {
      this.updateapplyUnmuteTip();
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceMemberListView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceMemberListView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.find.js */ "./node_modules/core-js/modules/es.iterator.find.js");
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/ui/voip/conference/conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");
/* harmony import */ var _wfc_av_messages_conferenceInviteMessageContent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/wfc/av/messages/conferenceInviteMessageContent */ "./src/wfc/av/messages/conferenceInviteMessageContent.js");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _ui_main_conversation_message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/ui/main/conversation/message/forward/ForwardType */ "./src/ui/main/conversation/message/forward/ForwardType.js");











/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceMemberListView",
  props: {
    participants: {
      type: Array,
      required: true
    },
    session: {
      type: Object,
      required: true
    },
    memberList: {
      type: Array,
      default() {
        return [];
      }
    },
    allMembers: {
      type: Array,
      default() {
        return [];
      }
    }
  },
  data() {
    return {
      conferenceManager: _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__["default"],
      rightPanelActiveName: "1",
      pickupVisible: false,
      pickupMemberList: [],
      pickupName: "",
      message: null
    };
  },
  computed: {
    handUpParticipantList() {
      let applyList = this.conferenceManager.handUpMembers;
      return _store_js__WEBPACK_IMPORTED_MODULE_6__["default"].getUserInfos(applyList);
    },
    tabsLabelConnecting() {
      return `调度中（${this.memberList.filter(x => x.state !== "DISCONNECTED").length}）`;
    },
    tabsLabelDisconnecting() {
      return `断联（${this.memberList.filter(x => x.state === "DISCONNECTED").length}）`;
    }
  },
  methods: {
    recall() {},
    muteAll() {},
    unMuteAll() {},
    onOpen() {
      let callSession = this.session;
      let inviteMessageContent = new _wfc_av_messages_conferenceInviteMessageContent__WEBPACK_IMPORTED_MODULE_8__["default"](callSession.callId, _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__["default"].conferenceInfo.owner, callSession.title, callSession.desc, callSession.startTime, callSession.audioOnly, callSession.defaultAudience, callSession.advance, callSession.pin);
      console.log("invite", inviteMessageContent);
      this.message = new _wfc_messages_message__WEBPACK_IMPORTED_MODULE_9__["default"](null, inviteMessageContent);
      this.pickupMemberList = this.allMembers.filter(x => !x.active);
    },
    queryPickup(val) {
      if (val) {
        this.pickupMemberList = this.allMembers.filter(x => {
          return x.name.indexOf(val) >= 0 && !x.active;
        });
      } else {
        this.pickupMemberList = this.allMembers.filter(x => !x.active);
      }
    },
    clearPickup() {
      this.allMembers.forEach(member => {
        if (!member.active) {
          member.checked = false;
        }
      });
    },
    addMembers() {
      const members = this.allMembers.filter(x => !x.active && x.checked);
      console.log("addMembers", members);
      if (!members || members.length === 0) {
        return;
      }
      const users = members.map(x => {
        return {
          uid: x.tencentUserId,
          displayName: x.name
        };
      });
      if (users.length + this.memberList.length <= 5) {
        users.forEach(user => {
          _store_js__WEBPACK_IMPORTED_MODULE_6__["default"].forwardByCreateConversation(_ui_main_conversation_message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_10__["default"].NORMAL, [user], [this.message], "");
          const member = this.allMembers.find(x => x.tencentUserId === user.uid);
          if (member) this.memberList.push({
            ...member,
            state: "CONNECTING"
          });
        });
        console.log("addMembers", this.memberList);
        this.$emit("update:memberList", [...this.memberList]);
        this.pickupVisible = false;
      } else {
        this.$store.commit("showMessage", {
          message: "最多选择5名被调度人"
        });
      }
    },
    participantName(user) {
      let name = "";
      if (user.groupAlias) {
        name = user.groupAlias;
      } else if (user.friendAlias) {
        name = user.friendAlias;
      } else if (user.displayName) {
        name = user.displayName;
      } else {
        name = user.name;
      }
      return name;
    },
    participantDesc(user) {
      let desc = "";
      if (user.uid === _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__["default"].selfUserId || user.tencentUserId === _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__["default"].selfUserId) {
        desc = "我";
        if (user.uid === _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__["default"].conferenceInfo.owner || user.tencentUserId === _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__["default"].conferenceInfo.owner) {
          desc += "、主持人";
        }
      } else if (user.uid === _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__["default"].conferenceInfo.owner || user.tencentUserId === _ui_voip_conference_conferenceManager__WEBPACK_IMPORTED_MODULE_7__["default"].conferenceInfo.owner) {
        desc = "主持人";
      } else if (user._isScreenSharing) {
        desc = "屏幕共享";
      }
      return desc;
    },
    memberMute() {},
    memberUnmute() {},
    memberVideoOff() {},
    memberVideoOn() {},
    kickOut(user) {
      console.log("kick out", user);
      this.$alert(`确认将${this.participantName(user)}移除会议?`, "", {}).then(() => {
        this.session.kickoffParticipant(user.tenantImUserId);
      });
    },
    handleMuteAudio() {
      let enable = !!this.session.audioMuted;
      this.session.selfUserInfo._isAudioMuted = !enable;
      this.session.setAudioEnabled(enable);
    },
    handleMuteVideo() {
      let enable = !!this.session.videoMuted;
      this.session.selfUserInfo._isVideoMuted = !enable;
      this.session.setVideoEnabled(enable);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceParticipantListView.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceParticipantListView.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wfc_av_messages_conferenceInviteMessageContent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../wfc/av/messages/conferenceInviteMessageContent */ "./src/wfc/av/messages/conferenceInviteMessageContent.js");
/* harmony import */ var _wfc_messages_message__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../wfc/messages/message */ "./src/wfc/messages/message.js");
/* harmony import */ var _main_conversation_message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../main/conversation/message/forward/ForwardType */ "./src/ui/main/conversation/message/forward/ForwardType.js");
/* harmony import */ var _main_user_UserCardView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../main/user/UserCardView */ "./src/ui/main/user/UserCardView.vue");
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/store.js */ "./src/store.js");











/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceParticipantListView",
  props: {
    participants: {
      type: Array,
      required: true
    },
    session: {
      type: Object,
      required: true
    },
    allMembers: {
      type: Array,
      default() {
        return [];
      }
    }
  },
  data() {
    return {
      conferenceManager: _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"],
      selfUserId: _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].selfUserId,
      isContextMenuShow: false,
      currentParticipant: {},
      pickupVisible: false,
      pickupMemberList: [],
      pickupName: "",
      message: null
    };
  },
  components: {
    UserCardView: _main_user_UserCardView__WEBPACK_IMPORTED_MODULE_8__["default"]
  },
  methods: {
    invite() {
      let callSession = this.session;
      let inviteMessageContent = new _wfc_av_messages_conferenceInviteMessageContent__WEBPACK_IMPORTED_MODULE_5__["default"](callSession.callId, _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].conferenceInfo.owner, callSession.title, callSession.desc, callSession.startTime, callSession.audioOnly, callSession.defaultAudience, callSession.advance, callSession.pin);
      // type:audio语音，video视频，videoup视频上拉；
      inviteMessageContent.extra = "{'type': 'invite','initiator': '侯晓晨','organization': ''}";
      console.log("invite", inviteMessageContent);
      this.message = new _wfc_messages_message__WEBPACK_IMPORTED_MODULE_6__["default"](null, inviteMessageContent);
      // TODO 弹出候选人框框
      this.pickupVisible = true;
      // this.$forwardMessage({
      //   forwardType: ForwardType.NORMAL,
      //   messages: [message],
      // });
      // this.showParticipantList = false;
    },
    onOpen() {
      this.pickupMemberList = this.allMembers.filter(x => !x.active);
    },
    queryPickup(val) {
      if (val) {
        this.pickupMemberList = this.allMembers.filter(x => {
          return x.name.indexOf(val) >= 0 && !x.active;
        });
      } else {
        this.pickupMemberList = this.allMembers.filter(x => !x.active);
      }
    },
    clearPickup() {
      this.allMembers.forEach(member => {
        if (!member.active) {
          member.checked = false;
        }
      });
    },
    addMembers() {
      const members = this.allMembers.filter(x => !x.active && x.checked);
      console.log("addMembers", members);
      this.pickupVisible = false;
      if (!members || members.length === 0) {
        return;
      }
      const users = members.map(x => {
        return {
          uid: x.tencentUserId,
          displayName: x.name
        };
      });
      users.forEach(user => {
        _store_js__WEBPACK_IMPORTED_MODULE_10__["default"].forwardByCreateConversation(_main_conversation_message_forward_ForwardType__WEBPACK_IMPORTED_MODULE_7__["default"].NORMAL, [user], [this.message], "");
      });
    },
    requestChangeMode(user) {
      if (user.uid === this.selfUserInfo.uid) {
        // TODO 需要根据实际产品定义处理，这儿直接禁止
        //this.session.switchAudience(!user._isAudience);
        return;
      }
      this.$alert({
        content: user._isAudience ? `邀请${this.participantName(user)}参与互动?` : `取消${this.participantName(user)}参与互动?`,
        cancelCallback: () => {
          // do nothing
        },
        confirmCallback: () => {
          this.session.requestChangeMode(user.uid, !user._isAudience);
        }
      });
    },
    kickoff(user) {
      this.$alert(`确认将${this.participantName(user)}移除会议?`, "", {
        cancelCallback: () => {
          // do nothing
        },
        confirmCallback: () => {
          console.log(this.session);
          this.session.kickoffParticipant(user.uid);
        }
      }).then(() => {
        this.session.kickoffParticipant(user.uid);
      });
    },
    participantName(user) {
      let name = "";
      if (user.groupAlias) {
        name = user.groupAlias;
      } else if (user.friendAlias) {
        name = user.friendAlias;
      } else if (user.displayName) {
        name = user.displayName;
      } else {
        name = user.name;
      }
      return name;
    },
    participantDesc(user) {
      let desc = "";
      if (user.uid === _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].selfUserId) {
        desc = "我";
        if (user.uid === _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].conferenceInfo.owner) {
          desc += "、主持人";
        }
      } else if (user.uid === _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].conferenceInfo.owner) {
        desc = "主持人";
      } else if (user._isScreenSharing) {
        desc = "屏幕共享";
      }
      return desc;
    },
    buildParticipantContextMenu(participant) {
      let selfUid = _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].selfUserId;
      let items = [];
      if (!participant) {
        return items;
      }
      items.push({
        title: "查看用户信息",
        handler: () => {
          this.showUserCard(participant);
        }
      });
      if (selfUid === participant.uid) {
        // TODO 临时屏蔽，现在不支持同时开视频和音频
        // if (participant._isAudience) {
        //     items.push({
        //         title: '开启音视频',
        //         handler: () => {
        //             this.$eventBus.$emit('muteAudio', false)
        //             this.$eventBus.$emit('muteVideo', false)
        //         }
        //     })
        // }

        if (participant._isAudience) {
          if (participant._isAudioMuted) {
            items.push({
              title: "开启音频",
              handler: () => {
                this.$eventBus.$emit("muteAudio", false);
              }
            });
          }
          if (participant._isVideoMuted) {
            items.push({
              title: "开启视频",
              handler: () => {
                this.$eventBus.$emit("muteVideo", false);
              }
            });
          }
        } else {
          if (!participant._isAudioMuted) {
            items.push({
              title: "关闭音频",
              handler: () => {
                this.$eventBus.$emit("muteAudio", true);
              },
              styleObject: {
                color: "red"
              }
            });
          }
          if (!participant._isVideoMuted) {
            items.push({
              title: "关闭视频",
              handler: () => {
                this.$eventBus.$emit("muteVideo", true);
              },
              styleObject: {
                color: "red"
              }
            });
          }
          if (!participant._isVideoMuted && !participant._isAudioMuted) {
            items.push({
              title: "关闭音视频",
              handler: () => {
                this.$eventBus.$emit("muteAudio", true);
                this.$eventBus.$emit("muteVideo", true);
              },
              styleObject: {
                color: "red"
              }
            });
          }
        }
      }
      if (selfUid === _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].conferenceInfo.owner) {
        if (participant.uid !== selfUid) {
          if (participant._isAudience) {
            items.push({
              title: "邀请发言",
              handler: () => {
                _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].requestMemberMute(participant.uid, false);
              }
            });
          } else {
            items.push({
              title: "取消发言",
              handler: () => {
                _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].requestMemberMute(participant.uid, true);
              }
            });
          }
        }
        if (participant.uid !== selfUid) {
          items.push({
            title: " 移除成员",
            handler: () => {
              this.kickoff(participant);
            }
          });
        }
        if (_conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].conferenceInfo.focus === participant.uid) {
          items.push({
            title: "取消焦点用户",
            handler: () => {
              _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].requestCancelFocus();
            }
          });
        } else {
          items.push({
            title: "设置为焦点用户",
            handler: () => {
              _conferenceManager__WEBPACK_IMPORTED_MODULE_9__["default"].requestFocus(participant.uid);
            }
          });
        }
      }
      return items;
    },
    showContextMenu(event, participant) {
      console.log(event);
      if (this.isContextMenuShow) {
        this.$refs.menu.close();
        this.isContextMenuShow = false;
        this.currentParticipant = {};
        return;
      }
      let ne = {
        type: "contextmenu"
      };
      console.log(this.$refs.rootContainer.parentElement);
      ne.clientX = event.clientX - this.$refs.rootContainer.parentElement.offsetLeft - 560;
      // 160 menu width
      // 360 slider width
      if (ne.clientX + 160 > 350) {
        ne.clientX = ne.clientX - 160;
      }
      ne.clientY = event.clientY - this.$refs.rootContainer.offsetTop - 280;
      this.$refs.menu.open(ne, participant);
      this.$refs.menu.$once("close", () => {
        this.isContextMenuShow = false;
        this.currentParticipant = {};
      });
      this.isContextMenuShow = true;
      this.currentParticipant = participant;
    },
    showUserCard(p) {
      this.$refs["userCardTippy-" + p.uid][0]._tippy.show();
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceParticipantVideoView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceParticipantVideoView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/av/engine/callState */ "./src/wfc/av/engine/callState.js");
/* harmony import */ var _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../wfc/av/engine/videoType */ "./src/wfc/av/engine/videoType.js");
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceParticipantVideoView",
  props: {
    participant: {
      type: Object,
      required: true
    },
    session: {
      type: Object,
      required: true
    }
  },
  data() {
    return {
      status: _wfc_av_engine_callState__WEBPACK_IMPORTED_MODULE_2__["default"].STATUS_CONNECTING,
      selfUserId: _conferenceManager__WEBPACK_IMPORTED_MODULE_4__["default"].selfUserId
    };
  },
  // created() {
  //     console.log('------------- videoView created', this.participant.uid);
  //     if (this.selfUserId !== this.participant.uid) {
  //         if (!this.participant._isVideoMuted) {
  //             this.session.setParticipantVideoType(this.participant.uid, this.participant._isScreenSharing, VideoType.BIG_STREAM);
  //         }
  //     }
  // },
  // destroyed() {
  //     console.log('------------- videoView destroyed', this.$parent.currentLayout, this.layoutMode, this.participant.uid);
  //     // fixme
  //     // 切换布局时，不取消订阅视频流
  //     // 已知问题，演讲者模式时，会订阅所有的视频流；从演讲者模式，切换到宫格布局时，会保持订阅所有的视频流，直到切换宫格布局的页面时，才会取消订阅一些看不见的流
  //     if (this.$parent.currentLayout !== this.currentLayout) {
  //         return;
  //     }
  //     if (this.selfUserId !== this.participant.uid) {
  //         if (!this.participant._isVideoMuted) {
  //             this.session.setParticipantVideoType(this.participant.uid, this.participant._isScreenSharing, VideoType.NONE);
  //         }
  //     }
  // },
  methods: {
    onDbClickVideo() {
      if (_conferenceManager__WEBPACK_IMPORTED_MODULE_4__["default"].isOwner()) {
        _conferenceManager__WEBPACK_IMPORTED_MODULE_4__["default"].requestFocus(this.participant.uid);
      } else {
        if (_conferenceManager__WEBPACK_IMPORTED_MODULE_4__["default"].conferenceInfo.focus) {
          this.$notify({
            text: "主持人已设置了焦点用户",
            type: "warn"
          });
        } else {
          _conferenceManager__WEBPACK_IMPORTED_MODULE_4__["default"].localFocusUser = this.participant;
        }
      }
    },
    switchVideoType(userId, screenSharing) {
      if (!this.session) {
        return;
      }
      let subscriber = this.session.getSubscriber(userId, screenSharing);
      if (subscriber) {
        let currentVideoType = subscriber.currentVideoType;
        let videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_3__["default"].NONE;
        if (currentVideoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_3__["default"].NONE) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_3__["default"].BIG_STREAM;
        } else if (currentVideoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_3__["default"].BIG_STREAM) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_3__["default"].SMALL_STREAM;
        } else if (videoType === _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_3__["default"].SMALL_STREAM) {
          videoType = _wfc_av_engine_videoType__WEBPACK_IMPORTED_MODULE_3__["default"].NONE;
        }
        this.session.setParticipantVideoType(userId, screenSharing, videoType);
      }
    },
    switchCamera() {
      if (!this.session || this.session.isScreenSharing()) {
        return;
      }
      // The order is significant - the default capture devices will be listed first.
      // navigator.mediaDevices.enumerateDevices()
      navigator.mediaDevices.enumerateDevices().then(devices => {
        devices = devices.filter(d => d.kind === "videoinput");
        if (devices.length < 2) {
          console.log("switchCamera error, no more video input device");
          return;
        }
        this.videoInputDeviceIndex++;
        if (this.videoInputDeviceIndex >= devices.length) {
          this.videoInputDeviceIndex = 0;
        }
        this.session.setVideoInputDeviceId(devices[this.videoInputDeviceIndex].deviceId);
        console.log("setVideoInputDeviceId", devices[this.videoInputDeviceIndex]);
      });
    }
  },
  computed: {
    userName() {
      let name = "";
      let user = this.participant;
      if (user.groupAlias) {
        name = user.groupAlias;
      } else if (user.friendAlias) {
        name = user.friendAlias;
      } else if (user.displayName) {
        name = user.displayName;
      } else {
        name = user.name;
      }
      return name;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferencePortalPage.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferencePortalPage.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CreateConferenceView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CreateConferenceView */ "./src/ui/voip/conference/CreateConferenceView.vue");
/* harmony import */ var _JoinConferenceView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./JoinConferenceView */ "./src/ui/voip/conference/JoinConferenceView.vue");
/* harmony import */ var _OrderConferenceView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OrderConferenceView */ "./src/ui/voip/conference/OrderConferenceView.vue");
/* harmony import */ var _api_conferenceApi__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../api/conferenceApi */ "./src/api/conferenceApi.js");
/* harmony import */ var _ConferenceInfoView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ConferenceInfoView */ "./src/ui/voip/conference/ConferenceInfoView.vue");
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");







/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferencePortalPage",
  data() {
    return {
      favConferenceInfos: [],
      historyConferenceInfos: []
    };
  },
  mounted() {
    this.loadFavConferences();
    this.historyConferenceInfos = _conferenceManager__WEBPACK_IMPORTED_MODULE_5__["default"].getHistoryConference();
  },
  methods: {
    loadFavConferences() {
      _api_conferenceApi__WEBPACK_IMPORTED_MODULE_3__["default"].getFavConferences().then(favConferenceInfos => {
        this.favConferenceInfos = favConferenceInfos;
      }).catch(err => {
        console.log("getFavConferences error", err);
      });
    },
    joinConference() {
      let beforeOpen = () => {
        console.log("Opening...");
      };
      let beforeClose = event => {
        console.log("Closing...", event, event.params);
      };
      let closed = event => {
        console.log("Close...", event);
      };
      this.$modal.show(_JoinConferenceView__WEBPACK_IMPORTED_MODULE_1__["default"], {}, {
        name: "join-conference-modal",
        width: 320,
        height: 300,
        clickToClose: true
      }, {
        "before-open": beforeOpen,
        "before-close": beforeClose,
        closed: closed
      });
    },
    createConference() {
      let beforeOpen = () => {
        console.log("Opening...");
      };
      let beforeClose = event => {
        console.log("Closing...", event, event.params);
      };
      let closed = event => {
        console.log("Close...", event);
        this.loadFavConferences();
      };
      this.$modal.show(_CreateConferenceView__WEBPACK_IMPORTED_MODULE_0__["default"], {}, {
        name: "create-conference-modal",
        width: 320,
        height: 500,
        clickToClose: true
      }, {
        "before-open": beforeOpen,
        "before-close": beforeClose,
        closed: closed
      });
    },
    orderConference() {
      let beforeOpen = () => {
        console.log("Opening...");
      };
      let beforeClose = event => {
        console.log("Closing...", event, event.params);
      };
      let closed = event => {
        console.log("Close...", event);
        this.loadFavConferences();
      };
      this.$modal.show(_OrderConferenceView__WEBPACK_IMPORTED_MODULE_2__["default"], {}, {
        name: "order-conference-modal",
        width: 320,
        height: 500,
        clickToClose: true
      }, {
        "before-open": beforeOpen,
        "before-close": beforeClose,
        closed: closed
      });
    },
    showConferenceInfo(info) {
      let beforeOpen = () => {
        console.log("Opening...");
      };
      let beforeClose = event => {
        console.log("Closing...", event, event.params);
      };
      let closed = event => {
        console.log("Close...", event);
      };
      this.$modal.show(_ConferenceInfoView__WEBPACK_IMPORTED_MODULE_4__["default"], {
        conferenceInfo: info
      }, {
        name: "conference-info-modal",
        width: 320,
        height: 580,
        clickToClose: true
      }, {
        "before-open": beforeOpen,
        "before-close": beforeClose,
        closed: closed
      });
    },
    favConferenceDesc(conferenceInfo) {
      let start = new Date(conferenceInfo.startTime * 1000).getTime();
      let end = new Date(conferenceInfo.endTime * 1000).getTime();
      let now = new Date().getTime();
      if (now < start) {
        return "会议尚未开始";
      } else if (start < end) {
        return "会议已开始，请尽快加入";
      } else {
        return "会议已结束";
      }
    },
    historyConferenceDesc(conferenceInfo) {
      console.log("xxxx", conferenceInfo);
      let duration = this.formatDuration(conferenceInfo.endTime - conferenceInfo.startTime);
      let ownerDisplayName = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_6__["default"].getUserDisplayName(conferenceInfo.owner);
      let date = new Date(conferenceInfo.startTime * 1000).toLocaleDateString();
      return `时间：${date} 发起人：${ownerDisplayName} 时长：${duration}`;
    },
    formatDuration(second) {
      let desc = "";
      if (second > 60 * 60) {
        desc = Math.floor(second / 60 / 60) + "H";
      }
      if (second > 60) {
        desc += Math.floor(second % (60 * 60) / 60) + "M";
      }
      desc += second % 60 + "S";
      return desc;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/ConferenceSimpleInfoView.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/ConferenceSimpleInfoView.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfcScheme__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfcScheme */ "./src/wfcScheme.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _util_clipboard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/clipboard */ "./src/ui/util/clipboard.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "ConferenceSimpleInfoView",
  props: {
    session: {
      type: Object,
      required: true
    }
  },
  methods: {
    conferenceLink() {
      return _wfcScheme__WEBPACK_IMPORTED_MODULE_0__["default"].buildConferenceLink(this.session.callId, this.session.pin);
    },
    hostName() {
      let userInfo = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_1__["default"].getUserInfo(this.session.host);
      return userInfo.displayName;
    },
    copyConferenceId() {
      Object(_util_clipboard__WEBPACK_IMPORTED_MODULE_2__["copyText"])(this.session.callId);
    },
    copyConferenceLink() {
      Object(_util_clipboard__WEBPACK_IMPORTED_MODULE_2__["copyText"])(this.conferenceLink());
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/CreateConferenceView.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/CreateConferenceView.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/av/engine/avenginekitproxy */ "./src/wfc/av/engine/avenginekitproxy.js");
/* harmony import */ var _api_conferenceApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../api/conferenceApi */ "./src/api/conferenceApi.js");
/* harmony import */ var _wfc_av_model_conferenceInfo__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../wfc/av/model/conferenceInfo */ "./src/wfc/av/model/conferenceInfo.js");
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CreateConferenceView",
  data() {
    return {
      title: "",
      desc: "",
      endTime: new Date(new Date().getTime() - new Date().getTimezoneOffset() * 60000 + 1 * 60 * 60 * 1000).toISOString().split(".")[0],
      audience: false,
      advance: false,
      allowTurnOnMic: true,
      enablePassword: false,
      password: ""
    };
  },
  methods: {
    async _createConference() {
      let info = new _wfc_av_model_conferenceInfo__WEBPACK_IMPORTED_MODULE_2__["default"]();
      info.conferenceTitle = this.title;
      if (this.password) {
        info.password = this.password;
      }
      info.pin = "" + Math.ceil((1 + Math.random() * 100000) / 10);
      info.owner = _conferenceManager__WEBPACK_IMPORTED_MODULE_3__["default"].selfUserId;
      info.startTime = Math.ceil(new Date().getTime() / 1000);
      info.endTime = Math.ceil(new Date(this.endTime).getTime() / 1000);
      info.audience = this.audience;
      info.allowSwitchMode = this.allowTurnOnMic;
      info.advance = this.advance;
      info.conferenceId = await _api_conferenceApi__WEBPACK_IMPORTED_MODULE_1__["default"].createConference(info);
      return info;
    },
    createConference() {
      this._createConference().then(info => {
        console.log(info);
        this.$notify({
          text: "创建会议 成功",
          type: "info"
        });
      }).catch(err => {
        this.$notify({
          title: "创建会议失败",
          text: err.message,
          type: "error"
        });
      });
      this.$modal.hide("create-conference-modal");
    },
    createAndJoinConference() {
      this._createConference().then(info => {
        console.log("createAndJoin conference", info);
        _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_0__["default"].startConference(info.conferenceId, false, info.pin, info.owner, info.conferenceTitle, this.desc, info.audience, info.advance);
      }).catch(err => {
        this.$notify({
          title: "创建会议失败",
          text: err.message,
          type: "error"
        });
      });
      this.$modal.hide("create-conference-modal");
    }
  },
  computed: {
    actionEnable() {
      let now = new Date().getTime();
      return this.title && this.title.trim() && this.endTime && new Date(this.endTime).getTime() > now;
    }
  },
  watch: {
    advance() {
      // 超级会议模式，一般参会人员会很多，但不需要所有人都能发言；互动模式，是允许每个人发言
      // 开启超级会之后，需要再次确认开启互动模式
      if (this.advance) {
        this.audience = false;
      }
    },
    endTime() {
      if (this.endTime) {
        if (new Date(this.endTime).getTime() < new Date().getTime()) {
          this.endTime = "";
          this.$notify({
            text: "结束时间不能小于当前时间",
            type: "warn"
          });
        }
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/JoinConferenceView.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/JoinConferenceView.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _api_conferenceApi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../api/conferenceApi */ "./src/api/conferenceApi.js");
/* harmony import */ var _ConferenceInfoView_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ConferenceInfoView.vue */ "./src/ui/voip/conference/ConferenceInfoView.vue");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CreateConferenceView",
  data() {
    return {
      conferenceId: "",
      password: ""
    };
  },
  methods: {
    joinConference() {
      _api_conferenceApi__WEBPACK_IMPORTED_MODULE_0__["default"].queryConferenceInfo(this.conferenceId, this.password).then(info => {
        console.log("conferenceInfo", info);
        this.$modal.show(_ConferenceInfoView_vue__WEBPACK_IMPORTED_MODULE_1__["default"], {
          conferenceInfo: info
        }, {
          name: "conference-info-modal",
          width: 320,
          height: 580,
          clickToClose: true
        }, {});
        this.$modal.hide("join-conference-modal");
      }).catch(reason => {
        console.log("queryConferenceInfo failed", reason);
        this.$modal.hide("join-conference-modal");
        this.$notify({
          text: "获取会议信息失败",
          type: "warn"
        });
      });
    },
    cancel() {
      this.$modal.hide("join-conference-modal");
    }
  },
  watch: {
    advance() {
      // 超级会议模式，一般参会人员会很多，但不需要所有人都能发言；互动模式，是允许每个人发言
      // 开启超级会之后，需要再次确认开启互动模式
      if (this.advance) {
        this.audience = false;
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/ui/voip/conference/OrderConferenceView.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/ui/voip/conference/OrderConferenceView.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wfc_av_model_conferenceInfo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../wfc/av/model/conferenceInfo */ "./src/wfc/av/model/conferenceInfo.js");
/* harmony import */ var _api_conferenceApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../api/conferenceApi */ "./src/api/conferenceApi.js");
/* harmony import */ var _conferenceManager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./conferenceManager */ "./src/ui/voip/conference/conferenceManager.js");



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "CreateConferenceView",
  data() {
    return {
      title: "",
      desc: "",
      startTime: "",
      endTime: "",
      audioOnly: false,
      audience: false,
      advance: false,
      allowTurnOnMic: false,
      enablePin: false,
      pin: "",
      callId: "1234567"
    };
  },
  methods: {
    orderConference() {
      console.log("order Conference");
      let info = new _wfc_av_model_conferenceInfo__WEBPACK_IMPORTED_MODULE_0__["default"]();
      info.conferenceTitle = this.title;
      if (this.password) {
        info.password = this.password;
      }
      info.pin = "" + Math.ceil((1 + Math.random() * 100000) / 10);
      info.owner = _conferenceManager__WEBPACK_IMPORTED_MODULE_2__["default"].selfUserId;
      info.startTime = Math.ceil(new Date(this.startTime).getTime() / 1000);
      info.endTime = Math.ceil(new Date(this.endTime).getTime() / 1000);
      info.audience = this.audience;
      info.allowSwitchMode = this.allowTurnOnMic;
      info.advance = this.advance;
      _api_conferenceApi__WEBPACK_IMPORTED_MODULE_1__["default"].createConference(info).then(r => {
        console.log("createConference success", r);
      }).catch(err => {
        console.log("createConference error", err);
      });
      this.$modal.hide("order-conference-modal");
    }
  },
  computed: {
    actionEnable() {
      if (this.title && this.title.trim() && this.startTime && this.endTime) {
        let now = new Date().getTime();
        let start = new Date(this.startTime).getTime();
        let end = new Date(this.endTime).getTime();
        return start > now && end > start;
      }
      return false;
    }
  },
  watch: {
    advance() {
      // 超级会议模式，一般参会人员会很多，但不需要所有人都能发言；互动模式，是允许每个人发言
      // 开启超级会之后，需要再次确认开启互动模式
      if (this.advance) {
        this.audience = false;
      }
    },
    startTime() {
      if (this.startTime) {
        let start = new Date(this.startTime).getTime();
        if (start < new Date().getTime()) {
          this.$notify({
            text: "开始时间不能早于当前时间",
            type: "warn"
          });
          this.startTime = "";
        }
      }
    },
    endTime() {
      if (this.endTime) {
        let end = new Date(this.endTime).getTime();
        let now = new Date().getTime();
        if (end < now) {
          this.$notify({
            text: "开始时间不能早于当前时间",
            type: "warn"
          });
          this.endTime = "";
        }
        if (this.startTime) {
          let start = new Date(this.startTime).getTime();
          if (end < start) {
            this.$notify({
              text: "结束时间不能早于当前时间",
              type: "warn"
            });
            this.endTime = "";
          }
        }
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/dispatch/components/electronicFence.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/dispatch/components/electronicFence.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.find.js */ "./node_modules/core-js/modules/es.iterator.find.js");
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_common_selfTable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/components/common/selfTable */ "./src/components/common/selfTable.vue");
/* harmony import */ var _api_security_station_rails_controller__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/api/security-station-rails-controller */ "./src/api/security-station-rails-controller.js");
/* harmony import */ var _api_analytics_controller__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/api/analytics-controller */ "./src/api/analytics-controller.js");




// import { parseTime } from "@/utils/index";



/* harmony default export */ __webpack_exports__["default"] = ({
  name: "trajectory",
  components: {
    selfTable: _components_common_selfTable__WEBPACK_IMPORTED_MODULE_4__["default"]
  },
  props: {
    info: {
      type: Object,
      default() {
        return {};
      }
    }
  },
  data() {
    return {
      columns: [{
        prop: "railName",
        label: "围栏名称",
        width: 120
      }, {
        prop: "stationName",
        label: "所属驻勤点",
        width: 120
      }, {
        prop: "ruleTypeText",
        label: "围栏类型",
        width: 75
      }, {
        prop: "time",
        label: "时间范围"
      }, {
        prop: "operation",
        label: "操作",
        width: 85
      }],
      tableData: [],
      stationForRail: {},
      multipleSelection: [],
      originData: [] // 后台返回的原始数据
    };
  },
  methods: {
    selectionChange(list) {
      this.multipleSelection = list;
    },
    edit() {
      if (this.multipleSelection.length === 1) {
        let params = this.originData.find(item => {
          return item.id === this.multipleSelection[0].railId;
        });
        let paramIndex = this.originData.findIndex(item => {
          return item.id === this.multipleSelection[0].railId;
        });
        let emitData = {
          data: params,
          index: paramIndex
        };
        this.$emit("electronicFenceEdit", emitData);
      } else if (this.multipleSelection.length === 0) {
        this.$message({
          message: "请先选择一条数据",
          type: "error"
        });
      } else {
        this.$message({
          message: "只能选中一条数据进行编辑",
          type: "error"
        });
      }
    },
    showRail(row) {
      let params = this.originData.find(item => {
        return item.id === row.railId;
      });
      let emitData = {
        data: params
      };
      this.$emit("electronicFenceEdit", emitData);

      //查询增加调度记录
      Object(_api_analytics_controller__WEBPACK_IMPORTED_MODULE_6__["saveAnalyticsLogs"])({
        analyticsLogs: [{
          referenceNumber: row.railId,
          //电子围栏id
          referenceName: row.railName,
          //电子围栏名称
          type: 1,
          //电子围栏对应的类型为1.
          params: {
            //参数为空
          }
        }]
      }).then(res => {
        console.log("saveAnalyticsLogs", res);
      }).catch(err => {
        console.log(err);
      });
    },
    addElectronic() {
      this.$emit("addElectronic");
    },
    del() {
      if (this.multipleSelection.length === 1) {
        let params = this.originData.find(item => {
          return item.id === this.multipleSelection[0].railId;
        });
        let paramIndex = this.originData.findIndex(item => {
          return item.id === this.multipleSelection[0].railId;
        });
        let emitData = {
          data: params,
          index: paramIndex
        };
        this.$emit("del", emitData);
      } else if (this.multipleSelection.length === 0) {
        this.$message({
          message: "请先选择一条数据",
          type: "error"
        });
      } else {
        this.$message({
          message: "只能选中一条数据进行编辑",
          type: "error"
        });
      }
    },
    cancel() {
      this.$emit("cancel");
    },
    getRails() {
      Object(_api_security_station_rails_controller__WEBPACK_IMPORTED_MODULE_5__["searchRail"])({
        pageIndex: 0,
        pageSize: 0,
        searchModel: "Station",
        stationId: this.info.id
      }).then(res => {
        console.log("searchRail", res);
        if (res) {
          this.tableData = [];
          this.originData = res;
          res.forEach(rail => {
            this.tableData.push({
              railId: rail.id,
              railName: rail.name,
              stationName: rail.stationName,
              ruleType: rail.ruleType,
              ruleTypeText: rail.ruleTypeText,
              // time: rail.beginTime.slice(11, 16) + "-" + rail.endTime.slice(11, 16)
              time: rail.beginTime + "-" + rail.endTime
            });
          });
        }
      }).catch(err => {
        console.log(err);
      });
    },
    operation(row) {
      console.log("operation", row);
    }
  },
  mounted() {
    this.getRails();
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/dispatch/components/electronicFenceEdit.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/dispatch/components/electronicFenceEdit.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_common_selfTable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/components/common/selfTable */ "./src/components/common/selfTable.vue");
/* harmony import */ var _api_security_station_rails_controller__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/api/security-station-rails-controller */ "./src/api/security-station-rails-controller.js");
/* harmony import */ var sass__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! sass */ "./node_modules/sass/sass.node.js");
/* harmony import */ var sass__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(sass__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _amap_amap_jsapi_loader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @amap/amap-jsapi-loader */ "./node_modules/@amap/amap-jsapi-loader/dist/index.js");
/* harmony import */ var _amap_amap_jsapi_loader__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_amap_amap_jsapi_loader__WEBPACK_IMPORTED_MODULE_7__);




// import { parseTime } from "@/utils/index";




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "trajectory",
  components: {
    selfTable: _components_common_selfTable__WEBPACK_IMPORTED_MODULE_4__["default"]
  },
  props: {
    info: {
      type: Object,
      default() {
        return {};
      }
    },
    electronicFenceInfo: {
      type: Object,
      default() {
        return {};
      }
    },
    map: {
      type: Object,
      default() {
        return null;
      }
    }
  },
  watch: {
    info: {
      handler(newVal) {
        console.log(newVal);
        if (Object.keys(newVal).length !== 0) {
          this.form.stationId = newVal.id;
          this.form.peopleNum = newVal.countOfSecurityMan;
          if (Object.keys(this.electronicFenceInfo).length === 0) {
            this.form.stationName = newVal.name;
          }
          this.isStation = true;
        } else {
          this.isStation = false;
        }
      },
      immediate: true,
      deep: true
    },
    electronicFenceInfo: {
      handler(newVal) {
        console.log("electronicFenceInfo", newVal);
        if (Object.keys(newVal).length !== 0) {
          let deepVal = JSON.parse(JSON.stringify(newVal));
          this.form.stationName = deepVal.stationName;
          this.form.id = deepVal.id;
          this.form.name = deepVal.name;
          this.form.ruleType = deepVal.ruleType;
          this.form.shapeType = deepVal.shapeType;
          this.form.shapedLocation = deepVal.shapedLocation;
          this.form.stationId = deepVal.stationId;
          this.form.time = deepVal.time;
          this.form.note = deepVal.note;
          if (deepVal.shapeType === "Circle") {
            this.setCircle(deepVal.shapedLocation);
          } else if (deepVal.shapeType === "Crib") {
            this.setPolygon(deepVal.shapedLocation);
          } else if (deepVal.shapeType === "Polygon") {
            this.setPolygon(deepVal.shapedLocation);
          }
          // this.form = newVal
          this.isAdd = false;
        } else {
          this.isAdd = true;
          this.reset();
        }
      },
      immediate: true,
      deep: true
    }
  },
  data() {
    return {
      isAdd: false,
      isStation: false,
      columns: [{
        prop: "peopleType",
        label: "成员类型"
      }, {
        prop: "name",
        label: "成员名称"
      }],
      tableData: [{
        id: 1,
        peopleType: "保安员",
        name: "张三"
      }, {
        id: 2,
        peopleType: "负责人",
        name: "张三"
      }],
      typeList: [{
        id: "Exit",
        name: "离开告警"
      }, {
        id: "Enter",
        name: "进入告警"
      }
      // {
      //   id: "Access",
      //   name: "进出告警",
      // },
      ],
      areaList: [{
        id: "Crib",
        icon: __webpack_require__(/*! @/assets/images/mapToolbar/electronicFence/框选.png */ "./src/assets/images/mapToolbar/electronicFence/框选.png"),
        name: "框形选择"
      }, {
        id: "Circle",
        icon: __webpack_require__(/*! @/assets/images/mapToolbar/electronicFence/圈选.png */ "./src/assets/images/mapToolbar/electronicFence/圈选.png"),
        name: "圆形选择"
      }, {
        id: "Polygon",
        icon: __webpack_require__(/*! @/assets/images/mapToolbar/electronicFence/多边形选择.png */ "./src/assets/images/mapToolbar/electronicFence/多边形选择.png"),
        name: "多边形选择"
      }],
      form: {
        id: "",
        name: "",
        ruleType: "Exit",
        stationId: this.info.id,
        stationName: this.info.name,
        peopleNum: this.info.countOfSecurityMan,
        time: "",
        note: "",
        shapeType: "",
        peopleList: [],
        shapedLocation: {
          geos: [],
          radius: ""
        }
      },
      Circle: null,
      mousetool: null
    };
  },
  methods: {
    //返回电子围栏查询
    back() {
      this.$emit("back");
      this.$emit("clearMap");
    },
    openPeopleNum() {
      this.$emit("openPeopleNum", this.info.id);
    },
    //更换区域-已不用
    changeAreaType(id) {
      let that = this;
      this.form.shapeType = id;
      if (this.mouseTool) {
        this.mouseTool.close(true);
      }
      if (id === "Circle") {
        that.drawCircle();
      } else if (id === "Crib") {
        that.drawRectangle();
      } else if (id === "Polygon") {
        that.drawPolygon();
      }
    },
    //画多边形-已不用
    drawPolygon() {
      let that = this;
      AMap.plugin(["AMap.MouseTool"], function () {
        // that.mousetool = new AMap.MouseTool(that.map);
        let mouseTool = new AMap.MouseTool(that.map);
        that.mouseTool = mouseTool;
        //添加事件
        that.mouseTool.polygon({
          strokeColor: "#E6A23C",
          strokeOpacity: 1,
          fillOpacity: 0.2,
          strokeStyle: "dashed",
          strokeDasharray: [10, 10],
          // 线样式还支持 'dashed'
          fillColor: "#E6A23C",
          zIndex: 50
        });
        AMap.Event.addListener(that.mouseTool, "draw", function (e) {
          that.form.shapedLocation.geos = [];
          let coordinate = [];
          let path = e.obj.getPath();
          path.forEach(e => {
            coordinate.push({
              lon: e.getLng(),
              lat: e.getLat()
            });
          });
          that.$set(that.form.shapedLocation, "geos", coordinate);
          that.mouseTool.close(false);
        });
      });
    },
    //画圆形-已不用
    drawCircle() {
      let that = this;
      AMap.plugin(["AMap.MouseTool"], function () {
        // that.mousetool = new AMap.MouseTool(that.map);
        let mouseTool = new AMap.MouseTool(that.map);
        that.mouseTool = mouseTool;
        //添加事件
        that.mouseTool.circle({
          strokeColor: "#E6A23C",
          strokeOpacity: 1,
          fillOpacity: 0.2,
          strokeStyle: "dashed",
          strokeDasharray: [10, 10],
          // 线样式还支持 'dashed'
          fillColor: "#E6A23C",
          zIndex: 50
        });
        AMap.Event.addListener(that.mouseTool, "draw", function (e) {
          that.form.shapedLocation.geos = [];
          let path = e.obj.getCenter();
          let coordinate = [];
          console.log(path);
          coordinate.push({
            lat: path.lat,
            lon: path.lng
          });
          // path.forEach((e) => {
          //   coordinate.push({lat:e.getLng(), lon:e.getLat()});
          // });
          that.$set(that.form.shapedLocation, "geos", coordinate);
          that.$set(that.form.shapedLocation, "radius", e.obj.getRadius());
          that.mouseTool.close(false);
        });
      });
    },
    //画方形-已不用
    drawRectangle() {
      let that = this;
      AMap.plugin(["AMap.MouseTool"], function () {
        // that.mousetool = new AMap.MouseTool(that.map);
        let mouseTool = new AMap.MouseTool(that.map);
        that.mouseTool = mouseTool;
        //添加事件
        that.mouseTool.rectangle({
          strokeColor: "#E6A23C",
          strokeOpacity: 1,
          fillOpacity: 0.2,
          strokeStyle: "dashed",
          strokeDasharray: [10, 10],
          // 线样式还支持 'dashed'
          fillColor: "#E6A23C",
          zIndex: 50
        });
        AMap.Event.addListener(that.mouseTool, "draw", function (e) {
          that.form.shapedLocation.geos = [];
          let coordinate = [];
          let bounds = e.obj.getOptions().bounds;
          console.log(e.obj.getOptions());
          // coordinate = [{lat: bounds.northEast.lat, lon: bounds.northEast.lng},
          // {lat: bounds.southWest.lat, lon: bounds.southWest.lng}]
          coordinate = [{
            lon: bounds.northEast.lng,
            lat: bounds.southWest.lat
          }, {
            lon: bounds.northEast.lng,
            lat: bounds.northEast.lat
          }, {
            lon: bounds.southWest.lng,
            lat: bounds.northEast.lat
          }, {
            lon: bounds.southWest.lng,
            lat: bounds.southWest.lat
          }];
          console.log("coordinate", coordinate);
          that.$set(that.form.shapedLocation, "geos", coordinate);
          that.mouseTool.close(false);
        });
      });
    },
    //显示圆形
    setCircle(data) {
      let that = this;
      let Circle = new AMap.Circle({
        center: [data.geos[0].lat, data.geos[0].lon],
        // 站点坐标，定位圆点位置
        radius: Number(data.radius),
        //Circle半径，我取得是父组件传过来的值
        borderWeight: 3,
        strokeColor: "#0E70FF",
        strokeOpacity: 1,
        strokeWeight: 6,
        // strokeOpacity: 1,
        fillOpacity: 0.2,
        strokeStyle: "dashed",
        strokeDasharray: [10, 10],
        fillColor: "#0E70FF",
        zIndex: 50
      });
      console.log(Circle);
      Circle.setMap(that.map);
      that.Circle = Circle;
      // // 缩放地图到合适的视野级别
      that.map.setFitView([that.Circle]);
    },
    setRectangle(data) {
      console.log(data.geos);
    },
    //显示方形和多边形
    setPolygon(data) {
      console.log("=======setPolygon======", data.geos);
      let that = this;
      let path = data.geos.map(x => [x.lon, x.lat]);
      let polygon = new AMap.Polygon({
        path,
        strokeColor: "#E6A23C",
        strokeWeight: 6,
        strokeOpacity: 1,
        fillOpacity: 0.2,
        fillColor: "#E6A23C",
        zIndex: 50,
        bubble: true
      });
      console.log(polygon);
      polygon.setMap(that.map);
      that.map.setFitView([polygon]);
      // that.polygon = polygon
      // // 缩放地图到合适的视野级别
      // that.map.setFitView([ that.Circle ])
    },
    cancel() {
      if (this.mouseTool) {
        this.mouseTool.close(true);
      }
      this.$emit("cancel");
    },
    reset() {
      this.form.name = "";
      this.form.ruleType = "Exit";
      this.form.time = [];
      this.form.note = "";
      this.form.shapeType = "";
      this.form.shapedLocation = {
        geos: [],
        radius: ""
      };
      this.$emit("cleanFigure");
    },
    saveRail() {
      if (!this.form.name) {
        this.$message({
          message: "请输入围栏名称",
          type: "warning"
        });
        return;
      }
      if (!this.form.time[0] && !this.form.time[1]) {
        this.$message({
          message: "请输入时间范围",
          type: "warning"
        });
        return;
      }
      if (this.form.shapedLocation.geos.length === 0) {
        this.$message({
          message: "请选择围栏区域",
          type: "warning"
        });
        return;
      }
      let params = {
        name: this.form.name,
        ruleType: this.form.ruleType,
        shapeType: this.form.shapeType,
        stationId: this.form.stationId,
        id: this.form.id,
        note: this.form.note,
        beginTime: this.form.time[0],
        endTime: this.form.time[1],
        shapedLocation: this.form.shapedLocation
      };
      if (this.isAdd) {
        Object(_api_security_station_rails_controller__WEBPACK_IMPORTED_MODULE_5__["createRail"])(params).then(res => {
          console.log("saveRail", res);
          if (this.mouseTool) {
            this.mouseTool.close(true);
          }
          this.$message({
            message: "新增成功",
            type: "success"
          });
          this.$emit("cancel");
        }).catch(err => {
          console.log(err);
        });
      } else {
        Object(_api_security_station_rails_controller__WEBPACK_IMPORTED_MODULE_5__["updateRail"])(params).then(res => {
          console.log("updateRail", res);
          if (this.mouseTool) {
            this.mouseTool.close(true);
          }
          this.$message({
            message: "修改成功",
            type: "success"
          });
          this.$emit("cancel");
        }).catch(err => {
          console.log(err);
        });
      }
    },
    setForm({
      shapedLocation,
      shapeType
    }) {
      this.form.shapedLocation = {
        ...{},
        ...shapedLocation
      };
      this.form.shapeType = shapeType;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/dispatch/components/electronicFencePeople.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/dispatch/components/electronicFencePeople.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);

/* harmony default export */ __webpack_exports__["default"] = ({
  name: "trajectory",
  props: {
    list: {
      type: Array,
      default() {
        return {};
      }
    },
    stationName: {
      type: String,
      default() {
        return "";
      }
    }
  },
  watch: {
    list: {
      handler(newVal) {
        if (newVal.length !== 0) {
          this.peoPleList = [];
          for (let i = 0; i < newVal.length; i++) {
            newVal[i].isPhone = false;
            this.peoPleList.push(newVal[i]);
          }
        }
      },
      immediate: true,
      deep: true
    }
  },
  data() {
    return {
      peoPleList: [],
      stationForRail: {}
    };
  },
  methods: {
    changeIsphone(index) {
      console.log(this.peoPleList[index]);
      let indexObj = JSON.parse(JSON.stringify(this.peoPleList[index]));
      indexObj.isPhone = !indexObj.isPhone;
      this.$set(this.peoPleList, index, indexObj);
    },
    cancel() {
      this.$emit("cancel");
    }
  },
  mounted() {}
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/dispatch/components/routeDetail.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/dispatch/components/routeDetail.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _api_malasong_route_controller__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/api/malasong-route-controller */ "./src/api/malasong-route-controller.js");
/* harmony import */ var _api_projects_controller__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/api/projects-controller */ "./src/api/projects-controller.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "RouteList",
  props: {
    routePath: {
      type: Array,
      default: () => []
    }
  },
  data() {
    return {
      mapType: "tianditu",
      projects: [],
      ruleForm: {
        name: "",
        projectId: "",
        routeLength: 42,
        color: "#409EFF",
        strokeWeight: 1
      },
      rules: {
        name: [{
          required: true,
          message: "请输入线路名称",
          trigger: "blur"
        }, {
          min: 1,
          max: 100,
          message: "长度在100个字符以内",
          trigger: "blur"
        }],
        projectId: [{
          required: true,
          message: "请选择所属项目",
          trigger: "change"
        }]
      }
    };
  },
  mounted() {
    //
  },
  methods: {
    async getProjects() {
      if (!this.projects.length) {
        this.projects = await Object(_api_projects_controller__WEBPACK_IMPORTED_MODULE_1__["getProjects"])({
          pageIndex: 1,
          pageSize: 10000,
          forExport: true,
          keyword: null,
          superviseDepartIds: []
        });
      }
    },
    setFormValue(data) {
      console.log("🚀 ~ setFormValue ~ data:", data);
      const {
        roadmap,
        projectId,
        name,
        id,
        polylineObj,
        polyEditor
      } = data;
      this.ruleForm = {
        ...this.ruleForm,
        polylineObj,
        polyEditor,
        id,
        projectId: projectId || "",
        name,
        color: (roadmap === null || roadmap === void 0 ? void 0 : roadmap.color) || "#28F",
        strokeWeight: (roadmap === null || roadmap === void 0 ? void 0 : roadmap.strokeWeight) || 4
      };
    },
    submitForm(formName) {
      this.$refs[formName].validate(valid => {
        if (valid) {
          const {
            polylineObj,
            polyEditor,
            strokeWeight,
            color,
            id,
            ...rest
          } = this.ruleForm;
          let path = [];
          if (this.mapType === "tianditu") {
            path = polyEditor ? polyEditor.getTarget().getPath() : polylineObj ? polylineObj.getLngLats() : [];
          } else {
            path = polyEditor ? polyEditor.getTarget().getPath() : polylineObj ? polylineObj.getPath() : [];
          }
          const params = {
            ...rest,
            roadmap: {
              path,
              strokeWeight,
              color
            }
          };
          if (id) {
            Object(_api_malasong_route_controller__WEBPACK_IMPORTED_MODULE_0__["editRoadmaps"])(id, params).then(res => {
              this.$message.success("保存成功");
              this.$emit("close", {
                ...params,
                id,
                polylineObj
              });
            }).catch(err => {
              console.log("🚀 ~ addRoadmaps ~ err:", err);
            });
          } else {
            Object(_api_malasong_route_controller__WEBPACK_IMPORTED_MODULE_0__["addRoadmaps"])(params).then(res => {
              this.$message.success("保存成功");
              this.$emit("close", {
                ...params,
                polylineObj
              });
            }).catch(err => {
              console.log("🚀 ~ addRoadmaps ~ err:", err);
            });
          }
        } else {
          return false;
        }
      });
    },
    handleClose() {
      this.$emit("close");
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/dispatch/components/routeList.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/dispatch/components/routeList.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _api_malasong_route_controller__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/api/malasong-route-controller */ "./src/api/malasong-route-controller.js");
/* harmony import */ var _api_projects_controller__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/api/projects-controller */ "./src/api/projects-controller.js");




/* harmony default export */ __webpack_exports__["default"] = ({
  name: "RouteList",
  data() {
    return {
      projects: [],
      dialogTableVisible: false,
      formLabelWidth: "70px",
      form: {
        name: ""
      },
      currentPage: 1,
      pageSize: 10000,
      tableData: [],
      multipleSelection: []
    };
  },
  mounted() {},
  methods: {
    getList() {
      const params = {
        name: this.form.name,
        projectIds: this.projects.map(e => e.id)
      };
      Object(_api_malasong_route_controller__WEBPACK_IMPORTED_MODULE_2__["searchRoadmaps"])(params).then(res => {
        const {
          data
        } = res;
        this.tableData = data;
      }).catch(err => {
        console.log("🚀 ~ searchRoadmaps ~ err:", err);
      });
    },
    async setVisible() {
      this.dialogTableVisible = true;
      this.projects = await Object(_api_projects_controller__WEBPACK_IMPORTED_MODULE_3__["getProjects"])({
        pageIndex: 1,
        pageSize: 10000,
        forExport: true,
        keyword: null,
        superviseDepartIds: []
      });
      this.getList();
    },
    handleSelectionChange(val) {
      this.multipleSelection = val;
    },
    handleSearch() {
      this.getList();
    },
    handleMap(row) {
      this.dialogTableVisible = false;
      this.$emit("viewRoute", row);
    },
    handleAdd() {
      this.dialogTableVisible = false;
      this.$emit("addRoute");
    },
    handleDel(row) {
      Object(_api_malasong_route_controller__WEBPACK_IMPORTED_MODULE_2__["delRoadmaps"])(row.id).then(res => {
        this.$message.success("操作成功");
        this.getList();
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/dispatch/components/trajectory.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/dispatch/components/trajectory.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _api_employee_controller__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/api/employee-controller */ "./src/api/employee-controller.js");
/* harmony import */ var _utils_index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/utils/index */ "./src/utils/index.js");
/* harmony import */ var _components_common_selfTable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/components/common/selfTable */ "./src/components/common/selfTable.vue");
/* harmony import */ var _api_analytics_controller__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/api/analytics-controller */ "./src/api/analytics-controller.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! dayjs */ "./node_modules/dayjs/dayjs.min.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_8__);




// import AMapLoader from "@amap/amap-jsapi-loader";





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "trajectory",
  components: {
    selfTable: _components_common_selfTable__WEBPACK_IMPORTED_MODULE_6__["default"]
  },
  props: {
    info: {
      type: Object,
      default() {
        return {};
      }
    },
    map: {
      type: Object,
      default() {
        return null;
      }
    }
  },
  data() {
    return {
      speedSelfValue: "",
      speedBtnActive: "1",
      detailOpen: false,
      columns: [{
        prop: "createdTime",
        label: "时间",
        width: 180
      }, {
        prop: "locations",
        label: "位置参数",
        width: 300
      }
      // {
      //   prop: "locationName",
      //   label: "位置名称",
      // },
      ],
      controlList: [
      // {
      //   id: 1,
      //   name: "left",
      //   icon: require("@/assets/images/mapToolbar/trajectory/left.png"),
      // },
      {
        id: 2,
        name: "play",
        icon: __webpack_require__(/*! @/assets/images/mapToolbar/trajectory/play.png */ "./src/assets/images/mapToolbar/trajectory/play.png")
      },
      // {
      //   id: 3,
      //   name: "right",
      //   icon: require("@/assets/images/mapToolbar/trajectory/right.png"),
      // },
      {
        id: 4,
        name: "stop",
        icon: __webpack_require__(/*! @/assets/images/mapToolbar/trajectory/stop.png */ "./src/assets/images/mapToolbar/trajectory/stop.png")
      }, {
        id: 5,
        name: "refresh",
        icon: __webpack_require__(/*! @/assets/images/mapToolbar/trajectory/refresh.png */ "./src/assets/images/mapToolbar/trajectory/refresh.png")
      }],
      speedBtnList: [{
        id: "1",
        label: "x1",
        num: 1
      }, {
        id: "2",
        label: "x2",
        num: 2
      }, {
        id: "3",
        label: "x5",
        num: 5
      }],
      form: {
        beginDate: "",
        endDate: ""
      },
      marketList: [],
      marker: null,
      lineArr: [],
      polyline: [],
      markerSpeed: 1,
      //速度
      polyline1: [],
      //重绘通过路径轨迹的集合
      len: null,
      //marker移动中路径数组
      duration: 5000,
      passedPolyline: [],
      currentIndex: null
    };
  },
  methods: {
    parseTime: _utils_index__WEBPACK_IMPORTED_MODULE_5__["parseTime"],
    endTrajectory() {
      if (this.lineArr.length > 0) {
        this.map.remove(this.marker);
        this.map.remove(this.polyline);
        this.map.remove(this.passedPolyline);
        this.lineArr = [];
        this.stopAnimation();
      }
      this.cancel();
    },
    controlClick(obj) {
      switch (obj.name) {
        case "left":
          this.backStep();
          break;
        case "play":
          this.startMove();
          break;
        case "stop":
          this.stopAnimation();
          break;
        case "right":
          this.nextStep();
          break;
        case "refresh":
          this.refresh();
          break;
      }
    },
    detailOpenFn() {
      if (this.marketList.length <= 0) {
        this.$message({
          message: "暂无轨迹数据",
          type: "warning"
        });
      } else {
        this.detailOpen = !this.detailOpen;
      }
    },
    changeSpeed(id) {
      this.speedBtnActive = id;
      let speedNumObj = [];
      if (Number(id) < 7) {
        speedNumObj = this.speedBtnList.filter(item => item.id === id);
        this.markerSpeed = speedNumObj[0].num;
      } else {
        this.markerSpeed = this.speedSelfValue;
      }
      //this.startAnimation();
      this.startMove();
    },
    // 开始回放
    startMove() {
      this.$emit("startMove", this.markerSpeed);
    },
    backStep() {
      this.$emit("backStep");
    },
    nextStep() {
      this.$emit("nextStep");
    },
    // startAnimation() {
    //   let that = this;
    //   if (this.passedPolyline.length != 0) {
    //     this.map.remove(this.passedPolyline);
    //     that.passedPolyline = new AMap.Polyline({
    //       map: this.map,
    //       strokeColor: "#AF5", // 线颜色
    //       strokeWeight: 6, // 线宽
    //     });
    //   }
    //   console.log(this.markerSpeed);
    //   this.marker.moveAlong(this.lineArr, this.markerSpeed);
    // },
    pauseAnimation() {
      this.marker.pauseMove();
    },
    resumeAnimation() {
      this.marker.resumeMove();
    },
    // 倍速控制
    // handleSelect(e) {
    //   console.log("e", parseInt(e.charAt(0)));
    //   this.duration = 5000 / parseInt(e.charAt(0));
    // },
    stopAnimation() {
      // this.marker.stopMove();
      // this.$emit("stopMove");
      this.$emit("pauseMove");
    },
    refresh() {
      this.$emit("refresh", this.markerSpeed);
    },
    mapListTrans(list) {
      let arr = [];
      for (let i = 0; i < list.length; i++) {
        let item = list[i];
        let items = [item.longitude, item.latitude];
        arr.push(items);
      }
      return arr;
    },
    search() {
      if (!this.form.beginDate) {
        this.$message.info("请输入开始时间");
        return false;
      }
      if (!this.form.endDate) {
        this.$message.info("请输入结束时间");
        return false;
      }
      let params = {
        employeeId: this.info.id,
        employeeName: this.info.name,
        beginDate: dayjs__WEBPACK_IMPORTED_MODULE_8___default()(this.form.beginDate).format("YYYY-MM-DD HH:mm:ss"),
        endDate: dayjs__WEBPACK_IMPORTED_MODULE_8___default()(this.form.endDate).format("YYYY-MM-DD HH:mm:ss")
      };
      Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_4__["getEmployeesTrack"])(params).then(res => {
        if (res.length > 0) {
          this.marketList = res;
          console.log(this.marketList);
          const pathData = this.marketList.map(path => {
            // const next = this.marketList[index+1]
            return {
              position: [path.longitude, path.latitude],
              time: dayjs__WEBPACK_IMPORTED_MODULE_8___default()(path.createdTime).format("YYYY-MM-DD HH:mm:ss"),
              duration: 10000
              // duration: dayjs(path.createdTime).diff(dayjs(pre.createdTime)),
            };
          });
          console.log(pathData);
          console.log(pathData.map(path => {
            return path === null || path === void 0 ? void 0 : path.position;
          }));
          this.$emit("setTrack", pathData);
          this.setCurrentRow(0);
        } else {
          this.$message({
            message: "暂无轨迹",
            type: "error"
          });
        }

        //查询增加调度记录
        Object(_api_analytics_controller__WEBPACK_IMPORTED_MODULE_7__["saveAnalyticsLogs"])({
          analyticsLogs: [{
            referenceNumber: params.employeeId,
            //轨迹查询对应的职员id
            referenceName: params.employeeName,
            //轨迹查询对应的职员名称
            type: 0,
            //职员的轨迹查询对应的类型为0.
            params: {
              beginDate: params.beginDate,
              //轨迹查询的起始时间
              endDate: params.endDate //截止时间
            }
          }]
        }).then(res => {
          console.log("saveAnalyticsLogs", res);
        }).catch(err => {
          console.log(err);
        });
      }).catch(err => {
        console.log(err);
        this.$message({
          message: err.response.data.message,
          type: "error"
        });
      });
    },
    cancel() {
      this.$emit("cancel");
    },
    setCurrentRow(index) {
      // const row = this.marketList[index]
      this.currentIndex = index;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/dispatch/index.vue?vue&type=script&lang=js":
/*!*****************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/dispatch/index.vue?vue&type=script&lang=js ***!
  \*****************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.find.js */ "./node_modules/core-js/modules/es.iterator.find.js");
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.iterator.for-each.js */ "./node_modules/core-js/modules/es.iterator.for-each.js");
/* harmony import */ var core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_for_each_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_iterator_to_array_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.iterator.to-array.js */ "./node_modules/core-js/modules/es.iterator.to-array.js");
/* harmony import */ var core_js_modules_es_iterator_to_array_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_to_array_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _components_AMap__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/components/AMap */ "./src/components/AMap/index.js");
/* harmony import */ var _components_mapSearch_index_vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/components/mapSearch/index.vue */ "./src/components/mapSearch/index.vue");
/* harmony import */ var _components_mapToolbar_index_vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/components/mapToolbar/index.vue */ "./src/components/mapToolbar/index.vue");
/* harmony import */ var _api_company_controller__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/api/company-controller */ "./src/api/company-controller.js");
/* harmony import */ var _api_employee_controller__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/api/employee-controller */ "./src/api/employee-controller.js");
/* harmony import */ var _api_device_controller__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/api/device-controller */ "./src/api/device-controller.js");
/* harmony import */ var _components_electronicFence_vue__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./components/electronicFence.vue */ "./src/views/dispatch/components/electronicFence.vue");
/* harmony import */ var _components_electronicFenceEdit_vue__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./components/electronicFenceEdit.vue */ "./src/views/dispatch/components/electronicFenceEdit.vue");
/* harmony import */ var _components_electronicFencePeople_vue__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./components/electronicFencePeople.vue */ "./src/views/dispatch/components/electronicFencePeople.vue");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _api_security_station_controller__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/api/security-station-controller */ "./src/api/security-station-controller.js");
/* harmony import */ var _api_projects_controller__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/api/projects-controller */ "./src/api/projects-controller.js");
/* harmony import */ var _components_trajectory_vue__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./components/trajectory.vue */ "./src/views/dispatch/components/trajectory.vue");
/* harmony import */ var _tim__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @/tim */ "./src/tim.js");
/* harmony import */ var _components_timApp_message_image_previewer_vue__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @/components/timApp/message/image-previewer.vue */ "./src/components/timApp/message/image-previewer.vue");
/* harmony import */ var _api_security_station_rails_controller__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @/api/security-station-rails-controller */ "./src/api/security-station-rails-controller.js");
/* harmony import */ var _utils_websocket__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @/utils/websocket */ "./src/utils/websocket.js");
/* harmony import */ var _api_common__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @/api/common */ "./src/api/common.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var _api_tenant_user_controller__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @/api/tenant-user-controller */ "./src/api/tenant-user-controller.js");
/* harmony import */ var _utils_im__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @/utils/im */ "./src/utils/im.js");
/* harmony import */ var draggable_vue_directive__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! draggable-vue-directive */ "./node_modules/draggable-vue-directive/dist/index.js");
/* harmony import */ var draggable_vue_directive__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(draggable_vue_directive__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var _components_timApp_conversation_current_conversation_vue__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @/components/timApp/conversation/current-conversation.vue */ "./src/components/timApp/conversation/current-conversation.vue");
/* harmony import */ var _components_timApp_trtc_calling_index_vue__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @/components/timApp/trtc/calling-index.vue */ "./src/components/timApp/trtc/calling-index.vue");
/* harmony import */ var _components_mqttClient_index_vue__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @/components/mqttClient/index.vue */ "./src/components/mqttClient/index.vue");
/* harmony import */ var _api_exam_site_room_controller__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! @/api/exam-site-room-controller */ "./src/api/exam-site-room-controller.js");
/* harmony import */ var _components_mapOverlay_exam__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! @/components/mapOverlay/exam */ "./src/components/mapOverlay/exam/index.vue");
/* harmony import */ var _components_mapOverlay_examSite__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! @/components/mapOverlay/examSite */ "./src/components/mapOverlay/examSite/index.vue");
/* harmony import */ var _components_pttClient_index_vue__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! @/components/pttClient/index.vue */ "./src/components/pttClient/index.vue");
/* harmony import */ var _components_routeList_vue__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./components/routeList.vue */ "./src/views/dispatch/components/routeList.vue");
/* harmony import */ var _components_routeDetail_vue__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./components/routeDetail.vue */ "./src/views/dispatch/components/routeDetail.vue");
/* harmony import */ var _components_lnglatMap_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./components/lnglatMap.js */ "./src/views/dispatch/components/lnglatMap.js");
/* harmony import */ var gcoord__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! gcoord */ "./node_modules/gcoord/dist/gcoord.esm-bundler.js");
/* harmony import */ var _turf_turf__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! @turf/turf */ "./node_modules/@turf/turf/turf.min.js");
/* harmony import */ var _turf_turf__WEBPACK_IMPORTED_MODULE_40___default = /*#__PURE__*/__webpack_require__.n(_turf_turf__WEBPACK_IMPORTED_MODULE_40__);
/* harmony import */ var _ui_main_HomePage_vue__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! @/ui/main/HomePage.vue */ "./src/ui/main/HomePage.vue");
/* harmony import */ var _api_appServerApi__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! @/api/appServerApi */ "./src/api/appServerApi.js");
/* harmony import */ var _ui_util_storageHelper__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! @/ui/util/storageHelper */ "./src/ui/util/storageHelper.js");
/* harmony import */ var _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! @/wfc/client/wfc */ "./src/wfc/client/wfc.js");
/* harmony import */ var _store_js__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! @/store.js */ "./src/store.js");
/* harmony import */ var _utils_wfc__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! @/utils/wfc */ "./src/utils/wfc.js");
/* harmony import */ var _ui_voip_Single_vue__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! @/ui/voip/Single.vue */ "./src/ui/voip/Single.vue");
/* harmony import */ var _ui_voip_Multi_vue__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! @/ui/voip/Multi.vue */ "./src/ui/voip/Multi.vue");
/* harmony import */ var _ui_voip_conference_Conference_vue__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! @/ui/voip/conference/Conference.vue */ "./src/ui/voip/conference/Conference.vue");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! @/wfc/av/internal/engine.min */ "./src/wfc/av/internal/engine.min.js");
/* harmony import */ var _wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_50___default = /*#__PURE__*/__webpack_require__.n(_wfc_av_internal_engine_min__WEBPACK_IMPORTED_MODULE_50__);
/* harmony import */ var _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! @/wfc/av/engine/avenginekitproxy */ "./src/wfc/av/engine/avenginekitproxy.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! @/platform */ "./src/platform.js");
/* harmony import */ var _wfc_client_wfcEvent__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! @/wfc/client/wfcEvent */ "./src/wfc/client/wfcEvent.js");
/* harmony import */ var _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! @/wfc/client/connectionStatus */ "./src/wfc/client/connectionStatus.js");























































// import pttClient from "@/ui/ptt/pttClient.vue";

var avenginkitSetuped = false;
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "dispatch",
  components: {
    AMap: _components_AMap__WEBPACK_IMPORTED_MODULE_7__["AMap"],
    AInfoWindow: _components_AMap__WEBPACK_IMPORTED_MODULE_7__["AInfoWindow"],
    mapSearch: _components_mapSearch_index_vue__WEBPACK_IMPORTED_MODULE_8__["default"],
    mapToolbar: _components_mapToolbar_index_vue__WEBPACK_IMPORTED_MODULE_9__["default"],
    trajectoryDialog: _components_trajectory_vue__WEBPACK_IMPORTED_MODULE_19__["default"],
    electronicFenceDialog: _components_electronicFence_vue__WEBPACK_IMPORTED_MODULE_13__["default"],
    electronicFenceEditDialog: _components_electronicFenceEdit_vue__WEBPACK_IMPORTED_MODULE_14__["default"],
    electronicFencePeople: _components_electronicFencePeople_vue__WEBPACK_IMPORTED_MODULE_15__["default"],
    imagePreviewer: _components_timApp_message_image_previewer_vue__WEBPACK_IMPORTED_MODULE_21__["default"],
    pttClient: _components_pttClient_index_vue__WEBPACK_IMPORTED_MODULE_35__["default"],
    currentConversation: _components_timApp_conversation_current_conversation_vue__WEBPACK_IMPORTED_MODULE_29__["default"],
    CallLayer: _components_timApp_trtc_calling_index_vue__WEBPACK_IMPORTED_MODULE_30__["default"],
    OverlayExam: _components_mapOverlay_exam__WEBPACK_IMPORTED_MODULE_33__["default"],
    OverlayExamSite: _components_mapOverlay_examSite__WEBPACK_IMPORTED_MODULE_34__["default"],
    MqttClient: _components_mqttClient_index_vue__WEBPACK_IMPORTED_MODULE_31__["default"],
    RouteList: _components_routeList_vue__WEBPACK_IMPORTED_MODULE_36__["default"],
    RouteDetail: _components_routeDetail_vue__WEBPACK_IMPORTED_MODULE_37__["default"],
    wfClient: _ui_main_HomePage_vue__WEBPACK_IMPORTED_MODULE_41__["default"],
    Conference: _ui_voip_conference_Conference_vue__WEBPACK_IMPORTED_MODULE_49__["default"],
    Multi: _ui_voip_Multi_vue__WEBPACK_IMPORTED_MODULE_48__["default"],
    Single: _ui_voip_Single_vue__WEBPACK_IMPORTED_MODULE_47__["default"]
  },
  data() {
    return {
      voipProxy: _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_51__["default"],
      mapType: "tianditu",
      showRouteDetail: false,
      showMonitor: false,
      actEmployeeTypes: [],
      radio: 1,
      platform: localStorage.getItem("platform") || "1",
      deskTypes: localStorage.getItem("platform") === "2" ? ["Proprietor"] : localStorage.getItem("platform") === "3" ? ["TemporarySecurity"] : ["Normal"],
      deskTypesParam: ["TemporarySecurity"],
      //默认临保调度参数
      isCompany: false,
      mapToolList: localStorage.getItem("platform") === "3" ? ["tile", "media", "polyline", "draw", "tools", "more", "history"] : ["tile", "media", "draw", "tools", "more", "history"],
      mapToolDisableList: [],
      isElectronicFencePeople: false,
      electronicFencePeopleList: [],
      isElectronicFenceEditDialog: false,
      map: null,
      AMap: null,
      isComplete: false,
      conversationVisible: false,
      isTrajectoryDialog: false,
      isElectronicFenceDialog: false,
      railDispatchShow: false,
      railDispatchDeviceShow: false,
      value: 0,
      distanceList: [{
        label: "请选择",
        value: 0
      }, {
        label: "100米",
        value: 100
      }, {
        label: "300米",
        value: 300
      }, {
        label: "500米",
        value: 500
      }],
      loadOptions: {
        version: "2.0"
      },
      mapOptions: {
        viewMode: "3D",
        //是否为3D地图模式
        pitchEnable: true,
        rotateEnable: true
      },
      markers: [],
      infoWindow: {
        employee: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        project: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        station: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        device: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        company: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        location: {
          anchor: "bottom-center",
          offset: [0, -60],
          position: undefined,
          autoMove: false
        },
        stationEmployees: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        companyStations: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        rail: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        railTwo: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        railSecurity: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        railDevices: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        track: {
          anchor: "bottom-center",
          offset: [0, 0],
          position: undefined,
          autoMove: false
        },
        SOS: {
          isCustom: true,
          anchor: "bottom-center",
          offset: [0, -46],
          position: undefined,
          autoMove: false,
          info: {
            name: "",
            content: ""
          }
        },
        exam: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        },
        examSite: {
          anchor: "bottom-center",
          offset: [0, -56],
          position: undefined,
          autoMove: false
        }
      },
      info: {
        resourceTypes: []
      },
      layers: [{
        type: "default"
      }],
      plugin: ["AMap.MouseTool", "AMap.PlaceSearch"],
      moveMarker: {
        icon: __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png"),
        anchor: "bottom-center"
      },
      moveAlong: {
        autoRotation: false
      },
      type: 1,
      infoType: "",
      stationTypes: [],
      isIdCardNo: false,
      isContact: false,
      commandList: [{
        label: "文字调度",
        value: "character"
      }, {
        label: "语音调度",
        value: "audio"
      }, {
        label: "视频调度",
        value: "video"
      }, {
        label: "周边调度",
        value: "rail"
      }, {
        label: "拉取视频",
        value: "videoLocalMute"
      }, {
        label: "对讲",
        value: "ptt"
      }],
      //指挥调度
      commandIndex: undefined,
      trackList: [{
        label: "轨迹查询",
        value: ""
      }
      // { label: "轨迹上拉", value: "" },
      ],
      //轨迹服务
      trackIndex: undefined,
      companyDetail: false,
      isPhone: false,
      rail: {},
      employee: {},
      stationEmployeesListType: "all",
      // all,on,off
      stationEmployeesList: [],
      stationEmployeesListFilter: [],
      totalNum: 0,
      previous: 0,
      nextPage: 4,
      // tim创建群聊表单
      groupFormDialogVisible: false,
      memberList: [],
      allMembers: [],
      stream: {
        audio: true,
        video: true
      },
      //调度类型：1视频调度 2 拉取视频：除了拉取视频传2，其他音频调度与视频调度都传1
      yardmanType: "1",
      callType: "video",
      form: {
        groupID: "",
        name: "",
        schedulingContent: "",
        type: this.TIM.TYPES.GRP_WORK,
        introduction: "",
        notification: "",
        joinOption: "FreeAccess",
        memberList: []
      },
      rules: {
        name: [{
          required: true,
          message: "请输入调度事由",
          trigger: "blur"
        }],
        schedulingContent: [{
          required: true,
          message: "请输入调度事由",
          trigger: "blur"
        }]
      },
      isImgError: false,
      stationForRail: {},
      electronicFenceInfo: {},
      delElectronicIndex: null,
      circleFigure: null,
      circleEditorObject: null,
      rectangleFigure: null,
      rectangleEditor: null,
      polygonFigure: null,
      polygonEditor: null,
      // sect.slice(0, 2)
      movePath: [],
      moveStatus: "",
      speedRatio: 1,
      ws: null,
      showStationEmployees: false,
      levelNameList: [
      //警情上报强提醒，弱提醒
      {
        label: "特别重大",
        level: "Greats",
        bgColor: "#A80000",
        index: 0
      }, {
        label: "重大",
        level: "Great",
        bgColor: "#F48200",
        index: 1
      }, {
        label: "较大",
        level: "More",
        bgColor: "#F7BE00",
        index: 2
      }, {
        label: "一般",
        level: "Comon",
        bgColor: "#00B40C",
        index: 3
      }],
      TRTCActionMap: {},
      showDutyCheckbox: false,
      //点击在岗时候显示
      isIndeterminate: false,
      dutyCheckAll: false,
      deviceCheckAll: false,
      cluster: {},
      stationTypeNameMap: {
        Security: "驻勤点",
        Population: "社区警务",
        TemporarySecurity: "临保岗点"
      },
      employeeTypeNameMap: {
        Proprietor: "甲方管理员",
        Security: "保安员",
        Population: "社会力量"
      },
      pttVisible: false,
      pttMultiple: false,
      isSingle: false,
      sharedMiscState: _store_js__WEBPACK_IMPORTED_MODULE_45__["default"].state.misc,
      conversationInfo: _store_js__WEBPACK_IMPORTED_MODULE_45__["default"].state.conversation,
      sosId: "",
      priority: 0,
      //PTT创建调度群优先级设置
      videoBoxes: 5,
      //默认视频时候显示5方，有些组织显示15
      customizeOrgs: ["eGrmlAN1", "gZGdnW3U", "kJe5VD6U", "mli417t9", "3iT1CmoS"],
      //指定显示15方的组织
      customizeOrgsNoLimit: ["Qg7WSfqc", "fWoCV2Df", "2r2IYLAy"],
      //不限制方数的组织
      audioState: false,
      isDeviceSOS: false,
      //是否是设备报警
      deviceSosId: "" //设备报警id
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_16__["mapState"])({
      currentConversation: ({
        conversation
      }) => conversation.currentConversation,
      currentMessageList: ({
        conversation
      }) => conversation.currentMessageList,
      dispatching: ({
        video
      }) => video.dispatching,
      appLoadingMask: state => state.appLoadingMask,
      roomId: ({
        trtc
      }) => trtc.roomId,
      pttAccount: ({
        gwsd
      }) => gwsd.account,
      dispatchMembers: ({
        gwsd
      }) => gwsd.dispatchMembers,
      pttMemberList: ({
        gwsd
      }) => gwsd.memberList,
      sysUserInfo: ({
        user
      }) => user.sysUserInfo
    }),
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_16__["mapGetters"])(["toAccount", "currentConversationType", "sysUserInfo", "dispatchClient"]),
    getUserInfo() {
      return this.sysUserInfo && Object.keys(this.sysUserInfo).length > 0;
    },
    getEmployeeType() {
      if (this.info.occupationType === "-") {
        var _this$actEmployeeType;
        return (_this$actEmployeeType = this.actEmployeeTypes.find(el => el.code === this.info.stationType)) === null || _this$actEmployeeType === void 0 ? void 0 : _this$actEmployeeType.name;
      }
      return this.info.occupationType;
    },
    getStationTypes() {
      if (this.info.stationTypes && this.info.stationTypes.length) {
        var _this$actEmployeeType2;
        return (_this$actEmployeeType2 = this.actEmployeeTypes.find(el => {
          var _this$info$stationTyp;
          return el.code === ((_this$info$stationTyp = this.info.stationTypes[0]) === null || _this$info$stationTyp === void 0 ? void 0 : _this$info$stationTyp.code);
        })) === null || _this$actEmployeeType2 === void 0 ? void 0 : _this$actEmployeeType2.name;
      }
      return "";
    },
    getStationIcon() {
      if (this.platform === "3" && this.sysUserInfo.orgInstitutional === "0201") {
        if (this.info.stationTypes && this.info.stationTypes.length) {
          var _this$actEmployeeType3;
          const icon = (_this$actEmployeeType3 = this.actEmployeeTypes.find(el => {
            var _this$info$stationTyp2;
            return el.code === ((_this$info$stationTyp2 = this.info.stationTypes[0]) === null || _this$info$stationTyp2 === void 0 ? void 0 : _this$info$stationTyp2.code);
          })) === null || _this$actEmployeeType3 === void 0 ? void 0 : _this$actEmployeeType3.icon;
          return icon || __webpack_require__(/*! @/assets/images/mapSearch/驻勤点备份.png */ "./src/assets/images/mapSearch/驻勤点备份.png");
        }
        return __webpack_require__(/*! @/assets/images/mapSearch/驻勤点备份.png */ "./src/assets/images/mapSearch/驻勤点备份.png");
      }
      return __webpack_require__(/*! @/assets/images/mapSearch/驻勤点备份.png */ "./src/assets/images/mapSearch/驻勤点备份.png");
    },
    defaultMessage: {
      get() {
        return this.currentConversation.type === this.TIM.TYPES.CONV_C2C ? "" : this.form.schedulingContent;
      },
      set(value) {
        this.form.schedulingContent = value;
      }
    },
    stationTypeName() {
      const {
        resourceTypes
      } = this.info;
      if (resourceTypes) {
        if (resourceTypes.includes("TemporarySecurity")) {
          return this.stationTypeNameMap["TemporarySecurity"];
        } else if (resourceTypes.includes("Security")) {
          return this.stationTypeNameMap["Security"];
        } else {
          return this.stationTypeNameMap["Population"];
        }
      } else {
        return "";
      }
    },
    employeeTypeName() {
      const {
        resourceTypes
      } = this.info;
      if (resourceTypes) {
        if (resourceTypes.includes("Security")) {
          return this.employeeTypeNameMap["Security"];
        } else if (resourceTypes.includes("Proprietor")) {
          return this.employeeTypeNameMap["Proprietor"];
        } else {
          return this.employeeTypeNameMap["Population"];
        }
      } else {
        return "";
      }
    },
    resourceType() {
      if (Object.prototype.hasOwnProperty.call(this.info, "resourceTypes")) {
        if (this.info.resourceTypes.length === 2) {
          return "Security";
        } else {
          return this.info.resourceTypes[0];
        }
      } else {
        return "";
      }
    },
    pptClientWidth() {
      return this.pttMemberList.length > 1 ? "919px" : "442px";
    }
  },
  directives: {
    Draggable: draggable_vue_directive__WEBPACK_IMPORTED_MODULE_28__["Draggable"]
  },
  watch: {
    stationEmployeesListType(val) {
      switch (val) {
        case "all":
          this.stationEmployeesListFilter = this.stationEmployeesList;
          break;
        case "on":
          this.stationEmployeesListFilter = this.stationEmployeesList.filter(x => x.dutyStatus === "SignIn");
          break;
        case "off":
          this.stationEmployeesListFilter = this.stationEmployeesList.filter(x => x.dutyStatus !== "SignIn");
          break;
      }
    }
  },
  methods: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_16__["mapActions"])(["createPTTGroup", "setYardman"]),
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_16__["mapMutations"])(["SET_MEMBER_LIST", "SET_PARTICIPANT", "SET_DISPATCH_MEMBERS", "UPDATE_DISPATCH_MEMBERS"]),
    async loginWithAuthCode() {
      this.loginStatus = 3;
      _api_appServerApi__WEBPACK_IMPORTED_MODULE_42__["default"].loginWithAuthCode(1891929349, 66666).then(res => {
        const {
          userId,
          token,
          portrait
        } = res;
        this.firstTimeConnect = _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_44__["default"].connect(userId, token);
        Object(_ui_util_storageHelper__WEBPACK_IMPORTED_MODULE_43__["setItem"])("wfcUserId", userId);
        Object(_ui_util_storageHelper__WEBPACK_IMPORTED_MODULE_43__["setItem"])("wfcToken", token);
        Object(_ui_util_storageHelper__WEBPACK_IMPORTED_MODULE_43__["setItem"])("userPortrait", portrait);
      }).catch(err => {
        this.authCode = "";
        this.loginStatus = 0;
        this.$notify({
          title: "登录失败",
          text: err.message,
          type: "error"
        });
      });
    },
    onKickOut(id) {
      // allMembers将移除的人active设为false
      this.allMembers.forEach(member => {
        if (member.tencentUserId === id) {
          member.active = false;
        }
      });
    },
    /**
     * @周边调度画圆
     */
    drawCircle(info) {
      const coordinates = [info.longitude, info.latitude];
      this.$refs.map.drawCircle(coordinates, this.value);
    },
    /**
     * @隐藏所有弹框
     */
    onHideAllLayers() {
      this.railDispatchShow = false;
      this.isTrajectoryDialog = false;
      this.isElectronicFenceDialog = false;
      this.isElectronicFenceEditDialog = false;
    },
    /**
     * @mapsearch页面隐藏列表
     */
    hideAllList() {
      this.$refs.mapsearch.hideAllList();
    },
    /**
     * @编辑某条电子围栏
     * @param data
     */
    electronicFenceEditFn({
      data
    }) {
      console.log("编辑某条电子围栏", data);
      // this.map.clearMap();
      this.isElectronicFenceEditDialog = true;
      this.isElectronicFenceDialog = false;
      this.electronicFenceInfo = JSON.parse(JSON.stringify(data));
      this.electronicFenceInfo.time = [this.electronicFenceInfo.beginTime, this.electronicFenceInfo.endTime];
      // 显示可编辑围栏区域
      // this.showMapEditor(data);
    },
    /**
     * @是否有人在编辑范围内
     * @param event
     */
    setContain(event) {
      let isContain;
      if (this.mapType === "tianditu") {
        const {
          target,
          currentLnglats,
          currentRectangle
        } = event;
        // 判断坐标是否在圆圈内
        const pointInCircle = (point, center, radius) => {
          const distance = _turf_turf__WEBPACK_IMPORTED_MODULE_40__["distance"](_turf_turf__WEBPACK_IMPORTED_MODULE_40__["point"](point), _turf_turf__WEBPACK_IMPORTED_MODULE_40__["point"](center), {
            units: 'metres'
          });
          return distance <= radius;
        };
        // 判断坐标是否在多边形内
        const pointInPolygon = (point, polygon) => {
          const pt = _turf_turf__WEBPACK_IMPORTED_MODULE_40__["point"](point);
          const poly = _turf_turf__WEBPACK_IMPORTED_MODULE_40__["polygon"]([[...polygon, polygon[0]]]);
          return _turf_turf__WEBPACK_IMPORTED_MODULE_40__["booleanPointInPolygon"](pt, poly);
        };
        isContain = this.MarkerClusterer.dataOptions.filter(x => {
          if (target.type === "circle") {
            //圆形
            if (pointInCircle([x.longitude, x.latitude], [event.currentCenter.lng, event.currentCenter.lat], event.currentRadius)) {
              return x;
            }
          }
          T;
          if (target.type === "rectangle") {
            var _currentRectangle$get;
            //正方形
            if (pointInPolygon([x.longitude, x.latitude], (_currentRectangle$get = currentRectangle.getLngLats()[0]) === null || _currentRectangle$get === void 0 ? void 0 : _currentRectangle$get.map(e => [e.lng, e.lat]))) {
              return x;
            }
          }
          if (target.type === "polygon") {
            //多边形
            if (pointInPolygon([x.longitude, x.latitude], currentLnglats === null || currentLnglats === void 0 ? void 0 : currentLnglats.map(e => [e.lng, e.lat]))) {
              return x;
            }
          }
        });
      } else {
        isContain = this.cluster.dataOptions.filter(x => {
          if (event.contains(x.lnglat)) {
            return x;
          }
        });
      }
      if (isContain && isContain.length > 0) {
        const ids = isContain.map(x => x.id);
        if (this.type === 1) {
          this.stationEmployeesList = [];
          Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployees"])({
            pageIndex: 1,
            pageSize: 1000,
            ids,
            searchModel: "SelectedEmployees",
            deskTypes: this.deskTypesParam
          }).then(res => {
            this.setEmployeesInContain(res);
          });
        } else if (this.type === 5) {
          // 查范围内的智能设备详情，弹出调度框
          Object(_api_device_controller__WEBPACK_IMPORTED_MODULE_12__["getDevices"])({
            pageIndex: 1,
            pageSize: 1000,
            ids,
            searchModel: "Selected"
          }).then(res => {
            this.setDeviceInContain(res);
          });
        } else if (this.type === 2) {
          if (isContain[0].type === "employee") {
            // 弹出调度弹框
            this.showDispatchEmployees(isContain);
          }
        }
      }
    },
    setDeviceInContain(res) {
      console.log(res);
      const data = [...res].map(x => {
        return {
          ...x,
          type: "device"
        };
      });
      this.infoWindow.railTwo.position = undefined; // 隐藏弹框
      this.showDispatchDevices(data);
    },
    setEmployeesInContain(isContain) {
      this.stationEmployeesList = [...isContain].map(extData => {
        console.log(extData);
        const {
          idCardNo,
          contact,
          name,
          companyName,
          securityStationName
        } = extData;
        return {
          ...extData,
          isPhone: false,
          isIdCardNo: false,
          active: false,
          nameSlice: name.slice(-2),
          companyNameSlice: Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(companyName),
          securityStationNameSlice: Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(securityStationName),
          idCardNoHide: this.parseStringToStar(idCardNo),
          contactHide: this.parseStringToStar(contact)
        };
      }).filter(x => x !== undefined);
      this.stationEmployeesListFilter = this.stationEmployeesList;
      this.totalNum = 0;
      console.log(this.stationEmployeesList);
      if (this.stationEmployeesList.length > 0) {
        this.stationEmployeesList.forEach(item => {
          item.active = false;
        });
        this.allMembers = this.stationEmployeesList.filter(({
          dutyStatus
        }) => dutyStatus === "SignIn");
        this.stationEmployeesListType = "all";
        this.dutyCheckAll = false;
        this.railDispatchShow = true;
      }
    },
    showMapEditor({
      shapeType,
      shapedLocation
    }) {
      switch (shapeType) {
        case "Circle":
          // 圆
          this.showCircleEditor(shapedLocation);
          break;
        case "Polygon":
          this.showPolygonEditor(shapedLocation);
          break;
        case "Crib":
          this.showCribEditor(shapedLocation);
          break;
      }
    },
    showCircleEditor(shapedLocation) {
      console.log(shapedLocation);
      let that = this;
      const {
        geos
      } = shapedLocation;
      const center = [Number(geos[0].lon), Number(geos[0].lat)];
      const {
        radius
      } = shapedLocation;
      this.$refs.map.setCircleEditor({
        center,
        radius
      }).then(({
        figure,
        editor
      }) => {
        that.circleFigure = figure;
        that.circleEditorObject = editor;
        that.circleEditorObject.open();
      });
    },
    onCircleEditorChange(event) {
      console.log("on circle Editor Change", event);
      const {
        target
      } = event;
      const center = target.getCenter().toArray();
      const radius = target.getRadius();
      console.log(center, radius);
      this.$refs.electronicFenceEdit.setForm({
        shapeType: "Circle",
        shapedLocation: {
          radius,
          geos: [{
            lon: center[0],
            lat: center[1]
          }]
        }
      });
      this.setContain(target);
    },
    showPolygonEditor(shapedLocation) {
      let that = this;
      let list = shapedLocation.geos.map(item => [item.lon, item.lat]);
      this.$refs.map.setPolygonEditor(list).then(({
        figure,
        editor
      }) => {
        that.polygonFigure = figure;
        that.polygonEditor = editor;
        that.polygonEditor.open();
      });
    },
    onPolygonEditorChange(event) {
      console.log(event);
      const {
        target
      } = event;
      // const center = target.getCenter().toArray();
      // const radius = target.getRadius();
      const path = target.getPath();
      console.log(path);
      let coordinate = [];
      path.forEach(e => {
        coordinate.push({
          lon: e.lng,
          lat: e.lat
        });
      });
      this.$refs.electronicFenceEdit.setForm({
        shapeType: "Polygon",
        shapedLocation: {
          radius: "",
          geos: coordinate
        }
      });
      this.setContain(target);
    },
    onRectangleEditorChange(event) {
      const {
        target
      } = event;
      let attr = target.getOptions();
      let bounds = attr.bounds;
      let coordinate = [{
        lat: bounds.northEast.lat,
        lon: bounds.northEast.lng
      }, {
        lat: bounds.southWest.lat,
        lon: bounds.southWest.lng
      }];
      this.$refs.electronicFenceEdit.setForm({
        shapeType: "Crib",
        shapedLocation: {
          radius: "",
          geos: coordinate
        }
      });
      this.setContain(target);
    },
    showCribEditor(shapedLocation) {
      let that = this;
      let southWest = [shapedLocation.geos[1].lon, shapedLocation.geos[1].lat];
      let northEast = [shapedLocation.geos[0].lon, shapedLocation.geos[0].lat];
      this.$refs.map.setRectangleEditor({
        northEast,
        southWest
      }).then(({
        figure,
        editor
      }) => {
        that.rectangleFigure = figure;
        that.rectangleEditor = editor;
        that.rectangleEditor.open();
      });
    },
    openPeopleNumFn(id) {
      this.isElectronicFencePeople = true;
      Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployees"])({
        pageIndex: 1,
        pageSize: 5000,
        securityStationIds: [id + ""],
        searchModel: "SecurityStation",
        deskTypes: this.deskTypesParam
      }).then(res => {
        this.electronicFencePeopleList = res;
      });
    },
    electronicFencePeopleCancel() {
      this.isElectronicFencePeople = false;
    },
    //查看返回时显示电子围栏查询
    showElectronic() {
      this.isElectronicFenceDialog = true;
      this.isElectronicFenceEditDialog = false;
      this.isElectronicFencePeople = false;
    },
    addElectronic() {
      this.isElectronicFenceEditDialog = true;
      this.isElectronicFenceDialog = false;
      this.electronicFenceInfo = JSON.parse(JSON.stringify(this.info));
      this.electronicFenceInfo = {};
    },
    delElectronic(data) {
      console.log(data);
      let params = {
        id: data.data.id
      };
      Object(_api_security_station_rails_controller__WEBPACK_IMPORTED_MODULE_22__["deleteRail"])(params).then(res => {
        console.log("deleteRail", res);
        this.$refs["electronicFence"].getRails();
        this.$message({
          message: "删除成功",
          type: "success"
        });
      }).catch(err => {
        console.log(err);
      });
    },
    electronicFenceEditCancel() {
      this.isElectronicFenceEditDialog = false;
      this.cleanDrawFigure();
    },
    cleanDrawFigure() {
      if (this.circleEditorObject) {
        this.map.remove(this.circleFigure);
        this.circleEditorObject.close();
      }
      if (this.rectangleEditor) {
        this.map.remove(this.rectangleFigure);
        this.rectangleEditor.close();
      }
      if (this.polygonEditor) {
        this.map.remove(this.polygonFigure);
        this.polygonEditor.close();
      }
    },
    mapFn(obj, AMap) {
      this.map = obj;
      this.AMap = AMap;
    },
    openElectronic() {
      this.isElectronicFenceDialog = true;
      this.infoWindow.station.position = null;
    },
    //跳转考场监控
    clickExamVideo(info) {
      console.log('goToExamView', info);
      this.$router.push({
        path: '/multiVideo',
        query: {
          stationId: info.id
        }
      });
    },
    electronicFenceCancel() {
      this.isElectronicFenceDialog = false;
    },
    selectCk(index, item) {
      if (item.dutyStatusText === "离岗") return false;
      this.seMemberList(index, item);
    },
    selectDispatchDevice(index, item) {
      if (item.status === "Offline") return false;
      const member = this.dispatchMembers[index];
      this.UPDATE_DISPATCH_MEMBERS({
        index,
        member: {
          ...member,
          active: !item.active,
          name: member.dispatchNo,
          nameSlice: member.dispatchNo.slice(-3)
        }
      });
      const memberList = this.dispatchMembers.filter(x => x.active);
      this.SET_MEMBER_LIST(memberList);
      let checkedCount = memberList.length;
      this.deviceCheckAll = this.dispatchMembers.length === checkedCount;
      this.isIndeterminate = checkedCount > 0 && checkedCount < memberList.length;
      this.$forceUpdate();
    },
    seMemberList(index, item) {
      this.totalNum = 0;
      // item.active = !item.active;
      // this.memberList = this.stationEmployeesList.filter((x) => x.active);
      this.memberList = [];
      this.stationEmployeesList.forEach(employee => {
        if (employee.id === item.id) {
          employee.active = !employee.active;
          const member = this.allMembers.find(x => x.id === item.id);
          if (member) {
            member.active = employee.active;
          }
        }
        if (employee.active) {
          this.memberList.push(employee);
        }
      });
      let checkedCount = this.memberList.length;
      this.dutyCheckAll = checkedCount === this.stationEmployeesListFilter.length;
      this.isIndeterminate = checkedCount > 0 && checkedCount < this.stationEmployeesListFilter.length;
      this.allMembers.forEach(member => {
        if (item.id === member.id) {
          member.active = item.active;
        }
      });
      this.totalNum = this.memberList.length;
    },
    parseStringToStar(str) {
      return str.length > 2 ? str.substr(0, 2) + new Array(str.length - 2).join("*") + str.substr(-2) : str;
    },
    //地址周边搜索
    railFun(info, type) {
      console.log("railInfo", info);
      let iconUrl;
      if (type === "location") {
        const coordinates = info.location.split(",");
        info["longitude"] = coordinates[0];
        info["latitude"] = coordinates[1];
        info["type"] = "location";
      }
      if (type === "station") {
        iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/驻勤点.png */ "./src/assets/images/mapSearch/驻勤点.png");
        if (info.resourceTypes.length === 1 && info.resourceTypes[0] === "Population") {
          if (this.mapType === "tianditu") {
            iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社区警务.png */ "./src/assets/images/mapSearch/社区警务.png");
          } else {
            iconUrl = {
              image: __webpack_require__(/*! @/assets/images/mapSearch/社区警务.png */ "./src/assets/images/mapSearch/社区警务.png"),
              imageSize: [56, 56]
            };
          }
        } else {
          if (this.mapType === "tianditu") {
            var _info$stationTypes$;
            iconUrl = (_info$stationTypes$ = info.stationTypes[0]) === null || _info$stationTypes$ === void 0 ? void 0 : _info$stationTypes$.mapIcon;
          } else {
            var _info$stationTypes$2;
            iconUrl = {
              image: (_info$stationTypes$2 = info.stationTypes[0]) === null || _info$stationTypes$2 === void 0 ? void 0 : _info$stationTypes$2.mapIcon,
              imageSize: [56, 56]
            };
          }
        }
      }
      if (iconUrl) {
        this.markers = [{
          position: [Number(info.longitude), Number(info.latitude)],
          anchor: "bottom-center",
          icon: iconUrl,
          extData: info
        }];
      }
      this.rail = info;
      if (type === "station" || type === "location" || type === "employee") {
        this.showInfoByRowClick(info, "railTwo");
      } else {
        this.showInfoByRowClick(info, "rail");
      }
    },
    employeeRails() {
      let iconUrl;
      if (this.employee.dutyStatusText === "在岗") {
        iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png");
      } else {
        iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/离岗_保安员.png */ "./src/assets/images/mapSearch/离岗_保安员.png");
      }
      this.markers = [{
        position: [Number(this.employee.longitude), Number(this.employee.latitude)],
        anchor: "bottom-center",
        icon: iconUrl,
        extData: this.employee
      }];
      this.rail = this.employee;
      this.showInfoByRowClick(this.employee, "railTwo");
    },
    pttRails() {
      this.rail = this.info;
      this.showInfoByRowClick(this.info, "railTwo");
    },
    // 单个保安员指挥调度功能点击事件
    commandCk: lodash__WEBPACK_IMPORTED_MODULE_25___default.a.debounce(function (index, item) {
      console.log('click', this.type, item);
      if (this.dispatching) return;
      this.commandIndex = index;
      const {
        value
      } = item;
      if (value === "rail") {
        // 周边调度
        // 搜保安员列表点击后触发
        // 聚焦并弹框
        this.employeeRails();
      } else if (value === "character") {
        this.character(this.info);
      } else if (value === "video") {
        this.memberList = [];
        // 1V1 视频调度
        this.startVideoCall();
      } else if (value === "audio") {
        this.memberList = [];
        // 1V1 语音
        this.startAudioCall();
      } else if (value === "videoLocalMute") {
        // 视频上拉
        this.videoLocalMute();
      }
    }, 500),
    // 单个智能设备指挥调度功能点击事件
    deviceCommandCk: lodash__WEBPACK_IMPORTED_MODULE_25___default.a.debounce(function (index, item) {
      console.log('deviceCommandCk', this.type);
      if (this.dispatching) return;
      this.commandIndex = index;
      // 单个设备参会人员处理
      this.memberList = [this.info].map(item => {
        return {
          ...item,
          active: true,
          state: "CONNECTING"
        };
      });
      this.SET_DISPATCH_MEMBERS(this.memberList);
      const {
        value
      } = item;
      if (value === "rail") {
        // 周边调度
        this.pttRails();
      } else if (value === "video") {
        // 1V1 视频调度
        this.openMqttVideo();
      } else if (value === "audio") {
        // 1V1 语音
        this.openMqttAudio();
      } else if (value === "videoLocalMute") {
        // 拉取视频
        this.openMqttVideo(false, true);
      } else if (value === "ptt") {
        // 对讲
        this.openPPTCall(false);
      }
    }, 500),
    oneCall() {
      return new Promise(resolve => {
        this.memberList = [this.info];
        this.allMembers = [];
        this.memberList.forEach(member => {
          member.state = "CONNECTING";
          member.action = "";
        });
        this.callType = "video";
        this.yardmanType = "1";
        this.stream.video = true;
        this.stream.audio = true;
        resolve();
      });
    },
    oneTel() {
      return new Promise(resolve => {
        this.memberList = [this.info];
        this.allMembers = [];
        this.memberList.forEach(member => {
          member.state = "CONNECTING";
          member.action = "";
        });
        this.stream.video = false;
        this.stream.audio = true;
        this.yardmanType = "1";
        this.callType = "audio";
        resolve();
      });
    },
    oneMuteVideoCall() {
      return new Promise(resolve => {
        this.memberList = [this.info];
        this.allMembers = [];
        this.memberList.forEach(member => {
          member.state = "CONNECTING";
          member.action = "";
          // member.id = member.employeeId
        });
        this.stream.video = false;
        this.stream.audio = true;
        this.yardmanType = "2";
        this.callType = "video";
        resolve();
      });
    },
    // * 单人音频
    startAudioCall() {
      this.oneTel().then(() => {
        this.$bus.$emit("video-call");
      });
    },
    // 单人视频
    startVideoCall() {
      this.oneCall().then(() => {
        this.$bus.$emit("video-call");
      });
    },
    // * 视频上拉
    videoLocalMute(sosId) {
      this.oneMuteVideoCall().then(() => {
        this.$bus.$emit("video-call", sosId);
      });
    },
    videoCall() {
      console.log(this.info);
      this.startVideoDispatch();
    },
    trackCk(index) {
      this.trackIndex = index;
      console.log("trackCk", this.info);
      if (index === 0) {
        //轨迹查询
        this.isTrajectoryDialog = true;
        // this.onHideAllLayers();
        this.railDispatchShow = false;
        this.isElectronicFenceDialog = false;
        this.isElectronicFenceEditDialog = false;
        this.hideAllList();
        this.infoWindow.employee.position = null;
        // getEmployeesTrack(this.info).then(res=>{
        //   console.log
        // })
      }
    },
    trajectoryCancel() {
      this.isTrajectoryDialog = false;
      this.onHideAllLayers();
      this.infoWindow.employee.position = null;
      this.$refs.map.stopMove();
      this.clearMap();
    },
    onSetTrack(path) {
      console.log("onSetTrack", path);
      this.$refs.map.setMoveAnimation(path);
      // this.$refs.map.moveStart()
    },
    onMove(e) {
      const {
        index
      } = e;
      this.$refs.trajectory.setCurrentRow(index);
    },
    onRefresh(speedRatio) {
      this.$refs.map.stopMove();
      this.$refs.map.moveStart(speedRatio);
    },
    onStartMove(speedRatio) {
      this.speedRatio = speedRatio;
      if (this.moveStatus === "pause") {
        this.$refs.map.resumeMove();
      } else {
        this.$refs.map.moveStart(speedRatio);
      }
      this.moveStatus = "moving";
    },
    onPauseMove() {
      this.$refs.map.pauseMove();
      this.moveStatus = "pause";
    },
    onStopMove() {
      this.$refs.map.stopMove();
      this.moveStatus = "stop";
    },
    onBackStep() {
      this.$refs.map.backStep();
    },
    onNextStep() {
      this.$refs.map.nextStep();
    },
    onMapComplete() {
      // if (process.env.VUE_APP_ENV === "development") {
      //   this.appLoadingMask.close();
      // }
      let userInfoJson;
      if (Object.keys(this.sysUserInfo).length > 0) {
        userInfoJson = this.sysUserInfo;
        this.setCenterByCurrent(userInfoJson);
      } else {
        Object(_api_tenant_user_controller__WEBPACK_IMPORTED_MODULE_26__["getCurrentUser"])().then(response => {
          this.setCenterByCurrent(response);
        });
      }
    },
    /**
     * @地图视窗移动到指定中心点
     * @param userInfoJson
     */
    async setCenterByCurrent(userInfoJson) {
      if (userInfoJson) {
        const {
          orgLongitude,
          orgLatitude
        } = userInfoJson;
        if (orgLongitude && orgLatitude) {
          this.$refs.map.setCenter([Number(orgLongitude), Number(orgLatitude)]);
          this.appLoadingMask.close();
        } else {
          const company = await Object(_api_company_controller__WEBPACK_IMPORTED_MODULE_10__["getCompanyDetail"])(userInfoJson.organizationId);
          if (company) {
            const {
              longitude,
              latitude
            } = company;
            if (longitude && latitude) {
              this.$refs.map.setCenter([Number(longitude), Number(latitude)]);
              this.appLoadingMask.close();
            }
          }
        }
      }

      // 判断是否在调度范围内
      // this.$refs.map.locationInContain(longitude, latitude);
    },
    onClickMap(e) {
      console.log("onClickMap", e);
    },
    // 点聚合图标事件
    clickCluster({
      cluster,
      clusterData,
      lnglat
    }, map) {
      const {
        p
      } = cluster;
      if (clusterData.length > 1) {
        map.setZoomAndCenter(map.getZoom() + 4, lnglat);
      } else {
        console.log("clusterp", p);
        if (p.type === "employee") {
          // onClickEmployee
          this.onClickEmployee(p);
        } else if (p.type === "station") {
          this.onClickStation(p);
        } else if (p.type === "device") {
          this.onClickDevice(p);
        } else if (p.type === "company") {
          // clickCompany
          this.clickCompany(p, "company");
        }
      }
    },
    onClickMarker(e) {
      const {
        target
      } = e;
      console.log("onClickMarker", target.getPosition());
      console.log("onClickMarker", target.getExtData());
      this.info = {
        ...this.info,
        ...target.getExtData()
      };
      console.log("onClickMarker info", this.info);
      this.infoWindow[this.info.type].position = target.getPosition();
      if (this.info.type === "employee") {
        Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployeeDetail"])(this.info.id, this.deskTypes[0]).then(employeeDetail => {
          this.$set(this.info, "authenticatedStatusText", employeeDetail.authenticatedStatusText);
          this.$set(this.info, "certificateSituation", employeeDetail.certificateSituation);
        }).catch(err => {
          console.log(err);
        });
        this.employee = this.info;
      } else if (this.info.type === "SOS") {
        // this.infoWindow.SOS.position = undefined;
      }
      this.onHideAllLayers();
      this.hideAllList();
      this.updateMarkerIcon(this.info);
    },
    updateMarkerIcon(data) {
      const {
        type,
        id
      } = data;
      if (!type) return;
      if (type === "location") {
        this.markers.forEach(marker => {
          if (marker.extData.id === id) {
            marker.icon = __webpack_require__(/*! @/assets/images/map/icons/mark_r.png */ "./src/assets/images/map/icons/mark_r.png");
            this.showInfoByRowClick(data, "location");
          } else {
            marker.icon = __webpack_require__(/*! @/assets/images/map/icons/mark_b.png */ "./src/assets/images/map/icons/mark_b.png");
          }
        });
      }
    },
    lnglatTransform(data, type = 'toWGS84') {
      // const { longitude, latitude } = data;
      // if (longitude && latitude) {
      //   if(type==='toWGS84'){
      //     const result = gcoord.transform(
      //       [longitude, latitude], // 经纬度坐标
      //       gcoord.GCJ02, // 当前坐标系
      //       gcoord.WGS84 // 目标坐标系
      //     );
      //     data.longitude = result[0];
      //     data.latitude = result[1];
      //   }
      //   if(type==='toGCJ02'){
      //     const result = gcoord.transform(
      //       [longitude, latitude], // 经纬度坐标
      //       gcoord.WGS84, // 当前坐标系
      //       gcoord.GCJ02, // 目标坐标系
      //     );
      //     data.longitude = result[0];
      //     data.latitude = result[1];
      //   }
      // }
      return data;
    },
    //显示弹窗
    showInfoByRowClick(data, type) {
      this.info = {
        ...{},
        ...data
      };
      console.log("showInfoByRowClick", type, this.info);
      this.$refs[type].$el.style.display = "block";
      if (type === "location") {
        //查地址
        if (this.mapType === "tianditu") {
          const lnglat = {
            lng: Number(location[0]),
            lat: Number(location[1])
          };
          const winInfo = new T.InfoWindow(this.$refs[type].$el, {
            offset: new T.Point(-14, -18)
          });
          this.map.openInfoWindow(winInfo, lnglat); //开启信息窗口
        } else {
          const location = data.location.split(",");
          this.infoWindow[type].position = [Number(location[0]), Number(location[1])];
          //   this.$refs.map.setZoomAndCenter(12, this.infoWindow[type].position);
        }
      } else if (type === "employee" || type === "station" || type === "project") {
        //查保安员或者驻勤点或者公司
        if (this.mapType === "tianditu") {
          const lnglat = {
            lng: Number(data.longitude),
            lat: Number(data.latitude)
          };
          const winInfo = new T.InfoWindow(this.$refs[type].$el, {
            offset: new T.Point(-14, -20)
          });
          this.map.openInfoWindow(winInfo, lnglat); //开启信息窗口
          const _this = this;
          setTimeout(function () {
            _this.map.panTo(new T.LngLat(Number(data.longitude), Number(data.latitude)));
          }, 500);
          this.MarkerClusterer = {
            ...this.this.MarkerClusterer,
            dataOptions: [{
              ...data
            }]
          };
        } else {
          const coordinates = [data.longitude, data.latitude + 0.038];
          this.infoWindow[type].position = [Number(data.longitude), Number(data.latitude)];
          //   this.$refs.map.setZoomAndCenter(12, coordinates);
        }
      } else if (["device", "company", "stationEmployees" /*查驻勤点保安员*/, "railSecurity", "exam" /*考场*/, "examSite"].includes(type)) {
        if (this.mapType === "tianditu") {
          const lnglat = {
            lng: Number(data.longitude),
            lat: Number(data.latitude)
          };
          const winInfo = new T.InfoWindow(this.$refs[type].$el, {
            offset: new T.Point(-14, -20)
          });
          this.map.openInfoWindow(winInfo, lnglat); //开启信息窗口
          const _this = this;
          setTimeout(function () {
            _this.map.panTo(new T.LngLat(Number(data.longitude), Number(data.latitude)));
          }, 500);
          this.MarkerClusterer = {
            ...this.this.MarkerClusterer,
            dataOptions: [{
              ...data
            }]
          };
        } else {
          this.infoWindow[type].position = [Number(data.longitude), Number(data.latitude)];
          //   this.$refs.map.setZoomAndCenter(12, this.infoWindow[type].position);
        }
      } else if (type === "companyStations") {
        //查内保单位驻勤点
        this.info.type = type;
        this.markers = [{
          position: this.infoWindow[type].position,
          anchor: "bottom-center",
          icon: __webpack_require__(/*! @/assets/images/mapSearch/内保单位公司.png */ "./src/assets/images/mapSearch/内保单位公司.png"),
          extData: {
            ...data,
            type
          }
        }];
        if (this.mapType === "tianditu") {
          const lnglat = {
            lng: data.longitude,
            lat: data.latitude
          };
          const winInfo = new T.InfoWindow(this.$refs[type].$el, {
            offset: new T.Point(-14, -20)
          });
          this.map.openInfoWindow(winInfo, lnglat); //开启信息窗口
          this.MarkerClusterer = {
            ...this.this.MarkerClusterer,
            dataOptions: [{
              ...data
            }]
          };
        } else {
          this.infoWindow[type].position = [Number(data.longitude), Number(data.latitude)];
          //   this.$refs.map.setZoomAndCenter(12, this.infoWindow[type].position);
        }
      } else if (type === "rail" || type === "railTwo") {
        if (this.info.type === "device") {
          this.radio = 5;
        }
        this.value = 0;
        if (this.mapType === "tianditu") {
          const lnglat = {
            lng: Number(data.longitude),
            lat: Number(data.latitude)
          };
          const winInfo = new T.InfoWindow(this.$refs[type].$el, {
            offset: new T.Point(-14, -20)
          });
          this.map.openInfoWindow(winInfo, lnglat); //开启信息窗口
          this.MarkerClusterer = {
            ...this.this.MarkerClusterer,
            dataOptions: [{
              ...data
            }]
          };
        } else {
          this.infoWindow[type].position = [Number(data.longitude), Number(data.latitude)];
          //   this.$refs.map.setZoomAndCenter(12, this.infoWindow[type].position);
        }
      }
      if (this.mapType !== "tianditu") {
        this.$refs.map.setCenter(this.infoWindow[type].position);
      }
    },
    /**
     * 渲染聚合图标样式
     * @param context
     */
    renderClusterMarker(context, {
      Pixel
    }) {
      const div = document.createElement("div");
      const bgColor = "#0E71FF";
      const fontColor = "white";
      div.style.backgroundColor = bgColor;
      const size = 80;
      div.style.width = div.style.height = size + "px";
      div.style.borderRadius = size / 2 + "px";
      div.innerHTML = context.count;
      div.style.lineHeight = size + "px";
      div.style.color = fontColor;
      div.style.fontSize = "22px";
      div.style.textAlign = "center";
      context.marker.setOffset(new Pixel(-size / 2, -size));
      context.marker.setContent(div);
    },
    /**
     * 聚合下单个人员图标渲染
     * @param marker
     * @param data
     */
    renderEmployeeMarker({
      marker,
      data
    }, {
      Pixel
    }) {
      const [item] = data;
      let iconUrl;
      const {
        dutyStatus,
        rts
      } = item;
      console.log("dutyStatus", dutyStatus);
      console.log("rts", rts);
      if (dutyStatus === "SignIn") {
        if (this.platform === "3" && this.sysUserInfo.orgInstitutional === "0201") {
          var _this$actEmployeeType4;
          //承办方图标
          iconUrl = ((_this$actEmployeeType4 = this.actEmployeeTypes.find(el => el.code === item.stationType)) === null || _this$actEmployeeType4 === void 0 ? void 0 : _this$actEmployeeType4.personMapIcon) || __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png");
        } else if (rts.includes("Proprietor")) {
          iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/保卫管理员.png */ "./src/assets/images/mapSearch/保卫管理员.png");
        } else if (rts.includes("Security") && !rts.includes("Population")) {
          iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png");
        } else if (rts.includes("Population") && !rts.includes("Security")) {
          iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社会力量.png */ "./src/assets/images/mapSearch/社会力量.png");
        } else if (rts.includes("Security") && rts.includes("Population")) {
          iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/兼职社会力量(部分保安员).png */ "./src/assets/images/mapSearch/兼职社会力量(部分保安员).png");
        }
        console.log("employeeCluster", item);
      } else {
        if (this.platform === "3" && this.sysUserInfo.orgInstitutional === "0201") {
          var _this$actEmployeeType5;
          //承办方图标
          iconUrl = ((_this$actEmployeeType5 = this.actEmployeeTypes.find(el => el.code === item.stationType)) === null || _this$actEmployeeType5 === void 0 ? void 0 : _this$actEmployeeType5.personOfflineMapIcon) || __webpack_require__(/*! @/assets/images/mapSearch/离岗_保安员.png */ "./src/assets/images/mapSearch/离岗_保安员.png");
        } else {
          iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/离岗_保安员.png */ "./src/assets/images/mapSearch/离岗_保安员.png");
        }
      }
      marker.setOffset(new Pixel(-28, -56));
      marker.setIcon(iconUrl);
      // marker.setAnchor("bottom-center");
    },
    /**
     * 聚合下单驻勤点图标渲染
     * @param marker
     * @param data
     * @param Icon
     */
    renderStationMarker({
      marker,
      data
    }, {
      Pixel,
      Icon
    }) {
      const [{
        rts,
        stationTypes
      }] = data;
      let mapIconUrl;
      if (this.platform === "3" && this.sysUserInfo.orgInstitutional === "0201") {
        var _this$actEmployeeType6;
        //承办方图标
        mapIconUrl = ((_this$actEmployeeType6 = this.actEmployeeTypes.find(el => el.code === stationTypes[0])) === null || _this$actEmployeeType6 === void 0 ? void 0 : _this$actEmployeeType6.mapIcon) || __webpack_require__(/*! @/assets/images/mapSearch/马拉松岗点.png */ "./src/assets/images/mapSearch/马拉松岗点.png");
      } else {
        if (stationTypes && stationTypes.length > 0) {
          //有驻勤点类型
          const stationType = this.stationTypes.find(t => t.code === stationTypes[0]);
          if (stationType && stationType.mapIcon) {
            mapIconUrl = stationType.mapIcon;
          } else {
            mapIconUrl = __webpack_require__(/*! @/assets/images/mapSearch/驻勤点.png */ "./src/assets/images/mapSearch/驻勤点.png");
          }
          // const { mapIcon } = this.stationTypes.find((t) => t.code === stationTypes[0]);

          if (rts.length === 1 && rts[0] === "Population") {
            mapIconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社区警务.png */ "./src/assets/images/mapSearch/社区警务.png");
          }
        } else {
          //没有驻勤点类型
          mapIconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社区警务.png */ "./src/assets/images/mapSearch/社区警务.png");
        }
      }
      const icon = new Icon({
        image: mapIconUrl,
        imageSize: [56, 56]
      });
      marker.setOffset(new Pixel(-28, -56));
      marker.setIcon(icon); // imageSize: [56, 56],
      // marker.setAnchor("bottom-center");
    },
    renderDeviceMarker({
      marker
    }, {
      Pixel
    }) {
      // marker.setAnchor("bottom-center");
      marker.setIcon(__webpack_require__(/*! @/assets/images/mapSearch/智能设备.png */ "./src/assets/images/mapSearch/智能设备.png"));
      marker.setOffset(new Pixel(-28, -56));
    },
    renderProprietorMarker({
      marker
    }, {
      Pixel
    }) {
      // marker.setAnchor("bottom-center");
      marker.setIcon(__webpack_require__(/*! @/assets/images/mapSearch/内保单位公司.png */ "./src/assets/images/mapSearch/内保单位公司.png"));
      marker.setOffset(new Pixel(-28, -56));
    },
    /**
     * 搜索后地图撒点
     * @param type 搜索类型
     * @param data 点位数据
     */
    onMapSearch({
      type,
      data,
      keywords
    }) {
      // this.cluster = {};
      if (type === 4) {
        //搜索地址
        console.log("on search place", data);
        this.markers = data.map((poi, index) => {
          const {
            location
          } = poi;
          if (location && location.length > 0) {
            const coordinates = location.split(",");
            console.log(coordinates);
            return {
              position: [Number(coordinates[0]), Number(coordinates[1])],
              anchor: "bottom-center",
              icon: __webpack_require__(/*! @/assets/images/map/icons/mark_b.png */ "./src/assets/images/map/icons/mark_b.png"),
              label: {
                content: index + 1,
                direction: "center",
                offset: [0, 0]
              },
              panTo: true,
              extData: {
                longitude: Number(coordinates[0]),
                latitude: Number(coordinates[1]),
                ...poi
              }
            };
          }
        }).filter(x => x !== undefined);
        console.log("markers", this.markers);
      } else {
        //搜索人员
        this.markers = [];
        let points = [];
        data.forEach(point => {
          const {
            longitude,
            latitude,
            dutyStatus
          } = point;
          if (longitude && latitude && dutyStatus !== "None") {
            points.push({
              lnglat: [Number(point.longitude), Number(point.latitude)],
              extData: point,
              ...point
            });
          }
        });
        console.log("searchEmployees", type, points);
        if (points.length > 0) {
          if (this.mapType === "tianditu") {
            this.clearMap();
            this.addPolylineEntity();
            const renderMarkerIcon = item => {
              let iconUrl;
              if (type === 1) {
                // 人员
                const {
                  dutyStatus,
                  rts
                } = item;
                if (dutyStatus === "SignIn") {
                  if (rts.includes("Proprietor")) {
                    iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/保卫管理员.png */ "./src/assets/images/mapSearch/保卫管理员.png");
                  } else if (rts.includes("Security") && !rts.includes("Population")) {
                    iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png");
                  } else if (rts.includes("Population") && !rts.includes("Security")) {
                    iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社会力量.png */ "./src/assets/images/mapSearch/社会力量.png");
                  } else if (rts.includes("Security") && rts.includes("Population")) {
                    iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/兼职社会力量(部分保安员).png */ "./src/assets/images/mapSearch/兼职社会力量(部分保安员).png");
                  }
                } else {
                  iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/离岗_保安员.png */ "./src/assets/images/mapSearch/离岗_保安员.png");
                }
              } else if (type === 2) {
                // 驻勤点
                const {
                  rts,
                  stationTypes
                } = item;
                if (stationTypes && stationTypes.length > 0) {
                  //有驻勤点类型
                  const stationType = this.stationTypes.find(t => t.code === stationTypes[0]);
                  if (stationType && stationType.mapIcon) {
                    iconUrl = stationType.mapIcon;
                  } else {
                    iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/驻勤点.png */ "./src/assets/images/mapSearch/驻勤点.png");
                  }
                  if (rts.length === 1 && rts[0] === "Population") {
                    iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社区警务.png */ "./src/assets/images/mapSearch/社区警务.png");
                  }
                } else {
                  //没有驻勤点类型
                  iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社区警务.png */ "./src/assets/images/mapSearch/社区警务.png");
                }
              } else if (type === 3) {
                // 内保单位
                iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/内保单位公司.png */ "./src/assets/images/mapSearch/内保单位公司.png");
              } else if (type === 5) {
                // 智能设备
                iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/智能设备.png */ "./src/assets/images/mapSearch/智能设备.png");
              }
              const icon = new T.Icon({
                iconUrl: iconUrl,
                iconSize: new T.Point(32, 42),
                // 图标可视区域的大小
                iconAnchor: new T.Point(30, 30) // 图标的定位锚点
              });
              return icon;
            };
            if (this.MarkerClusterer && this.MarkerClusterer.object) {
              // 很重要！！！点聚合它不是一个普通的Marker对象
              this.MarkerClusterer.object.clearMarkers();
            }
            if (keywords) {
              return;
            }
            let markers = new Array();
            for (let i = 0; i < points.length; i++) {
              const {
                longitude,
                latitude
              } = this.lnglatTransform(points[i]);
              const icons = renderMarkerIcon(points[i]);
              const marker = new T.Marker(new T.LngLat(longitude, latitude), {
                icon: icons,
                title: i
              });
              markers.push(marker);
              const _this = this;
              //给每个marker点添加监听点击事件打开信息窗口
              marker.addEventListener("click", function (e) {
                _this.clickCluster({
                  cluster: {
                    p: {
                      ...points[i]
                    }
                  },
                  clusterData: []
                });
              });
            }
            this.MarkerClusterer = {
              dataOptions: [...points],
              object: new T.MarkerClusterer(this.map, {
                markers: markers,
                styles: [{
                  url: "http://api.tianditu.gov.cn/img/map/cluster/cluster0.png",
                  size: [100, 100],
                  //图片大小
                  // offset:new T.Point(-15, -13), //显示图片的偏移量
                  textColor: "#fff",
                  //显示数字的颜色
                  textSize: 22,
                  //显示文字的大小
                  range: [0, 10000]
                }]
              })
            };
            this.MarkerClusterer.object.setMaxZoom(16);
            // Clusterer.setStyles([
            //   {
            //     url: 'http://api.tianditu.gov.cn/img/map/cluster/cluster0.png',
            //     size:[100, 100], //图片大小
            //     // offset:new T.Point(-15, -13), //显示图片的偏移量
            //     textColor: '#fff', //显示数字的颜色
            //     textSize: 22,//显示文字的大小
            //     range:[0, 10000],
            //   }
            // ]);
            // Clusterer.clearMarkers(markers);
          } else {
            // const count = this.markers.length;
            this.cluster = {
              dataOptions: [...points],
              MarkerClusterOptions: {
                maxZoom: 18,
                gridSize: 60,
                // 聚合计算时网格的像素大小，默认60
                clusterByZoomChange: true,
                renderClusterMarker: context => this.renderClusterMarker(context, this.AMap),
                renderMarker: ({
                  marker,
                  data
                }) => {
                  if (type === 1) {
                    // 人员
                    this.renderEmployeeMarker({
                      marker,
                      data
                    }, this.AMap);
                  } else if (type === 2) {
                    // 驻勤点
                    this.renderStationMarker({
                      marker,
                      data
                    }, this.AMap);
                  } else if (type === 3) {
                    // 内保单位
                    this.renderProprietorMarker({
                      marker
                    }, this.AMap);
                  } else if (type === 5) {
                    // 智能设备
                    this.renderDeviceMarker({
                      marker
                    }, this.AMap);
                  }
                }
              }
            };
          }
        }
      }
    },
    //地址搜索
    onPlaceSearch(data) {
      // console.log("onPlaceSearch", data);
      if (!data) return;
      this.markers = data.map((poi, index) => {
        const {
          location
        } = poi;
        if (location && location.length > 0) {
          console.log(location);
          const coordinates = location.split(",");
          poi["type"] = "location";
          poi["addressSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(poi.address); //多出部分省略号显示
          return {
            position: [Number(coordinates[0]), Number(coordinates[1])],
            anchor: "bottom-center",
            icon: __webpack_require__(/*! @/assets/images/map/icons/mark_b.png */ "./src/assets/images/map/icons/mark_b.png"),
            label: {
              content: index + 1,
              direction: "center",
              offset: [0, 0]
            },
            extData: poi
          };
        }
      }).filter(x => x !== undefined);
      console.log("markers", this.markers);
    },
    changeStationIsPhone(index) {
      let list = [...this.stationEmployeesList];
      list[index].isPhone = !list[index].isPhone;
      this.stationEmployeesList = [...list];
    },
    changeStationIsIdCardNo(index) {
      let list = [...this.stationEmployeesList];
      list[index].isIdCardNo = !list[index].isIdCardNo;
      this.stationEmployeesList = [...list];
    },
    //周边调度选择保安员计算人数
    changesStationEmployeesActive(index) {
      let that = this;
      let list = JSON.parse(JSON.stringify(that.stationEmployeesList));
      list[index].active = !list[index].active;
      this.$nextTick(() => {
        that.stationEmployeesList = [];
        that.stationEmployeesList = list;
        this.memberList = this.stationEmployeesList.filter(item => item.active);
        this.totalNum = this.memberList.length;
      });
    },
    async railCk() {
      if (this.value === 0) {
        this.$message({
          message: "请选择范围",
          type: "warning"
        });
        return;
      }
      console.log("rail", this.rail);
      const tData = this.lnglatTransform({
        latitude: this.rail.latitude,
        longitude: this.rail.longitude
      }, 'toGCJ02');
      let params = {
        pageIndex: 1,
        pageSize: 1000,
        longitude: tData.longitude,
        latitude: tData.latitude,
        distance: this.value,
        searchModel: "",
        deskTypes: this.deskTypesParam
      };
      if (this.radio === 1) {
        // *周边调度查询保安员
        params.searchModel = "Geo";
        const stationEmployees = await Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployees"])(params);
        this.showDispatchEmployees(stationEmployees);
      } else if (this.radio === 2) {
        // *周边调度查询驻勤点并撒点
        params.searchModel = "Location";
        const res = await Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_17__["getStations"])(params);
        const data = [...res].map(x => {
          x.type = "station";
          return x;
        });
        this.onMapSearch({
          type: 2,
          data
        }); // 撒点
        this.infoWindow.railTwo.position = undefined; // 隐藏弹框
      } else if (this.radio === 5) {
        // *周边调度查询智能设备
        params.searchModel = "Geo";
        const devices = await Object(_api_device_controller__WEBPACK_IMPORTED_MODULE_12__["getDevices"])(params);
        const data = [...devices].map(x => {
          x.type = "device";
          return x;
        });
        this.onMapSearch({
          type: 5,
          data
        }); // 撒点
        this.infoWindow.railTwo.position = undefined; // 隐藏弹框
        this.showDispatchDevices(data);
      }
    },
    /**
     * * 周边调度查询保安员
     * @param stationEmployees
     */
    showDispatchEmployees(stationEmployees) {
      console.log("stationEmployees:", stationEmployees);
      this.stationEmployeesList = [...stationEmployees].map(item => {
        const {
          name,
          idCardNo,
          contact,
          companyName,
          securityStationName
        } = item;
        return {
          ...item,
          active: false,
          nameSlice: name ? item.name.slice(-2) : "",
          idCardNoHide: idCardNo ? this.parseStringToStar(idCardNo) : "",
          contactHide: contact ? this.parseStringToStar(contact) : "",
          companyNameSlice: companyName ? Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(companyName) : "",
          securityStationNameSlice: securityStationName ? Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(securityStationName) : "",
          type: "employee",
          isPhone: false,
          isIdCardNo: false
        };
      });
      this.stationEmployeesListFilter = this.stationEmployeesList;
      this.allMembers = this.stationEmployeesList.filter(({
        dutyStatus
      }) => dutyStatus === "SignIn");
      this.totalNum = 0;
      this.stationEmployeesList.forEach(item => {
        item.active = false;
      });
      this.stationEmployeesListFilter = this.stationEmployeesList;
      this.stationEmployeesListType = "all";
      this.dutyCheckAll = false;
      this.railDispatchShow = true;
    },
    showDispatchDevices(devices) {
      console.log("devices:", devices);
      const memberList = devices.map(item => {
        return {
          ...item,
          active: false,
          name: item.dispatchNo,
          nameSlice: item.dispatchNo.slice(-3)
        };
      });
      this.SET_DISPATCH_MEMBERS(memberList);
      this.railDispatchDeviceShow = true;
    },
    onClickRail(rail) {
      this.rail = rail;
      // latitude
      // longitude
      console.log("===========", rail);
      rail["type"] = "rail";
      this.markers = [{
        position: [Number(rail.longitude), Number(rail.latitude)],
        anchor: "bottom-center",
        extData: rail,
        icon: this.mapType === "tianditu" ? __webpack_require__(/*! @/assets/images/mapSearch/警情打点.png */ "./src/assets/images/mapSearch/警情打点.png") : {
          image: __webpack_require__(/*! @/assets/images/mapSearch/警情打点.png */ "./src/assets/images/mapSearch/警情打点.png"),
          imageSize: [56, 56]
        }
      }];
      this.showInfoByRowClick(rail, "rail");
    },
    // 搜保安员列表点击后触发
    onClickEmployee(employee, isBack) {
      // 聚焦并弹框
      Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployeeDetail"])(employee.id, this.deskTypes[0]).then(employeeDetail => {
        console.log("onClickEmployee", employeeDetail);
        this.employee = employeeDetail;
        let iconUrl;
        if (employeeDetail.dutyStatusText === "在岗") {
          if (this.platform === "3" && this.sysUserInfo.orgInstitutional === "0201") {
            var _this$actEmployeeType7;
            //承办方图标
            iconUrl = ((_this$actEmployeeType7 = this.actEmployeeTypes.find(el => el.code === employeeDetail.stationType)) === null || _this$actEmployeeType7 === void 0 ? void 0 : _this$actEmployeeType7.personMapIcon) || __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png");
          } else {
            if (employeeDetail.resourceTypes.includes("Proprietor")) {
              iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/保卫管理员.png */ "./src/assets/images/mapSearch/保卫管理员.png");
              employeeDetail["proprietorCompanyId"] = employeeDetail.organizationId;
              employeeDetail["proprietorCompanyName"] = employeeDetail.companyName;
            } else if (employeeDetail.resourceTypes.includes("Security") && !employeeDetail.resourceTypes.includes("Population")) {
              iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png");
            } else if (employeeDetail.resourceTypes.includes("Population") && !employeeDetail.resourceTypes.includes("Security")) {
              iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社会力量.png */ "./src/assets/images/mapSearch/社会力量.png");
            } else if (employeeDetail.resourceTypes.includes("Security") && employeeDetail.resourceTypes.includes("Population")) {
              iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/兼职社会力量(部分保安员).png */ "./src/assets/images/mapSearch/兼职社会力量(部分保安员).png");
            }
          }
        } else {
          if (this.platform === "3" && this.sysUserInfo.orgInstitutional === "0201") {
            var _this$actEmployeeType8;
            //承办方图标
            iconUrl = ((_this$actEmployeeType8 = this.actEmployeeTypes.find(el => el.code === employeeDetail.stationType)) === null || _this$actEmployeeType8 === void 0 ? void 0 : _this$actEmployeeType8.personOfflineMapIcon) || __webpack_require__(/*! @/assets/images/mapSearch/离岗_保安员.png */ "./src/assets/images/mapSearch/离岗_保安员.png");
          } else {
            iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/离岗_保安员.png */ "./src/assets/images/mapSearch/离岗_保安员.png");
          }
        }
        employeeDetail["nameSlice"] = employeeDetail.name.slice(-2);
        employeeDetail["idCardNoHide"] = this.parseStringToStar(employeeDetail.idCardNo);
        employeeDetail["contactHide"] = this.parseStringToStar(employeeDetail.contact);
        employeeDetail["type"] = "employee";
        employeeDetail["companyNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(employeeDetail.companyName); //多出部分省略号显示
        employeeDetail["proprietorCompanyNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(employeeDetail.proprietorCompanyName); //多出部分省略号显示
        employeeDetail["securityStationNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(employeeDetail.securityStationName); //多出部分省略号显示
        if (isBack === "isBack") {
          if (this.mapType === "tianditu") {
            this.clearMap();
          }
          //如果是返回
          this.markers = [{
            position: [Number(employeeDetail.longitude), Number(employeeDetail.latitude)],
            anchor: "bottom-center",
            icon: iconUrl,
            extData: employeeDetail
          }];
        }
        // this.cluster.dataOptions = [];
        // this.markers = [
        //   {
        //     position: [Number(employeeDetail.longitude), Number(employeeDetail.latitude)],
        //     anchor: "bottom-center",
        //     icon: iconUrl,
        //     extData: employeeDetail,
        //   },
        // ];
        this.showInfoByRowClick(this.lnglatTransform(employeeDetail), "employee");
      }).catch(err => {
        console.log(err);
      });
    },
    async onClickProject(project) {
      console.log("onClickProject", project);
      let iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/驻勤点.png */ "./src/assets/images/mapSearch/驻勤点.png");
      const extData = {
        type: "project",
        ...project
      };
      this.markers = [{
        position: [Number(project.longitude), Number(project.latitude)],
        anchor: "bottom-center",
        icon: iconUrl,
        extData
      }];
      if (this.mapType === "tianditu") {
        this.clearMap();
      }
      this.showInfoByRowClick(extData, "project");
    },
    // 搜驻勤点后触发
    async onClickStation(station, type) {
      // 聚焦并弹框
      console.log("onClickStation", station);
      console.log("type", type);
      this.showMonitor = station.hasVideo;
      if (type === "employee") {
        this.onClickEmployee(this.employee);
      } else {
        let StationDetail = await Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_17__["getStationDetail"])(station.id);
        StationDetail["type"] = "station";
        StationDetail["returnWin"] = station.returnWin;
        StationDetail["returnDetail"] = station.returnDetail;
        StationDetail["companyNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(StationDetail.companyName); //多出部分省略号显示
        StationDetail["securityStationNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(StationDetail.name); //多出部分省略号显示
        StationDetail["superviseDepartNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(StationDetail.superviseDepartName); //多出部分省略号显示
        StationDetail["addressSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(StationDetail.address); //多出部分省略号显示
        console.log("station:", StationDetail);
        let mapIconUrl;
        if (this.platform === "3" && this.sysUserInfo.orgInstitutional === "0201") {
          var _this$actEmployeeType9;
          mapIconUrl = ((_this$actEmployeeType9 = this.actEmployeeTypes.find(el => {
            var _StationDetail$statio;
            return el.code === ((_StationDetail$statio = StationDetail.stationTypes[0]) === null || _StationDetail$statio === void 0 ? void 0 : _StationDetail$statio.code);
          })) === null || _this$actEmployeeType9 === void 0 ? void 0 : _this$actEmployeeType9.mapIcon) || __webpack_require__(/*! @/assets/images/mapSearch/马拉松岗点.png */ "./src/assets/images/mapSearch/马拉松岗点.png");
        } else {
          if (StationDetail.stationTypes && StationDetail.stationTypes.length > 0) {
            //有驻勤点类型
            mapIconUrl = StationDetail.stationTypes[0].mapIcon;
            if (StationDetail.resourceTypes.length === 1 && StationDetail.resourceTypes[0] === "Population") {
              mapIconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社区警务.png */ "./src/assets/images/mapSearch/社区警务.png");
            }
          } else {
            //没有驻勤点类型，说明是社区警务
            mapIconUrl = __webpack_require__(/*! @/assets/images/mapSearch/社区警务.png */ "./src/assets/images/mapSearch/社区警务.png");
          }
        }
        if (!mapIconUrl) {
          mapIconUrl = __webpack_require__(/*! @/assets/images/mapSearch/驻勤点.png */ "./src/assets/images/mapSearch/驻勤点.png");
        }
        this.info = StationDetail;
        if (type === "station") {
          if (this.mapType === "tianditu") {
            this.clearMap();
          }
          //返回驻勤点
          this.markers = [{
            position: [Number(StationDetail.longitude), Number(StationDetail.latitude)],
            anchor: "bottom-center",
            // icon: require("@/assets/images/mapSearch/驻勤点.png"),
            icon: this.mapType === "tianditu" ? mapIconUrl : {
              image: mapIconUrl,
              imageSize: [56, 56]
            },
            extData: StationDetail
          }];
        }
        // this.cluster.dataOptions = [];
        // this.markers = [
        //   {
        //     position: [Number(StationDetail.longitude), Number(StationDetail.latitude)],
        //     anchor: "bottom-center",
        //     // icon: require("@/assets/images/mapSearch/驻勤点.png"),
        //     icon: {
        //       image: mapIconUrl,
        //       imageSize: [56, 56],
        //     },
        //     extData: StationDetail,
        //   },
        // ];
        this.showInfoByRowClick(this.lnglatTransform(StationDetail), "station");
      }
    },
    // 搜设备后触发
    async onClickDevice(device) {
      // 聚焦并弹框
      Object(_api_device_controller__WEBPACK_IMPORTED_MODULE_12__["getDeviceDetail"])(device.id).then(deviceDetail => {
        console.log("onClickDevice", deviceDetail);
        const extData = {
          ...deviceDetail,
          type: "device",
          name: deviceDetail.dispatchNo
        };
        let iconUrl = __webpack_require__(/*! @/assets/images/mapSearch/智能设备.png */ "./src/assets/images/mapSearch/智能设备.png");
        this.cluster.dataOptions = [];
        this.markers = [{
          position: [Number(deviceDetail.longitude), Number(deviceDetail.latitude)],
          anchor: "bottom-center",
          icon: iconUrl,
          extData
        }];
        this.showInfoByRowClick(extData, "device");
      }).catch(err => {
        console.log(err);
      });
    },
    // 搜地点列表点击后触发
    onClickPoi(poi) {
      console.log("on click poi point: ", poi);
      this.$refs["location"].$el.style.display = "block";
      // 聚焦并弹框
      let tempMarker;
      this.markers.forEach(marker => {
        if (marker.extData.id === poi.id) {
          marker.icon = __webpack_require__(/*! @/assets/images/map/icons/mark_r.png */ "./src/assets/images/map/icons/mark_r.png");
          this.showInfoByRowClick(poi, "location");
          tempMarker = marker;
        } else {
          // marker.icon = require("@/assets/images/map/icons/mark_b.png");
        }
      });
      this.markers = [];
      this.markers.push(tempMarker);
    },
    // * 点考场
    async onClickExam(info, infoType) {
      console.log("on click exam info: ", info);
      console.log("on click exam type: ", infoType);
      let examId = info.id;
      if (infoType === "examSite") {
        examId = info.returnDetail.id;
      }
      const exam = await Object(_api_exam_site_room_controller__WEBPACK_IMPORTED_MODULE_32__["getExamSiteRoomDetail"])(examId);
      exam["companyNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(exam.companyName);
      const extData = {
        ...exam,
        returnWin: infoType,
        returnDetail: exam,
        type: "exam"
      };
      this.info = {
        ...{},
        ...extData
      };
      this.cluster.dataOptions = [];
      this.markers = [{
        position: [Number(exam.longitude), Number(exam.latitude)],
        anchor: "bottom-center",
        icon: this.mapType === "tianditu" ? __webpack_require__(/*! @/assets/images/mapSearch/考场.png */ "./src/assets/images/mapSearch/考场.png") : {
          image: __webpack_require__(/*! @/assets/images/mapSearch/考场.png */ "./src/assets/images/mapSearch/考场.png"),
          imageSize: [56, 56]
        },
        extData
      }];
      this.showInfoByRowClick(extData, "exam");
    },
    // * 点考试点
    async onClickExamSite(info, infoType) {
      console.log("examInfo_" + infoType, info);
      let examSiteId = info.examSiteId;
      if (infoType === "examSite") {
        examSiteId = info.id;
      }
      const examSite = await Object(_api_exam_site_room_controller__WEBPACK_IMPORTED_MODULE_32__["getExamSiteDetail"])(examSiteId);
      examSite["companyNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(examSite.companyName);
      examSite["addressSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(examSite.address);
      const extData = {
        ...examSite,
        returnWin: infoType,
        returnDetail: {
          ...info,
          infoType
        },
        type: "examSite"
      };
      this.info = {
        ...{},
        ...extData
      };
      this.cluster.dataOptions = [];
      this.markers = [{
        position: [Number(examSite.longitude), Number(examSite.latitude)],
        anchor: "bottom-center",
        icon: this.mapType === "tianditu" ? __webpack_require__(/*! @/assets/images/mapSearch/考试点.png */ "./src/assets/images/mapSearch/考试点.png") : {
          image: __webpack_require__(/*! @/assets/images/mapSearch/考试点.png */ "./src/assets/images/mapSearch/考试点.png"),
          imageSize: [56, 56]
        },
        extData
      }];
      this.showInfoByRowClick(extData, "examSite");
    },
    // 跳转公司
    async clickCompany(info, infoType, isProprietor) {
      console.log("company", info);
      let companyId = infoType === "company" ? info.id : info.organizationId;
      if (isProprietor === "Proprietor") {
        companyId = info.proprietorCompanyId;
      }
      if (infoType === "companyStations") {
        if (info.proprietorCompanyId) {
          companyId = info.proprietorCompanyId;
        }
      }
      console.log("companyID", companyId);
      const company = await Object(_api_company_controller__WEBPACK_IMPORTED_MODULE_10__["getCompanyDetail"])(companyId);
      let companyIcon = __webpack_require__(/*! @/assets/images/mapSearch/公司.png */ "./src/assets/images/mapSearch/公司.png");
      if (company.resourceTypes.includes("Proprietor")) {
        companyIcon = __webpack_require__(/*! @/assets/images/mapSearch/内保单位公司.png */ "./src/assets/images/mapSearch/内保单位公司.png");
      }
      company["returnWin"] = infoType;
      company["returnDetail"] = info;
      company["type"] = "company";
      company["registerAddressSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(company.registerAddress);
      this.cluster.dataOptions = [];
      this.markers = [{
        position: [Number(company.longitude), Number(company.latitude)],
        anchor: "bottom-center",
        icon: companyIcon,
        extData: company
      }];
      console.log(this.markers);
      this.clearMap();
      this.showInfoByRowClick(company, "company");
    },
    async clickProject(info, infoType) {
      Object(_api_projects_controller__WEBPACK_IMPORTED_MODULE_18__["getProjectsDetail"])(info.projectId).then(project => {
        console.log("project", project);
        project["returnWin"] = infoType;
        project["returnDetail"] = info;
        project["longitude"] = info.longitude;
        project["latitude"] = info.latitude;
        project["companyNameSlice"] = Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(info.companyName);
        this.onClickProject(project);
      }).catch(err => {
        console.log(err);
      });
    },
    // 跳转驻勤点
    clickStation(info, infoType) {
      let stationId = "";
      if (infoType === "companyStations") {
        stationId = info.id;
      } else {
        stationId = info.securityStationId;
      }
      console.log("stationId", stationId);
      Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_17__["getStationDetail"])(stationId).then(station => {
        console.log("station", station);
        station["returnWin"] = infoType;
        station["returnDetail"] = info;
        this.onClickStation(station, "station");
      }).catch(err => {
        console.log(err);
      });
    },
    // 点击驻勤点人员，修改成驻勤点人员撒点
    clickStationEmployees(info) {
      console.log("stationId", info.id);
      let params = {
        pageIndex: 1,
        pageSize: 5000,
        securityStationIds: [info.id + ""],
        searchModel: "SecurityStation",
        deskTypes: this.deskTypesParam
      };
      if (info.resourceTypes.length === 1 && info.resourceTypes[0] === "Population") {
        //如果是社区警务，传一个resourceType = Population
        params = {
          pageIndex: 1,
          pageSize: 5000,
          securityStationIds: [info.id + ""],
          resourceType: "population",
          searchModel: "SecurityStation",
          deskTypes: this.deskTypesParam
        };
      }
      Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployees"])(params).then(res => {
        const stationEmployees = [...res].sort(function (x, y) {
          // true values first
          return x.stationResponsible === y.stationResponsible ? 0 : x.stationResponsible ? -1 : 1;
        });
        this.onMapSearch({
          type: 1,
          data: [...stationEmployees].map(x => {
            return {
              ...x,
              type: "employee"
            };
          })
        });
        console.log("markers", this.cluster.dataOptions);
        console.log("stationEmployees", this.info); // info.stationEmployees
        this.showInfoByRowClick({
          ...info,
          stationEmployees
        }, "stationEmployees");
      }).catch(err => {
        console.log(err);
      });
    },
    // 点击内保单位驻勤点
    clickCompanyStations(info, infoType) {
      console.log("clickCompanyStations-info", info);
      let companyId = info.id;
      if (infoType === "back") {
        companyId = info.proprietorCompanyId;
        info["companyName"] = info.proprietorCompanyName;
      } else {
        info["companyName"] = info.name;
      }
      Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_17__["getStations"])({
        pageIndex: 1,
        pageSize: 1000,
        searchModel: "Organization",
        organizationId: companyId,
        deskTypes: this.deskTypesParam
      }).then(companyStations => {
        console.log("companyStations", companyStations);
        this.showInfoByRowClick({
          ...info,
          companyStations
        }, "companyStations");
      }).catch(err => {
        console.log(err);
      });
    },
    //考场跳转显示音视频弹框
    onClickExamEmployees(info) {
      //如果是考场查询监考老师
      let params = {
        pageIndex: 1,
        pageSize: 5000,
        examSiteRoomId: info.id + "",
        searchModel: "ExamSiteRoom",
        deskTypes: this.deskTypesParam
      };
      Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployees"])(params).then(res => {
        console.log("stationEmployees", res);
        this.stationEmployeesList = res.map(extData => {
          console.log(extData);
          const {
            idCardNo,
            contact,
            name,
            companyName,
            securityStationName
          } = extData;
          return {
            ...extData,
            isPhone: false,
            isIdCardNo: false,
            active: false,
            nameSlice: name.slice(-2),
            companyNameSlice: Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(companyName),
            securityStationNameSlice: Object(_api_common__WEBPACK_IMPORTED_MODULE_24__["textSlice"])(securityStationName),
            idCardNoHide: this.parseStringToStar(idCardNo),
            contactHide: this.parseStringToStar(contact)
          };
        }).filter(x => x !== undefined);
        this.stationEmployeesListFilter = this.stationEmployeesList;
        this.totalNum = 0;
        console.log(this.stationEmployeesList);
        if (this.stationEmployeesList.length > 0) {
          this.stationEmployeesList.forEach(item => {
            item.active = false;
          });
          this.allMembers = this.stationEmployeesList.filter(({
            dutyStatus
          }) => dutyStatus === "SignIn");
          this.stationEmployeesListType = "all";
          this.dutyCheckAll = false;
          this.railDispatchShow = true;
        }
      }).catch(err => {
        console.log(err);
      });
    },
    onClickExamVideo(info) {
      console.log('onClickExamVideo2222', info);
      this.$router.push({
        path: "/multiVideo",
        query: {
          stationId: info.id
        }
      });
    },
    /**
     * @切换图层
     * @param types
     */
    changeLayer(types) {
      this.layers = [];
      types.forEach(type => {
        this.layers.push({
          type
        });
      });
    },
    // TODO 电子围栏
    setFence() {
      this.$message.info("电子围栏");
    },
    // TODO 视频会商
    setVideo() {
      this.$message.info("视频会商");
    },
    // TODO 批量视频查看
    setPreview() {
      this.$message.info("批量视频查看");
    },
    // TODO 广播/全呼
    setBroadcast() {
      this.$message.info("广播/全呼");
    },
    // 工具栏添加线路
    setPolyline() {
      this.$refs.routeListRef.setVisible();
    },
    // 添加路线
    addRoute() {
      this.clearMap();
      // this.$refs.map.polyline("polyline"); // 自由线路
      this.$refs.map.xmPolyline(); // 厦门路线
    },
    // 查看路线
    viewRoute(row) {
      this.clearMap();
      this.$refs.map.addPolyline(row);
    },
    handleRouteDetailClose(data) {
      this.showRouteDetail = false;
      if (data) {
        this.storagePolyine(data === null || data === void 0 ? void 0 : data.polylineObj);
      } else {
        this.clearMap();
      }
      this.$refs.map.setPolyEditorClose(data);
    },
    setShowRouteDetail(data) {
      this.showRouteDetail = true;
      this.$nextTick(() => {
        this.$refs.routeDetailRef.setFormValue({
          ...data
        });
        this.$refs.routeDetailRef.getProjects();
      });
    },
    // 暂存线路实例
    storagePolyine(obj) {
      this.polylineEntity = obj;
    },
    // 重新添加线路实例
    addPolylineEntity(showText) {
      if (this.polylineEntity) {
        if (this.mapType === "tianditu") {
          this.map.addOverLay(this.polylineEntity);
          if (showText) {
            const path = _components_lnglatMap_js__WEBPACK_IMPORTED_MODULE_38__["default"].map(e => {
              const result = gcoord__WEBPACK_IMPORTED_MODULE_39__["default"].transform([e.lng, e.lat],
              // 经纬度坐标
              gcoord__WEBPACK_IMPORTED_MODULE_39__["default"].GCJ02,
              // 当前坐标系
              gcoord__WEBPACK_IMPORTED_MODULE_39__["default"].WGS84 // 目标坐标系
              );
              return {
                ...e,
                lng: result[0],
                lat: result[1]
              };
            });
            path.map((item, index) => {
              const latlng = new T.LngLat(item.lng, item.lat);
              const label = new T.Label({
                text: `${index}`,
                position: latlng,
                offset: new T.Point(-9, 0)
              });
              //创建地图文本对象
              this.map.addOverLay(label);
            });
          }
        } else {
          this.map.add([this.polylineEntity]);
          if (showText) {
            const list = _components_lnglatMap_js__WEBPACK_IMPORTED_MODULE_38__["default"].map(e => [e.lng, e.lat]);
            list.map((item, index) => {
              const text = new this.AMap.Text({
                text: !index ? "0" : index,
                //标记显示的文本内容
                anchor: "center",
                //设置文本标记锚点位置
                // draggable: true, //是否可拖拽
                cursor: "pointer",
                //指定鼠标悬停时的鼠标样式。
                // angle: 10, //点标记的旋转角度
                style: {
                  //设置文本样式，Object 同 css 样式表
                  "border-radius": "30px",
                  "background-color": "white",
                  width: "30px",
                  height: "30px",
                  display: "flex",
                  "align-items": "center",
                  "justify-content": "center",
                  "border-width": 0,
                  "font-size": "16px",
                  color: "blue"
                },
                position: item //点标记在地图上显示的位置
              });
              text.setMap(this.map);
            });
          }
        }
      }
    },
    /**
     * @圈选
     * @param {*} active
     */
    setCircle(active) {
      if (this.mapType === "tianditu") return this.$refs.map.openCircleTool(active);
      this.$refs.map.closeCircleEditor();
      this.$refs.map.closeRectangleEditor();
      this.$refs.map.closePolygonEditor();
      this.$refs.map.clearMeasure();
      const editor = this.$refs.map.getCircleEditor();
      if (editor) this.$refs.map.map.remove(editor);
      // this.$refs.map.map.clearMap();
      if (active) {
        this.$refs.map.circle("circle");
      }
    },
    /**
     * @矩形
     * @param {*} active
     */
    setSquare(active) {
      if (this.mapType === "tianditu") return this.$refs.map.openRectangleTool(active);
      this.$refs.map.closeCircleEditor();
      this.$refs.map.closeRectangleEditor();
      this.$refs.map.closePolygonEditor();
      this.$refs.map.clearMeasure();
      const editor = this.$refs.map.getRectangleEditor();
      if (editor) this.$refs.map.map.remove(editor);
      // this.$refs.map.map.clearMap();
      if (active) {
        this.$refs.map.square("square");
      }
    },
    /**
     * @多边形选择
     * @param {*} active
     */
    setPolygon(active) {
      if (this.mapType === "tianditu") return this.$refs.map.openPolygonTool(active);
      this.$refs.map.closeCircleEditor();
      this.$refs.map.closeRectangleEditor();
      this.$refs.map.closePolygonEditor();
      this.$refs.map.clearMeasure();
      const editor = this.$refs.map.getPolygonEditor();
      if (editor) this.$refs.map.map.remove(editor);
      if (active) {
        this.$refs.map.polygon("polygon");
      }
    },
    onDraw(evt) {
      console.log("onDraw", evt);
      const {
        obj,
        drawType
      } = evt;
      if (drawType === "polyline") {
        this.showRouteDetail = true;
        this.$refs.map.setPolyEditor(obj);
        this.storagePolyine(obj);
        this.$nextTick(() => {
          this.$refs.routeDetailRef.getProjects();
          this.$refs.routeDetailRef.setFormValue({
            polylineObj: obj
          });
        });
      } else {
        if (this.mapType === "tianditu") {
          return this.setContain(evt);
        }
        this.setContain(obj);
        if (drawType === "circle") {
          this.$refs.map.setCircleEditor({
            center: obj.getCenter(),
            radius: obj.getRadius()
          }, false).then(({
            editor
          }) => {
            this.$refs.map.clearMeasure();
            editor.open();
          });
        } else if (drawType === "square") {
          const bounds = obj.getBounds();
          console.log(bounds);
          const {
            northEast,
            southWest
          } = bounds;
          this.$refs.map.setRectangleEditor({
            northEast: [northEast.lng, northEast.lat],
            southWest: [southWest.lng, southWest.lat]
          }, false).then(({
            editor
          }) => {
            this.$refs.map.clearMeasure();
            editor.open();
          });
        } else if (drawType === "polygon") {
          this.$refs.map.setPolygonEditor(obj.getPath(), false).then(({
            editor
          }) => {
            this.$refs.map.clearMeasure();
            editor.open();
          });
        }
      }
    },
    // TODO 隐藏路况
    setTraffic() {
      if (this.mapType === "tianditu") {
        //
      } else {
        this.$refs.map.toggleTraffic();
      }
    },
    // TODO 显示非关
    setStar() {
      this.$message.info("显示非关");
    },
    /**
     * @测距
     * @param {*} active 是否激活
     */
    setMeasure(active) {
      if (this.mapType === "tianditu") return this.$refs.map.openPolylineTool(active);
      if (active) {
        this.$refs.map.measure("rule");
      } else {
        this.$refs.map.clearMeasure();
      }
    },
    setChair() {},
    /**
     * @历史消息
     */
    setHistory() {
      // this.$message.info("历史消息");
      this.isSingle = false;
      this.isComplete = true;
      this.conversationVisible = true;
    },
    /**
     * @地图清除覆盖物
     */
    clearMap() {
      if (this.mapType === "tianditu") {
        let newMarker = this.map.getOverlays(); // 获取到了地图上的所有点
        for (let i = 0; i < newMarker.length; i++) {
          this.map.removeOverLay(newMarker[i]);
        }
        // this.map.clearOverLays();
        if (this.MarkerClusterer && this.MarkerClusterer.object) {
          // 很重要！！！点聚合它不是一个普通的Marker对象
          this.MarkerClusterer.object.clearMarkers();
        }
      } else {
        this.cluster.dataOptions = [];
        this.$refs.map.map.clearMap();
      }
    },
    /**
     * @驻勤点类型获取驻勤点信息
     */
    onGetStationsByType(data) {
      console.log(data);
      this.markers = [];
      data.forEach(info => {
        Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_17__["getStationDetail"])(info.id).then(station => {
          this.info = station;
          station["type"] = "station";
          this.markers.push({
            position: [Number(station.longitude), Number(station.latitude)],
            anchor: "bottom-center",
            icon: this.mapType === "tianditu" ? station.stationTypes[0].mapIcon : {
              image: station.stationTypes[0].mapIcon,
              imageSize: [56, 56]
            },
            extData: station
          });
        }).catch(err => {
          console.log(err);
        });
      });
      if (data && data.length > 0) {
        const coordinates = [data[0].longitude, data[0].latitude]; //取一个经纬度跳转
        this.$refs.map.setZoomAndCenter(7, coordinates);
      }
    },
    /**
     * @文字调度事件-单人
     */
    character(info) {
      _utils_im__WEBPACK_IMPORTED_MODULE_27__["default"].character(info).then(() => {
        this.isSingle = true;
        this.isComplete = false;
        this.conversationVisible = true;
      });
    },
    openGroupFormDialog() {
      if (this.memberList.length > 0) {
        this.isSingle = false;
        this.form.memberList = this.stationEmployeesList.filter(x => x.active);
        this.groupFormDialogVisible = true;
      } else {
        this.$store.commit("showMessage", {
          message: "至少选择一名被调度人"
        });
      }
      console.log(this.form);
    },
    participantJoined(userId) {
      console.log("on participantJoined", userId);
      // this.memberList.forEach((member) => {
      //   if (member.tencentUserId === userId) {
      //     member.state = "CONNECTED";
      //   }
      // });
    },
    participantLeft(userId) {
      console.log("on participantLeft", userId);
      this.allMembers.forEach(member => {
        if (member.tencentUserId === userId) {
          member.active = false;
        }
      });
    },
    onHangup() {
      this.allMembers.forEach(member => {
        member.checked = false;
      });
      this.memberList.forEach(member => {
        member.state = "CONNECTING";
      });
    },
    // 发起多人会议
    openGroupCall: lodash__WEBPACK_IMPORTED_MODULE_25___default.a.debounce(function (type) {
      console.log("call type", type);
      this.memberList.forEach(member => {
        member.state = "CONNECTING";
        member.action = "";
      });
      console.log("openGroupCall", this.memberList);
      if (this.memberList.length > 0) {
        if (type === "audio" || this.memberList.length <= this.videoBoxes) {
          this.setCallProps(type).then(() => {
            this.startVideoDispatch();
          });
        } else {
          this.$store.commit("showMessage", {
            message: "最多选择" + this.videoBoxes + "名被调度人"
          });
        }
      } else {
        this.$store.commit("showMessage", {
          message: "至少选择一名被调度人"
        });
      }
    }, 500),
    //PTT设置优先级
    setPriority(role) {
      switch (role) {
        case "Company":
          this.priority = 0;
          break;
        case "Proprietor":
          this.priority = 10;
          break;
        case "PoliceStation":
        case "PopulationPoliceStation":
          this.priority = 20;
          break;
        case "SubUrb":
        case "PopulationSubUrb":
          this.priority = 30;
          break;
        case "Urban":
        case "PopulationUrban":
          this.priority = 50;
          break;
        default:
          console.error("无效的类型");
      }
    },
    // 创建群聊并打开对讲弹框
    openPPTCall(multiple) {
      this.pttMultiple = multiple;
      const memberList = this.dispatchMembers.filter(member => member.active);
      if (memberList && memberList.length > 0) {
        this.SET_MEMBER_LIST(memberList); // 被调度人数组
        const {
          dispatchNo,
          name,
          role
        } = this.sysUserInfo;
        this.setPriority(role);
        // 构造参会人列表数组，统一设计稿所需字段，加一个区分[调度员/被调度人]字段,调度员位于第一位
        const participant = [{
          dispatchNo: dispatchNo,
          userName: name,
          host: true
        }].concat(memberList.map(x => {
          return {
            ...x,
            host: false
          };
        }));
        // 重新拾取dispatchNo组成accountLists
        const accountLists = participant.map(x => x.dispatchNo);
        // 先创建组群再打开ptt弹框 createPTTGroup: src/store/modules/ptt.js
        this.createPTTGroup({
          adminName: this.pttAccount.adminName,
          name: "临时组群",
          subAccount: dispatchNo,
          accountLists,
          priority: this.priority
        }).then(res => {
          const {
            status,
            message
          } = res;
          if (status === 200) {
            this.pttVisible = true;
          } else {
            this.$message.error(message);
          }
        });
      } else {
        this.$message.warning("请选择被调度人");
      }
    },
    // 中诺视频
    openMqttVideo(multiple = false, isCallVideo = false) {
      // 先设定好调度类型
      this.setYardman({
        type: isCallVideo ? "2" : "1",
        callType: isCallVideo ? "dispatch" : "video",
        video: !isCallVideo,
        audio: true,
        isMutedAudio: false,
        isCallVideo: isCallVideo
      }).then(() => {
        // 唤起音视频窗口
        this.openMqttCall(multiple, isCallVideo);
      });
    },
    // 中诺语音
    openMqttAudio(multiple = false) {
      // 先设定好调度类型
      this.setYardman({
        type: "1",
        callType: "audio",
        video: false,
        audio: true,
        isMutedAudio: false
      }).then(() => {
        // 唤起音视频窗口
        this.openMqttCall(multiple);
      });
    },
    // 中诺视频上拉
    openMqttVideoLocalMute(multiple = false) {
      // 先设定好调度类型
      this.setYardman({
        type: "2",
        callType: "video",
        video: false,
        audio: true,
        isMutedAudio: false
      }).then(() => {
        // 唤起音视频窗口
        this.openMqttCall(multiple);
      });
    },
    openMqttCall(multiple, isCallVideo = false) {
      // 处理参会人
      const list = this.dispatchMembers.filter(member => member.active);
      let memberList = [];
      if (list && list.length > 0) {
        memberList = list.map(x => {
          // 更新调度人状态
          const index = this.dispatchMembers.findIndex(item => item.dispatchNo === x.dispatchNo);
          const member = this.dispatchMembers[index];
          this.UPDATE_DISPATCH_MEMBERS({
            index,
            member: {
              ...member,
              state: "CONNECTING",
              isMutedAudio: true
            }
          });
          return {
            ...x,
            name: x.dispatchNo,
            nameSlice: x.dispatchNo.slice(-3),
            state: "CONNECTING",
            isMutedAudio: true
          };
        });
        this.SET_MEMBER_LIST(memberList); // 被调度人数组
      }
      if (multiple) {
        // 多人调度
        const participant = [this.pttAccount].concat(memberList);
        this.SET_PARTICIPANT(participant);
        // this.$bus.$emit("mqtt-call");
      } else {
        this.SET_PARTICIPANT([]);
      }
      if (isCallVideo) {
        this.$bus.$emit("mqtt-pull-video");
      } else {
        // 打开音视频
        this.$bus.$emit("mqtt-call");
      }
    },
    setCallProps(type) {
      if (type === "video") {
        this.stream.video = true;
        this.stream.audio = true;
        this.callType = "video";
        this.yardmanType = "1";
      } else if (type === "audio") {
        this.stream.video = false;
        this.stream.audio = true;
        this.callType = "audio";
        this.yardmanType = "1";
      } else if (type === "videoLocalMute") {
        this.stream.video = false;
        this.stream.audio = true;
        this.callType = "video";
        this.yardmanType = "2";
      }
      return Promise.resolve();
    },
    startDispatch() {
      this.$refs.ruleForm.validate(valid => {
        if (valid) {
          this.createGroup();
        } else {
          console.log("error submit!!");
          return false;
        }
      });
    },
    cancelDispatch() {
      this.$refs.ruleForm.resetFields();
      this.groupFormDialogVisible = false;
    },
    /**
     * @创建多人群聊
     */
    createGroup() {
      _utils_im__WEBPACK_IMPORTED_MODULE_27__["default"].createGroup(this.form).then(() => {
        // 关闭调度弹框、发送默认信息
        this.groupFormDialogVisible = false;
        this.isComplete = false;
        this.conversationVisible = true;
      });
    },
    showGroupConversation({
      group
    }) {
      console.log("group data ===", group);
      _tim__WEBPACK_IMPORTED_MODULE_20__["default"].getConversationProfile(`GROUP${group.groupID}`).then(({
        data
      }) => {
        console.log(data);
        this.$store.commit("updateCurrentConversation", data.conversation);
        this.$store.dispatch("checkoutConversation", data.conversation.conversationID);
        const {
          conversationID
        } = data.conversation;
        this.$store.dispatch("getMessageList", conversationID);
        console.log(this.currentConversation);
        this.groupFormDialogVisible = false;
        this.isComplete = false;
        this.conversationVisible = true;
      });
      this.closeCreateGroupModel();
    },
    closeCreateGroupModel() {
      this.$store.commit("updateCreateGroupModelVisible", false);
    },
    getOptions() {
      let options = {
        ...this.form,
        memberList: this.form.memberList.map(({
          tenantImUserId
        }) => {
          return {
            userID: tenantImUserId + ""
          };
        })
      };
      if ([this.TIM.TYPES.GRP_WORK, this.TIM.TYPES.GRP_AVCHATROOM].includes(this.form.type)) {
        delete options.joinOption;
      }
      return options;
    },
    onCloseConversation() {
      this.conversationVisible = false;
    },
    handleImgError() {
      this.isImgError = true;
    },
    startVideoDispatch() {
      this.$bus.$emit("video-call");
    },
    //ws初始化
    initWs() {
      const dispatchToken = localStorage.getItem("dispatchToken");
      if (!dispatchToken) return false;
      this.webSocketUrl = `/websocket/police_incidents?dispatchToken=${dispatchToken}`;
      this.ws = Object(_utils_websocket__WEBPACK_IMPORTED_MODULE_23__["default"])({
        url: this.webSocketUrl,
        onMessage: this.onMessage,
        heart: {
          timer: 5000,
          message: "keep alive"
        },
        isReconnect: true,
        onClose: this.onClose
      });
    },
    onClose() {
      this.initWs();
    },
    onMessage(evt) {
      // console.log('evt:--999 ', evt);
      if (evt) {
        if (evt.data.includes("keep alive")) {
          //心跳
        } else {
          console.log("eventdata", evt.data);
          const data = JSON.parse(evt.data);
          console.log("ws data ===", data);
          const {
            type,
            message
          } = data;
          if (type === "PoliceIncidents") {
            const content = message.contents[0];
            if (content.category === "Sos") {
              this.isDeviceSOS = false;
              this.SOSHandler(content);
            } else {
              if (this.$refs.mapsearch.policeIncidentsShow) this.$refs.mapsearch.showPoliceIncidents(true);
              let levelName = ""; //警情等级
              let levelNameColor = ""; //警情等级颜色
              this.levelNameList.forEach(item => {
                if (item.level === content.level) {
                  levelName = item.label;
                  levelNameColor = item.bgColor;
                }
              });
              const h = this.$createElement;
              this.$message({
                customClass: "custom-message",
                dangerouslyUseHTMLString: true,
                //自定义html
                message: h("div", {
                  class: "warning-message"
                }, [h("div", {
                  class: "icon-warning"
                }, ""), h("div", {
                  style: "padding: 0 2px;margin-right: 8px;background:" + levelNameColor + ";height:24px;line-height: 24px;font-size: 14px;color: #ffffff;"
                }, levelName), h("div", {
                  class: "message"
                }, content.reason), h("div", {
                  class: "btn-handle",
                  on: {
                    click: () => {
                      this.$refs.mapsearch.policeIncidentsShow = true;
                      this.$refs.mapsearch.lookDetail(content, true);
                    }
                  }
                }, "立即处理")]),
                duration: 10000 //显示时间 10秒
                // type: "warning",
              });
            }
          } else if (type === "TRTC") {
            const content = message.contents[0];
            console.log(content);
            const {
              action,
              tencentUserId,
              roomId
            } = content;
            // 如果不是本人的房间直接忽略
            if (this.roomId && roomId === this.roomId) {
              if (action === "handUp" || action === "cheese") {
                this.$message.info("有1人举手");
              }
              this.memberList.forEach(member => {
                if (member.tencentUserId === tencentUserId) {
                  member.action = action;
                }
              });
              console.log(this.memberList);
            }
          }
        }
      }
    },
    async handleSOSEvent(res) {
      console.log('handleSOSEvent----------', res);
      this.isDeviceSOS = true;
      this.deviceSosId = res.from;
      let content = {
        id: res.sessionId,
        longitude: res.lon || '112.000000',
        latitude: res.lat || '35.000000',
        empName: res.sendName || '测试测试',
        employeeId: JSON.parse(localStorage.getItem('userInfo')).employeeId
      };
      await this.SOSHandler(content);
    },
    async SOSHandler(content) {
      console.log('SOSHandler----------', content);
      const {
        id,
        longitude,
        latitude,
        empName
      } = content;
      const employeeData = await Object(_api_employee_controller__WEBPACK_IMPORTED_MODULE_11__["getEmployeeDetail"])(content.employeeId);
      const position = [longitude, latitude];
      this.sosId = id;
      console.log("sosId", this.sosId);
      console.log("🚀 ~ SOSHandler ~ this.mapType:", this.mapType);
      // this.markers = [];
      if (this.mapType === 'tianditu') {
        this.markers.push({
          position,
          anchor: "bottom-center",
          icon: __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png"),
          extData: {
            longitude: position[0],
            latitude: position[1]
          },
          panTo: true
        });
      } else {
        this.markers.push({
          position,
          anchor: "bottom-center",
          icon: __webpack_require__(/*! @/assets/images/mapSearch/在岗_保安员.png */ "./src/assets/images/mapSearch/在岗_保安员.png"),
          extData: {}
        });
      }
      // TODO: data = await getEmployeeDetail
      const data = this.isDeviceSOS ? {
        name: empName,
        content: "接听"
      } : {
        name: empName,
        content: "一键报警",
        ...employeeData
      };

      // 预警声音播放获取元素
      let warningAudioDom = document.getElementById("warningAudio");
      console.log("🚀 ~ SOSHandler ~ this.audioState:", this.audioState);
      if (!this.audioState) {
        // 获取元素标签
        // 触发交互
        warningAudioDom.pause();
        this.audioState = true;
      }
      // 触发播放
      warningAudioDom.play();
      //5分钟定时器,停止响铃
      setTimeout(() => {
        warningAudioDom.pause();
        this.markers = [];
        this.infoWindow.SOS.position = undefined;
      }, 5 * 60 * 1000);
      // debugger;
      this.$refs['SOS'].$el.style.display = "block";
      if (this.mapType === 'tianditu') {
        this.info = {
          type: "SOS",
          ...data
        };
        const lnglat = {
          lng: Number(position[0]),
          lat: Number(position[1])
        };
        const winInfo = new T.InfoWindow(this.$refs['SOS'].$el, {
          offset: new T.Point(-14, -18)
        });
        // 清除点marker;
        const clearIcon = e => {
          let newMarker = this.map.getOverlays(); // 获取到了地图上的所有点
          for (let i = 0; i < newMarker.length; i++) {
            // 遍历地图上点
            this.map.removeOverLay(newMarker[i]);
          }
        };
        // 监听信息窗口关闭事件
        winInfo.addEventListener("clickclose", function (e) {
          warningAudioDom.pause();
          clearIcon(e);
        });
        this.map.openInfoWindow(winInfo, lnglat); //开启信息窗口
      } else {
        this.infoWindow.SOS.position = position;
        this.$refs.map.setZoomAndCenter(12, position);
        this.info = {
          type: "SOS",
          ...data
        };
      }
    },
    handleSOSExit() {
      let warningAudioDom = document.getElementById("warningAudio");
      if (this.audioState) {
        // 获取元素标签
        // 触发交互
        warningAudioDom.pause();
        this.audioState = false;
      }
      this.markers = [];
      this.infoWindow.SOS.position = undefined;
      this.$refs['SOS'].$el.style.display = "none";
      this.sosId = "";
      this.clearMap();
    },
    openCallBySOS(info) {
      console.log("isDeviceSOS", this.isDeviceSOS, info);
      this.markers = [];
      this.infoWindow.SOS.position = undefined;
      // this.info.id
      if (this.isDeviceSOS) {
        this.$bus.$emit("mqtt-pull-video", this.deviceSosId);
      } else {
        this.videoLocalMute(this.sosId);
        this.sosId = "";
      }
      // 预警声音播放获取元素
      let warningAudioDom = document.getElementById("warningAudio");
      // 触发播放
      warningAudioDom.pause();
    },
    onDispatchWindowClose() {
      console.log("onDispatchWindowClose");
      this.allMembers = [];
    },
    onRailDispatchClose() {
      this.allMembers = [];
      this.showDutyCheckbox = false;
      this.railDispatchShow = false;
    },
    onRailDispatchDeviceClose() {
      this.SET_DISPATCH_MEMBERS([]);
      this.railDispatchDeviceShow = false;
    },
    clickAllDuty() {
      console.log(this.stationEmployeesList);
      this.stationEmployeesListType = "all";
      this.showDutyCheckbox = false;
    },
    clickOnDuty() {
      this.stationEmployeesListType = "on";
      this.showDutyCheckbox = true;
    },
    clickNoDuty() {
      this.stationEmployeesListType = "off";
      this.showDutyCheckbox = false;
    },
    onCheckDuty(val) {
      console.log(val);
      if (val) {
        this.stationEmployeesListFilter.forEach(x => x.active = true);
        this.totalNum = 0;
        this.memberList = [];
        this.stationEmployeesListFilter.forEach(employee => {
          employee.active = true;
          this.memberList.push(employee);
        });
        this.totalNum = this.memberList.length;
      } else {
        this.stationEmployeesListFilter.forEach(x => x.active = false);
        this.totalNum = 0;
        this.memberList = [];
      }
      this.isIndeterminate = false;
    },
    onCheckDevice(val) {
      const dispatchMembers = this.dispatchMembers.map(x => {
        return {
          ...x,
          // 离线总是不选中
          active: x.status === "Online" ? val : false,
          name: x.dispatchNo,
          nameSlice: x.dispatchNo.slice(-3)
        };
      });
      this.SET_DISPATCH_MEMBERS(dispatchMembers);
      const memberList = this.dispatchMembers.filter(member => member.active);
      this.SET_MEMBER_LIST(memberList);
      this.$forceUpdate();
      this.isIndeterminate = false;
    },
    setItemPhoneVisible(item) {
      item.isPhone = !item.isPhone;
      this.$forceUpdate();
    },
    closePTT() {
      this.pttMultiple = false;
    },
    // 天地图撒点
    setWinInfo(marker, data) {
      const openInfo = (e, data) => {
        this.info = {
          ...this.info,
          ...data
        };
        const point = e.lnglat;
        const markerInfoWin = new T.InfoWindow(this.$refs[data.type || data.extData.type].$el, {
          offset: new T.Point(-14, 10)
        }); // 创建信息窗口对象
        // markerInfoWin.setContent(this.$refs.winInfoLocation.$el);
        marker.openInfoWindow(markerInfoWin, point); //开启信息窗口
      };
      marker.addEventListener("click", function (e) {
        openInfo(e, data);
      });
    },
    onConnectionStatusChange(status) {
      if (status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusRejected || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusLogout || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusSecretKeyMismatch || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusTokenIncorrect || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusKickedOff ||
      // TODO 断网时，显示网络断开状态
      // || status === ConnectionStatus.ConnectionStatusUnconnected
      _wfc_client_wfc__WEBPACK_IMPORTED_MODULE_44__["default"].getUserId() === "") {
        // if (this.$router.currentRoute.path !== "/") {
        //   this.$router.replace({ path: "/" });
        // }
        if (this.pageName !== "ConversationPage") {
          // this.pageName = "ConversationPage";
          this.$store.commit("SET_PAGE_NAME", "ConversationPage");
        }
        if (status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusSecretKeyMismatch || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusLogout || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusTokenIncorrect || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusKickedOff || status === _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].ConnectionStatusRejected) {
          Object(_ui_util_storageHelper__WEBPACK_IMPORTED_MODULE_43__["removeItem"])("wfcUserId");
          Object(_ui_util_storageHelper__WEBPACK_IMPORTED_MODULE_43__["removeItem"])("wfcToken");
          _wfc_av_engine_avenginekitproxy__WEBPACK_IMPORTED_MODULE_51__["default"].forceCloseVoipWindow();
          console.error("连接失败", _wfc_client_connectionStatus__WEBPACK_IMPORTED_MODULE_54__["default"].desc(status));
        }
      }
    },
    closePTT() {
      this.dismissGroup(() => {
        this.pttVisible = false;
      });
    }
  },
  async created() {
    this.initWs();
    const employeeTypesList = await Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_17__["getAllStationTypes"])({
      deskTypes: ["TemporarySecurity"]
    }); //获取大活行业人员类型
    if (this.type == 1) {
      this.actEmployeeTypes = employeeTypesList.filter(el => !el.onlyForStation);
    } else if (this.type == 2) {
      this.actEmployeeTypes = employeeTypesList;
    }
    this.$refs.mapsearch.setActEmployeeTypes(this.actEmployeeTypes);
    this.stationTypes = await Object(_api_security_station_controller__WEBPACK_IMPORTED_MODULE_17__["getAllStationTypes"])({
      deskTypes: []
    }); //获取驻勤点信息
    const userInfo = localStorage.getItem("userInfo");
    if (userInfo) {
      this.isCompany = JSON.parse(userInfo).role === "Company" || JSON.parse(userInfo).role === "Proprietor";
      if (this.platform !== "3") {
        this.deskTypesParam = this.isCompany ? ["Normal", "Proprietor"] : this.deskTypes;
      }
      this.videoBoxes = this.customizeOrgs.includes(JSON.parse(userInfo).organizationId) ? 15 : 5;
      this.videoBoxes = this.customizeOrgsNoLimit.includes(JSON.parse(userInfo).organizationId) ? 10000 : 5;
    }
    // 获取元素标签
    let warningAudioDom = document.getElementById("warningAudio");
    // 触发交互
    warningAudioDom.pause();
  },
  mounted() {
    window.addEventListener("sos-event", res => {
      this.handleSOSEvent(res.detail);
    });
    window.addEventListener("sos-exit", () => {
      this.handleSOSExit();
    });
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/layout/AppMain.vue?vue&type=script&lang=js":
/*!*****************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/layout/AppMain.vue?vue&type=script&lang=js ***!
  \*****************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ({
  name: "AppMain",
  computed: {
    cachedViews() {
      return this.$store.state.cachedViews;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/layout/NavBar.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/layout/NavBar.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/settings */ "./src/settings.js");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_settings__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _views_layout_SideMenu_index_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/views/layout/SideMenu/index.vue */ "./src/views/layout/SideMenu/index.vue");
/* harmony import */ var screenfull__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! screenfull */ "./node_modules/screenfull/index.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _views_layout_PlatformSelection_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/views/layout/PlatformSelection.vue */ "./src/views/layout/PlatformSelection.vue");





/* harmony default export */ __webpack_exports__["default"] = ({
  name: "NavBar",
  components: {
    SideMenu: _views_layout_SideMenu_index_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
    platformSelection: _views_layout_PlatformSelection_vue__WEBPACK_IMPORTED_MODULE_4__["default"]
  },
  data() {
    return {
      // title,
      // logo: require("@/assets/警徽.png"),
      userInfo: "",
      isFullscreen: false,
      platform: localStorage.getItem("platform") || "1"
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_3__["mapGetters"])(["settings", "sysUserInfo", "version"]),
    getUserInfo() {
      return this.sysUserInfo && Object.keys(this.sysUserInfo).length > 0;
    },
    logo() {
      //判断当前是否有logo配置，undefined结尾说明还没有配置
      console.log("setting", this.settings.logo);
      if (this.settings.logo.endsWith("undefined") || this.settings.logo.endsWith("null")) {
        return __webpack_require__(/*! @/assets/警徽.png */ "./src/assets/警徽.png");
      } else {
        return this.settings.logo;
      }
    },
    title() {
      return this.settings.title || _settings__WEBPACK_IMPORTED_MODULE_0__["title"];
    }
  },
  mounted() {
    const userInfo = localStorage.getItem("userInfo");
    if (userInfo) {
      console.log("userInfo", JSON.parse(userInfo));
      this.userInfo = JSON.parse(userInfo);
    }
    if (screenfull__WEBPACK_IMPORTED_MODULE_2__["default"].isEnabled) {
      screenfull__WEBPACK_IMPORTED_MODULE_2__["default"].on("change", () => {
        this.isFullscreen = screenfull__WEBPACK_IMPORTED_MODULE_2__["default"].isFullscreen;
      });
    }
  },
  methods: {
    noPlatformChange() {
      localStorage.setItem("platform", this.platform);
      window.location.reload();
    },
    handleScreen() {
      if (screenfull__WEBPACK_IMPORTED_MODULE_2__["default"].isEnabled) {
        screenfull__WEBPACK_IMPORTED_MODULE_2__["default"].toggle();
      }
    },
    showDialog() {
      this.$store.commit("SET_VISUAL_VISIBLE", true);
    },
    showVersion() {
      alert("APP Version: " + this.version);
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/layout/PlatformSelection.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/layout/PlatformSelection.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);


/* harmony default export */ __webpack_exports__["default"] = ({
  name: "PlatformSelection",
  props: {
    userRole: {
      type: String,
      required: true
    }
  },
  data() {
    return {
      platform: "",
      platformOptions: [{
        value: "1",
        label: "指挥调度台",
        role: ["Company", "Urban", "SubUrb", "PoliceStation", "PopulationPoliceStation", "PopulationUrban", "PopulationSubUrb"],
        disabled: this.renderSelectDisabled()
      }, {
        value: "2",
        label: "内保调度台",
        role: ["Proprietor", "PoliceStation", "PopulationPoliceStation"]
      }, {
        value: "3",
        label: "临保调度台",
        role: ["Company", "Urban", "SubUrb", "PoliceStation", "PopulationPoliceStation"]
        // disabled: true,
      }]
    };
  },
  methods: {
    noPlatformChange() {
      localStorage.setItem("platform", this.platform);
      window.location.reload();
    },
    renderSelectDisabled() {
      const userInfo = localStorage.getItem("userInfo") && JSON.parse(localStorage.getItem("userInfo"));
      if ((userInfo === null || userInfo === void 0 ? void 0 : userInfo.orgInstitutional) === "0201") {
        return true;
      }
      return false;
    }
  },
  mounted() {
    const platformInfRole = this.platformOptions.filter(x => x.role.includes(this.userRole));
    let defaultPlatform = platformInfRole[0].value;
    const userInfo = localStorage.getItem("userInfo") && JSON.parse(localStorage.getItem("userInfo"));
    if (userInfo.orgInstitutional === "0201") {
      defaultPlatform = 3;
    }
    console.log("defaultPlatform: " + defaultPlatform);
    const storePlatform = localStorage.getItem("platform");
    if (platformInfRole.filter(x => x.value === storePlatform).length <= 0) {
      this.platform = defaultPlatform;
      localStorage.setItem("platform", this.platform);
    } else {
      this.platform = storePlatform;
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/layout/SideMenu/Link.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/layout/SideMenu/Link.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/utils */ "./src/utils/index.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  props: {
    to: {
      type: String,
      required: true
    }
  },
  computed: {
    isExternal() {
      return Object(_utils__WEBPACK_IMPORTED_MODULE_0__["isExternal"])(this.to);
    },
    type() {
      if (this.isExternal) {
        return "a";
      }
      return "router-link";
    }
  },
  methods: {
    linkProps(to) {
      if (this.isExternal) {
        return {
          href: to,
          target: "_blank",
          rel: "noopener"
        };
      }
      return {
        to: to
      };
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/layout/SideMenu/index.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/layout/SideMenu/index.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.iterator.find.js */ "./node_modules/core-js/modules/es.iterator.find.js");
/* harmony import */ var core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_find_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js");
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/utils */ "./src/utils/index.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Link */ "./src/views/layout/SideMenu/Link.vue");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");








/* harmony default export */ __webpack_exports__["default"] = ({
  data() {
    return {
      basePath: "/",
      onlyOneChild: null,
      navMenuFlag: false,
      moreRouter: {},
      menuList: [{
        menuName: "测试",
        menuUrl: "/index"
      }, {
        menuName: "测试2",
        menuUrl: "/index"
      }, {
        menuName: "测试3",
        menuUrl: "/index"
      }],
      sidebarRouters: this.$router.getRoutes(),
      permissionRouters: [],
      isMove: false,
      allWidth: 0,
      // 菜单总宽度
      boxLength: 0,
      // 可视窗口宽度
      menuWidth: 114 // 移动宽度
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_7__["mapGetters"])(["sysUserInfo"]),
    menu() {
      return [...this.sidebarRouters].filter(route => {
        if (!Object.prototype.hasOwnProperty.call(route.meta, "hidden") || !route.meta.hidden) {
          return route;
        }
      });
    },
    activePath() {
      return () => {
        var _route$parent;
        const route = this.$route.matched.pop();
        console.log("current route---: ", route);
        if (((_route$parent = route.parent) === null || _route$parent === void 0 ? void 0 : _route$parent.name) !== "layout") {
          return route.parent.path;
        } else {
          return route.path;
        }
      };
    }
  },
  components: {
    AppLink: _Link__WEBPACK_IMPORTED_MODULE_6__["default"]
  },
  watch: {
    $route() {
      this.navMenuFlag = false;
      this.addView();
    }
  },
  created() {
    const platform = localStorage.getItem("platform");
    console.log("menu platform", platform);
    const dispatchRoute = this.sidebarRouters.find(x => x.name === "dispatch");
    const businessRoute = this.sidebarRouters.find(x => x.name === "business");
    if (platform) {
      switch (platform) {
        case "1":
          dispatchRoute.meta.title = "指挥调度";
          businessRoute.meta.title = "业务管理";
          break;
        case "2":
          dispatchRoute.meta.title = "内保调度";
          businessRoute.meta.title = "内保记录";
          break;
        case "3":
          dispatchRoute.meta.title = "临保调度";
          businessRoute.meta.title = "临保记录";
          break;
        default:
          dispatchRoute.meta.title = "指挥调度";
          businessRoute.meta.title = "业务管理";
      }
    }
    this.moreRouter = {
      path: "",
      meta: {
        title: ""
      },
      children: this.permissionRouters.slice(4)
    };
    this.initMenusWidth();
    // 监听页面窗口变化
    window.addEventListener("resize", () => {
      this.initMenusWidth();
    });
  },
  mounted() {
    this.addView();
  },
  methods: {
    setActivePath() {
      var _route$parent2;
      const route = this.$route.matched.pop();
      if (((_route$parent2 = route.parent) === null || _route$parent2 === void 0 ? void 0 : _route$parent2.name) !== "layout") {
        this.activePath = route.parent.path;
      } else {
        this.activePath = route.path;
      }
    },
    generateRoute() {
      if (this.$route.name) {
        return this.$route;
      }
      return false;
    },
    addView() {
      const route = this.generateRoute();
      if (!route) {
        return false;
      }
      this.$store.dispatch("addVisitedViews", route);
    },
    changeMoreMenu() {
      this.navMenuFlag = !this.navMenuFlag;
    },
    hideNavContext() {
      this.navMenuFlag = false;
    },
    hasOneShowingChild(children = [], parent) {
      if (!children) {
        children = [];
      }
      const showingChildren = children.filter(item => {
        if (item.hidden) {
          return false;
        } else {
          // Temp set(will be used if only has one showing child)
          this.onlyOneChild = item;
          return true;
        }
      });

      // When there is only one child router, the child router is displayed by default
      if (showingChildren.length === 1) {
        return true;
      }

      // Show parent if there are no child router to display
      if (showingChildren.length === 0) {
        this.onlyOneChild = {
          ...parent,
          path: "",
          noShowingChildren: true
        };
        return true;
      }
      return false;
    },
    resolvePath(routePath) {
      if (Object(_utils__WEBPACK_IMPORTED_MODULE_5__["isExternal"])(routePath)) {
        return routePath;
      }
      if (Object(_utils__WEBPACK_IMPORTED_MODULE_5__["isExternal"])(this.basePath)) {
        return this.basePath;
      }
      return path__WEBPACK_IMPORTED_MODULE_4___default.a.resolve(this.basePath, routePath);
    },
    // 菜单右侧移动按钮
    toRightMove() {
      const menuscrollLeft = document.getElementById("navSystemMenu").scrollLeft;
      if (this.allWidth > this.boxLength + menuscrollLeft) {
        document.getElementById("navSystemMenu").scrollLeft += this.menuWidth;
      } else {
        document.getElementById("navSystemMenu").scrollLeft = this.allWidth;
      }
    },
    // 菜单左侧移动按钮
    toLeftMove() {
      let menuscrollLeft = document.getElementById("navSystemMenu").scrollLeft;
      if (menuscrollLeft > 0) {
        document.getElementById("navSystemMenu").scrollLeft -= this.menuWidth;
      } else {
        document.getElementById("navSystemMenu").scrollLeft = 0;
      }
    },
    // 初始化目录栏
    initMenusWidth() {
      this.$nextTick(() => {
        // 可视窗口宽度
        this.boxLength = document.getElementById("swiperMenu").offsetWidth;
        // 菜单宽度
        this.allWidth = document.getElementById("navSystemMenu").scrollWidth;
        if (this.allWidth > this.boxLength) {
          this.isMove = true;
        } else {
          this.isMove = false;
        }
      });
    },
    toParentView({
      path
    }) {
      this.$router.push({
        path
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/views/layout/index.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/views/layout/index.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.url-search-params.delete.js */ "./node_modules/core-js/modules/web.url-search-params.delete.js");
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.url-search-params.has.js */ "./node_modules/core-js/modules/web.url-search-params.has.js");
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.url-search-params.size.js */ "./node_modules/core-js/modules/web.url-search-params.size.js");
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _views_layout_NavBar_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/views/layout/NavBar.vue */ "./src/views/layout/NavBar.vue");
/* harmony import */ var _views_layout_AppMain_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/views/layout/AppMain.vue */ "./src/views/layout/AppMain.vue");
/* harmony import */ var _components_visualConfig_index_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/components/visualConfig/index.vue */ "./src/components/visualConfig/index.vue");
/* harmony import */ var _components_imageCropper_index_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/components/imageCropper/index.vue */ "./src/components/imageCropper/index.vue");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");








/* harmony default export */ __webpack_exports__["default"] = ({
  name: "layout",
  components: {
    NavBar: _views_layout_NavBar_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
    AppMain: _views_layout_AppMain_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
    visualConfig: _components_visualConfig_index_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
    imageCropper: _components_imageCropper_index_vue__WEBPACK_IMPORTED_MODULE_6__["default"]
  },
  data() {
    return {
      showCropper: false,
      uploadImageUrl: ""
    };
  },
  computed: {
    ...Object(vuex__WEBPACK_IMPORTED_MODULE_7__["mapGetters"])(["settings"])
  },
  methods: {
    openCropper(url) {
      this.uploadImageUrl = url;
      this.showCropper = true;
    },
    onCropped(data) {
      this.uploadImageUrl = window.URL.createObjectURL(data);
      this.showCropper = false;
      const {
        logo
      } = this.settings;
      const spliceLength2 = logo.lastIndexOf("/");
      const imageFullName = logo.slice(spliceLength2 + 1);
      const imageName = imageFullName.split(".")[0];
      //blob转file
      const file = new File([data], `${imageName}-剪裁-${new Date()}.jpg`, {
        type: "contentType",
        lastModified: Date.now()
      });
      this.$refs.visualConfig.uploadAvatar({
        file: file
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?{\"cacheDirectory\":\"node_modules/.cache/vue-loader\",\"cacheIdentifier\":\"7ab4c6d0-vue-loader-template\"}!./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/AMap/infowindow/index.vue?vue&type=template&id=1a998d16&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js?{"cacheDirectory":"node_modules/.cache/vue-loader","cacheIdentifier":"7ab4c6d0-vue-loader-template"}!./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/AMap/infowindow/index.vue?vue&type=template&id=1a998d16&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "render", function() { return render; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "staticRenderFns", function() { return staticRenderFns; });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c("div", {
    ref: "windowInfo",
    class: _vm.className
  }, [_vm._t("default")], 2);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?{\"cacheDirectory\":\"node_modules/.cache/vue-loader\",\"cacheIdentifier\":\"7ab4c6d0-vue-loader-template\"}!./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/AMap/map/index.vue?vue&type=template&id=a24d298a&scoped=true":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js?{"cacheDirectory":"node_modules/.cache/vue-loader","cacheIdentifier":"7ab4c6d0-vue-loader-template"}!./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/AMap/map/index.vue?vue&type=template&id=a24d298a&scoped=true ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "render", function() { return render; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "staticRenderFns", function() { return staticRenderFns; });
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.map.js */ "./node_modules/core-js/modules/es.iterator.map.js");
/* harmony import */ var core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_map_js__WEBPACK_IMPORTED_MODULE_1__);


var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c("div", {
    style: _vm.mapStyle,
    attrs: {
      id: _vm.id
    }
  }, [_vm.map ? _vm._t("default") : _vm._e()], 2);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?{\"cacheDirectory\":\"node_modules/.cache/vue-loader\",\"cacheIdentifier\":\"7ab4c6d0-vue-loader-template\"}!./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/imageCropper/index.vue?vue&type=template&id=66c542c5&scoped=true":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js?{"cacheDirectory":"node_modules/.cache/vue-loader","cacheIdentifier":"7ab4c6d0-vue-loader-template"}!./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/imageCropper/index.vue?vue&type=template&id=66c542c5&scoped=true ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "render", function() { return render; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "staticRenderFns", function() { return staticRenderFns; });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c("el-dialog", {
    attrs: {
      title: "裁剪图片",
      visible: _vm.openDialog,
      "destroy-on-close": true,
      width: "600px",
      "append-to-body": ""
    },
    on: {
      "update:visible": function ($event) {
        _vm.openDialog = $event;
      },
      close: _vm.closeDialog
    }
  }, [_c("div", {
    staticStyle: {
      width: "100%",
      height: "100%",
      display: "flex",
      "align-items": "center",
      "justify-content": "center",
      "flex-wrap": "wrap"
    }
  }, [_c("div", {
    staticStyle: {
      width: "400px",
      height: "300px"
    }
  }, [_c("vue-cropper", {
    ref: "cropper",
    staticStyle: {
      margin: "0 auto"
    },
    style: {
      width: _vm.showPreview ? "100%" : "80%"
    },
    attrs: {
      img: _vm.img,
      info: true,
      autoCrop: _vm.autoCrop,
      autoCropWidth: _vm.autoCropWidth,
      autoCropHeight: _vm.autoCropHeight,
      fixedBox: _vm.fixedBox
    },
    on: {
      realTime: _vm.realTime
    }
  })], 1), _c("el-row", {
    staticStyle: {
      width: "100%",
      "margin-top": "10px"
    }
  }, [_c("el-col", {
    attrs: {
      lg: {
        span: 1,
        offset: 2
      },
      md: 2
    }
  }, [_c("el-button", {
    attrs: {
      icon: "el-icon-plus",
      size: "small"
    },
    on: {
      click: function ($event) {
        return _vm.changeScale(1);
      }
    }
  })], 1), _c("el-col", {
    attrs: {
      lg: {
        span: 1,
        offset: 1
      },
      md: 2
    }
  }, [_c("el-button", {
    attrs: {
      icon: "el-icon-minus",
      size: "small"
    },
    on: {
      click: function ($event) {
        return _vm.changeScale(-1);
      }
    }
  })], 1), _c("el-col", {
    attrs: {
      lg: {
        span: 1,
        offset: 1
      },
      md: 2
    }
  }, [_c("el-button", {
    attrs: {
      icon: "el-icon-refresh-left",
      size: "small"
    },
    on: {
      click: function ($event) {
        return _vm.rotateLeft();
      }
    }
  })], 1), _c("el-col", {
    attrs: {
      lg: {
        span: 1,
        offset: 1
      },
      md: 2
    }
  }, [_c("el-button", {
    attrs: {
      icon: "el-icon-refresh-right",
      size: "small"
    },
    on: {
      click: function ($event) {
        return _vm.rotateRight();
      }
    }
  })], 1), _c("el-col", {
    staticStyle: {
      display: "flex",
      "flex-direction": "row",
      "align-items": "center",
      "justify-content": "flex-end"
    },
    attrs: {
      lg: {
        span: 2,
        offset: 6
      },
      md: 2
    }
  }, [_c("el-button", {
    attrs: {
      size: "small",
      plain: ""
    },
    on: {
      click: _vm.downImg
    }
  }, [_vm._v("下 载")]), _c("el-button", {
    attrs: {
      type: "primary",
      plain: "",
      size: "small"
    },
    on: {
      click: _vm.getCropData
    }
  }, [_vm._v("裁 剪")])], 1)], 1)], 1)]);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?{\"cacheDirectory\":\"node_modules/.cache/vue-loader\",\"cacheIdentifier\":\"7ab4c6d0-vue-loader-template\"}!./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader/lib/index.js?!./src/components/mapSearch/index.vue?vue&type=template&id=f7424872&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js?{"cacheDirectory":"node_modules/.cache/vue-loader","cacheIdentifier":"7ab4c6d0-vue-loader-template"}!./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--1-0!./node_modules/vue-loader/lib??vue-loader-options!./src/components/mapSearch/index.vue?vue&type=template&id=f7424872&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "render", function() { return render; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "staticRenderFns", function() { return staticRenderFns; });
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.iterator.constructor.js */ "./node_modules/core-js/modules/es.iterator.constructor.js");
/* harmony import */ var core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_constructor_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.iterator.filter.js */ "./node_modules/core-js/modules/es.iterator.filter.js");
/* harmony import */ var core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_iterator_filter_js__WEBPACK_IMPORTED_MODULE_1__);


var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c("div", {
    staticClass: "map-search"
  }, [_c("div", {
    staticClass: "search"
  }, [_c("div", {
    staticClass: "select",
    on: {
      click: _vm.showResTypeList
    }
  }, [_c("span", {
    staticClass: "name"
  }, [_vm._v(_vm._s(_vm.typeName))]), _c("i", {
    staticClass: "arrow"
  })]), _c("el-input", {
    staticClass: "input",
    attrs: {
      type: "text",
      placeholder: _vm.placeholder,
      clearable: "",
      autocomplete: "new-password"
    },
    on: {
      input: _vm.setKeywords,
      clear: _vm.onClearSearch
    },
    nativeOn: {
      keydown: function ($event) {
        if (!$event.type.indexOf("key") && _vm._k($event.keyCode, "enter", 13, $event.key, "Enter")) return null;
        return _vm.search.apply(null, arguments);
      }
    },
    model: {
      value: _vm.keywords,
      callback: function ($$v) {
        _vm.keywords = $$v;
      },
      expression: "keywords"
    }
  }), _c("div", {
    staticClass: "btn",
    on: {
      click: _vm.search
    }
  }, [_vm._v("搜索")])], 1), _c("div", {
    staticClass: "tool-btn"
  }, [_vm.showResourceLayers ? _c("div", {
    staticClass: "types",
    on: {
      click: _vm.showStationTypes
    }
  }) : _vm._e(), _vm.showIncidents ? _c("div", {
    staticClass: "situation",
    on: {
      click: function ($event) {
        return _vm.showPoliceIncidents(false);
      }
    }
  }) : _vm._e()]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.resTypeListShow,
      expression: "resTypeListShow"
    }],
    staticClass: "res-type-list res-type-list-type"
  }, [_vm.resTypeList.length <= 0 ? _c("el-empty") : _vm._e(), _vm._l(_vm.resTypeRoleList, function (item, index) {
    return _c("div", {
      key: index,
      staticClass: "item",
      class: [item.value === _vm.type ? "item-active" : "", item.disabled ? "item-disabled" : ""],
      on: {
        click: function ($event) {
          return _vm.setType(item.value, index);
        }
      }
    }, [_c("div", {
      staticClass: "icon",
      class: "icon-" + item.value
    }), _c("span", {
      staticClass: "name"
    }, [_vm._v(_vm._s(item.name))])]);
  }), _c("div", {
    staticClass: "filter-type"
  }, [Number(_vm.type) === 1 && _vm.platform === "3" ? _c("el-form", {
    staticClass: "filter-form",
    attrs: {
      model: _vm.formEmployee
    }
  }, [_vm.isSuperVision ? _c("el-form-item", {
    staticStyle: {
      "padding-top": "6px"
    },
    attrs: {
      label: "辖区"
    }
  }, [_c("tree-select", {
    staticClass: "tree-select",
    attrs: {
      options: _vm.departs,
      placeholder: "请选择",
      normalizer: _vm.normalizer1,
      noOptionsText: "无数据",
      noResultsText: "无数据"
    },
    on: {
      select: _vm.onSelectEmployeeDeparts
    },
    model: {
      value: _vm.formEmployee.depart,
      callback: function ($$v) {
        _vm.$set(_vm.formEmployee, "depart", $$v);
      },
      expression: "formEmployee.depart"
    }
  })], 1) : _vm._e(), _c("el-form-item", {
    staticStyle: {
      "padding-top": "6px"
    },
    attrs: {
      label: "临保项目"
    }
  }, [_c("tree-select", {
    staticClass: "tree-select",
    attrs: {
      options: _vm.projects,
      placeholder: "请选择",
      normalizer: _vm.normalizer2,
      noOptionsText: "无数据",
      noResultsText: "无数据"
    },
    on: {
      select: _vm.onSelectEmployeeProjects
    },
    model: {
      value: _vm.formEmployee.project,
      callback: function ($$v) {
        _vm.$set(_vm.formEmployee, "project", $$v);
      },
      expression: "formEmployee.project"
    }
  })], 1), _vm.platform === "3" && _vm.orgInstitutional === "0201" ? _c("el-form-item", {
    staticStyle: {
      "padding-top": "3px"
    },
    attrs: {
      label: "人员类型"
    }
  }, [_vm.platform === "3" && _vm.orgInstitutional === "0201" ? _c("div", {
    staticClass: "checkActWrap"
  }, [_vm.actEmployeeTypes.length ? _c("el-checkbox", {
    attrs: {
      indeterminate: _vm.isIndeterminate
    },
    on: {
      change: _vm.handleCheckAllChangeAct
    },
    model: {
      value: _vm.checkAll,
      callback: function ($$v) {
        _vm.checkAll = $$v;
      },
      expression: "checkAll"
    }
  }, [_vm._v("全选")]) : _vm._e(), _c("el-checkbox-group", {
    on: {
      change: _vm.handleCheckedCitiesChangeAct
    },
    model: {
      value: _vm.checkedActEmployeeTypes,
      callback: function ($$v) {
        _vm.checkedActEmployeeTypes = $$v;
      },
      expression: "checkedActEmployeeTypes"
    }
  }, _vm._l(_vm.actEmployeeTypes, function (item) {
    return _c("el-checkbox", {
      key: item.code,
      attrs: {
        label: item.code
      }
    }, [_vm._v(_vm._s(item.name))]);
  }), 1)], 1) : _c("el-radio-group", {
    model: {
      value: _vm.formEmployee.type,
      callback: function ($$v) {
        _vm.$set(_vm.formEmployee, "type", $$v);
      },
      expression: "formEmployee.type"
    }
  }, _vm._l(_vm.employeeRolesTypes, function (item) {
    return _c("el-radio", {
      key: item.name,
      staticStyle: {
        "padding-top": "15px",
        "margin-right": "25px"
      },
      attrs: {
        label: item.code,
        disabled: item.disabled
      }
    }, [_vm._v(_vm._s(item.name))]);
  }), 1)], 1) : _vm._e(), _c("el-form-item", {
    staticStyle: {
      "padding-top": "6px"
    },
    attrs: {
      label: "关注类型"
    }
  }, [_c("el-radio-group", {
    model: {
      value: _vm.formEmployee.followed,
      callback: function ($$v) {
        _vm.$set(_vm.formEmployee, "followed", $$v);
      },
      expression: "formEmployee.followed"
    }
  }, [_c("el-radio", {
    attrs: {
      label: 1
    }
  }, [_vm._v("全部")]), _c("el-radio", {
    attrs: {
      label: 2
    }
  }, [_vm._v("已关注")]), _c("el-radio", {
    attrs: {
      label: 3
    }
  }, [_vm._v("未关注")])], 1)], 1)], 1) : _vm._e(), Number(_vm.type) === 1 && _vm.platform !== "3" && _vm.personRoleValid ? _c("el-form", {
    staticClass: "filter-form",
    attrs: {
      model: _vm.formEmployee
    }
  }, [_c("el-form-item", {
    staticStyle: {
      "padding-top": "3px"
    },
    attrs: {
      label: "类型"
    }
  }, [_c("el-radio-group", {
    model: {
      value: _vm.formEmployee.type,
      callback: function ($$v) {
        _vm.$set(_vm.formEmployee, "type", $$v);
      },
      expression: "formEmployee.type"
    }
  }, _vm._l(_vm.employeeRolesTypes, function (item) {
    return _c("el-radio", {
      key: item.name,
      staticStyle: {
        "padding-top": "15px",
        "margin-right": "25px"
      },
      attrs: {
        label: item.code,
        disabled: item.disabled
      }
    }, [_vm._v(_vm._s(item.name))]);
  }), 1)], 1)], 1) : _vm._e(), Number(_vm.type) === 2 && _vm.companyRoleValid && _vm.platform === "1" ? _c("el-form", {
    staticClass: "filter-form",
    attrs: {
      model: _vm.formStation
    }
  }, [_vm.formStation.type === null || _vm.formStation.type === "Security" ? _c("station-types-form", {
    attrs: {
      "station-types": _vm.stationTypes,
      "is-security": _vm.isSecurity,
      "is-police-station": _vm.isPoliceStation
    },
    on: {
      handleCheckChange: _vm.handleCheckChange
    }
  }) : _vm._e(), _c("el-form-item", {
    staticStyle: {
      "padding-top": "3px"
    },
    attrs: {
      label: "类型"
    }
  }, [_c("el-radio-group", {
    model: {
      value: _vm.formStation.type,
      callback: function ($$v) {
        _vm.$set(_vm.formStation, "type", $$v);
      },
      expression: "formStation.type"
    }
  }, _vm._l(_vm.stationRolesTypes, function (item) {
    return _c("el-radio", {
      key: item.code,
      staticStyle: {
        "padding-top": "8px"
      },
      attrs: {
        label: item.code
      }
    }, [_vm._v(_vm._s(item.name))]);
  }), 1)], 1)], 1) : _vm._e(), Number(_vm.type) === 2 && _vm.sysUserInfo.role === "Proprietor" && _vm.platform === "2" ? _c("el-form", {
    staticClass: "filter-form",
    attrs: {
      model: _vm.formStation
    }
  }) : _vm._e(), Number(_vm.type) === 2 && _vm.platform === "3" ? _c("el-form", {
    staticClass: "filter-form",
    attrs: {
      model: _vm.formStation
    }
  }, [_vm.isSuperVision ? _c("el-form-item", {
    staticStyle: {
      "padding-top": "6px"
    },
    attrs: {
      label: "辖区"
    }
  }, [_c("tree-select", {
    staticClass: "tree-select",
    attrs: {
      options: _vm.departs,
      placeholder: "请选择",
      normalizer: _vm.normalizer1,
      noOptionsText: "无数据",
      noResultsText: "无数据"
    },
    on: {
      select: _vm.onSelectStationDeparts
    },
    model: {
      value: _vm.formStation.depart,
      callback: function ($$v) {
        _vm.$set(_vm.formStation, "depart", $$v);
      },
      expression: "formStation.depart"
    }
  })], 1) : _vm._e(), _c("el-form-item", {
    staticStyle: {
      "padding-top": "6px"
    },
    attrs: {
      label: "临保项目"
    }
  }, [_c("tree-select", {
    staticClass: "tree-select",
    attrs: {
      options: _vm.projects,
      placeholder: "请选择",
      normalizer: _vm.normalizer2,
      noOptionsText: "无数据",
      noResultsText: "无数据"
    },
    on: {
      select: _vm.onSelectStationProjects
    },
    model: {
      value: _vm.formStation.project,
      callback: function ($$v) {
        _vm.$set(_vm.formStation, "project", $$v);
      },
      expression: "formStation.project"
    }
  })], 1), _vm.platform === "3" && _vm.orgInstitutional === "0201" ? _c("el-form-item", {
    staticStyle: {
      "padding-top": "3px"
    },
    attrs: {
      label: "类型"
    }
  }, [_c("div", {
    staticClass: "checkActWrap"
  }, [_vm.actEmployeeTypes.length ? _c("el-checkbox", {
    attrs: {
      indeterminate: _vm.isIndeterminate
    },
    on: {
      change: _vm.handleCheckAllChangeAct
    },
    model: {
      value: _vm.checkAll,
      callback: function ($$v) {
        _vm.checkAll = $$v;
      },
      expression: "checkAll"
    }
  }, [_vm._v("全选")]) : _vm._e(), _c("el-checkbox-group", {
    on: {
      change: _vm.handleCheckedCitiesChangeAct
    },
    model: {
      value: _vm.checkedActEmployeeTypes,
      callback: function ($$v) {
        _vm.checkedActEmployeeTypes = $$v;
      },
      expression: "checkedActEmployeeTypes"
    }
  }, _vm._l(_vm.actEmployeeTypes, function (item) {
    return _c("el-checkbox", {
      key: item.code,
      attrs: {
        label: item.code
      }
    }, [_vm._v(_vm._s(item.name))]);
  }), 1)], 1)]) : _vm._e()], 1) : _vm._e(), Number(_vm.type) === 3 && _vm.platform === "2" && (_vm.sysUserInfo.role === "PoliceStation" || _vm.sysUserInfo.role === "PopulationPoliceStation") ? _c("el-form", {
    staticClass: "filter-form",
    attrs: {
      model: _vm.formCompany
    }
  }, [_c("el-form-item", {
    staticStyle: {
      "padding-top": "3px"
    },
    attrs: {
      label: "内保单位类型"
    }
  }, [_c("el-checkbox", {
    attrs: {
      indeterminate: _vm.isIndeterminatePro
    },
    on: {
      change: _vm.handleCheckAllChangePro
    },
    model: {
      value: _vm.checkAllPro,
      callback: function ($$v) {
        _vm.checkAllPro = $$v;
      },
      expression: "checkAllPro"
    }
  }, [_vm._v("全选")]), _c("el-checkbox-group", {
    on: {
      change: _vm.handleCheckedCitiesChangePro
    },
    model: {
      value: _vm.formCompany.institutional,
      callback: function ($$v) {
        _vm.$set(_vm.formCompany, "institutional", $$v);
      },
      expression: "formCompany.institutional"
    }
  }, [_c("el-row", _vm._l(_vm.proprietorTypes, function (item) {
    return _c("el-col", {
      key: item.code,
      staticStyle: {
        "padding-top": "10px"
      },
      attrs: {
        span: 8
      }
    }, [_c("el-checkbox", {
      attrs: {
        label: item.code
      }
    }, [_c("span", {
      staticStyle: {
        "font-size": "12px",
        "padding-left": "2px"
      }
    }, [_vm._v(_vm._s(item.name))])])], 1);
  }), 1)], 1)], 1), _c("el-form-item", {
    staticStyle: {
      "padding-top": "6px"
    },
    attrs: {
      label: "辖区"
    }
  }, [_c("tree-select", {
    staticClass: "tree-select",
    attrs: {
      options: _vm.departs,
      placeholder: "请选择",
      normalizer: _vm.normalizer1,
      noOptionsText: "无数据",
      noResultsText: "无数据"
    },
    on: {
      select: _vm.onSelectCompanyDeparts
    },
    model: {
      value: _vm.formCompany.depart,
      callback: function ($$v) {
        _vm.$set(_vm.formCompany, "depart", $$v);
      },
      expression: "formCompany.depart"
    }
  })], 1)], 1) : _vm._e(), Number(_vm.type) === 5 ? _c("el-form", {
    staticClass: "filter-form",
    attrs: {
      model: _vm.formDevice
    }
  }, [_vm.isSuperVision ? _c("el-form-item", {
    staticStyle: {
      "padding-top": "6px"
    },
    attrs: {
      label: "辖区"
    }
  }, [_c("tree-select", {
    staticClass: "tree-select",
    attrs: {
      options: _vm.departs,
      placeholder: "请选择",
      normalizer: _vm.normalizer1,
      noOptionsText: "无数据",
      noResultsText: "无数据"
    },
    on: {
      select: _vm.onSelectDeviceDeparts
    },
    model: {
      value: _vm.formDevice.depart,
      callback: function ($$v) {
        _vm.$set(_vm.formDevice, "depart", $$v);
      },
      expression: "formDevice.depart"
    }
  })], 1) : _vm._e()], 1) : _vm._e()], 1)], 2)]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.empoloyeesResultShow,
      expression: "empoloyeesResultShow"
    }],
    staticClass: "employee-list"
  }, [Number(_vm.type) === 1 ? _c("div", {
    directives: [{
      name: "loading",
      rawName: "v-loading",
      value: _vm.employeeLoading,
      expression: "employeeLoading"
    }],
    ref: "employeeRes",
    staticClass: "employee-detail"
  }, [_vm.resResult.length <= 0 ? _c("el-empty") : _vm._e(), _vm._l(_vm.resResult, function (item, index) {
    return _c("div", {
      key: index,
      staticClass: "employee-item",
      on: {
        click: function ($event) {
          return _vm.onClickEmployee(item);
        }
      }
    }, [_c("div", {
      staticClass: "employee-list-item"
    }, [_c("div", {
      staticClass: "employee-left"
    }, [_c("div", {
      staticClass: "name-photo"
    }, [_vm._v(_vm._s(item.nameSlice))]), _c("div", {
      staticClass: "employee-item-detail"
    }, [_c("div", {
      staticClass: "employee-name"
    }, [_vm._v(_vm._s(item.name))]), _vm.platform === "2" ? _c("div", {
      staticClass: "employee-contact"
    }, [_vm._v(" 所属内保单位： "), _c("el-tooltip", {
      attrs: {
        effect: "dark",
        content: item.proprietorCompanyName,
        placement: "top"
      }
    }, [_c("span", {
      staticClass: "item-value"
    }, [_vm._v(_vm._s(item.proprietorCompanyNameSlice))])])], 1) : _vm._e(), !item.isProprietor && _vm.platform !== "3" ? _c("div", {
      staticClass: "employee-contact"
    }, [_vm._v(" 所属公司： "), _c("el-tooltip", {
      attrs: {
        effect: "dark",
        content: item.companyName,
        placement: "top"
      }
    }, [_c("span", {
      staticClass: "item-value"
    }, [_vm._v(_vm._s(item.companyNameSlice + (item.institutional === "0104" ? "/自招" : "")))])])], 1) : _vm._e(), _c("div", {
      staticClass: "employee-contact"
    }, [_vm._v(" 联系方式："), _c("span", {
      staticClass: "item-value"
    }, [_vm._v(_vm._s(item.isContact ? item.contact : "***********"))]), item.isContact ? _c("span", {
      staticClass: "hide-show",
      on: {
        click: function ($event) {
          $event.stopPropagation();
          return _vm.lookContact(index, "isContact");
        }
      }
    }, [_vm._v("隐藏")]) : _vm._e(), !item.isContact ? _c("span", {
      staticClass: "hide-show",
      on: {
        click: function ($event) {
          $event.stopPropagation();
          return _vm.lookContact(index, "isContact");
        }
      }
    }, [_vm._v("显示")]) : _vm._e()]), _c("div", {
      staticClass: "employee-idCardNo"
    }, [_vm._v(" 证件号码："), _c("span", {
      staticClass: "item-value"
    }, [_vm._v(_vm._s(item.isIdCardNo ? item.idCardNo : "******************"))]), item.isIdCardNo ? _c("span", {
      staticClass: "hide-show",
      on: {
        click: function ($event) {
          $event.stopPropagation();
          return _vm.lookContact(index, "isIdCardNo");
        }
      }
    }, [_vm._v("隐藏")]) : _vm._e(), !item.isIdCardNo ? _c("span", {
      staticClass: "hide-show",
      on: {
        click: function ($event) {
          $event.stopPropagation();
          return _vm.lookContact(index, "isIdCardNo");
        }
      }
    }, [_vm._v("显示")]) : _vm._e()]), !item.isProprietor && _vm.platform !== "3" ? _c("div", {
      staticClass: "employee-contact"
    }, [_vm._v(" 所属驻勤点： "), _c("el-tooltip", {
      attrs: {
        effect: "dark",
        content: item.securityStationName,
        placement: "top"
      }
    }, [_c("span", {
      staticClass: "item-value"
    }, [_vm._v(_vm._s(item.stationNameSlice))])])], 1) : _vm._e(), _vm.platform === "3" ? _c("div", {
      staticClass: "employee-contact"
    }, [_vm._v(" 所属临保项目： "), _c("el-tooltip", {
      attrs: {
        effect: "dark",
        content: item.projectName,
        placement: "top"
      }
    }, [_c("span", {
      staticClass: "item-value"
    }, [_vm._v(_vm._s(item.projectName))])])], 1) : _vm._e(), _vm.platform === "3" ? _c("div", {
      staticClass: "employee-contact"
    }, [_vm._v(" 所属临保岗点： "), _c("el-tooltip", {
      attrs: {
        effect: "dark",
        content: item.stationName,
        placement: "top"
      }
    }, [_c("span", {
      staticClass: "item-value"
    }, [_vm._v(_vm._s(item.stationNameSlice))])])], 1) : _vm._e()])]), _c("img", {
      staticClass: "address-icon",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/map/icons/mark_b.png */ "./src/assets/images/map/icons/mark_b.png"),
        alt: ""
      }
    })])]);
  }), _vm.resResult.length > 0 && !_vm.noMore ? _c("div", {
    staticClass: "load-more"
  }, [_c("el-button", {
    attrs: {
      type: "primary",
      size: "mini"
    },
    on: {
      click: _vm.loadEmployee
    }
  }, [_vm._v("加载更多")])], 1) : _vm._e()], 2) : _vm._e()])]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.stationsResultShow,
      expression: "stationsResultShow"
    }],
    staticClass: "employee-list"
  }, [Number(_vm.type) === 2 ? _c("div", {
    directives: [{
      name: "loading",
      rawName: "v-loading",
      value: _vm.stationLoading,
      expression: "stationLoading"
    }],
    ref: "stationRes",
    staticClass: "employee-detail"
  }, [_vm.resResult.length <= 0 ? _c("el-empty") : _vm._e(), _vm._l(_vm.resResult, function (item, index) {
    return _c("div", {
      key: index,
      staticClass: "employee-item",
      on: {
        click: function ($event) {
          return _vm.onClickStation(item.id);
        }
      }
    }, [_c("div", {
      staticClass: "employee-item-new-main"
    }, [_c("div", {
      staticClass: "employee-item-new"
    }, [_c("img", {
      staticClass: "employee-item-new-img",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/mapSearch/驻勤点备份.png */ "./src/assets/images/mapSearch/驻勤点备份.png"),
        alt: ""
      }
    }), _c("div", {
      staticClass: "employee-item-new-detail"
    }, [_c("div", {
      staticClass: "employee-new-name"
    }, [_vm._v(_vm._s(item.name))]), _vm.platform !== "3" ? _c("div", {
      staticClass: "employee-new-item",
      staticStyle: {
        margin: "9px 0"
      }
    }, [_vm._v(" 驻勤地址："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.address))])]) : _vm._e(), _vm.platform !== "3" ? _c("div", {
      staticClass: "employee-new-item"
    }, [_vm._v(" 保安公司："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.companyName))])]) : _vm._e(), _vm.platform === "3" ? _c("div", {
      staticClass: "employee-new-item",
      staticStyle: {
        margin: "9px 0"
      }
    }, [_vm._v(" 临保岗点地址："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.address))])]) : _vm._e(), _vm.platform === "3" ? _c("div", {
      staticClass: "employee-new-item",
      staticStyle: {
        margin: "9px 0"
      }
    }, [_vm._v(" 所属临保项目："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.projectName))])]) : _vm._e(), _vm.platform === "3" ? _c("div", {
      staticClass: "employee-new-item"
    }, [_vm._v(" 项目所属公司："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.companyName))])]) : _vm._e()])]), _c("img", {
      staticClass: "address-icon",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/map/icons/mark_b.png */ "./src/assets/images/map/icons/mark_b.png"),
        alt: ""
      }
    })])]);
  }), _vm.resResult.length > 0 && !_vm.noMore ? _c("div", {
    staticClass: "load-more"
  }, [_c("el-button", {
    attrs: {
      type: "primary",
      size: "mini"
    },
    on: {
      click: _vm.loadStation
    }
  }, [_vm._v("加载更多")])], 1) : _vm._e()], 2) : _vm._e()])]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.devicesResultShow,
      expression: "devicesResultShow"
    }],
    staticClass: "employee-list"
  }, [Number(_vm.type) === 5 ? _c("div", {
    directives: [{
      name: "loading",
      rawName: "v-loading",
      value: _vm.deviceLoading,
      expression: "deviceLoading"
    }],
    ref: "deviceRes",
    staticClass: "employee-detail"
  }, [_vm.resResult.length <= 0 ? _c("el-empty") : _vm._e(), _vm._l(_vm.resResult, function (item, index) {
    return _c("div", {
      key: index,
      staticClass: "employee-item",
      on: {
        click: function ($event) {
          return _vm.onClickDevice(item.id);
        }
      }
    }, [_c("div", {
      staticClass: "employee-item-new-main"
    }, [_c("div", {
      staticClass: "employee-item-new"
    }, [_c("img", {
      staticClass: "employee-item-new-img",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/mapSearch/智能对讲终端.png */ "./src/assets/images/mapSearch/智能对讲终端.png"),
        alt: ""
      }
    }), _c("div", {
      staticClass: "employee-item-new-detail"
    }, [_c("div", {
      staticClass: "employee-new-name"
    }, [_vm._v(_vm._s(item.dispatchNo))]), _c("div", {
      staticClass: "employee-new-item",
      staticStyle: {
        margin: "9px 0"
      }
    }, [_vm._v(" 所属公司："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.organizationName))])]), _c("div", {
      staticClass: "employee-new-item"
    }, [_vm._v(" 所属驻勤点："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.securityStationName))])])])]), _c("img", {
      staticClass: "address-icon",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/map/icons/mark_b.png */ "./src/assets/images/map/icons/mark_b.png"),
        alt: ""
      }
    })])]);
  }), _vm.resResult.length > 0 && !_vm.noMore ? _c("div", {
    staticClass: "load-more"
  }, [_c("el-button", {
    attrs: {
      type: "primary",
      size: "mini"
    },
    on: {
      click: _vm.loadDevice
    }
  }, [_vm._v("加载更多")])], 1) : _vm._e()], 2) : _vm._e()])]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.proprietorResultShow,
      expression: "proprietorResultShow"
    }],
    staticClass: "employee-list"
  }, [Number(_vm.type) === 3 ? _c("div", {
    directives: [{
      name: "loading",
      rawName: "v-loading",
      value: _vm.proprietorLoading,
      expression: "proprietorLoading"
    }],
    ref: "proprietorRes",
    staticClass: "employee-detail"
  }, [_vm.resResult.length <= 0 ? _c("el-empty") : _vm._e(), _vm._l(_vm.resResult, function (item, index) {
    return _c("div", {
      key: index,
      staticClass: "employee-item",
      on: {
        click: function ($event) {
          return _vm.onClickProprietor(item);
        }
      }
    }, [_c("div", {
      staticClass: "employee-item-new-main"
    }, [_c("div", {
      staticClass: "employee-item-new"
    }, [_c("img", {
      staticClass: "employee-item-new-img",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/mapSearch/内保单位.png */ "./src/assets/images/mapSearch/内保单位.png"),
        alt: "",
        width: "60",
        height: "60"
      }
    }), _c("div", {
      staticClass: "employee-item-new-detail"
    }, [_c("div", {
      staticClass: "employee-new-name"
    }, [_vm._v(_vm._s(item.name))]), _c("div", {
      staticClass: "employee-new-item",
      staticStyle: {
        margin: "9px 0"
      }
    }, [_vm._v(" 内保单位地址："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.registerAddress))])]), _c("div", {
      staticClass: "employee-new-item"
    }, [_vm._v(" 负责人员："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.legal))])])])]), _c("img", {
      staticClass: "address-icon",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/map/icons/mark_b.png */ "./src/assets/images/map/icons/mark_b.png"),
        alt: ""
      }
    })])]);
  }), _vm.resResult.length > 0 && !_vm.noMore ? _c("div", {
    staticClass: "load-more"
  }, [_c("el-button", {
    attrs: {
      type: "primary",
      size: "mini"
    },
    on: {
      click: _vm.loadProprietor
    }
  }, [_vm._v("加载更多")])], 1) : _vm._e()], 2) : _vm._e()])]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.examResultShow,
      expression: "examResultShow"
    }],
    staticClass: "employee-list"
  }, [Number(_vm.type) === 7 ? _c("div", {
    directives: [{
      name: "loading",
      rawName: "v-loading",
      value: _vm.examLoading,
      expression: "examLoading"
    }],
    ref: "proprietorRes",
    staticClass: "employee-detail"
  }, [_vm.resResult.length <= 0 ? _c("el-empty") : _vm._e(), _vm._l(_vm.resResult, function (item, index) {
    return _c("div", {
      key: index,
      staticClass: "employee-item",
      on: {
        click: function ($event) {
          return _vm.onClickExam(item);
        }
      }
    }, [_c("div", {
      staticClass: "employee-item-new-main"
    }, [_c("div", {
      staticClass: "employee-item-new"
    }, [_c("img", {
      staticClass: "employee-item-new-img",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/mapSearch/考场-2.png */ "./src/assets/images/mapSearch/考场-2.png"),
        alt: "",
        width: "36",
        height: "36"
      }
    }), _c("div", {
      staticClass: "employee-item-new-detail"
    }, [_c("div", {
      staticClass: "employee-new-name"
    }, [_vm._v(_vm._s(item.name))]), _c("div", {
      staticClass: "employee-new-item",
      staticStyle: {
        margin: "9px 0"
      }
    }, [_vm._v(" 所属考点："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.examSiteName))])]), _c("div", {
      staticClass: "employee-new-item"
    }, [_vm._v(" 培训机构："), _c("span", {
      staticClass: "employee-new-value"
    }, [_vm._v(_vm._s(item.companyName))])])])]), _c("img", {
      staticClass: "address-icon",
      attrs: {
        src: __webpack_require__(/*! @/assets/images/map/icons/mark_b.png */ "./src/assets/images/map/icons/mark_b.png"),
        alt: ""
      }
    })])]);
  }), _vm.resResult.length > 0 && !_vm.noMore ? _c("div", {
    staticClass: "load-more"
  }, [_c("el-button", {
    attrs: {
      type: "primary",
      size: "mini"
    },
    on: {
      click: _vm.loadExam
    }
  }, [_vm._v("加载更多")])], 1) : _vm._e()], 2) : _vm._e()])]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.resResultShow,
      expression: "resResultShow"
    }],
    staticClass: "res-type-list res-type-list-result"
  }, [Number(_vm.type) === 4 ? _c("div", {
    staticClass: "pois"
  }, [_vm.resResult.length <= 0 ? _c("el-empty") : _vm._e(), _vm._l(_vm.resResult, function (item, index) {
    return _c("div", {
      key: index,
      staticClass: "poi",
      on: {
        click: function ($event) {
          return _vm.onClickPoi(item);
        }
      }
    }, [_c("span", {
      staticClass: "name"
    }, [_vm._v(_vm._s(item.name))]), _c("span", {
      staticClass: "sub"
    }, [_vm._v(_vm._s(item.district) + _vm._s(item.address))])]);
  })], 2) : _vm._e()])]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.stationTypesShow,
      expression: "stationTypesShow"
    }],
    staticClass: "station-types"
  }, [_c("div", {
    staticClass: "header"
  }, [_c("span", {
    staticClass: "title"
  }, [_vm._v("资源图层")]), _c("i", {
    staticClass: "el-icon-close",
    on: {
      click: function ($event) {
        _vm.stationTypesShow = false;
      }
    }
  })]), _c("div", {
    staticClass: "content"
  }, [_c("div", {
    staticClass: "top"
  }, [_c("i", {
    staticClass: "location"
  }), _c("span", {
    staticClass: "title"
  }, [_vm._v("驻勤点类型")])]), _c("el-radio-group", {
    model: {
      value: _vm.stationType,
      callback: function ($$v) {
        _vm.stationType = $$v;
      },
      expression: "stationType"
    }
  }, [_c("el-row", [_vm._l(_vm.stationTypes.filter((x, i) => i <= 23), function (item) {
    return _c("el-col", {
      key: item.code,
      attrs: {
        span: 8
      }
    }, [_c("el-radio", {
      attrs: {
        label: item.code
      },
      on: {
        change: function ($event) {
          return _vm.getStationsByType(item.code);
        }
      }
    }, [_c("img", {
      staticClass: "type-icon",
      attrs: {
        src: item.icon,
        alt: ""
      }
    }), _c("span", [_vm._v(_vm._s(item.name))])])], 1);
  }), _vm._l(_vm.stationTypes.filter((x, i) => i > 23), function (item) {
    return _c("el-col", {
      key: item.code,
      attrs: {
        span: 12
      }
    }, [_c("el-radio", {
      attrs: {
        label: item.code
      },
      on: {
        change: function ($event) {
          return _vm.getStationsByType(item.code);
        }
      }
    }, [_c("img", {
      staticClass: "type-icon",
      attrs: {
        src: item.icon,
        alt: ""
      }
    }), _c("span", [_vm._v(_vm._s(item.name))])])], 1);
  })], 2)], 1)], 1)])]), _c("transition", {
    attrs: {
      name: "slide-fade"
    }
  }, [_c("div", {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.policeIncidentsShow,
      expression: "policeIncidentsShow"
    }],
    staticClass: "police-incidents"
  }, [_c("div", {
    staticClass: "header"
  }, [_c("span", {
    staticClass: "title"
  }, [_vm._v("线索上报")]), _c("i", {
    staticClass: "el-icon-close",
    on: {
      click: function ($event) {
        _vm.policeIncidentsShow = false;
      }
    }
  })]), _vm.isDetail ? _c("div", {
    staticClass: "list-detail"
  }, [_c("div", {
    staticClass: "detail-header"
  }, [_c("div", {
    staticClass: "header-back",
    on: {
      click: _vm.goBackList
    }
  }, [_vm._v("< 返回警情列表")]), _c("div", {
    staticClass: "header-btn"
  }, [_c("div", {
    staticClass: "header-zb",
    on: {
      click: _vm.railCk
    }
  }, [_vm._v("周边调度")]), _vm.isSuperVision ? _c("div", {
    staticClass: "header-close",
    on: {
      click: function ($event) {
        return _vm.closeIncident(_vm.policeIncidentsData.id);
      }
    }
  }, [_vm._v("关闭事件")]) : _vm._e()])]), _c("div", {
    staticClass: "detail"
  }, [_c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("事件类别：")]), _c("div", {
    staticClass: "detail-item-value"
  }, [_vm._v(" " + _vm._s(_vm.policeIncidentsData.name || "无") + " ")])]), _c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("报警对象：")]), _c("div", {
    staticClass: "detail-item-value color-blue",
    on: {
      click: function ($event) {
        return _vm.showEmployeeByIncident(_vm.policeIncidentsData.tenantEmployeeId);
      }
    }
  }, [_vm._v(" " + _vm._s(_vm.policeIncidentsData.empName || "无") + " ")])]), _c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("联系方式：")]), _c("div", {
    staticClass: "detail-item-value"
  }, [_vm._v(" " + _vm._s(_vm.isPhone ? _vm.policeIncidentsData.contact : "***********") + " "), _vm.isPhone ? _c("span", {
    staticClass: "hide-show",
    on: {
      click: function ($event) {
        $event.stopPropagation();
        _vm.isPhone = !_vm.isPhone;
      }
    }
  }, [_vm._v("隐藏")]) : _vm._e(), !_vm.isPhone ? _c("span", {
    staticClass: "hide-show",
    on: {
      click: function ($event) {
        $event.stopPropagation();
        _vm.isPhone = !_vm.isPhone;
      }
    }
  }, [_vm._v("显示")]) : _vm._e()])]), _c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("上报时间：")]), _c("div", {
    staticClass: "detail-item-value"
  }, [_vm._v(" " + _vm._s(_vm.policeIncidentsData.createdTime || "无") + " ")])]), _c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("事发地点：")]), _c("div", {
    staticClass: "detail-item-value"
  }, [_vm._v(" " + _vm._s(_vm.policeIncidentsData.address || "无") + " ")])]), _c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("事件类型：")]), _c("div", {
    staticClass: "detail-item-value"
  }, [_vm._v(" " + _vm._s(_vm.policeIncidentsData.policeEventType || "无") + " ")])]), _c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("事件级别：")]), _c("div", {
    staticClass: "detail-item-value"
  }, [_vm._v(" " + _vm._s(_vm.policeIncidentsData.policeEventLevel || "无") + " ")])]), _vm.policeIncidentsData.name !== "一键报警" ? _c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("事件情况：")]), _c("div", {
    staticClass: "detail-item-value"
  }, [_vm._v(" " + _vm._s(_vm.policeIncidentsData.reason || "无") + " ")])]) : _vm._e(), _vm.policeIncidentsData.name !== "一键报警" ? _c("div", {
    staticClass: "detail-item marginbottom11"
  }, [_c("div", {
    staticClass: "detail-item-title"
  }, [_vm._v("已采取措施：")]), _c("div", {
    staticClass: "detail-item-value"
  }, [_vm._v(" " + _vm._s