import React, { Component } from "react";
import { render } from 'react-dom';
import './modal.less';
import { Button, Icon, Modal } from "antd";

function renderModal(modalInfo) {

  class ModalComponent extends Component {
    constructor(props, context) {
      super(props, context);

      this.state = {
        ...modalInfo
      };
    }
    render() {
      return (
        <Modal
          closable={false}
          visible={this.state.visible}
          footer={null}
          wrapClassName="modal_on_footer"
          width={416}
        >
          <div className="bcx_modal_content">
            {(() => {
              let style = {fontSize: 26, marginRight: 15};
              switch(modalInfo.icon) {
                case 'info':
                  style = { ...style, color: '#1890ff', ...modalInfo.iconStyle }
                  return <Icon type="info-circle" style={style} />;
                case 'success':
                  style = { ...style, color: '#52c41a', ...modalInfo.iconStyle }
                  return <Icon type="check-circle" style={style} />;
                case 'warning':
                  style = { ...style, color: '#faad14', ...modalInfo.iconStyle }
                  return <Icon type="exclamation-circle" style={style} />;
                case 'error':
                  style = { ...style, color: '#f5222d', ...modalInfo.iconStyle }
                  return <Icon type="close-circle" style={style} />;
                default:
                  // return <Icon type="einfo-circle" style={{ fontSize: 26, color: '#1890ff', marginRight: 15 }} />;
                  return '';
              }
            })()}
            <div className="info">
              <h3>{modalInfo.title}</h3>
              <div className="info_container">
                {modalInfo.message}
                {/* <span style={{ color: '#FF9900' }}></span> */}
              </div>
              <div className="bcx_modal_btns">
                {modalInfo.footer instanceof Array && modalInfo.footer.map((btn, index) => {
                  return <Button
                    key={index}
                    type={btn.type?btn.type: ''} 
                    onClick={
                    () => {
                      if(typeof btn.onPress == 'function') {
                        btn.onPress();
                      }
                      this.setState({
                        visible: false
                      });
                    }
                  }>{btn.text}</Button>
                })}
              </div>
            </div>
          </div>
        </Modal>
      );
    }
  }
  let div = document.createElement('div');
  render(<ModalComponent />, div);
}


export default function modal (
  title = '提示', 
  message = '', 
  footer, 
  icon, 
  maskClosable = false,
  iconStyle = {}
  ) {
  const modalInfo = {
    visible: true,
    maskClosable,
    title,
    message,
    footer: footer || [{ text: '确定', type: 'primary' }],
    icon: icon || 'warning',
    iconStyle
  };
  renderModal(modalInfo);
}