import React, { Component } from "react";
import RreactDom from 'react-dom';
// import PropTypes from 'prop-types';
import { Modal } from "antd";
// 弹窗组件
class NormalModal extends Component {
  constructor(props, context) {
    super(props, context);

    this.state = {
      visible: true
    };
  }
  _toggle = (type) => {
    const close = () => {
      this.setState({
        visible: false
      }, () => {
        // 删除组件
        setTimeout(() => {
          const divs = document.getElementsByClassName('n_modal');
          Reflect.apply(Array.prototype.forEach, divs, [item => {
            RreactDom.unmountComponentAtNode(item);
            document.body.removeChild(item);
          }]);
        }, 300);
      });
    }
    // 点击确定以后
    if (type == 'confirm') {
      if(this.props.onOk) {
        this.props.onOk(close);
        this.props.update && this.props.update();
      }else {
        close();
      }
    }else {
      this.props.onCancel && this.props.onCancel();
      close();
    }
  }
  render() {
    return (
      <Modal
        {...this.props}
        visible={this.state.visible}
        onOk={() => {
          this._toggle('confirm');
        }}
        onCancel={() => {
          this._toggle();
        }}
        okText={this.props.okText || '确定'}
        cancelText={this.props.cancelText || '取消'}
      >
        {this.props.content}
      </Modal>
    );
  }
}

// NormalModal.propTypes = {

// };

// 插入弹窗
export default function showInsuranceModal(props) {
  const div = document.createElement('div');
  div.setAttribute('class', 'n_modal');
  document.body.appendChild(div);
  props.okText = props.okText || '确定';
  props.cancelText = props.cancelText || '取消';
  RreactDom.render(<NormalModal {...props} />, div);
}