import React, { Component } from "react";
import { Modal, Icon, message } from "antd";

import SelectUser from "../SelectUser";
import "./index.less";

/** 选择人员弹窗 */
class PartmentSelect extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      checkedkeys: this.props.value || [],
      // checkedkeys: [],
      visible: this.props.visible,
      arrayObj: []
    };
  }

  componentWillReceiveProps(nextprops) {
    this.setState({
      visible: nextprops.visible
      // checkedkeys: nextprops.value || []
    });
  }

  handleCancel = () => {
    this.setState({
      visible: false,
      checkedkeys: [],
      arrayObj:[]
    });
    this.props.handleCancel();
  };

  handleOk = () => {
    if(this.state.checkedkeys.length === 0){
      return message.error("请至少选择一个人员");
    }
    this.setState({
      visible: false
    });
    this.props.onCheck(
      this.state.checkedkeys,
      this.state.arrayObj
    );
    //之后初始化选择框的数据
    this.setState({
      checkedkeys: [],
      arrayObj:[]
    });
  };

  // 该函数貌似没什么作用
  // showModal = e => {
  //   const targetClass = e.target.className;
  //   console.log(targetClass, e.target)
  //   if (
  //     targetClass === "ant-select-selection__rendered" ||
  //     targetClass === "ant-select-selection__placeholder" ||
  //     targetClass.indexOf("ant-select-selection--multiple") !== -1
  //   ) {
  //     this.setState({ visible: true });
  //   }
  // };

  render() {
    let { arrayObj } = this.state;
    const selectedList = () => {
      return arrayObj.map((val, i) => {
        return (
          <div key={val.key} className="PartmentSelect-list-item">
            <Icon type="user" /> {val.title || val.name}
            <Icon
              style={{ cursor:'pointer'}}
              onClick={() => {
                let checkedkeys = this.state.checkedkeys.slice();
                if (checkedkeys instanceof Array) {
                  checkedkeys = checkedkeys.filter(value => {
                    if (val.key === value) {
                      arrayObj.splice(i, 1);
                    }
                    return val.key !== value;
                  });
                } else {
                  checkedkeys = "null";
                  arrayObj = [];
                }

                this.setState({ checkedkeys, arrayObj });
              }}
              type="close-circle-o"
            />
          </div>
        );
      });
    };

    return (
      <div>
        <Modal
          title={this.props.title || "选择人员"}
          wrapClassName="PartmentSelect"
          closable={false}
          visible={this.state.visible}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          width={700}
          destroyOnClose={this.props.destroyOnClose}
        >
          <div className="PartmentSelect-title">
            <h2>选择：</h2>
            <h2>已选：</h2>
          </div>
          <div className="PartmentSelect-box">
            <SelectUser
              visible={this.state.visible}
              value={this.state.checkedkeys || []}
              type={this.props.type || "checkbox"}
              onSelect={(checkedkeys, obj) => {
                this.setState({ checkedkeys, arrayObj: obj });
              }}
            />
            <div className="PartmentSelect-wrap PartmentSelect-wrap-selected" style={{overflow:'auto'}}>
              {selectedList()}
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}

export default PartmentSelect;
