package com.bcxin.risk.org;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.contractor.dto.UserCompanyDto;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.Company;
import com.bcxin.risk.org.domain.CompanyDao;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("companyDao")
@SuppressWarnings("unchecked")

public class CompanyDaoImpl extends DaoImpl<Company> implements CompanyDao {

    public Company findCompanyByOid(Long oid){
        return selectById(oid);
    }
    @Override
    public List<Company> findCompanyList(UserCompanyDto userDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( userDto.getAuditActive() != null ) {
            criterionList.add(Restrictions.eq("auditactive", userDto.getAuditActive()));
        }
        if (StringUtil.isNotEmpty(userDto.getName()) ) {
            criterionList.add(Restrictions.eq("name", userDto.getName()));
        }
        if (StringUtil.isNotEmpty(userDto.getUserName()) ) {
            criterionList.add(Restrictions.eq("userName", userDto.getUserName()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
    @Override
    public Company findCompanyByOid(long oid) {
        return selectById(oid);
    }

    @Override
    public Company findCompanyByName(String name) {
        List list = selectList(CriterionWrapper.instance().eq("name",name));
        if (list != null && list.size() > 0) {
            return (Company)list.get(0);
        } else {
            return null;
        }
    }
}
