package com.bcxin.risk.common.dao;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.Message;
import com.bcxin.risk.common.dto.data.MessageDataDto;
import com.bcxin.risk.common.dto.search.MessageSearchDto;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class MessageDaoImpl extends DaoImpl<Message> implements MessageDao {

    @Override
    public Message findMessageByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<MessageDataDto> findMessageByDto(MessageSearchDto searchDto, Page page) {
        // 分页查询统一用hql
        String sql = "SELECT oid, " +
                             "DATE_FORMAT(createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                             "readStatus ," +
                             "content," +
                             "title,"+
                             "keyword," +
                             "url, " +
                             "checkFun " +
                            "FROM risk_message ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if ( searchDto.getUser() != null ) {
            wrapper.eq("user_id", searchDto.getUser().getOid());
        }
        if (StringUtil.isNotEmpty(searchDto.getReadStatus()) ) {
            wrapper.eq("readStatus", searchDto.getReadStatus());
        }
        wrapper.orderBy("createOn", false);
        wrapper.orderBy("oid",false);
        List<MessageDataDto> dtoList = Lists.newArrayList();

        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper,page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result->{  // 循环，把list的值放入MessageDataDto
            MessageDataDto dto = new MessageDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public Map<String, String> countMessage(User user) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sql = new StringBuilder("select "
                + " sum(case readStatus when '" + DictConst.READSTATUS_YD + "' then 1 else 0 end) as readtotal,"
                + " sum(case readStatus when '" + DictConst.READSTATUS_WD + "' then 1 else 0 end) as unreadtotal "
                + " from risk_message ");

        if (user == null) {
            return Maps.newHashMap();
        } else {
            wrapper.eq("user_id", user.getOid());
        }
        Map<String, String> countMap = Maps.newHashMap();
        Map<String, Object> result = queryMap(sql.toString(),wrapper);
        countMap.put("readtotal", result.get("readtotal") == null ? "0" : result.get("readtotal").toString());
        countMap.put("unreadtotal", result.get("unreadtotal") == null ? "0" : result.get("unreadtotal").toString());
        return countMap;
    }


    @Override
    public List<Message> findMessageList(MessageSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getUser() != null ) {
            criterionList.add(Restrictions.eq("user_id", searchDto.getUser().getOid()));
        }
        if (StringUtil.isNotEmpty(searchDto.getReadStatus()) ) {
            criterionList.add(Restrictions.eq("readStatus", searchDto.getReadStatus()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);

    }

    @Override
    public void updateMessage(Message message) {
        update(message);
    }

}
