package com.bcxin.risk.org;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.org.domain.OrgDao;
import com.bcxin.risk.org.dto.OrgDto;
import com.bcxin.risk.report.enums.ApprovalStatus;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.dto.data.UserDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("orgDao")
@SuppressWarnings("unchecked")

public class OrgDaoImpl extends DaoImpl<Org> implements OrgDao {


    @Override
    public Org findOrgByOid(Long oid) {  return selectById(oid);
    }
    @Override
    public List<Org> findOrgList(OrgDto orgDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (orgDto != null) {
            if (StringUtil.isNotEmpty(orgDto.getUserName())) {
                criterionList.add(Restrictions.eq("userName", orgDto.getUserName()));
            }
            if (StringUtil.isNotEmpty(orgDto.getName())) {
                criterionList.add(Restrictions.eq("name",orgDto.getName()));
            }
            if (StringUtil.isNotEmpty(orgDto.getOrgType())) {
                criterionList.add(Restrictions.eq("orgType",orgDto.getOrgType()));
            }
            if (StringUtil.isNotEmpty(orgDto.getApprovalStatus())) {
                criterionList.add(Restrictions.eq("approvalStatus",ApprovalStatus.convert(orgDto.getApprovalStatus())));
            }
            if (StringUtil.isNotEmpty(orgDto.getSelfSupport())){
                criterionList.add(Restrictions.eq("selfSupport",orgDto.getSelfSupport()));
            }
        }
        return selectPage(criterionList,page);
    }


    // 更新用户
    public int updateOrg(Org org){

        String sql = "Update risk_org " +
                       " SET code = '" + org.getCode() +"' , "+
                             " address = '"+ org.getAddress() +"' , "+
                              "province_id = '"+ org.getProvince_id() +"' , "+
                              "city_id = '"+ org.getCity_id() +"' , "+
                              "area_id = '"+ org.getArea_id() +"' , "+
                             " updateOn = SYSDATE() "+
                     " WHERE oid = "+org.getOid()  ;
        return executeSqlUpdate(sql);
    }

    @Override
    public List<Org>  findOrgListByDto(OrgDto dto) {
        List<Criterion> criterionList = Lists.newArrayList();
//        Object[] o = new Object[2];
//        o[0] = new String(DictConst.ORGTYPE_CBDW);
//        o[1] = new String(DictConst.ORGTYPE_DSFFWJG);
//        criterionList.add(Restrictions.in("orgType", o));
        criterionList.add(Restrictions.or(Restrictions.eq("isSync", DictConst.N),Restrictions.isNull("isSync")));
        if (StringUtil.isNotEmpty(dto.getOid())) {
            criterionList.add(Restrictions.eq("oid", dto.getOid()));
        }
        Order order = Order.desc("oid");
        return selectList(criterionList,order);

    }



}
