package com.bcxin.risk.report.material.dao;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.bcxin.risk.report.material.dto.MaterialFormMenuDTO;
import com.bcxin.risk.report.material.dto.MaterialFormMenuSearchDto;

import java.util.List;
import java.util.Map;

public interface MaterialFormMenuDao extends IDao<MaterialFormMenu> {

	List<MaterialFormMenu> selectListByDto(MaterialFormMenuSearchDto dto);

	List<MaterialFormMenu> findByActivity(Activity activity);

	MaterialFormMenu findMaterialFormMenuByOid(Long oid);

	List<MaterialFormMenuDTO> selectDTOByOrg(Activity activity);

	MaterialFormMenu findByActivityAndMenuCode(Activity activity,String menuCode);

	void deleteByActivityId(Long activityId);

	List<Map<String,Object>> getFormMenuRequired(Long activityId);

}
