/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.news;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.news.NewsDao;
import com.bcxin.risk.news.domain.News;
import com.bcxin.risk.news.dto.NewsDto;
import com.bcxin.risk.news.dto.search.NewsSearchDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="newsDao")
public class NewsDaoImpl
extends DaoImpl<News>
implements NewsDao {
    @Resource
    private BaseDao baseDao;

    public List<News> findNewsList(NewsSearchDTO searchDTO, DwzPage page) {
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)searchDTO.getNewsType())) {
            criterionList.add(Restrictions.eq((String)"newsType", (Object)searchDTO.getNewsType()));
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getProvinceId())) {
            criterionList.add(Restrictions.eq((String)"provinceId", (Object)searchDTO.getProvinceId()));
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getTitle())) {
            criterionList.add(Restrictions.like((String)"title", (Object)("%" + searchDTO.getTitle() + "%")));
        }
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc((String)"createOn"));
        if (page == null) {
            return this.baseDao.findByCriterion(News.class, (List)criterionList, orderList);
        }
        return this.baseDao.findByCriterionForPage(News.class, (List)criterionList, page, orderList);
    }

    public News findNewsByOid(Long oid) {
        return (News)this.selectById(oid);
    }

    public List<NewsDto> findNewsList(NewsSearchDTO searchDto, Page page) {
        String sql = "SELECT a.oid,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,DATE_FORMAT(a.publishDate,'%Y-%m-%d') AS publishDate,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,a.title,a.content,a.category,a.newsType,a.priority,a.attachment FROM sys_news a  WHERE 1=1 ";
        if (StringUtil.isNotEmpty((String)searchDto.getNewsType()) && !searchDto.getNewsType().equals("All")) {
            sql = sql + " AND a.newsType = '" + searchDto.getNewsType() + "'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getTitle())) {
            sql = sql + " AND a.title like '%" + searchDto.getTitle() + "%'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate()) && StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND a.publishDate >= '" + searchDto.getStartDate() + " 00:00:00'";
            sql = sql + " AND a.publishDate <= '" + searchDto.getEndDate() + " 00:00:00' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPriority())) {
            if (searchDto.getPriority().equalsIgnoreCase("priority")) {
                sql = sql + " ORDER BY a.publishDate DESC";
            }
            if (searchDto.getPriority().equalsIgnoreCase("important")) {
                sql = sql + " ORDER BY a.priority ASC,a.publishDate DESC";
            }
        } else {
            sql = sql + " ORDER BY a.publishDate DESC";
        }
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            NewsDto dto = new NewsDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<NewsDto> findNewNotice() {
        Page page = new Page();
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select * from sys_news";
        ArrayList dtoList = Lists.newArrayList();
        wrapper.orderBy("createOn", false);
        wrapper.orderBy("oid", false);
        Page pageList = this.queryMapsPage("select * from sys_news ", (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            NewsDto dto = new NewsDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public void deleteByUUID(String uuid) {
        DeleteWrapper wrapper = DeleteWrapper.instance();
        wrapper.eq("uuid", (Object)uuid);
        this.delete((Wrapper)wrapper);
    }

    public void deleteAll() {
        DeleteWrapper wrapper = DeleteWrapper.instance();
        this.delete((Wrapper)wrapper);
    }

    public News selectByUUID(String uuid) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("uuid", (Object)uuid);
        return (News)this.selectOne((Wrapper)wrapper);
    }
}

