/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import com.bcxin.risk.activity.Venue;
import com.bcxin.risk.activity.VenueDao;
import com.bcxin.risk.activity.dto.search.VenueSearchDTO;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class VenueDaoImpl
extends DaoImpl<Venue>
implements VenueDao {
    public Venue getVenueByName(String name) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"name", (Object)name));
        Order order = Order.desc((String)"oid");
        List list = this.selectPage(criterionList, null, order);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (Venue)list.get(0);
    }

    public List<Venue> getStandardVenue(Region province, Region city) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"standard", (Object)"1"));
        if (province != null) {
            criterionList.add(Restrictions.eq((String)"province", (Object)province));
        }
        if (city != null) {
            criterionList.add(Restrictions.eq((String)"city", (Object)city));
        }
        return this.selectList(criterionList);
    }

    public Venue findVenueByOid(Long oid) {
        return (Venue)this.selectById(oid);
    }

    public List<Venue> findVenueList(VenueSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDto.getOrg() != null) {
            wrapper.eq("org", (Object)searchDto.getOrg());
        }
        if (searchDto.getProvince() != null) {
            wrapper.eq("province", (Object)searchDto.getProvince());
        }
        if (searchDto.getCity() != null) {
            wrapper.eq("city", (Object)searchDto.getCity());
        }
        if (searchDto.getArea() != null) {
            wrapper.eq("area", (Object)searchDto.getArea());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            wrapper.eq("name", (Object)searchDto.getName());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStandard())) {
            wrapper.eq("standard", (Object)searchDto.getStandard());
        }
        if (page == null) {
            return this.selectList((Wrapper)wrapper);
        }
        return this.selectPage((Wrapper)wrapper, page).getRecords();
    }
}

