/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util.compose;

import java.math.BigInteger;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class AESUtil1 {
    private static final String KEY = "abcdeabcde123v56";
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";
    private static final Logger LOGGER = LoggerFactory.getLogger(AESUtil1.class);

    public static String aesDecrypt(String encrypt) {
        try {
            return AESUtil1.aesDecrypt(encrypt, KEY);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String aesEncrypt(String content) {
        try {
            return AESUtil1.aesEncrypt(content, KEY);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String binary(byte[] bytes, int radix) {
        return new BigInteger(1, bytes).toString(radix);
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] base64Decode(String base64Code) throws Exception {
        return StringUtils.isEmpty((CharSequence)base64Code) ? null : Base64Utils.decodeFromString((String)base64Code);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(1, new SecretKeySpec(encryptKey.getBytes(), "AES"));
        return cipher.doFinal(content.getBytes("utf-8"));
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return AESUtil1.base64Encode(AESUtil1.aesEncryptToBytes(content, encryptKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(2, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty((CharSequence)encryptStr) ? null : AESUtil1.aesDecryptByBytes(AESUtil1.base64Decode(encryptStr), decryptKey);
    }

    public static void main(String[] args) throws Exception {
        String content = "bcx666666";
        System.out.println("\u52a0\u5bc6\u524d\uff1a" + content);
        System.out.println("\u52a0\u5bc6\u5bc6\u94a5\u548c\u89e3\u5bc6\u5bc6\u94a5\uff1aabcdeabcde123v56");
        String encrypt = AESUtil1.aesEncrypt(content);
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + encrypt);
        String decrypt = AESUtil1.aesDecrypt(encrypt);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + decrypt);
    }
}

