/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.converter.cache;

import com.bcxin.risk.hibernateplus.converter.utils.StrUtils;
import com.bcxin.risk.hibernateplus.exceptions.HibernatePlusException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class IntrospectionCache {
    public static final Map<Class<?>, Object> classCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;

    private IntrospectionCache(Class<?> beanClass) {
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            Class<?> classToFlush = beanClass;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
            this.propertyDescriptorCache = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                if (Class.class.equals(beanClass) && "classLoader".equals(pd.getName())) continue;
                this.propertyDescriptorCache.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException ex) {
            throw new HibernatePlusException("\u521d\u59cb\u5316\u7f13\u5b58bean\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", ex);
        }
    }

    public static IntrospectionCache forClass(Class<?> beanClass) {
        IntrospectionCache introspectionCache;
        Object value = classCache.get(beanClass);
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            introspectionCache = (IntrospectionCache)ref.get();
        } else {
            introspectionCache = (IntrospectionCache)value;
        }
        if (introspectionCache == null) {
            introspectionCache = new IntrospectionCache(beanClass);
            classCache.put(beanClass, introspectionCache);
        }
        return introspectionCache;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pds = new PropertyDescriptor[this.propertyDescriptorCache.size()];
        int i = 0;
        Iterator<PropertyDescriptor> iterator = this.propertyDescriptorCache.values().iterator();
        while (iterator.hasNext()) {
            PropertyDescriptor pd;
            pds[i] = pd = iterator.next();
            ++i;
        }
        return pds;
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.propertyDescriptorCache.get(name);
        if (pd == null && StrUtils.isNotBlank(name) && (pd = this.propertyDescriptorCache.get(name.substring(0, 1).toLowerCase() + name.substring(1))) == null) {
            pd = this.propertyDescriptorCache.get(name.substring(0, 1).toUpperCase() + name.substring(1));
        }
        return pd;
    }
}

