/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.converter;

import com.bcxin.risk.hibernateplus.converter.EnumStringConverter;
import com.bcxin.risk.hibernateplus.converter.TypeConverter;
import com.bcxin.risk.hibernateplus.converter.cache.IntrospectionCache;
import com.bcxin.risk.hibernateplus.converter.config.BeanConverterConfig;
import com.bcxin.risk.hibernateplus.converter.page.Pageable;
import com.bcxin.risk.hibernateplus.converter.type.IEnum;
import com.bcxin.risk.hibernateplus.converter.utils.ClassUtils;
import com.bcxin.risk.hibernateplus.converter.utils.NameUtils;
import com.bcxin.risk.hibernateplus.converter.utils.StrUtils;
import com.bcxin.risk.hibernateplus.exceptions.HibernatePlusException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BeanConverter {
    public static <T> List<T> underlineKeyMapToBean(List<Map<String, Object>> mapList, Class<T> beanClass) {
        return BeanConverter.mapToBean(mapList, beanClass, Character.valueOf('_'));
    }

    public static <T> List<T> mapToBean(List<Map<String, Object>> mapList, Class<T> beanClass) {
        return BeanConverter.mapToBean(mapList, beanClass, null);
    }

    public static <T> List<T> mapToBean(List<Map<String, Object>> mapList, Class<T> beanClass, Character delimiter) {
        ArrayList<T> beanList = new ArrayList<T>(mapList == null ? 0 : mapList.size());
        if (mapList == null) {
            return beanList;
        }
        for (Map<String, Object> map : mapList) {
            T t = BeanConverter.mapToBean(map, beanClass, delimiter);
            beanList.add(t);
        }
        return beanList;
    }

    public static <T> T underlineKeyMapToBean(Map<String, Object> map, Class<T> beanClass) {
        return BeanConverter.mapToBean(map, beanClass, Character.valueOf('_'));
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        return BeanConverter.mapToBean(map, beanClass, null);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass, Character delimiter) {
        Object bean = ClassUtils.newInstance(beanClass);
        if (map == null) {
            return (T)bean;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Method writeMethod;
            PropertyDescriptor targetPd;
            Object value = entry.getValue();
            if (value == null) continue;
            String name = entry.getKey();
            if (delimiter != null) {
                String string = name = StrUtils.indexOf(name, delimiter.charValue()) != -1 ? NameUtils.getCamelName(name, delimiter.charValue()) : name.toLowerCase();
            }
            if ((targetPd = BeanConverter.getPropertyDescriptor(beanClass, name)) == null || (writeMethod = targetPd.getWriteMethod()) == null) {
                if (!Pageable.class.isAssignableFrom(beanClass)) continue;
                ((Pageable)bean).put(name, value);
                continue;
            }
            value = BeanConverter.typeConvert(value.getClass(), targetPd.getPropertyType(), value);
            ClassUtils.invokeMethod(writeMethod, bean, value);
        }
        return (T)bean;
    }

    public static <T> List<T> convert(Class<T> clazz, List<?> list) {
        return BeanConverter.convert(clazz, list, null);
    }

    public static <T> List<T> convert(Class<T> clazz, List<?> list, String[] ignoreProperties) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (list == null || list.isEmpty()) {
            return resultList;
        }
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                T t = clazz.newInstance();
                Object obj = iterator.next();
                t = BeanConverter.convert(t, obj, ignoreProperties);
                resultList.add(t);
            }
            catch (Exception e) {
                throw new HibernatePlusException("\u5217\u8868\u8f6c\u6362\u5931\u8d25", e);
            }
        }
        return resultList;
    }

    public static <T> T convert(T target, Object source) {
        return BeanConverter.convert(target, source, null);
    }

    public static <T> T convert(T target, Object source, String[] ignoreProperties) {
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        BeanConverter.copySameProperties(target, source, ignoreList);
        return target;
    }

    private static void copySameProperties(Object target, Object source, List<String> ignoreList) {
        PropertyDescriptor[] targetPds;
        for (PropertyDescriptor targetPd : targetPds = BeanConverter.getPropertyDescriptors(target.getClass())) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanConverter.getPropertyDescriptor(source.getClass(), targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            Method readMethod = sourcePd.getReadMethod();
            Object value = ClassUtils.invokeMethod(readMethod, source);
            Method writeMethod = targetPd.getWriteMethod();
            value = BeanConverter.typeConvert(sourcePd.getPropertyType(), targetPd.getPropertyType(), value);
            ClassUtils.invokeMethod(writeMethod, target, value);
        }
    }

    private static Object typeConvert(Class<?> sourcePropertyType, Class<?> targetPropertyType, Object value) {
        if (value == null) {
            return null;
        }
        Map<String, TypeConverter> converters = BeanConverter.getConverters();
        if (converters == null || converters.isEmpty()) {
            return value;
        }
        TypeConverter typeConverter = converters.get(BeanConverterConfig.getCovertKey(sourcePropertyType, targetPropertyType));
        if (typeConverter != null) {
            return typeConverter.convert(sourcePropertyType, targetPropertyType, value);
        }
        for (TypeConverter converter : converters.values()) {
            if (!converter.getSourceTypeClass().isAssignableFrom(sourcePropertyType) || !converter.getTargetTypeClass().isAssignableFrom(targetPropertyType)) continue;
            return converter.convert(sourcePropertyType, targetPropertyType, value);
        }
        return value;
    }

    public static void registerConverter(TypeConverter converter) {
        BeanConverterConfig.getInstance().registerConverter(converter);
    }

    public static void unregisterConverter(Class<?> sourceClass, Class<?> targetClass) {
        BeanConverterConfig.getInstance().unregisterConverter(sourceClass, targetClass);
    }

    public static void clearConverter() {
        BeanConverterConfig.getInstance().clearConverter();
    }

    public static Map<String, TypeConverter> getConverters() {
        BeanConverter.registerConverter(new EnumStringConverter(IEnum.class, String.class));
        BeanConverter.registerConverter(new EnumStringConverter(String.class, IEnum.class));
        return BeanConverterConfig.getInstance().getConverters();
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        IntrospectionCache introspectionCache = IntrospectionCache.forClass(beanClass);
        return introspectionCache.getPropertyDescriptors();
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) {
        IntrospectionCache introspectionCache = IntrospectionCache.forClass(beanClass);
        return introspectionCache.getPropertyDescriptor(propertyName);
    }
}

