package com.bcxin.risk.base.dao;

import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.type.Type;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 基础类dao
 * @author admin
 *
 */
public interface BaseDao {

	abstract Criteria createCriteria(Class clazz);

	abstract <T> T get(Class<T> clazz, Long oid);
	
	abstract <T> T load(Class<T> clazz, Long oid);

	abstract void save(Object obj);
	
	boolean batchSave(List<Object> list);

	abstract void update(Object obj);
	
	abstract void saveOrUpdate(Object obj);

	abstract void delete(Object obj);

	abstract <T> List findAll(Class<T> clazz);

	abstract <T> List findByCriterion(Class<T> clazz, Criterion criterion);

	abstract List findByHql(String queryString, Object value) throws Exception;

	abstract <T> List findByHql(String queryString, Object[] values);

	abstract List findByHql(String queryString) throws Exception;

	<T>T findByCriterionToUnique(Class<T> clazz, Criterion criterion);
	
	List find(String queryString, Map paras);
	
	List findPageByHql(String queryString, Map paras, Page page);
	
	List getObejctByCollection(String queryString, String name, Collection collection);
	
	List getObejctByCollection(String queryString, String name, Collection collection, Type type);
	
	<T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page);

	<T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page, Order order);
	
	<T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page, List<Order> orderList);
	
	<T>List findByCriterion(Class<T> clazz, List<Criterion> criterionList);
	
	<T>List findByCriterion(Class<T> clazz, List<Criterion> criterionList, List<Order> orderList);
	
	<T>List findByCriterion(Class<T> clazz, List<Criterion> criterionList, Order order);
	
	int executeUpdate(final String sql);
	
	List findBySQL(String sql, final Object[] values);	
	
	void evictObj(Object obj);
	
	void mergeObj(Object obj);
	
	<T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, int pagesize, int offset);
	
	<T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, int pagesize, int offset, Order order);
	
}