/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.UserRoleDao;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.domain.UserRole;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="userRole")
public class UserRoleDaoImpl
extends DaoImpl<UserRole>
implements UserRoleDao {
    public List<UserRole> findUserRoleByName(String name, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"userName", (Object)name));
        Order order = Order.desc((String)"createon");
        return this.selectPage(criterionList, page, order);
    }

    public List<UserRole> findUserRoleByUserid(long userid, Page page) {
        return this.selectPage((Criterion)Restrictions.eq((String)"user_id", (Object)userid), page);
    }

    public UserRole findUserRoleByOid(Long oid) {
        return (UserRole)this.selectById(oid);
    }

    public void deleteUserRole(UserRole userRole) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (userRole.getRole() != null) {
            wrapper.eq("role_id", (Object)userRole.getRole().getOid());
        }
        if (userRole.getUser() != null) {
            wrapper.eq("user_id", (Object)userRole.getUser().getOid());
        }
        this.delete((Wrapper)wrapper);
    }

    public void insertUserRole(List<UserRole> userRoleList) {
        String sql = "INSERT INTO risk_user_role (createOn,role_id,user_id) VALUES ";
        for (UserRole userRole : userRoleList) {
            sql = sql + "(SYSDATE()," + userRole.getRole().getOid() + "," + userRole.getUser().getOid() + "),";
        }
        sql = sql.substring(0, sql.length() - 1);
        this.executeSqlUpdate(sql);
    }

    public void deleteByUser(User user) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (user != null) {
            wrapper.eq("user_id", (Object)user.getOid());
        }
        this.delete((Wrapper)wrapper);
    }
}

