export const hourTimeRange = [
  Array.from({ length: 5 }, (_, i) => i.toString() + '小时'),
  Array.from({ length: 60 }, (_, i) => i.toString() + '分钟'),
];

Object.freeze(hourTimeRange);

export const formatHourTime = (value: number[]) => {
  const result = [];
  if (value[0] !== 0) {
    result.push(hourTimeRange[0][value[0]]);
  }
  result.push(hourTimeRange[1][value[1]]);
  return result.join('');
}

/**
 * 计算两个时间差(小时分钟)
 * @param {startDate} 开始时间 9:00
 * @param {endDate} 结束时间 18:00
 * @returns {String}
 */
export const getInervalHour = (startDate: number, endDate: number) => {
  startDate = new Date(`1970-01-01 ${startDate}`).getTime();
  endDate = new Date(`1970-01-01 ${endDate}`).getTime();
  let dateDiff = endDate - startDate
  let residue1 = dateDiff % (24 * 3600 * 1000)
  let hours = Math.floor(residue1 / (3600 * 1000))
  let residue2 = residue1 % (3600 * 1000)
  let minutes = Math.floor(residue2 / (60 * 1000))
  return [hours, minutes]
}

/**
 * 计算两个时间差(小时分钟)
 * @param {startDate} 开始时间 9:00
 * @param {endDate} 结束时间 18:00
 * @returns {String}
 */
export const getInervalTwoHour = (startDate: number, endDate: number, start: number, end: number) => {
  startDate = new Date(`1970-01-01 ${startDate}`).getTime();
  endDate = new Date(`1970-01-01 ${endDate}`).getTime();
 

  let dateDiff2 = 0;
  if (start && end) {
    start = new Date(`1970-01-01 ${start}`).getTime();
    end = new Date(`1970-01-01 ${end}`).getTime();
    dateDiff2 = end - start;
  }

  let dateDiff = endDate - startDate - dateDiff2
  let residue1 = dateDiff % (24 * 3600 * 1000)
  let hours = Math.floor(residue1 / (3600 * 1000))
  let residue2 = residue1 % (3600 * 1000)
  let minutes = Math.floor(residue2 / (60 * 1000))
  return [hours, minutes]
}

/**
 * 计算两个时间和(小时分钟)
 * @param {startDate} 开始时间 9:00
 * @param {endDate} 结束时间 18:00
 * @returns {String}
 */
export const getHour = (startDate: number, endDate: number, start: number, end: number) => {
  startDate = new Date(`1970-01-01 ${startDate}`).getTime();
  endDate = new Date(`1970-01-01 ${endDate}`).getTime();

  let dateDiff2 = 0;
  if (start && end) {
    start = new Date(`1970-01-01 ${start}`).getTime();
    end = new Date(`1970-01-01 ${end}`).getTime();
    dateDiff2 = end - start;
  }

  let dateDiff = endDate - startDate + dateDiff2
  let residue1 = dateDiff % (24 * 3600 * 1000)
  let hours = Math.floor(residue1 / (3600 * 1000))
  let residue2 = residue1 % (3600 * 1000)
  let minutes = Math.floor(residue2 / (60 * 1000))
  return [hours, minutes]
}
