/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.spring.adpater.config;

import com.bcxin.saas.core.InjectResolver;
import com.bcxin.saas.core.InjectResolverFactory;
import com.bcxin.saas.core.components.CacheProvider;
import com.bcxin.saas.core.components.CacheProviderFactory;
import com.bcxin.saas.core.components.ClientAccessProvider;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.components.EncryptProvider;
import com.bcxin.saas.core.components.FeatureOptionChecker;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.domains.readers.DepartmentDbReader;
import com.bcxin.saas.domains.readers.DepartmentDbReaderImpl;
import com.bcxin.saas.domains.readers.DomainRelationDbReader;
import com.bcxin.saas.domains.readers.DomainRelationDbReaderImpl;
import com.bcxin.saas.domains.readers.EmployeeDbReader;
import com.bcxin.saas.domains.readers.EmployeeDbReaderImpl;
import com.bcxin.saas.domains.readers.RbacDbReader;
import com.bcxin.saas.domains.readers.RbacDbReaderImpl;
import com.bcxin.saas.domains.repositories.DepartmentRepository;
import com.bcxin.saas.domains.repositories.DomainRelationRepository;
import com.bcxin.saas.domains.repositories.EmployeeRepository;
import com.bcxin.saas.domains.repositories.RbacAppRepository;
import com.bcxin.saas.domains.repositories.RbacOptionRepository;
import com.bcxin.spring.adpater.config.InjectFactory;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ComponentScan(basePackages={"com.bcxin.saas"})
public class SaasSpringConfig
implements ApplicationContextAware,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(SaasSpringConfig.class);
    private ApplicationContext applicationContext;

    @Bean
    public CacheProvider cacheProvider() {
        return CacheProviderFactory.getCacheProvider();
    }

    @Bean
    public DomainRelationDbReader domainRelationDbReader(DomainRelationRepository domainRelationRepository, CacheProvider cacheProvider) {
        return new DomainRelationDbReaderImpl(domainRelationRepository, cacheProvider);
    }

    @Bean
    public DepartmentDbReader departmentDbReader(DepartmentRepository departmentRepository) {
        return new DepartmentDbReaderImpl(departmentRepository);
    }

    @Bean
    public EmployeeDbReader employeeDbReader(EmployeeRepository employeeRepository) {
        return new EmployeeDbReaderImpl(employeeRepository);
    }

    @Bean
    public RbacDbReader rbacDbReader(DistributedCacheProvider distributedCacheProvider, RbacAppRepository rbacAppRepository, RbacOptionRepository rbacOptionRepository) {
        return new RbacDbReaderImpl(distributedCacheProvider, rbacAppRepository, rbacOptionRepository);
    }

    public void setApplicationContext(final ApplicationContext appContext) throws BeansException {
        this.applicationContext = appContext;
        InjectFactory.setApplicationContext(appContext);
        InjectResolverFactory.setInjectResolver((InjectResolver)new InjectResolver(){

            public <T> T resolve(Class<T> tClass) {
                return (T)appContext.getBean(tClass);
            }

            public <T> T resolve(String beanName) {
                return (T)appContext.getBean(beanName);
            }
        });
    }

    @Bean
    public EncryptProvider encryptProvider() {
        return new EncryptProvider.EncryptProviderImpl();
    }

    @Bean
    public JsonProvider jsonProvider() {
        return new JsonProvider.JsonProviderImpl();
    }

    @Bean
    public ClientAccessProvider clientAccessProvider(JsonProvider jsonProvider, EncryptProvider encryptProvider) {
        return new ClientAccessProvider.ClientAccessProviderImpl(jsonProvider, encryptProvider);
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ClientAccessProvider clientAccessProvider = (ClientAccessProvider)this.applicationContext.getBean(ClientAccessProvider.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 50);
        Date expiredTime = calendar.getTime();
        String token = clientAccessProvider.createToken("Ai6hllhNjS2ull9TKGb", expiredTime);
        logger.error("\u7ba1\u7406\u7aefv2.App token:{}", (Object)token);
        String devToken = clientAccessProvider.createToken("__A7yVvj33RRHsOLgvt0d", expiredTime);
        logger.error("\u6d4b\u8bd5\u7ad9\u70b9v2.yy_super.App token:{}", (Object)devToken);
        String prodToken = clientAccessProvider.createToken("__8Sprpm5xUGOiYzD0n61", expiredTime);
        logger.error("\u6b63\u5f0f\u7ad9\u70b9v2.yy_super.App token:{}", (Object)prodToken);
        System.err.println("V3.\u5f00\u59cb\u628aSystem.err\u5207\u6362\u5230Logger\u6765\u5b9e\u73b0");
        System.setErr(CustomSystemErrorPrintStream.instance);
    }

    private static class CustomSystemErrorPrintStream
    extends PrintStream {
        private static final Logger logger = LoggerFactory.getLogger(CustomSystemErrorPrintStream.class);
        private static CustomSystemErrorPrintStream instance = new CustomSystemErrorPrintStream(System.out);

        public CustomSystemErrorPrintStream(OutputStream out) {
            super(out);
        }

        @Override
        public void print(String s) {
            if (!FeatureOptionChecker.isEnable((String)"ENABLE_PRINTED")) {
                return;
            }
            if (StringUtils.hasLength((String)s)) {
                logger.error(s);
            }
        }

        @Override
        public void println() {
            if (!FeatureOptionChecker.isEnable((String)"ENABLE_PRINTED")) {
                return;
            }
            logger.error("\n");
        }

        @Override
        public void println(Object x) {
            if (!FeatureOptionChecker.isEnable((String)"ENABLE_PRINTED")) {
                return;
            }
            super.println(x);
        }

        @Override
        public void println(String x) {
            if (!FeatureOptionChecker.isEnable((String)"ENABLE_PRINTED")) {
                return;
            }
            super.println(x);
        }
    }
}

