package com.bcxin.saas.logging.jdbcs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

public class Log4j2DataSourceInitializer implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(Log4j2DataSourceInitializer.class);

    public Log4j2DataSourceInitializer(){
        logger.error("初始化Log4j2DataSourceInitializer");
    }

    @Override
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent contextRefreshedEvent) {
        Environment environment = contextRefreshedEvent.getEnvironment();

        try {
            Log4j2JdbcConnectionFactory.setDataSource(environment);
        } catch (Exception e) {
            logger.error("获取数据源信息发生异常", e);
        }
    }
}
