package com.bcxin.saas.logging;

import com.bcxin.saas.core.logs.Logging;
import org.apache.logging.log4j.core.LogEvent;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;

@Component
public class JdbcAppenderConnectionFactory implements ApplicationContextAware {
    private static DataSource _selectedDataSource;
    public static DataSource getUsableDataSource() {
        if (_selectedDataSource == null) {
            if (JdbcAppenderConnectionFactory.applicationContext == null) {
                return null;
            }

            Map<String, Object> loggingDataSources =
                    JdbcAppenderConnectionFactory.applicationContext.getBeansWithAnnotation(Logging.class);
            if (!loggingDataSources.isEmpty()) {
                Optional<DataSource> dataSourceOptional = loggingDataSources.values().stream().filter(ii -> ii instanceof DataSource)
                        .map(ii -> (DataSource) ii).findFirst();
                if (dataSourceOptional.isPresent()) {
                    _selectedDataSource = dataSourceOptional.get();
                }
            }

            if (_selectedDataSource == null) {
                _selectedDataSource = (DataSource) JdbcAppenderConnectionFactory.applicationContext.getBean("loggerDataSource");
            }
        }

        return _selectedDataSource;
    }

    public static Connection getConnection() throws SQLException {
        DataSource dataSource = getUsableDataSource();
        if (dataSource == null) {
            return null;
        }

        return dataSource.getConnection();
    }

    private static ApplicationContext applicationContext;
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        JdbcAppenderConnectionFactory.applicationContext = applicationContext;
    }

    public static String getRouteSelectedAppender(LogEvent logEvent, String consoleAppender, String jdbcAppender) {
        return consoleAppender;
        /*
        if (getUsableDataSource() == null) {
            return consoleAppender;
        }

        if (!logEvent.getLoggerName().contains("com.bcxin") && !logEvent.getLoggerName().contains("cn.myapps")) {
            return consoleAppender;
        }

        return jdbcAppender;
         */
    }
}
