/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.logging.jdbcs;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class Log4j2JdbcConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(Log4j2JdbcConnectionFactory.class);
    private static volatile DataSource dataSource;
    private static volatile Properties properties;

    public Log4j2JdbcConnectionFactory() {
        System.err.println("\u521d\u59cb\u5316Log4j2JdbcConnectionFactory\u7684\u5b9e\u4f8b\u5bf9\u8c61\u4fe1\u606f");
    }

    public static void setDataSource(Environment env) throws Exception {
        if (properties == null) {
            String url = env.getProperty("spring.datasource.url");
            String username = env.getProperty("spring.datasource.username");
            String password = env.getProperty("spring.datasource.password");
            String driver = env.getProperty("spring.datasource.driver-class-name");
            if (StringUtils.hasLength((String)url)) {
                properties = new Properties();
                properties.put("driverClassName", driver);
                properties.put("url", url);
                properties.put("username", username);
                properties.put("password", password);
            }
        }
    }

    public static Connection getConnection() throws SQLException {
        if (dataSource == null) {
            if (properties == null) {
                throw new RuntimeException("\u8bf7\u5148\u8c03\u7528setDataSource\u65b9\u6cd5");
            }
            try {
                dataSource = DruidDataSourceFactory.createDataSource((Properties)properties);
            }
            catch (Exception ex) {
                logger.error("\u521b\u5efaDataSource\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
        return dataSource.getConnection();
    }

    private static interface Singleton {
        public static final Log4j2JdbcConnectionFactory INSTANCE = new Log4j2JdbcConnectionFactory();
    }
}

