/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.logging;

import com.alibaba.fastjson.JSON;
import com.bcxin.saas.core.components.FeatureOptionChecker;
import com.bcxin.saas.core.logs.LoggerEventMessage;
import com.bcxin.saas.core.logs.LoggerProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class LoggerProviderImpl
implements LoggerProvider {
    public static String JDBC_APPENDER_ENABLED_PRINT_FLAG = "ENABLE_PRINTED";
    private final Logger logger = LoggerFactory.getLogger(LoggerProviderImpl.class);

    public void append(LoggerEventMessage message) {
        if (!FeatureOptionChecker.isEnable((String)JDBC_APPENDER_ENABLED_PRINT_FLAG)) {
            return;
        }
        String detailJson = null;
        try {
            detailJson = JSON.toJSONString((Object)message.getParams());
        }
        catch (Exception ex) {
            detailJson = "\u6570\u636e\u5e8f\u5217\u5316\u5f02\u5e38:" + ExceptionUtils.getStackMessage((Throwable)ex);
        }
    }

    public void appends(Collection<LoggerEventMessage> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            return;
        }
        messages.forEach(ms -> this.append((LoggerEventMessage)ms));
    }
}

