package cn.myapps.versions;

import java.util.Collection;
import java.util.Date;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.common.dao.versions.FileSystemVersionsDAO;
import cn.myapps.common.model.versions.Versions;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.run.Start;
import cn.myapps.util.sequence.Sequence;
import cn.myapps.versions.service.VersionsService;

/**
 * Created by ZhanBo-ZJB on 2017/9/19.
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= Start.class)
public class FileSystemVersinsDAOTest {
    @Test
    public void testSave() throws Exception{
        Versions versionsVO = new Versions();

        versionsVO.setName("2");
        versionsVO.setId(Sequence.getDesignTimeSequence());
        versionsVO.setType(Versions.TYPE_SOURCECODE_UPGRADE);
        versionsVO.setRemark("这是一个版本测试");
        versionsVO.setUpgrade_date(new Date());
        versionsVO.setVersion_name("1.0测试版本");
        versionsVO.setVersion_number("1.0");

        VersionsService versionsService = (VersionsService) DesignTimeServiceFactory.resolve(VersionsService.class);
        versionsService.save(versionsVO);
    }

    @Test
    public void testListByName() throws Exception {
        Collection<Versions> list = new FileSystemVersionsDAO(Versions.class).queryByVersionAndType("2","1.0",1);

        //System.out.println("versions count ------->"+list.size());

        for(Versions versionsVO :list){
            //System.out.println("version name -------->"+ versionsVO.getName());
            //System.out.println("class --------->"+ versionsVO.getClass());
        }
    }
}
