package cn.myapps.upgrade.service;

import cn.myapps.common.DesignTimeService;
import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.crossreport.CrossReportVO;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.excelimport.IMPMappingConfigVO;
import cn.myapps.common.model.macrorepository.RepositoryVO;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.multilanguage.MultiLanguage;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.statelabel.StateLabel;
import cn.myapps.common.model.stylerepository.StyleRepositoryVO;
import cn.myapps.common.model.summary.SummaryCfgVO;
import cn.myapps.common.model.task.Task;
import cn.myapps.common.model.validaterepository.ValidateRepositoryVO;
import cn.myapps.common.model.widget.PageWidget;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.designtime.crossreport.definition.service.CrossReportDesignTimeService;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.dts.excelimport.config.service.IMPMappingConfigDesignTimeService;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.macro.repository.service.RepositoryDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.multilanguage.service.MultiLanguageService;
import cn.myapps.designtime.report.service.ReportDesignTimeService;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.statelabel.service.StateLabelService;
import cn.myapps.designtime.style.repository.service.StyleRepositoryDesignTimeService;
import cn.myapps.designtime.summary.service.SummaryCfgDesignTimeService;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.designtime.validate.repository.service.ValidateRepositoryDesignTimeService;
import cn.myapps.designtime.view.column.service.ColumnDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.designtime.widget.service.PageWidgetDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.run.Start;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.upgrade.dao.UpgradeDao;
import cn.myapps.upgrade.util.DaoManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.Collection;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= Start.class)
public class UpgradeServiceTest {

	private UpgradeDao upgradeDao;
	
	private Collection<String> msg = new ArrayList<String>();

	/**
	 * 获取DAO
	 */
	@Before
	public void getUpGradeDao() {
		try {
			upgradeDao = DaoManager.getUpGradeDAO();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Test
	public void testService() {
		UpgradeService up = new UpgradeServiceImpl();
		try {
			String doUpGrade = up.doUpGrade();
			//System.out.println(doUpGrade);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Test
	public void queryApplications() throws Exception {
		
		//TODO ok
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryApplications();
		ApplicationDesignTimeService applicationProcess = (ApplicationDesignTimeService) DesignTimeServiceFactory
				.resolve(ApplicationDesignTimeService.class);
		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof Application) {
				Application obj = (Application) tmp;
				applicationProcess.save(obj);
			}
		}

	}

	@Test
	public void queryDataSources() throws Exception {
		//TODO ok
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryDataSources();

		DataSourceDesignTimeService dataSourceProcess = (DataSourceDesignTimeService) DesignTimeServiceFactory
				.resolve(DataSourceDesignTimeService.class);
		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof DataSource) {
				DataSource obj = (DataSource) tmp;
				dataSourceProcess.save(obj);
			}
		}
	}

	@Test
	public void queryModules() throws Exception {
		// TODO ok
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryModules();
		ModuleDesignTimeService moduleService = (ModuleDesignTimeService) DesignTimeServiceFactory.resolve(ModuleDesignTimeService.class);
		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof Module) {
				Module obj = (Module) tmp;
				moduleService.save(obj);
			}
		}
	}

	@Test
	public void queryForms() throws Exception {

		
		queryModules();
		queryDataSources();
		
		//TODO ok
		FormDesignTimeService formService = (FormDesignTimeService) DesignTimeServiceFactory.resolve(FormDesignTimeService.class);
		ActivityDesignTimeService actService = (ActivityDesignTimeService) DesignTimeServiceFactory.resolve(ActivityDesignTimeService.class);

		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryForms();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof Form) {
				Form obj = (Form) tmp;
				//System.out.println("parentid:    "+ obj.getParentId() + "        id:    " + obj.getId() + "-------" + obj.getName() + "-----" + obj.getPath());
//				save(formService,obj);
			}

			if (tmp instanceof Activity) {
				Activity obj = (Activity) tmp;
				save(actService,obj);
			}
		}
	}

	@Test
	public void queryViews() throws Exception {
		
		//TODO ok
		//queryModules();

		ViewDesignTimeService viewService = (ViewDesignTimeService) DesignTimeServiceFactory.resolve(ViewDesignTimeService.class);
		ColumnDesignTimeService colService = (ColumnDesignTimeService) DesignTimeServiceFactory.resolve(ColumnDesignTimeService.class);
		ActivityDesignTimeService actService = (ActivityDesignTimeService) DesignTimeServiceFactory.resolve(ActivityDesignTimeService.class);

		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryViews();

		for (FileSystemDesignTimeSerializable tmp : list) {
			/*if (tmp instanceof View) {
				View obj = (View) tmp;
				save(viewService, obj);
			}*/

			if (tmp instanceof Activity) {
				Activity obj = (Activity) tmp;
				
                if(obj.getId().equals("11e6-0c40-1cc71c37-be8f-a1e944b5b7c9") && obj.getParentId().equals("11e6-dbc1-3de88bd3-ad00-8d81212e6562")){
                	save(actService, obj);
                }
				
			}

			/*if (tmp instanceof Column) {
				Column obj = (Column) tmp;
				save(colService, obj);
			}*/
		}
	}

	@Test
	public void querySummarys() throws Exception {

		SummaryCfgDesignTimeService reminderProcess = (SummaryCfgDesignTimeService) DesignTimeServiceFactory
				.resolve(SummaryCfgDesignTimeService.class);
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.querySummarys();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof SummaryCfgVO) {
				SummaryCfgVO obj = (SummaryCfgVO) tmp;
				reminderProcess.save(obj);
			}
		}
	}

	@Test
	public void queryFlows() throws Exception {

		BillDefiDesignTimeService billDefiService = (BillDefiDesignTimeService) DesignTimeServiceFactory
				.resolve(BillDefiDesignTimeService.class);

		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryFlows();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof BillDefiVO) {
				BillDefiVO obj = (BillDefiVO) tmp;
				billDefiService.save(obj);
			}
		}
	}

	@Test
	public void queryResouces() throws Exception {
		//TODO ok
		ResourceDesignTimeService resourceService = (ResourceDesignTimeService) DesignTimeServiceFactory
				.resolve(ResourceDesignTimeService.class);
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryResouces();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof ResourceVO) {
				ResourceVO obj = (ResourceVO) tmp;
				resourceService.save(obj);
			}
		}
	}

	@Test
	public void queryCrossReports() throws Exception {
		
		//TODO ok
		queryModules();
		CrossReportDesignTimeService crossReportService = (CrossReportDesignTimeService) DesignTimeServiceFactory.resolve(CrossReportDesignTimeService.class);
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryCrossReports();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof CrossReportVO) {
				CrossReportVO obj = (CrossReportVO) tmp;
				crossReportService.save(obj);
			}
		}
	}

	@Test
	public void queryExlcfgs() throws Exception {
		
		//TODO ok
		IMPMappingConfigDesignTimeService excelMappingConfigProcess = (IMPMappingConfigDesignTimeService) DesignTimeServiceFactory
				.resolve(IMPMappingConfigDesignTimeService.class);
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryExlcfgs();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof IMPMappingConfigVO) {
				IMPMappingConfigVO obj = (IMPMappingConfigVO) tmp;
				excelMappingConfigProcess.save(obj);
			}
		}
	}

	@Test
	public void queryTasks() throws Exception {
		
		//TODO ? Collection<int> daysOfWeek
		TaskDesignTimeService taskService = (TaskDesignTimeService) DesignTimeServiceFactory.resolve(TaskDesignTimeService.class);

		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryTasks();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof Task) {
				Task obj = (Task) tmp;
				// //System.out.println(obj.toString());
				taskService.save(obj);
			}
		}
	}

	@Test
	public void queryWidgets() throws Exception {
		//TODO ok
		PageWidgetDesignTimeService pageWidgetService = (PageWidgetDesignTimeService) DesignTimeServiceFactory
				.resolve(PageWidgetDesignTimeService.class);
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryWidgets();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof PageWidget) {
				PageWidget obj = (PageWidget) tmp;
				// //System.out.println(obj.toString());
				pageWidgetService.save(obj);
			}
		}
	}

	@Test
	public void queryStateLabels() throws Exception {
		//TODO ok
		StateLabelService stateLabelService = (StateLabelService) DesignTimeServiceFactory
				.resolve(StateLabelService.class);
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryStateLabels();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof StateLabel) {
				StateLabel obj = (StateLabel) tmp;
				// //System.out.println(obj.toString());
				stateLabelService.save(obj);
			}
		}
	}

	@Test
	public void queryPrints() throws Exception {

		//TODO ok
		
		ReportDesignTimeService printerService = (ReportDesignTimeService) DesignTimeServiceFactory.resolve(ReportDesignTimeService.class);

		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryPrints();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof Report) {
				Report obj = (Report) tmp;
				// //System.out.println(obj.toString());
				printerService.save(obj);
			}
		}
	}

	@Test
	public void queryMacroRepositorys() throws Exception {
		//TODO ok
		RepositoryDesignTimeService repositoryService = (RepositoryDesignTimeService) DesignTimeServiceFactory
				.resolve(RepositoryDesignTimeService.class);

		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryMacroRepositorys();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof RepositoryVO) {
				RepositoryVO obj = (RepositoryVO) tmp;
				// //System.out.println(obj.toString());
				repositoryService.save(obj);
			}
		}

	}

	@Test
	public void queryValidRepositorys() throws Exception {
		//TODO ok
		ValidateRepositoryDesignTimeService validateRepositoryService = (ValidateRepositoryDesignTimeService) DesignTimeServiceFactory
				.resolve(ValidateRepositoryDesignTimeService.class);

		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryValidRepositorys();

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof ValidateRepositoryVO) {
				ValidateRepositoryVO obj = (ValidateRepositoryVO) tmp;

				validateRepositoryService.save(obj);
				// //System.out.println(obj.toString());
			}
		}
	}

	@Test
	public void queryStyleRepositorys() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryStyleRepositorys();
		//TODO ok
		StyleRepositoryDesignTimeService styleProcess = (StyleRepositoryDesignTimeService) DesignTimeServiceFactory
				.resolve(StyleRepositoryDesignTimeService.class);

		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof StyleRepositoryVO) {
				StyleRepositoryVO obj = (StyleRepositoryVO) tmp;
				styleProcess.save(obj);
				// //System.out.println(obj.toString());
			}
		}
	}

	@Test
	public void queryMulitlangs() throws Exception {
		//TODO ok
		MultiLanguageService multiLanguageService = (MultiLanguageService) DesignTimeServiceFactory
				.resolve(MultiLanguageService.class);

		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryMulitlangs();
		for (FileSystemDesignTimeSerializable tmp : list) {
			if (tmp instanceof MultiLanguage) {
				MultiLanguage obj = (MultiLanguage) tmp;
				multiLanguageService.save(obj);
				// //System.out.println(obj.toString());
			}
		}
	}
	
	
	private void save(DesignTimeService designTimeService , FileSystemDesignTimeSerializable obj){
		
		try {
			 designTimeService.save(obj);
		} catch (Exception e) {
		    String message = "  Class类型：" + obj.getClass().getSimpleName() + "  名称："+ obj.getName() + "  id: "+ obj.getId() + "  路径：  "+obj.getPath(); 
		    msg.add(message);
		    e.printStackTrace();
		}
		
	}

	/**
	 * 递归查询工作目录下的所有文件，并替换字符串内容
	 */
	@Test
	public void testTraverseFolder(){

		String folder = "D:\\Document\\IntelliJ\\obpm_dev\\target\\obpm\\WEB-INF\\workspace";
		try {
			UpgradeServiceImpl.traverseFolder(folder);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
