package cn.myapps.upgrade.service;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.DesignTimeService;
import cn.myapps.common.Environment;
import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.crossreport.CrossReportVO;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.excelimport.IMPMappingConfigVO;
import cn.myapps.common.model.macrorepository.RepositoryVO;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.multilanguage.MultiLanguage;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.model.statelabel.StateLabel;
import cn.myapps.common.model.stylerepository.StyleRepositoryVO;
import cn.myapps.common.model.summary.SummaryCfgVO;
import cn.myapps.common.model.task.Task;
import cn.myapps.common.model.validaterepository.ValidateRepositoryVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.view.Column;
import cn.myapps.common.model.widget.PageWidget;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.common.util.fs.VirtualFileSystemUtils;
import cn.myapps.designtime.crossreport.definition.service.CrossReportDesignTimeService;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.dts.excelimport.config.service.IMPMappingConfigDesignTimeService;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.macro.repository.service.RepositoryDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.multilanguage.service.MultiLanguageService;
import cn.myapps.designtime.report.service.ReportDesignTimeService;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.designtime.statelabel.service.StateLabelService;
import cn.myapps.designtime.style.repository.service.StyleRepositoryDesignTimeService;
import cn.myapps.designtime.summary.service.SummaryCfgDesignTimeService;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.designtime.validate.repository.service.ValidateRepositoryDesignTimeService;
import cn.myapps.designtime.view.column.service.ColumnDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.designtime.widget.service.PageWidgetDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.upgrade.dao.UpgradeDao;
import cn.myapps.upgrade.model.ApplicationDomainSet;
import cn.myapps.upgrade.util.DaoManager;
import cn.myapps.upgrade.util.LogHelper;
import cn.myapps.upgrade.util.UpgradeMessage;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.vfs2.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UpgradeServiceImpl implements UpgradeService {

	private static final Logger log = LoggerFactory.getLogger(UpgradeServiceImpl.class);

	private UpgradeDao upgradeDao;

	@Override
	public UpgradeDao getDAO() throws Exception {
		if (upgradeDao == null) {
			upgradeDao = DaoManager.getUpGradeDAO();
		}
		return upgradeDao;
	}

	FormDesignTimeService formService;
	ViewDesignTimeService viewService;
	BillDefiDesignTimeService billDefiService;
	ModuleDesignTimeService ModuleService;
	ResourceDesignTimeService resourceService;
	RepositoryDesignTimeService repositoryService;
	ValidateRepositoryDesignTimeService validateRepositoryService;
	IMPMappingConfigDesignTimeService excelMappingConfigProcess;
	SummaryCfgDesignTimeService reminderProcess;
	ApplicationDesignTimeService applicationProcess;
	PageWidgetDesignTimeService pageProcess;
	TaskDesignTimeService taskService;
	CrossReportDesignTimeService crossReportService;
	DataSourceDesignTimeService dataSourceProcess;
	ReportDesignTimeService printerService;
	MultiLanguageService multiLanguageService;
	StateLabelService stateLabelService;
	PageWidgetDesignTimeService pageWidgetService;
	StyleRepositoryDesignTimeService styleProcess;
	ActivityDesignTimeService actService;
	ColumnDesignTimeService colService;
	RoleDesignTimeService roleService;

	@SuppressWarnings("deprecation")
	public UpgradeServiceImpl() {
		try {
			formService = DesignTimeServiceManager.formDesignTimeService();
			viewService = DesignTimeServiceManager.viewDesignTimeService();
			billDefiService = DesignTimeServiceManager.billDefiDesignTimeService();
			ModuleService = DesignTimeServiceManager.moduleDesignTimeService();
			resourceService = DesignTimeServiceManager.resourceDesignTimeService();
			repositoryService = DesignTimeServiceManager.repositoryDesignTimeService();
			validateRepositoryService = DesignTimeServiceManager.validateRepositoryDesignTimeService();
			excelMappingConfigProcess = DesignTimeServiceManager.impMappingConfigDesignTimeService();
			reminderProcess = DesignTimeServiceManager.summaryCfgDesignTimeService();
			styleProcess = DesignTimeServiceManager.styleRepositoryDesignTimeService();
			applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
			taskService = DesignTimeServiceManager.taskDesignTimeService();
			crossReportService = DesignTimeServiceManager.crossReportDesignTimeService();
			dataSourceProcess = DesignTimeServiceManager.dataSourceDesignTimeService();
			printerService = DesignTimeServiceManager.reportDesignTimeService();
			multiLanguageService = DesignTimeServiceManager.multiLanguageService();
			stateLabelService = DesignTimeServiceManager.stateLabelService();
			pageWidgetService = DesignTimeServiceManager.pageWidgetDesignTimeService();
			actService = DesignTimeServiceManager.activityDesignTimeService();
			colService = DesignTimeServiceManager.columnDesignTimeService();
			roleService = DesignTimeServiceManager.roleDesignTimeService();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public String doUpGrade() throws Exception {

		String result = "";
		try {
			LogHelper.initList();
			upGrade();
		} catch (Exception e) {
			e.printStackTrace();
			LogHelper.setError(null, "获取数据失败", e.getMessage(), true);
		} finally {
			Collection<UpgradeMessage> errorList = LogHelper.getErrorList();
			JSONArray list = new JSONArray();

			for (UpgradeMessage msg : errorList) {
				String errorMsg = LogHelper.getErrorMsg(msg);
				if (!StringUtil.isBlank(errorMsg)) {
					list.add(errorMsg);
				}
			}

			result = list.toString();
		}

		return result;
	}

	/**
	 * 数据迁移
	 * 
	 * @throws Exception
	 */
	private void upGrade() throws Exception {
		// 企业域绑定软件
		DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
		Collection<DomainVO> domains = dp.getAllDomain();
		Collection<ApplicationDomainSet> applicationDomainSets = getDAO().queryApplicationDomainSets();
		for (DomainVO domainVO : domains) {
			try {
				JSONArray array = new JSONArray();
				String domainId = domainVO.getId();
				for (ApplicationDomainSet set : applicationDomainSets) {
					String tempId = set.getDomainId();
					if (domainId.equals(tempId)) {
						String applicationId = set.getApplicationId();
						array.add(applicationId);
					}
				}
				domainVO.setBindApplicatons(array.toString());
				dp.doCreateOrUpdate(domainVO);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		// 软件
		Collection<FileSystemDesignTimeSerializable> apps = getDAO().queryApplications();
		for (FileSystemDesignTimeSerializable tmp : apps) {
			if (tmp instanceof Application) {
				Application obj = (Application) tmp;
				save(applicationProcess, obj);
			}
		}

		// 数据源
		Collection<FileSystemDesignTimeSerializable> dts = getDAO().queryDataSources();
		for (FileSystemDesignTimeSerializable tmp : dts) {
			if (tmp instanceof DataSource) {
				DataSource obj = (DataSource) tmp;
				save(dataSourceProcess, obj);
			}
		}

		// 模块
		Collection<FileSystemDesignTimeSerializable> modules = getDAO().queryModules();
		for (FileSystemDesignTimeSerializable tmp : modules) {
			if (tmp instanceof Module) {
				Module obj = (Module) tmp;
				save(ModuleService, obj);
			}
		}

		// 表单
		Collection<FileSystemDesignTimeSerializable> forms = getDAO().queryForms();
		for (FileSystemDesignTimeSerializable tmp : forms) {
			if (tmp instanceof Form) {
				Form obj = (Form) tmp;

				// 1.6版本升级2.0版本,包结构变动
				if (obj.getTemplatecontext() != null) {
					String replaceTempalteContextString = obj.getTemplatecontext()
							.replaceAll("cn.myapps.core.dynaform.form.ejb", "cn.myapps.runtime.dynaform.form.ejb");
					obj.setTemplatecontext(replaceTempalteContextString);
				}

				save(formService, obj);
			}

			if (tmp instanceof Activity) {
				Activity obj = (Activity) tmp;
				save(actService, obj);
			}
		}

		// 摘要
		Collection<FileSystemDesignTimeSerializable> summarys = getDAO().querySummarys();
		for (FileSystemDesignTimeSerializable tmp : summarys) {
			if (tmp instanceof SummaryCfgVO) {
				SummaryCfgVO obj = (SummaryCfgVO) tmp;
				save(reminderProcess, obj);
			}
		}

		// 视图
		Collection<FileSystemDesignTimeSerializable> views = getDAO().queryViews();
		for (FileSystemDesignTimeSerializable tmp : views) {
			if (tmp instanceof AbstractView) {
				AbstractView obj = (AbstractView) tmp;
				save(viewService, obj);
			}

			if (tmp instanceof Activity) {
				Activity obj = (Activity) tmp;
				save(actService, obj);
			}

			if (tmp instanceof Column) {
				Column obj = (Column) tmp;
				save(colService, obj);
			}
		}

		// 流程
		Collection<FileSystemDesignTimeSerializable> flows = getDAO().queryFlows();
		for (FileSystemDesignTimeSerializable tmp : flows) {
			if (tmp instanceof BillDefiVO) {
				BillDefiVO obj = (BillDefiVO) tmp;
				save(billDefiService, obj);
			}
		}

		// 交叉报表
		Collection<FileSystemDesignTimeSerializable> crs = getDAO().queryCrossReports();
		for (FileSystemDesignTimeSerializable tmp : crs) {
			if (tmp instanceof CrossReportVO) {
				CrossReportVO obj = (CrossReportVO) tmp;
				save(crossReportService, obj);

			}
		}

		// 菜单
		Collection<FileSystemDesignTimeSerializable> menus = getDAO().queryResouces();
		for (FileSystemDesignTimeSerializable tmp : menus) {
			if (tmp instanceof ResourceVO) {
				ResourceVO obj = (ResourceVO) tmp;
				save(resourceService, obj);
			}
		}

		// excel
		Collection<FileSystemDesignTimeSerializable> excels = getDAO().queryExlcfgs();
		for (FileSystemDesignTimeSerializable tmp : excels) {
			if (tmp instanceof IMPMappingConfigVO) {
				IMPMappingConfigVO obj = (IMPMappingConfigVO) tmp;
				save(excelMappingConfigProcess, obj);
			}
		}

		// 任务
		Collection<FileSystemDesignTimeSerializable> tasks = getDAO().queryTasks();
		for (FileSystemDesignTimeSerializable tmp : tasks) {
			if (tmp instanceof Task) {
				Task obj = (Task) tmp;
				save(taskService, obj);
			}
		}

		// Widget
		Collection<FileSystemDesignTimeSerializable> widgets = getDAO().queryWidgets();
		for (FileSystemDesignTimeSerializable tmp : widgets) {
			if (tmp instanceof PageWidget) {
				PageWidget obj = (PageWidget) tmp;
				save(pageWidgetService, obj);
			}
		}

		// 标签
		Collection<FileSystemDesignTimeSerializable> stls = getDAO().queryStateLabels();
		for (FileSystemDesignTimeSerializable tmp : stls) {
			if (tmp instanceof StateLabel) {
				StateLabel obj = (StateLabel) tmp;
				save(stateLabelService, obj);
			}
		}

		// printer
		Collection<FileSystemDesignTimeSerializable> printers = getDAO().queryPrints();
		for (FileSystemDesignTimeSerializable tmp : printers) {
			if (tmp instanceof Report) {
				Report obj = (Report) tmp;
				save(printerService, obj);
			}
		}

		// 脚本库
		Collection<FileSystemDesignTimeSerializable> macros = getDAO().queryMacroRepositorys();
		for (FileSystemDesignTimeSerializable tmp : macros) {
			if (tmp instanceof RepositoryVO) {
				RepositoryVO obj = (RepositoryVO) tmp;
				save(repositoryService, obj);
			}
		}

		// 校验库
		Collection<FileSystemDesignTimeSerializable> validates = getDAO().queryValidRepositorys();
		for (FileSystemDesignTimeSerializable tmp : validates) {
			if (tmp instanceof ValidateRepositoryVO) {
				ValidateRepositoryVO obj = (ValidateRepositoryVO) tmp;
				save(validateRepositoryService, obj);
			}
		}

		// 样式库
		Collection<FileSystemDesignTimeSerializable> srs = getDAO().queryStyleRepositorys();
		for (FileSystemDesignTimeSerializable tmp : srs) {
			if (tmp instanceof StyleRepositoryVO) {
				StyleRepositoryVO obj = (StyleRepositoryVO) tmp;
				save(styleProcess, obj);
			}
		}

		// 多语言
		Collection<FileSystemDesignTimeSerializable> muls = getDAO().queryMulitlangs();
		for (FileSystemDesignTimeSerializable tmp : muls) {
			if (tmp instanceof MultiLanguage) {
				MultiLanguage obj = (MultiLanguage) tmp;
				save(multiLanguageService, obj);
			}
		}

		//角色
		Collection<FileSystemDesignTimeSerializable> roles = getDAO().queryRoles();
		for(FileSystemDesignTimeSerializable tmp : roles) {
			if(tmp instanceof Role) {
				Role obj = (Role) tmp;
				save(roleService,obj);
			}
		}
		
		// 递归查询工作目录下的所有文件，准备替换
		traverseFolder(Environment.getInstance().getWorkspaceRootPath());
		
		//根据1.6.0的数据库插入2.0的t_user_department_role_set
		insertUserDepartmentRoleSet();
	}

	/**
	 * 数据持久化
	 * 
	 * @param designTimeService
	 * @param obj
	 */
	@SuppressWarnings("unchecked")
	private void save(DesignTimeService designTimeService, FileSystemDesignTimeSerializable obj) {
		try {
			designTimeService.save(obj);
		} catch (Exception e) {
			LogHelper.setError(obj, "创建失败", e.getMessage(), true);
			e.printStackTrace();
		}
	}

	/**
	 * 清空数据
	 */
	public String doClear() throws Exception {

		JSONObject result = new JSONObject();

		boolean status = true;
		String message = "迁移数据删除成功";

		try {

			String WORKSPACE_ROOT_PATH = Environment.getInstance().getWorkspaceRootPath();
			File root = new File(WORKSPACE_ROOT_PATH);

			File[] apps = root.listFiles(new FilenameFilter() {
				@Override
				public boolean accept(File dir, String name) {
					boolean accept = false ;
					if(name.equals("Default.application")){
						accept = false ;
					}else if(name.lastIndexOf(".application") > 0){
						accept = true ;
					}
					return accept;
				}
			});

			for(File app : apps){
				delDir(app);
			}

		} catch (Exception e) {
			status = false;
			message = "迁移数据删除失败，请到" + Environment.getInstance().getWorkspaceRootPath() + "目录下,手动删除";
		}

		result.put("status", status);
		result.put("message", message);

		return result.toString();
	}

	public static void delDir(File f) {
		// 判断是否是一个目录, 不是的话跳过, 直接删除; 如果是一个目录, 先将其内容清空.
		if(f.isDirectory()) {
			// 获取子文件/目录
			File[] subFiles = f.listFiles();
			// 遍历该目录
			for (File subFile : subFiles) {
				// 递归调用删除该文件: 如果这是一个空目录或文件, 一次递归就可删除. 如果这是一个非空目录, 多次
				// 递归清空其内容后再删除
				delDir(subFile);
			}
		}
		// 删除空目录或文件
		f.delete();
	}


	@Override
	public boolean isUpGradeEnable() throws Exception {

		boolean isUpGradeEnable = false;
		Collection<FileSystemDesignTimeSerializable> apps = getDAO().queryApplications();
		if (apps.size() > 0) {
			isUpGradeEnable = true;
		}
		return isUpGradeEnable;
	}

	public static void traverseFolder(String path) throws Exception {

		File file = new File(path);
		if (file.exists()) {
			File[] files = file.listFiles();
			if (files.length == 0) {
				System.out.println("文件夹是空的!");
				return;
			} else {
				for (File file2 : files) {
					if (file2.isDirectory()) {
						System.out.println("文件夹:" + file2.getAbsolutePath());
						traverseFolder(file2.getAbsolutePath());
					} else {
						System.out.println("文件:" + file2.getAbsolutePath());
						replaceKeyWord(file2.getAbsolutePath());
					}
				}
			}
		} else {
			System.out.println("文件不存在!");
		}
	}

	/**
	 * 1.6到2.0迁移，包结构进行替换。
	 * @param sourceFile
	 * @throws Exception
	 */
	public static void replaceKeyWord(String sourceFile) throws Exception {
		FileObject source = VirtualFileSystemUtils.resolveFile(sourceFile);

		String newStr = VirtualFileSystemUtils.readFileToString(source);
		newStr = newStr.replaceAll("cn.myapps.core.workflow.element","cn.myapps.runtime.workflow.element");
		newStr = newStr.replaceAll("cn.myapps.core.user.ejb.UserProcess", "cn.myapps.authtime.user.service.UserProcess");
		newStr = newStr.replaceAll("cn.myapps.core.department.ejb.DepartmentProcess", "cn.myapps.authtime.department.service.DepartmentProcess");
		newStr = newStr.replaceAll("cn.myapps.core.dynaform.dts.excelimport", "cn.myapps.runtime.dynaform.dts.excelimport");
		newStr = newStr.replaceAll("cn.myapps.core.dynaform.dts.datasource.ejb.DataSourceProcess", "cn.myapps.runtime.datasource.service.DataSourceService");
		newStr = newStr.replaceAll("cn.myapps.base.action.ParamsTable", "cn.myapps.common.data.ParamsTable");
		newStr = newStr.replaceAll("cn.myapps.core.workflow.engine.StateMachine", "cn.myapps.runtime.workflow.engine.StateMachine");
		newStr = newStr.replaceAll("cn.myapps.core.dynaform.form.ejb", "cn.myapps.runtime.dynaform.form.ejb");
		newStr = newStr.replaceAll("cn.myapps.core.workflow.storage.definition.ejb.BillDefiProcess", "cn.myapps.runtime.workflow.definition.service.BillDefiService");
		newStr = newStr.replaceAll("cn.myapps.core.workflow.storage.runtime.ejb", "cn.myapps.runtime.workflow.storage.runtime.ejb");
		
		

		VirtualFileSystemUtils.writeStringToFile(sourceFile, newStr);
		System.out.println("sourceFile:" + sourceFile + "--- finish ----");
	}
	
	public void insertUserDepartmentRoleSet() throws Exception{
//		if(getDAO().isExistUserRoleSetAndUserDeptSet()){
			List<Map<String,String>> lits=getDAO().listUserIdDeptIdRoleId();
			for (Map<String, String> map : lits) {
				//插入userDepartmentRole表里(2.0生成的表t_user_department_role_set)
				getDAO().insertUserDepartmentRoleSet(map.get("userId"), map.get("roleId"), map.get("departmentId"));
			}
//		}
	}
	
}
