package cn.myapps.destop.tray.ui;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;

import javax.swing.*;

import cn.myapps.destop.tray.SystemContacts;
import cn.myapps.destop.tray.fs.OfficeRespWatchService;
import cn.myapps.destop.tray.operator.FileOperator;
import cn.myapps.destop.tray.server.SimpleHttpServer;

public class MainFrame extends JFrame implements ActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8517485418016811254L;
	
	private SystemTray systemTray; // 系统托盘
	private TrayIcon trayicon;
	
	private void initCompoenent() {
		if (!SystemTray.isSupported()) {
			return;
		} else {
			systemTray = SystemTray.getSystemTray();
			String title = "teemlink helper";
			Image image = Toolkit.getDefaultToolkit().getImage(
					getClass().getResource("/icon.png"));
			trayicon = new TrayIcon(image, title, createMenu());
			trayicon.addActionListener(this);
			try {
				systemTray.add(trayicon);
				//trayicon.displayMessage(title, company, MessageType.INFO);
			} catch (AWTException e) {
				e.printStackTrace();
			}
		}
		setVisible(false);
	}

	@Override
	public void actionPerformed(ActionEvent ex) {
		if (ex.getSource().equals(trayicon)) {
			if (!isVisible()) {
				setVisible(true);
				toFront();
			}
		}
	}

	public MainFrame() {
		initCompoenent();
		try {
			cleanWatchPath();
			SimpleHttpServer.start();
			OfficeRespWatchService.start();
			FileOperator.start();
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(0);
		}
		
	}
	
	private void cleanWatchPath(){
		File dir = Paths.get(SystemContacts.WATCH_PATH).toFile();
		if(dir.exists()){
			File[] files = dir.listFiles();
			for(File f : files){
				f.delete();
			}
		}
		
		File dir2 = Paths.get(SystemContacts.TEMP_DOWNLOAD_PATH).toFile();
		if(dir2.exists()){
			File[] files = dir2.listFiles();
			for(File f : files){
				f.delete();
			}
		}else{
			dir2.mkdirs();
		}
	}

	private PopupMenu createMenu() {
		PopupMenu menu = new PopupMenu();
		MenuItem exit = new MenuItem("Close");
		exit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ex) {
				SimpleHttpServer.stop();
				System.exit(0);
			}
		});
		MenuItem open = new MenuItem("Open");
		open.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ex) {
				//TODO
			}
		});
		//menu.add(open);
		//menu.addSeparator();
		//menu.add(exit);
		return menu;
	}
	
    /**
     * 检查是否获得锁,true:获得锁，说明是第一次执行;false:没有取得锁，说明已经有一个程序在执行
     * @return
     */
    public static boolean checkLock() {
        FileLock lock = null;
        RandomAccessFile r = null;
        FileChannel fc = null;
        try {
            // 在临时文件夹创建一个临时文件，锁住这个文件用来保证应用程序只有一个实例被创建.
            File sf = new File(System.getProperty("java.io.tmpdir") + "myapps_tray_single.lock");
            sf.deleteOnExit();
            sf.createNewFile();
            r = new RandomAccessFile(sf, "rw");
            fc = r.getChannel();
            lock = fc.tryLock();
            if (lock == null || !lock.isValid()) {
                // 如果没有得到锁，则程序退出.
                // 没有必要手动释放锁和关闭流，当程序退出时，他们会被关闭的.
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

	public static void main(String[] args) {
		if(checkLock()){
			new MainFrame();
		}
	}
}