package cn.myapps.destop.tray.server.controller;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import javax.ws.rs.GET;  
import javax.ws.rs.Path;  
import javax.ws.rs.Produces;  
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;  

import org.apache.commons.lang.StringUtils;

import net.sf.json.JSONObject;


import cn.myapps.destop.tray.SystemContacts;
import cn.myapps.destop.tray.client.RemoteFileService;
import cn.myapps.destop.tray.client.http.HttpRemoteFileService;
import cn.myapps.destop.tray.fs.FileItem;
import cn.myapps.destop.tray.operator.DocumentOperatorFactory;

/**
 * 托盘程序HTTP服务的控制器，提供本地浏览器调用的RESTfull API
 * @author Happy
 *
 */
@Path("/tray")  
public class TrayController {
	
	RemoteFileService remoteFileService = new HttpRemoteFileService();

	@GET
    @Path("/ping")
    @Produces(MediaType.TEXT_PLAIN+";charset=utf8")
    public String ping(@QueryParam("jsonpCallback") String jsonpCallback) throws Exception {
		return jsonpCallback+"("+setResult(true, "success", SystemContacts.VERSION).toString()+")";
    }
	
	@GET
    @Path("/download")
    @Produces(MediaType.TEXT_PLAIN+";charset=utf8")
    public String download(@QueryParam("path") String path,@QueryParam("name") String name,@QueryParam("jsonpCallback") String jsonpCallback) throws Exception {
		if(SystemContacts.SERVER_HOST == null || StringUtils.isBlank(name) || StringUtils.isBlank(path)){
			return jsonpCallback+"("+setResult(false, "参数不符", null).toString()+")";
		}
		Object result = null;
		FileItem fileItem = SystemContacts.filePool.get(name);
		if(fileItem !=null && fileItem.getState()!=FileItem.STATE_DELETED){
			result = fileItem.getState();
		}else{
			Map<String, String> params = new HashMap<String, String>();
			params.put("path", path);
			params.put("name", name);
			fileItem = new FileItem(params, null, 0);
			SystemContacts.filePool.put(name, fileItem);
			String fullPath = SystemContacts.WATCH_PATH+name;
			File f = new File(fullPath);
			if(f.exists()) f.delete();
			remoteFileService.download(params, fullPath);
		}
		return jsonpCallback+"("+setResult(true, "success", result).toString()+")";
    }
	
	@GET
    @Path("/upload")
    @Produces(MediaType.TEXT_PLAIN+";charset=utf8")
    public String upload(@QueryParam("path") String path,@QueryParam("name") String name,@QueryParam("jsonpCallback") String jsonpCallback) throws Exception {
		Map<String, String> params = new HashMap<String, String>();
		params.put("path", path);
		params.put("name", name);
		String filePath = SystemContacts.WATCH_PATH+name;
		remoteFileService.upload(params, filePath);
		return jsonpCallback+"("+setResult(true, "success", null).toString()+")";
    }
	
	@GET
    @Path("/progress")
    @Produces(MediaType.TEXT_PLAIN+";charset=utf8")
    public String progress(@QueryParam("name") String name,@QueryParam("jsonpCallback") String jsonpCallback) throws Exception {
		int state = 0;
		if(SystemContacts.SERVER_HOST == null || StringUtils.isBlank(name)){
			state = -1;
		}
		FileItem fileItem = SystemContacts.filePool.get(name);
		if(fileItem!=null){
			state = fileItem.getState();
			if(state==FileItem.STATE_DELETED){
				SystemContacts.filePool.remove(name);
			}
		}
		return jsonpCallback+"("+setResult(true, "success", state).toString()+")";
    }
	
	@GET
    @Path("/setServerHost")
    @Produces(MediaType.TEXT_PLAIN+";charset=utf8")
    public String setServerHost(@QueryParam("host") String host,@QueryParam("jsonpCallback") String jsonpCallback) throws Exception {
		if(!StringUtils.isBlank(host) && !host.equals(SystemContacts.SERVER_HOST)){
			SystemContacts.SERVER_HOST = host;
		}
        return jsonpCallback+"("+setResult(true, "success", null).toString()+")";
    }
	
	@GET
    @Path("/open")
    @Produces(MediaType.TEXT_PLAIN+";charset=utf8")
    public String open(@QueryParam("path") String path,@QueryParam("jsonpCallback") String jsonpCallback) throws Exception {
		if(SystemContacts.SERVER_HOST == null || StringUtils.isBlank(path)){
			return jsonpCallback+"("+setResult(false, "参数不符", null).toString()+")";
		}
		Object result = null;
		Map<String, String> params = new HashMap<String, String>();
		int index = path.lastIndexOf("/");
		String name = path.substring(index+1);
		String sPath = path.substring(0, index);
		params.put("path", sPath);
		params.put("name", name);
		String fullPath = SystemContacts.TEMP_DOWNLOAD_PATH+name;
		File f = new File(fullPath);
		if(f.exists()) f.delete();
		
		remoteFileService.download(params, fullPath);
		
		f = new File(fullPath);
		if(f.exists()){
			DocumentOperatorFactory.getDocumentOperator().open(fullPath);
		}
		
		return jsonpCallback+"("+setResult(true, "success", result).toString()+")";
    }
	
	@GET
    @Path("/getVersion")
    @Produces(MediaType.TEXT_PLAIN+";charset=utf8")
    public String getVersion(@QueryParam("jsonpCallback") String jsonpCallback) throws Exception {
		
		return jsonpCallback+"("+setResult(true, "success", SystemContacts.VERSION).toString()+")";
    }
	
	
	private JSONObject setResult(boolean isSuccess,String message,Object data){
		JSONObject result = new JSONObject();
		result.put("state", isSuccess? 1:0);
		result.put("message", message);
		result.put("data", data);
		
		return result;
	}
}
