package cn.myapps.destop.tray.server;

import java.io.IOException;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

import com.sun.jersey.spi.container.servlet.ServletContainer;

/**
 * HTTP 服务端
 * 
 * @author Happy
 *
 */
public class SimpleHttpServer {

	private static final int PORT = 9001;
	private static Server server;

	/**
	 * 启动服务，监听来自客户端浏览器的请求
	 * 
	 * @throws Exception
	 */
	public static void start() throws Exception {
		server = new Server(PORT);
		ServletContextHandler context = new ServletContextHandler(
				ServletContextHandler.SESSIONS);
		context.setContextPath("/");
		server.setHandler(context);
		ServletHolder sh = new ServletHolder(ServletContainer.class);
		sh.setInitParameter(
				"com.sun.jersey.config.property.resourceConfigClass",
				"com.sun.jersey.api.core.PackagesResourceConfig");
		sh.setInitParameter("com.sun.jersey.config.property.packages",
				"cn.myapps.destop.tray.server.controller");
		context.addServlet(sh, "/*");
		server.start();
	}

	/**
	 * 关闭服务
	 */
	public static void stop() {
		if (server != null) {
			try {
				server.stop();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void main(String[] args) throws IOException {
		try {
			start();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
