package cn.myapps.destop.tray.operator;

import cn.myapps.destop.tray.fs.FileItem;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;

public class WpsDocumentOperator implements DocumentOperator {

	@Override
	public void open(String source) throws DocumentOperatorException {
		ActiveXComponent wps = null;
		Dispatch documents = null;
		Dispatch document = null;
		try {
			ComThread.InitMTA(true);
			wps = new ActiveXComponent("Kwps.application");
			Dispatch.put(wps.getObject(), "Visible", new Variant(true));
			wps.setProperty("USERNAME", FileItem.userName);

			documents = wps.getProperty("Documents").toDispatch();
			document = Dispatch.invoke(
					documents,
					"Open",
					Dispatch.Method,
					new Object[] { source, false, false, false, "", "", true,
							"", "", null, null, null, null, null, true },
					new int[1]).toDispatch();
			Dispatch activeDocument = Dispatch.get(wps, "ActiveDocument").toDispatch();
			Dispatch.put(activeDocument, "TrackRevisions",new Variant(true));
			Dispatch.put(activeDocument, "ShowRevisions",new Variant(false));
		} catch (Exception e) {
			throw e;
		}  finally {
			try {
				if (document != null) {
//					Dispatch.invoke(document, "Close", Dispatch.Method,
//							new Object[] { false }, new int[1]);
					//document.safeRelease();
				}
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					if (document != null) {
//						document.safeRelease();
//						document = null;
					}
					if (documents != null){
//						documents.safeRelease();
//						documents = null;
					}
					if (wps != null){
//						wps.safeRelease();
//						wps = null;
					}
//					ComThread.Release();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

}
