package cn.myapps.destop.tray.operator;

import java.io.IOException;

public class ShellDocumentOperator implements DocumentOperator {
	
	private static final String OS = System.getProperty("os.name").toLowerCase();
	private static final String WINDOWS_CMD_PREFIX = "cmd /c start ";
	private static final String MAC_CMD_PREFIX = "open ";

	@Override
	public void open(String source) throws DocumentOperatorException {
		try {
			String cmd = "";
			if(OS.contains("windows")){
				if(source.indexOf("Documents and Settings")>=0){
					source = source.replace("Documents and Settings", "\"Documents and Settings\"");
				}
				cmd = WINDOWS_CMD_PREFIX+source;
			}else if(OS.contains("mac")){
				cmd = MAC_CMD_PREFIX+source;
			}
			Runtime.getRuntime().exec(cmd);
			Thread.sleep(6000);
		} catch (IOException e) {
			e.printStackTrace();
			throw new DocumentOperatorException(e);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		try {
			String source = "D:\\Documents and Settings\\demo.docx";
			if(source.indexOf("Documents and Settings")>=0){
				source = source.replace("Documents and Settings", "\"Documents and Settings\"");
			}
			String cmd = WINDOWS_CMD_PREFIX+source;
			Runtime.getRuntime().exec(cmd);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
