package cn.myapps.destop.tray.operator;

import cn.myapps.destop.tray.fs.FileItem;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;

public class OfficeDocumentOperator implements DocumentOperator {

	@Override
	public void open(String source) throws DocumentOperatorException {
		ActiveXComponent word = null;
		Dispatch documents = null;
		Dispatch document = null;
		try {
			ComThread.InitMTA(true);
			word = new ActiveXComponent("Word.Application");
			Dispatch.put(word.getObject(), "Visible", new Variant(true));

			documents = word.getProperty("Documents").toDispatch();
			//放修订的用户名
			word.setProperty("USERNAME", FileItem.userName);
			document = Dispatch.invoke(
					documents,
					"Open",
					Dispatch.Method,
					new Object[] { source},
					new int[1]).toDispatch();
			Dispatch activeDocument = Dispatch.get(word, "ActiveDocument").toDispatch();
			//打开修订
			Dispatch.put(activeDocument, "TrackRevisions",new Variant(true));
			//默认为最终状态
			Dispatch.put(activeDocument, "ShowRevisions",new Variant(false));
		} catch (Exception e) {
			throw e;
		} finally {
			try {
				if (document != null) {
					document.safeRelease();
					document = null;
				}
				if (documents != null){
					documents.safeRelease();
					documents = null;
				}
					
				if (word != null){
					word.safeRelease();
					word = null;
				}
				ComThread.Release();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}
