package cn.myapps.destop.tray.operator;

import java.io.File;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Timer;
import java.util.TimerTask;

import cn.myapps.destop.tray.SystemContacts;
import cn.myapps.destop.tray.client.RemoteFileService;
import cn.myapps.destop.tray.client.http.HttpRemoteFileService;
import cn.myapps.destop.tray.fs.FileItem;

public class FileOperator {
	
	
	private static RemoteFileService remoteFileService = new HttpRemoteFileService();
	
	private static final long period = 1*1000L;
	
	public static void start(){
		
		Timer editWatchTimer = new Timer("editWatchTimer");
		editWatchTimer.schedule(new TimerTask() {
			@Override
			public void run() {
				for (Iterator<Entry<String, FileItem>> iterator = SystemContacts.filePool.entrySet().iterator(); iterator
						.hasNext();) {
					Entry<String, FileItem> entry = iterator.next();
					try {
						FileItem item = entry.getValue();
						if(item.getState()!=FileItem.STATE_UPLOAD_STANDBY) continue;
						File _f = new File(item.getFilePath());
						if(_f.renameTo(_f)){
							System.out.println("文件已经结束编辑-->"+item.getFilePath());
							item.setState(FileItem.STATE_UPLOADING);
							SystemContacts.filePool.put(entry.getKey(), item);
							
							final FileItem f = item;
							new Thread(new Runnable() {
								@Override
								public void run() {
									remoteFileService.upload(f.getParams(), f.getFilePath());
								}
							}).start();;
						}else if(!_f.exists()){
							item.setState(FileItem.STATE_DELETED);
							SystemContacts.filePool.put(entry.getKey(), item);
							SystemContacts.FILE_SIZE_CAHCE.remove(entry.getKey());
						}else{
							  System.out.println("文件正在被操作->"+item.getFilePath());  
						}
						/*if(item.getState()==FileItem.STATE_UPLOAD_STANDBY && System.currentTimeMillis()-item.getRefreshTime()>FileItem.UPLOAD_DELAY){
							item.setState(FileItem.STATE_UPLOADING);
							SystemContacts.filePool.put(entry.getKey(), item);
							
							final FileItem f = item;
							new Thread(new Runnable() {
								@Override
								public void run() {
									remoteFileService.upload(f.getParams(), f.getFilePath());
								}
							}).start();;
						}*/
						
					} catch (Exception e) {
					}
					
				}
			}
		}, 1000, 1*1000);
		
		
		Timer timer = new Timer("removeFileTimer");
		timer.schedule(new TimerTask() {
			
			@Override
			public void run() {
				for (Iterator<Entry<String, FileItem>> iterator = SystemContacts.filePool.entrySet().iterator(); iterator
						.hasNext();) {
					Entry<String, FileItem> entry = iterator.next();
					try {
						FileItem fileItem = entry.getValue();
						if(fileItem.getState()==FileItem.STATE_DELETE_STANDBY){
							File uploadFile = new File(fileItem.getFilePath());
							if(uploadFile.delete()){
								fileItem.setState(FileItem.STATE_DELETED);
								SystemContacts.filePool.put(entry.getKey(), fileItem);
//								filePool.put(entry.getKey(), fileItem);
								SystemContacts.FILE_SIZE_CAHCE.remove(entry.getKey());
								System.out.println("文件删除成功："+entry.getValue());
								
							}
						}
					} catch (Exception e) {
					}
					
				}
			}
		}, 1000, period);
		
		/*Timer uploadFileTimer = new Timer("uploadFileTimer");
		uploadFileTimer.schedule(new TimerTask() {
			@Override
			public void run() {
				for (Iterator<Entry<String, FileItem>> iterator = SystemContacts.filePool.entrySet().iterator(); iterator
						.hasNext();) {
					Entry<String, FileItem> entry = iterator.next();
					try {
						FileItem item = entry.getValue();
						if(item.getState()==FileItem.STATE_UPLOAD_STANDBY && System.currentTimeMillis()-item.getRefreshTime()>FileItem.UPLOAD_DELAY){
							item.setState(FileItem.STATE_UPLOADING);
							SystemContacts.filePool.put(entry.getKey(), item);
							
							final FileItem f = item;
							new Thread(new Runnable() {
								@Override
								public void run() {
									remoteFileService.upload(f.getParams(), f.getFilePath());
								}
							}).start();;
						}
						
					} catch (Exception e) {
					}
					
				}
			}
		}, 1000, 10*1000);*/
		
		
	}
	
}
