package cn.myapps.destop.tray.operator;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Variant;

public class DocumentOperatorFactory {
	
	private static DocumentOperator instance;
	
	private static String OS = System.getProperty("os.name");
	
	private static int WPS_VERSION = 9;
	
	static {
		if(isWpsEnable()){
			instance = new WpsDocumentOperator();
		}else if(isOfficeEnable()){
			instance = new OfficeDocumentOperator();
		}else{
			instance = new ShellDocumentOperator();
		}
	}
	
	private static boolean isOfficeEnable(){
		if(!OS.toLowerCase().contains("windows")) return false;
		ActiveXComponent word = null;
		try {
			ComThread.InitMTA(true);
				word = new ActiveXComponent("Word.Application");
				if(word !=null) return true;
			
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				if (word != null) {
					word.invoke("Quit", new Variant(false));
				}
			} catch (Exception e) {
				word.invoke("Terminate");
			}
			if (word != null)
				word.safeRelease();
			ComThread.Release();
		}
		return false;
	}
	
	public static boolean isWpsEnable(){
		if(!OS.toLowerCase().contains("windows")) return false;
		ActiveXComponent wps = null;
		try {
			ComThread.InitMTA(true);
			try {
				wps = new ActiveXComponent("wps.application");
				WPS_VERSION = 8;
			} catch (Exception e) {
				wps = new ActiveXComponent("Kwps.application");
				if(wps !=null) WPS_VERSION = 9;
			}
			if(wps !=null) return true;
			
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				if (wps != null) {
					wps.invoke("Quit", new Variant(false));
				}
			} catch (Exception e) {
				wps.invoke("Terminate");
			}
			if (wps != null)
				wps.safeRelease();
			
			ComThread.Release();
		}
		return false;
	}
	
	public static DocumentOperator getDocumentOperator(){
		return instance;
	}
	
	
	public static void main(String[] args) {
		DocumentOperatorFactory.getDocumentOperator().open("d:\\a.docx");
	}

}
