package cn.myapps.destop.tray.fs;

/**
 * 文件监控事件监听器
 * @author Happy
 *
 */
public interface WatchListener {

	/**
	 * 文件创建事件处理
	 * @param path
	 * 		完整目录
	 * @param name
	 * 		文件名
	 */
	public void fileCreated(String path,String name);
	
	/**
	 * 文件修改事件处理
	 * @param path
	 * 		完整目录
	 * @param name
	 * 		文件名
	 */
	public void fileModified(String path,String name);
	
	/**
	 * 文件重命名事件处理
	 * @param path
	 * 		完整目录
	 * @param name
	 * 		文件名
	 */
	public void fileRenamed(String path, String oldName,String newName);
	
	/**
	 * 文件删除事件处理
	 * @param path
	 * 		完整目录
	 * @param name
	 * 		文件名
	 */
	public void fileDeleted(String path,String name);
	
}
