package cn.myapps.destop.tray.fs;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import cn.myapps.destop.tray.SystemContacts;
import cn.myapps.destop.tray.client.RemoteFileService;
import cn.myapps.destop.tray.client.http.HttpRemoteFileService;
import cn.myapps.destop.tray.operator.DocumentOperatorException;
import cn.myapps.destop.tray.operator.DocumentOperatorFactory;

/**
 * 常规的文件系统目录监控事件处理实现
 * @author Happy
 *
 */
public class StandardWatchListener implements WatchListener {
	
	private static final String OS = System.getProperty("os.name").toLowerCase();
	
	RemoteFileService remoteFileService = new HttpRemoteFileService();
	

	@Override
	public void fileCreated(String rootPath, String name) {
		System.out.println("fileCreated-->"+rootPath);
		
		if(name.startsWith("~$") || name.toLowerCase().endsWith(".tmp") || name.startsWith(".")) return;
		
		try {
			if(OS.contains("windows") || OS.contains("mac")){
				if(SystemContacts.FILE_SIZE_CAHCE.get(name)==null){
					SystemContacts.FILE_SIZE_CAHCE.put(name, new File(rootPath).length());
//					FileSystemUtil.removeFilePool.put(name, rootPath);
					DocumentOperatorFactory.getDocumentOperator().open(rootPath);
					//Runtime.getRuntime().exec("cmd /c start "+rootPath);
				}
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	@Override
	public void fileModified(String rootPath, String name) {
		System.out.println("fileModified-->"+rootPath);
		if(name.startsWith("~$") || name.endsWith(".tmp")) return;
		FileItem fileItem = SystemContacts.filePool.get(name);
		if(fileItem!=null){
			long size = new File(rootPath).length();
//			if(SystemContacts.FILE_SIZE_CAHCE.get(name)!=null && size==SystemContacts.FILE_SIZE_CAHCE.get(name)) return;
			fileItem.setFilePath(rootPath);
			fileItem.setState(FileItem.STATE_UPLOAD_STANDBY);
			fileItem.setRefreshTime(System.currentTimeMillis());
//			SystemContacts.filePool.put(name, fileItem);
			
			SystemContacts.FILE_SIZE_CAHCE.put(name, size);
			
			
		}

	}

	@Override
	public void fileRenamed(String rootPath, String oldName, String newName) {
		throw new UnsupportedOperationException();

	}

	@Override
	public void fileDeleted(String rootPath, String name) {
		System.out.println("fileDeleted-->"+rootPath);
		
		/*if(!name.startsWith("~$")){
			name = name.substring(2);
			
			Map<String, String> params = new HashMap<String, String>();
			String _path = SystemContacts.UPLOAD_PATH_CACHE.get(name);
			int index = _path.lastIndexOf("/");
			String path = _path.substring(0, index+1);
			name = _path.substring(index+1);
			params.put("path", path);
			params.put("name", name);
			String filePath = SystemContacts.WATCH_PATH+name;
			remoteFileService.upload(params, filePath);
			
		}*/

	}

}
