package cn.myapps.destop.tray.client.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import cn.myapps.destop.tray.SystemContacts;
import cn.myapps.destop.tray.client.ClientException;
import cn.myapps.destop.tray.client.RemoteFileService;
import cn.myapps.destop.tray.fs.FileItem;

/**
 *  HTTP传输协议的远程文件管理服务实现
 * @author Happy
 *
 */
public class HttpRemoteFileService implements RemoteFileService{
	
	private static HttpClient httpclient;
	private static Object LOCK = new Object();
	
	private static final String DOWNLOAD_URI = "/tray/service/download.action";
	private static final String UPLOAD_URI = "/tray/service/upload";

	@Override
	public void download(Map<String, String> params, String filePath) throws ClientException {
		HttpClient httpclient = new DefaultHttpClient();//getHttpClient();
		try {
			String path = params.get("path");
			String name = params.get("name");
			String url = SystemContacts.SERVER_HOST+DOWNLOAD_URI;
			HttpPost httpost = new HttpPost(url);

			System.out.println("发起下载请求 " + httpost.getURI());

			if(!params.isEmpty()){
				List<NameValuePair> nvps = new ArrayList<NameValuePair>();
				for (Iterator<Entry<String, String>> iterator = params.entrySet().iterator(); iterator.hasNext();) {
					Entry<String, String> entry = iterator.next();
					nvps.add(new BasicNameValuePair(entry.getKey(),entry.getValue()));
				}
				httpost.setEntity(new UrlEncodedFormEntity(nvps, Consts.UTF_8));
			}
			

			HttpResponse response = httpclient.execute(httpost);
			HttpEntity entity = response.getEntity();
			int statusCode = response.getStatusLine().getStatusCode();
			System.out.println(statusCode);
			if(statusCode ==200){
				String fullPath = filePath;
				OutputStream os = new FileOutputStream(fullPath);
				entity.writeTo(os);
				os.close();
			}else{
				throw new ClientException("服务器无法响应请求！");
			}
			EntityUtils.consume(entity);
		} catch (Exception e) {
			e.printStackTrace();
			throw new ClientException(e);
		} finally {
			try { httpclient.getConnectionManager().shutdown(); } catch (Exception ignore) {}
		}
		
	}

	@Override
	public void upload(Map<String, String> params, String filePath) throws ClientException {
		String name = params.get("name");
		FileItem fileItem = SystemContacts.filePool.get(name);
		try {
			if(!new File(filePath).exists()) return;
			long offset = 0;//queryUploadSize(url,params);
			int state = multipartFormPost(offset,params,filePath);
			if(state==200){
				System.out.println("文件上传成功："+filePath);
				//上传成功，删除文件
				fileItem.setState(FileItem.STATE_DELETE_STANDBY);
				SystemContacts.FILE_SIZE_CAHCE.remove(name);
			}else{
				fileItem.setState(FileItem.STATE_UPLOAD_STANDBY);
				System.err.println("文件上传失败："+filePath);
			}
		} catch (Exception e) {
			fileItem.setState(FileItem.STATE_UPLOAD_STANDBY);
		}
		
	}

	@Override
	public void delete(Map<String, String> params, String filePath) throws ClientException {
		throw new UnsupportedOperationException();
		
	}
	
	private HttpClient getHttpClient(){
		if(httpclient !=null) return httpclient;
				
			synchronized (LOCK) {
				PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
		        cm.setMaxTotal(100);
				httpclient = new DefaultHttpClient(cm);
			}
			return httpclient;
	}
	
	private long queryUploadSize(String url,Map<String, String> params){
		HttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(url);
            
            if(!params.isEmpty()){
				for (Iterator<Entry<String, String>> iterator = params.entrySet().iterator(); iterator.hasNext();) {
					Entry<String, String> entry = iterator.next();
					httpget.getParams().setParameter(entry.getKey(), entry.getValue());
				}
			}
            System.out.println("executing request " + httpget.getURI());
            HttpResponse response = httpclient.execute(httpget);
            HttpEntity entity = response.getEntity();

            System.out.println("----------------------------------------");
            System.out.println(response.getStatusLine());
            
            String offset = EntityUtils.toString(entity);
            if(offset !=null && offset.trim().length()>0){
            	return Long.valueOf(offset.trim());
            }
            EntityUtils.consume(entity);
        } catch(Exception e){
        	e.printStackTrace();
        }finally {
            httpclient.getConnectionManager().shutdown();
        }
		
		return -1;
	}
	
	public static int multipartFormPost(long offset,Map<String, String> params,String filePath){
		   HttpClient httpclient = new DefaultHttpClient();
	        try {
	        	String url = SystemContacts.SERVER_HOST+UPLOAD_URI;
	        	File uploadFile = new File(filePath);
	            HttpPost httppost = new HttpPost(url);

	            FileBody file = new BreakedFileBody(uploadFile,offset);

	            MultipartEntity reqEntity = new MultipartEntity();
	            reqEntity.addPart("file", file);
	            //reqEntity.addPart("offset", new StringBody(String.valueOf(offset)));
	            //reqEntity.addPart("fileLength", new StringBody(String.valueOf(uploadFile.length())));
	            
	            if(!params.isEmpty()){
					for (Iterator<Entry<String, String>> iterator = params.entrySet().iterator(); iterator.hasNext();) {
						Entry<String, String> entry = iterator.next();
						reqEntity.addPart(entry.getKey(), new StringBody(entry.getValue()));
					}
				}
	            
	            httppost.setEntity(reqEntity);

	            System.out.println("executing request " + httppost.getRequestLine());
	            HttpResponse response = httpclient.execute(httppost);
	            HttpEntity resEntity = response.getEntity();

	            //System.out.println(response.getStatusLine());
	            String state = EntityUtils.toString(resEntity);
	            System.out.println("state:"+state);
	            EntityUtils.consume(resEntity);
	            return Integer.valueOf(state);
	        } catch (Exception e){
	        	e.printStackTrace();
	        }finally {
	            try { httpclient.getConnectionManager().shutdown(); } catch (Exception ignore) {}
	        }
	        return -1;
	}
	
	public static void main(String[] args) {
		
	}

}
