package cn.myapps.destop.tray.client.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.http.entity.mime.content.FileBody;

/**
 * 支持断点续传的ContentBody子类
 * @author Happy
 *
 */
public class BreakedFileBody extends FileBody {
	
	private long offset;
	
	public BreakedFileBody(File file,long offset) {
		super(file,file.getName(), "application/octet-stream",null);
		this.offset = offset;
	}

	/* 重写FileBody数据传输方法，使之支持断点续传
	 * (non-Javadoc)
	 * @see org.apache.http.entity.mime.content.FileBody#writeTo(java.io.OutputStream)
	 */
	@Override
	public void writeTo(OutputStream out) throws IOException {
		if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream in = new FileInputStream(this.getFile());
        if( this.offset>0 ){ //跳过offset不传送
        	in.skip(offset);
        }
        try {
            byte[] tmp = new byte[4096];
            int l;
            while ((l = in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
                //break;//跳出数据传输 模拟网络中断。
            }
            out.flush();
        } finally {
            in.close();
        }
	}
	
	

}
